/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.COperatorType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.CVisitResults;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICAssignment;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICBlock;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICBreak;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICCall;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICClass;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICCompound;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICConditionalStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICConstant;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICConstantInteger;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICContinue;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICCustomStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICDecl;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICDoWhileStm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICElement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICExpression;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICField;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICGenericLoop;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICGoto;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICIfStm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICInstanceField;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICJumpFar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICLabel;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICOperation;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICOperatorFactory;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICReturn;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICSwitchStm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICThrow;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICVisitor;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICWhileStm;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CUtil {
    public static ICElement findParent(ICElement iCElement, ICElement iCElement2) {
        List<ICElement> list = iCElement.getSubElements();
        for (ICElement iCElement3 : list) {
            if (iCElement3 != iCElement2) continue;
            return iCElement;
        }
        for (ICElement iCElement3 : list) {
            ICElement iCElement4 = CUtil.findParent(iCElement3, iCElement2);
            if (iCElement4 == null) continue;
            return iCElement4;
        }
        return null;
    }

    public static boolean isClassMethodField(ICElement iCElement) {
        return iCElement instanceof ICClass || iCElement instanceof ICMethod || iCElement instanceof ICField;
    }

    public static boolean isIntegerConstant(ICExpression iCExpression) {
        return iCExpression instanceof ICConstantInteger;
    }

    public static boolean isIntegerValue(ICExpression iCExpression, long l2) {
        if (CUtil.isIntegerConstant(iCExpression)) {
            Long l3 = CUtil.getConstantAsLong((ICConstantInteger)iCExpression);
            return l3 != null && l3 == l2;
        }
        return false;
    }

    public static Long getConstantAsLong(ICConstant<?> iCConstant) {
        Object obj = iCConstant.getValue();
        if (obj instanceof Integer) {
            return ((Integer)obj).longValue();
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return null;
    }

    public static boolean hasNoSideEffects(ICElement iCElement) {
        if (iCElement instanceof ICCall || iCElement instanceof ICAssignment) {
            return false;
        }
        for (ICElement iCElement2 : iCElement.getSubElements()) {
            boolean bl;
            if (CUtil.isClassMethodField(iCElement2) || (bl = CUtil.hasNoSideEffects(iCElement2))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasNoCall(ICElement iCElement) {
        if (iCElement instanceof ICCall) {
            return false;
        }
        for (ICElement iCElement2 : iCElement.getSubElements()) {
            boolean bl;
            if (CUtil.isClassMethodField(iCElement2) || (bl = CUtil.hasNoCall(iCElement2))) continue;
            return false;
        }
        return true;
    }

    public static ICLabel getIfGotoTarget(ICStatement iCStatement) {
        if (!(iCStatement instanceof ICIfStm)) {
            return null;
        }
        ICIfStm iCIfStm = (ICIfStm)iCStatement;
        if (iCIfStm.size() != 1) {
            return null;
        }
        ICBlock iCBlock = iCIfStm.getBranchBody(0);
        if (iCBlock.size() != 1 || !(iCBlock.get(0) instanceof ICGoto)) {
            return null;
        }
        return ((ICGoto)iCBlock.get(0)).getLabel();
    }

    public static boolean isIfBranch(ICStatement iCStatement) {
        if (!(iCStatement instanceof ICIfStm)) {
            return false;
        }
        ICIfStm iCIfStm = (ICIfStm)iCStatement;
        if (iCIfStm.size() != 1) {
            return false;
        }
        ICBlock iCBlock = iCIfStm.getBranchBody(0);
        if (iCBlock.size() != 1) {
            return false;
        }
        ICStatement iCStatement2 = iCBlock.get(0);
        return iCStatement2 instanceof ICGoto || iCStatement2 instanceof ICBreak || iCStatement2 instanceof ICContinue || iCStatement2 instanceof ICReturn || iCStatement2 instanceof ICThrow;
    }

    public static boolean hasEmptyBranch(ICIfStm iCIfStm) {
        for (ICBlock iCBlock : iCIfStm.getBlocks()) {
            if (iCBlock.size() != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainingLabel(ICStatement iCStatement, ICLabel iCLabel) {
        if (iCStatement instanceof ICLabel && ((ICLabel)iCStatement).equals(iCLabel)) {
            return true;
        }
        if (iCStatement instanceof ICCompound) {
            for (ICBlock iCBlock : ((ICCompound)iCStatement).getBlocks()) {
                for (ICStatement iCStatement2 : iCBlock) {
                    if (!CUtil.isContainingLabel(iCStatement2, iCLabel)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isGotoTo(ICStatement iCStatement, ICLabel iCLabel) {
        return iCStatement instanceof ICGoto && ((ICGoto)iCStatement).getLabel() == iCLabel;
    }

    public static ICLabel getGotoLabel(ICStatement iCStatement) {
        if (iCStatement instanceof ICGoto) {
            return ((ICGoto)iCStatement).getLabel();
        }
        return null;
    }

    public static boolean isBreakTo(ICStatement iCStatement, ICLabel iCLabel) {
        return iCStatement instanceof ICBreak && ((ICBreak)iCStatement).getLabel() == iCLabel;
    }

    public static boolean isPlainBreak(ICStatement iCStatement) {
        return iCStatement instanceof ICBreak && ((ICBreak)iCStatement).getLabel() == null;
    }

    public static boolean isIfElse(ICStatement iCStatement) {
        ICIfStm iCIfStm;
        return iCStatement instanceof ICIfStm && (iCIfStm = (ICIfStm)iCStatement).size() == 2 && iCIfStm.hasDefaultBlock();
    }

    public static boolean flipIfElse(ICStatement iCStatement, ICOperatorFactory iCOperatorFactory) {
        ICIfStm iCIfStm;
        if (iCStatement instanceof ICIfStm && (iCIfStm = (ICIfStm)iCStatement).size() == 2 && iCIfStm.hasDefaultBlock()) {
            ICBlock iCBlock = iCIfStm.getBranchBody(0);
            ICBlock iCBlock2 = iCIfStm.getDefaultBlock();
            iCIfStm.getBranchPredicate(0).reverse(iCOperatorFactory);
            iCIfStm.setBranchBody(0, iCBlock2);
            iCIfStm.setDefaultBlock(iCBlock);
            return true;
        }
        return false;
    }

    public static boolean isIfNoElse(ICStatement iCStatement) {
        if (iCStatement instanceof ICIfStm) {
            ICIfStm iCIfStm = (ICIfStm)iCStatement;
            return !iCIfStm.hasDefaultBlock();
        }
        return false;
    }

    public static boolean isWhileTrue(ICStatement iCStatement) {
        if (iCStatement instanceof ICWhileStm) {
            return ((ICWhileStm)iCStatement).getPredicate().isLitteralTrue();
        }
        return false;
    }

    public static boolean isDoWhileTrue(ICStatement iCStatement) {
        if (iCStatement instanceof ICDoWhileStm) {
            return ((ICDoWhileStm)iCStatement).getPredicate().isLitteralTrue();
        }
        return false;
    }

    public static int countAllSubElements(ICElement iCElement) {
        int n2 = 0;
        for (ICElement iCElement2 : iCElement.getSubElements()) {
            if (CUtil.isClassMethodField(iCElement2)) {
                ++n2;
                continue;
            }
            n2 += CUtil.countAllSubElements(iCElement2);
        }
        return ++n2;
    }

    public static ICStatement getFirstRealStatement(ICBlock iCBlock, int n2) {
        if (n2 >= iCBlock.size()) {
            return null;
        }
        ICStatement iCStatement = iCBlock.get(n2);
        if (!(iCStatement instanceof ICCompound)) {
            return iCStatement;
        }
        if (iCStatement instanceof ICDoWhileStm) {
            ICStatement iCStatement2 = CUtil.getFirstRealStatement(((ICDoWhileStm)iCStatement).getBody(), 0);
            return iCStatement2 == null ? iCStatement : iCStatement2;
        }
        if (iCStatement instanceof ICWhileStm) {
            if (!((ICWhileStm)iCStatement).getPredicate().isLitteralTrue()) {
                return iCStatement;
            }
            ICStatement iCStatement3 = CUtil.getFirstRealStatement(((ICWhileStm)iCStatement).getBody(), 0);
            return iCStatement3 == null ? iCStatement : iCStatement3;
        }
        if (iCStatement instanceof ICIfStm) {
            if (!((ICIfStm)iCStatement).getBranchPredicate(0).isLitteralTrue()) {
                return iCStatement;
            }
            ICStatement iCStatement4 = CUtil.getFirstRealStatement(((ICIfStm)iCStatement).getBranchBody(0), 0);
            return iCStatement4 == null ? iCStatement : iCStatement4;
        }
        return iCStatement;
    }

    public static ICStatement getFirstRealStatementEx(ICMethod iCMethod, ICStatement iCStatement) {
        Boolean[] booleanArray = new Boolean[]{Boolean.FALSE, null};
        return CUtil.findFirstStatementAfter(iCMethod.getBody(), iCStatement, booleanArray);
    }

    private static ICStatement findFirstStatementAfter(ICBlock iCBlock, ICStatement iCStatement, Boolean[] booleanArray) {
        block0: for (int i = 0; i < iCBlock.size(); ++i) {
            ICStatement iCStatement2 = iCBlock.get(i);
            if (booleanArray[1] == Boolean.FALSE) {
                return null;
            }
            if (booleanArray[0].booleanValue()) {
                return CUtil.getFirstRealStatement(iCBlock, i);
            }
            if (iCStatement2 == iCStatement) {
                booleanArray[0] = true;
                continue;
            }
            if (!(iCStatement2 instanceof ICCompound)) continue;
            for (ICBlock iCBlock2 : ((ICCompound)iCStatement2).getBlocks()) {
                ICStatement iCStatement3 = CUtil.findFirstStatementAfter(iCBlock2, iCStatement, booleanArray);
                if (iCStatement3 != null) {
                    return iCStatement3;
                }
                if (!booleanArray[0].booleanValue()) continue;
                if (booleanArray[1] != null || iCStatement2 instanceof ICConditionalStatement) continue block0;
                booleanArray[1] = Boolean.FALSE;
                continue block0;
            }
        }
        return null;
    }

    public static boolean canFallthrough(ICStatement iCStatement, ICStatement iCStatement2, boolean bl) {
        if (iCStatement == null || iCStatement2 == null) {
            throw new InvalidParameterException();
        }
        if (CUtil.containsLabel(iCStatement2)) {
            return true;
        }
        if (iCStatement instanceof ICGoto || !bl && iCStatement instanceof ICBreak || iCStatement instanceof ICContinue || iCStatement instanceof ICJumpFar || iCStatement instanceof ICReturn || iCStatement instanceof ICThrow) {
            return false;
        }
        if (iCStatement instanceof ICBlock) {
            return CUtil.canFallthrough(((ICBlock)iCStatement).getLast(), iCStatement2, bl);
        }
        if (iCStatement instanceof ICConditionalStatement && ((ICConditionalStatement)iCStatement).hasDefaultBlock()) {
            boolean bl2 = true;
            for (ICBlock iCBlock : ((ICConditionalStatement)iCStatement).getBlocks()) {
                if (iCBlock.isEmpty()) {
                    bl2 = false;
                    break;
                }
                if (iCBlock.isEmpty() || !CUtil.canFallthrough(iCBlock, iCStatement2, bl || iCStatement instanceof ICSwitchStm)) continue;
                bl2 = false;
                break;
            }
            return !bl2;
        }
        if (iCStatement instanceof ICGenericLoop) {
            return true;
        }
        return true;
    }

    public static List<ICStatement> getPreviouslyExecutedStatements(ICMethod iCMethod, ICStatement iCStatement) {
        ICStatement iCStatement2 = CUtil.getParentBlock(iCMethod, iCStatement);
        if (iCStatement2 == null) {
            return null;
        }
        if (iCStatement2 instanceof ICBlock) {
            return CUtil.getPreviouslyExecutedStatements(iCMethod, (ICBlock)iCStatement2, iCStatement);
        }
        if (iCStatement2 instanceof ICIfStm) {
            return CUtil.getPreviouslyExecutedStatements(iCMethod, iCStatement2);
        }
        return null;
    }

    private static List<ICStatement> getPreviouslyExecutedStatements(ICMethod iCMethod, ICBlock iCBlock, ICStatement iCStatement) {
        for (int i = 0; i < iCBlock.size(); ++i) {
            ICStatement iCStatement2 = iCBlock.get(i);
            if (iCStatement2 != iCStatement) continue;
            if (i == 0) {
                return CUtil.getPreviouslyExecutedStatements(iCMethod, iCBlock);
            }
            return CUtil.getLastInstructions(iCBlock.get(i - 1));
        }
        return null;
    }

    private static List<ICStatement> getLastInstructions(ICStatement iCStatement) {
        if (!(iCStatement instanceof ICCompound)) {
            return Arrays.asList(iCStatement);
        }
        if (iCStatement instanceof ICIfStm) {
            ICIfStm iCIfStm = (ICIfStm)iCStatement;
            if (!iCIfStm.hasDefaultBlock()) {
                return null;
            }
            ArrayList<ICStatement> arrayList = new ArrayList<ICStatement>();
            for (int i = 0; i < iCIfStm.sizeWithoutDefault(); ++i) {
                ICBlock iCBlock = iCIfStm.getBranchBody(i);
                if (iCBlock == null) {
                    return null;
                }
                List<ICStatement> list = CUtil.getLastInstructions(iCBlock.getLast());
                if (list == null) {
                    return null;
                }
                arrayList.addAll(list);
            }
            List<ICStatement> list = CUtil.getLastInstructions(iCIfStm.getDefaultBlock().getLast());
            if (list == null) {
                return null;
            }
            arrayList.addAll(list);
            return arrayList;
        }
        return null;
    }

    public static ICStatement getParentBlock(ICMethod iCMethod, ICStatement iCStatement) {
        ICElement iCElement = CUtil.getParentBlockInner(iCMethod.getBody(), iCStatement, null);
        if (iCElement instanceof ICStatement) {
            return (ICStatement)iCElement;
        }
        return null;
    }

    private static ICElement getParentBlockInner(ICCompound iCCompound, ICStatement iCStatement, ICElement iCElement) {
        if (iCCompound == iCStatement) {
            return iCElement;
        }
        for (ICElement iCElement2 : iCCompound.getSubElements()) {
            ICElement iCElement3;
            if (iCElement2 == iCStatement) {
                return iCCompound;
            }
            if (!(iCElement2 instanceof ICCompound) || (iCElement3 = CUtil.getParentBlockInner((ICCompound)iCElement2, iCStatement, iCCompound)) == null) continue;
            return iCElement3;
        }
        return null;
    }

    public static BreakFlowStatus isBreakingFlow(ICStatement iCStatement) {
        return CUtil.getBreakingFlowResult(iCStatement).getStatus();
    }

    public static BreakFlowResult getBreakingFlowResult(ICStatement iCStatement) {
        if (iCStatement instanceof ICReturn || iCStatement instanceof ICThrow || iCStatement instanceof ICGoto || iCStatement instanceof ICContinue || iCStatement instanceof ICJumpFar) {
            return BreakFlowResult.TRUE;
        }
        if (iCStatement instanceof ICAssignment || iCStatement instanceof ICLabel || iCStatement instanceof ICCustomStatement || iCStatement instanceof ICDecl) {
            return BreakFlowResult.FALSE;
        }
        if (iCStatement instanceof ICBreak) {
            if (((ICBreak)iCStatement).getLabel() == null) {
                return BreakFlowResult.BREAK;
            }
            return BreakFlowResult.TRUE;
        }
        if (iCStatement instanceof ICConditionalStatement) {
            boolean bl = false;
            boolean bl2 = false;
            if (!((ICConditionalStatement)iCStatement).hasDefaultBlock()) {
                bl2 = true;
            }
            boolean bl3 = true;
            for (ICBlock iCBlock : ((ICConditionalStatement)iCStatement).getBlocks()) {
                BreakFlowResult breakFlowResult = CUtil.getBreakingFlowResult(iCBlock);
                switch (breakFlowResult.getStatus()) {
                    case TRUE: {
                        bl = true;
                        bl3 &= breakFlowResult.isLastInstruction();
                        break;
                    }
                    case FALSE: {
                        bl2 = true;
                        bl3 = false;
                        break;
                    }
                    case BOTH: {
                        bl = true;
                        bl2 = true;
                        bl3 &= breakFlowResult.isLastInstruction();
                        break;
                    }
                    case UNKNOWN: {
                        return breakFlowResult;
                    }
                    case BREAK: {
                        if (iCStatement instanceof ICSwitchStm) {
                            bl2 = true;
                        } else {
                            bl = true;
                        }
                        bl3 &= breakFlowResult.isLastInstruction();
                    }
                }
            }
            if (bl && bl2) {
                return new BreakFlowResult(BreakFlowStatus.BOTH, bl3);
            }
            if (bl) {
                return new BreakFlowResult(BreakFlowStatus.TRUE, bl3);
            }
            return BreakFlowResult.FALSE;
        }
        if (iCStatement instanceof ICBlock) {
            if (((ICBlock)iCStatement).isEmpty()) {
                return BreakFlowResult.FALSE;
            }
            for (int i = 0; i < ((ICBlock)iCStatement).size(); ++i) {
                BreakFlowResult breakFlowResult = CUtil.getBreakingFlowResult(((ICBlock)iCStatement).get(i));
                if (breakFlowResult.getStatus() == BreakFlowStatus.TRUE) {
                    return new BreakFlowResult(breakFlowResult.getStatus(), breakFlowResult.isLastInstruction() && i == ((ICBlock)iCStatement).size() - 1);
                }
                if (breakFlowResult.getStatus() == BreakFlowStatus.FALSE) continue;
                return new BreakFlowResult(breakFlowResult.getStatus(), breakFlowResult.isLastInstruction() && i == ((ICBlock)iCStatement).size() - 1);
            }
            return BreakFlowResult.FALSE;
        }
        return BreakFlowResult.UNKNOWN;
    }

    public static ICOperation lt(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.LT), iCExpression, iCExpression2);
    }

    public static ICOperation le(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.LE), iCExpression, iCExpression2);
    }

    public static ICOperation gt(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.GT), iCExpression, iCExpression2);
    }

    public static ICOperation ge(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.GE), iCExpression, iCExpression2);
    }

    public static ICOperation eq(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.EQ), iCExpression, iCExpression2);
    }

    public static ICOperation ne(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.NE), iCExpression, iCExpression2);
    }

    public static ICOperation andL(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.LOG_AND), iCExpression, iCExpression2);
    }

    public static ICOperation orL(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.LOG_OR), iCExpression, iCExpression2);
    }

    public static ICExpression notL(ICMethod iCMethod, ICExpression iCExpression) {
        if (iCExpression instanceof ICOperation && ((ICOperation)iCExpression).checkOperatorType(COperatorType.LOG_NOT)) {
            return ((ICOperation)iCExpression).getFirstOperand();
        }
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.LOG_NOT), iCExpression);
    }

    public static ICExpression notLDeepReplace(ICMethod iCMethod, ICExpression iCExpression) {
        ICExpression iCExpression2;
        ICExpression iCExpression3 = CUtil.notL(iCMethod, iCExpression);
        if (iCExpression3 instanceof ICOperation && (iCExpression2 = CUtil.resolveNotOperation(iCMethod, (ICOperation)iCExpression3, null)) != null) {
            return iCExpression2;
        }
        return iCExpression3;
    }

    public static ICExpression resolveNotOperation(ICMethod iCMethod, ICOperation iCOperation, ICElement iCElement) {
        if (iCOperation.getOperatorType() == COperatorType.LOG_NOT && iCOperation.getFirstOperand() instanceof ICOperation) {
            ICOperation iCOperation2 = (ICOperation)iCOperation.getFirstOperand();
            ICOperation iCOperation3 = iCOperation2.duplicate();
            if (iCOperation3.reverse(iCMethod.getGlobalContext().getOperatorFactory())) {
                if (iCElement == null || iCElement.replaceSubElement(iCOperation, iCOperation3)) {
                    return iCOperation3;
                }
            } else if (iCOperation3.getOperatorType() == COperatorType.LOG_AND) {
                iCOperation3 = CUtil.orL(iCMethod, CUtil.notL(iCMethod, iCOperation3.getFirstOperand()), CUtil.notL(iCMethod, iCOperation3.getSecondOperand()));
                if (iCElement == null || iCElement.replaceSubElement(iCOperation, iCOperation3)) {
                    CUtil.resolveNotOperationG(iCMethod, iCOperation3.getFirstOperand(), iCOperation3);
                    CUtil.resolveNotOperationG(iCMethod, iCOperation3.getSecondOperand(), iCOperation3);
                    return iCOperation3;
                }
            } else if (iCOperation3.getOperatorType() == COperatorType.LOG_OR) {
                iCOperation3 = CUtil.andL(iCMethod, CUtil.notL(iCMethod, iCOperation3.getFirstOperand()), CUtil.notL(iCMethod, iCOperation3.getSecondOperand()));
                if (iCElement == null || iCElement.replaceSubElement(iCOperation, iCOperation3)) {
                    CUtil.resolveNotOperationG(iCMethod, iCOperation3.getFirstOperand(), iCOperation3);
                    CUtil.resolveNotOperationG(iCMethod, iCOperation3.getSecondOperand(), iCOperation3);
                    return iCOperation3;
                }
            }
        }
        return null;
    }

    private static ICExpression resolveNotOperationG(ICMethod iCMethod, ICExpression iCExpression, ICElement iCElement) {
        if (iCExpression instanceof ICOperation) {
            return CUtil.resolveNotOperation(iCMethod, (ICOperation)iCExpression, iCElement);
        }
        return null;
    }

    public static ICOperation andB(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.AND), iCExpression, iCExpression2);
    }

    public static ICOperation orB(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.OR), iCExpression, iCExpression2);
    }

    public static ICOperation xorB(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.XOR), iCExpression, iCExpression2);
    }

    public static ICExpression notB(ICMethod iCMethod, ICExpression iCExpression) {
        if (iCExpression instanceof ICOperation && ((ICOperation)iCExpression).checkOperatorType(COperatorType.NOT)) {
            return ((ICOperation)iCExpression).getFirstOperand();
        }
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.NOT), iCExpression);
    }

    public static ICOperation add(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.ADD), iCExpression, iCExpression2);
    }

    public static ICOperation add(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2, ICExpression iCExpression3) {
        return CUtil.add(iCMethod, CUtil.add(iCMethod, iCExpression, iCExpression2), iCExpression3);
    }

    public static ICOperation sub(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.SUB), iCExpression, iCExpression2);
    }

    public static ICOperation mul(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.MUL), iCExpression, iCExpression2);
    }

    public static ICOperation div(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.DIV), iCExpression, iCExpression2);
    }

    public static ICOperation rem(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.REM), iCExpression, iCExpression2);
    }

    public static ICOperation shl(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.SHL), iCExpression, iCExpression2);
    }

    public static ICOperation shr(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.SHR), iCExpression, iCExpression2);
    }

    public static ICOperation ushr(ICMethod iCMethod, ICExpression iCExpression, ICExpression iCExpression2) {
        return iCMethod.getElementFactory().createOperation(iCMethod.getOperatorFactory().get(COperatorType.USHR), iCExpression, iCExpression2);
    }

    public static boolean isOperation(ICExpression iCExpression, COperatorType ... cOperatorTypeArray) {
        return CUtil.getOperation(iCExpression, cOperatorTypeArray) != null;
    }

    public static COperatorType getOperation(ICExpression iCExpression, COperatorType ... cOperatorTypeArray) {
        return iCExpression instanceof ICOperation ? CUtil.getOperation((ICOperation)iCExpression, cOperatorTypeArray) : null;
    }

    public static COperatorType getOperation(ICOperation iCOperation, COperatorType ... cOperatorTypeArray) {
        COperatorType cOperatorType = iCOperation.getOperatorType();
        for (COperatorType cOperatorType2 : cOperatorTypeArray) {
            if (cOperatorType2 != cOperatorType) continue;
            return cOperatorType;
        }
        return null;
    }

    public static int replaceSubElementRecurse(ICElement iCElement, ICExpression iCExpression, ICExpression iCExpression2) {
        int n2 = 0;
        if (iCExpression2 instanceof ICConstant && iCElement instanceof ICInstanceField) {
            return 0;
        }
        List<ICElement> list = iCElement.getSubElements();
        for (ICElement iCElement2 : list) {
            if (CUtil.isClassMethodField(iCElement2)) continue;
            if (iCElement2.equals(iCExpression)) {
                if (!iCElement.replaceSubElement(iCElement2, iCExpression2)) continue;
                ++n2;
                continue;
            }
            n2 += CUtil.replaceSubElementRecurse(iCElement2, iCExpression, iCExpression2);
        }
        return n2;
    }

    public static ICDecl getDefinition(ICElement iCElement) {
        ICAssignment iCAssignment;
        ICDecl iCDecl = null;
        if (iCElement instanceof ICDecl) {
            iCDecl = (ICDecl)iCElement;
        }
        if (iCElement instanceof ICAssignment && (iCAssignment = (ICAssignment)iCElement).getLeft() instanceof ICDecl) {
            iCDecl = (ICDecl)iCAssignment.getLeft();
        }
        return iCDecl;
    }

    public static ICElement getDefinitionInitialValue(ICElement iCElement) {
        ICAssignment iCAssignment;
        ICExpression iCExpression = null;
        if (iCElement instanceof ICAssignment && (iCAssignment = (ICAssignment)iCElement).getLeft() instanceof ICDecl) {
            iCExpression = iCAssignment.getRight();
        }
        return iCExpression;
    }

    public static boolean isDeclareAndAssign(ICElement iCElement) {
        ICAssignment iCAssignment;
        return iCElement instanceof ICAssignment && (iCAssignment = (ICAssignment)iCElement).getLeft() instanceof ICDecl;
    }

    public static boolean visitICStatementDepthPost(ICVisitor iCVisitor, ICBlock iCBlock, int n2, CVisitResults cVisitResults) {
        if (cVisitResults == null) {
            cVisitResults = new CVisitResults();
        }
        for (int i = n2; i < iCBlock.size(); ++i) {
            CUtil.visitICStatementDepthPostInternal(iCVisitor, iCBlock.get(i), null, cVisitResults);
            if (cVisitResults.isInterruptedVisit()) break;
        }
        return cVisitResults.isVisitedSuccessfully();
    }

    public static boolean visitICStatementDepthPost(ICVisitor iCVisitor, ICStatement iCStatement, CVisitResults cVisitResults) {
        if (cVisitResults == null) {
            cVisitResults = new CVisitResults();
        }
        CUtil.visitICStatementDepthPostInternal(iCVisitor, iCStatement, null, cVisitResults);
        return cVisitResults.isVisitedSuccessfully();
    }

    private static void visitICStatementDepthPostInternal(ICVisitor iCVisitor, ICStatement iCStatement, ICStatement iCStatement2, CVisitResults cVisitResults) {
        List<ICElement> list = iCStatement.getSubElements();
        cVisitResults.pushParent(iCStatement);
        for (ICElement iCElement : list) {
            if (CUtil.isClassMethodField(iCElement) || !(iCElement instanceof ICStatement)) continue;
            CUtil.visitICStatementDepthPostInternal(iCVisitor, (ICStatement)iCElement, iCStatement, cVisitResults);
            if (!cVisitResults.isInterruptedVisit()) continue;
            return;
        }
        cVisitResults.popParent();
        cVisitResults.setReplacedNode(iCStatement);
        iCVisitor.process(iCStatement, iCStatement2, cVisitResults);
    }

    public static boolean containsBreak(ICStatement iCStatement) {
        return CUtil.containsStatement(iCStatement, ICBreak.class);
    }

    public static boolean containsLabel(ICStatement iCStatement) {
        return CUtil.containsStatement(iCStatement, ICLabel.class);
    }

    public static boolean containsStatement(ICStatement iCStatement, Class<? extends ICStatement> clazz) {
        if (clazz.isInstance(iCStatement)) {
            return true;
        }
        if (iCStatement instanceof ICCompound) {
            for (ICBlock iCBlock : ((ICCompound)iCStatement).getBlocks()) {
                for (ICStatement iCStatement2 : iCBlock) {
                    if (!CUtil.containsStatement(iCStatement2, clazz)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static class BreakFlowResult {
        private static BreakFlowResult TRUE = new BreakFlowResult(BreakFlowStatus.TRUE, true);
        private static BreakFlowResult FALSE = new BreakFlowResult(BreakFlowStatus.FALSE, false);
        private static BreakFlowResult BREAK = new BreakFlowResult(BreakFlowStatus.BREAK, true);
        private static BreakFlowResult UNKNOWN = new BreakFlowResult(BreakFlowStatus.UNKNOWN, false);
        private BreakFlowStatus status;
        private boolean lastInstruction;

        public BreakFlowResult(BreakFlowStatus breakFlowStatus, boolean bl) {
            this.status = breakFlowStatus;
            this.lastInstruction = bl;
        }

        public BreakFlowStatus getStatus() {
            return this.status;
        }

        public boolean isLastInstruction() {
            return this.lastInstruction;
        }
    }

    public static enum BreakFlowStatus {
        TRUE,
        FALSE,
        BREAK,
        BOTH,
        UNKNOWN;

    }
}

