/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast;

import com.pnfsoftware.jeb.core.output.code.CppLikeDocumentPart;
import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IDynamicContentManager;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ISourceCustomizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.SourceCustomizerAdapter;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.CDocument;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.CKeyword;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICClass;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICElement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICMethod;
import com.pnfsoftware.jeb.util.base.Assert;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class COutputSink
extends CppLikeDocumentPart {
    private CDocument doc;
    private INativeDecompilerUnit<?> decomp;
    private Boolean ovrSpaceOutCompounds;
    private Boolean ovrMergeAdjacentDefinitions;
    private Boolean ovrHideCasts;
    private Boolean ovrHideTLNS;
    private IDynamicContentManager dynamicContentManager;
    private ISourceCustomizer sourceCustomizer;
    private Deque<ICClass> containingClasses = new ArrayDeque<ICClass>();
    private Deque<ICMethod> containingMethods = new ArrayDeque<ICMethod>();
    private int current_method_index = -1;
    private boolean omitTypeForNextDefinitionPrinting;
    private List<ICElement> aststk = new ArrayList<ICElement>();

    public COutputSink(long l2) {
        this(l2, null, null);
    }

    public COutputSink(long l2, CDocument cDocument, INativeDecompilerUnit<?> iNativeDecompilerUnit) {
        super(l2);
        this.doc = cDocument;
        this.decomp = iNativeDecompilerUnit;
        this.setSourceCustomizer(null);
    }

    public CDocument getDocument() {
        return this.doc;
    }

    public INativeDecompilerUnit<?> getDecompilerUnit() {
        return this.decomp;
    }

    public void setSpaceOutCompounds(Boolean bl) {
        this.ovrSpaceOutCompounds = bl;
    }

    public boolean getSpaceOutCompounds() {
        if (this.ovrSpaceOutCompounds != null) {
            return this.ovrSpaceOutCompounds;
        }
        return this.doc == null ? false : this.doc.optionSpaceOutCompounds;
    }

    public void setMergeAdjacentDefinitions(Boolean bl) {
        this.ovrMergeAdjacentDefinitions = bl;
    }

    public boolean getMergeAdjacentDefinitions() {
        if (this.ovrMergeAdjacentDefinitions != null) {
            return this.ovrMergeAdjacentDefinitions;
        }
        return this.doc == null ? false : this.doc.optionMergeAdjacentDefinitions;
    }

    public void setHideCasts(Boolean bl) {
        this.ovrHideCasts = bl;
    }

    public boolean getHideCasts() {
        if (this.ovrHideCasts != null) {
            return this.ovrHideCasts;
        }
        return this.doc == null ? false : this.doc.optionHideCasts;
    }

    public void setHideTLNS(Boolean bl) {
        this.ovrHideTLNS = bl;
    }

    public boolean getHideTLNS() {
        if (this.ovrHideTLNS != null) {
            return this.ovrHideTLNS;
        }
        return this.doc == null ? false : this.doc.optionHideTopLevelNamespaceElements;
    }

    public boolean omitTypeForNextDefinitionPrinting() {
        return this.omitTypeForNextDefinitionPrinting;
    }

    public void setOmitTypeForNextDefinitionPrinting(boolean bl) {
        this.omitTypeForNextDefinitionPrinting = bl;
    }

    public void pushContainingClass(ICClass iCClass) {
        if (iCClass == null) {
            throw new RuntimeException();
        }
        this.containingClasses.push(iCClass);
    }

    public ICClass popContainingClass() {
        return this.containingClasses.pop();
    }

    public ICClass getCurrentContainingClass() {
        return this.containingClasses.peek();
    }

    public ICClass getTopLevelClass() {
        return this.containingClasses.peekLast();
    }

    public void pushContainingMethod(ICMethod iCMethod) {
        if (iCMethod == null) {
            throw new RuntimeException();
        }
        this.containingMethods.push(iCMethod);
    }

    public ICMethod popContainingMethod() {
        return this.containingMethods.pop();
    }

    public ICMethod getCurrentContainingMethod() {
        return this.containingMethods.peek();
    }

    public void setDynamicContentManager(IDynamicContentManager iDynamicContentManager) {
        this.dynamicContentManager = iDynamicContentManager;
    }

    public IDynamicContentManager getDynamicContentManager() {
        return this.dynamicContentManager;
    }

    public void setSourceCustomizer(ISourceCustomizer iSourceCustomizer) {
        if (iSourceCustomizer == null) {
            iSourceCustomizer = new SourceCustomizerAdapter();
        }
        this.sourceCustomizer = iSourceCustomizer;
    }

    public ISourceCustomizer getSourceCustomizer() {
        return this.sourceCustomizer;
    }

    public int setCurrentMethodIndex(int n2) {
        int n3 = this.current_method_index;
        this.current_method_index = n2;
        return n3;
    }

    public int getCurrentMethodIndex() {
        return this.current_method_index;
    }

    public void appendKeyword(CKeyword cKeyword) {
        this.appendKeyword(cKeyword.toString().toLowerCase());
    }

    public void astPush(ICElement iCElement) {
        Assert.a(iCElement != null);
        this.aststk.add(iCElement);
    }

    public ICElement astPop() {
        return this.aststk.remove(this.aststk.size() - 1);
    }

    public ICElement astPeekSafe(int n2) {
        int n3 = this.aststk.size() - 1 - n2;
        if (n3 < 0 || n3 >= this.aststk.size()) {
            return null;
        }
        return this.aststk.get(n3);
    }

    public int astDepth() {
        return this.aststk.size();
    }

    public void renderPreComment(ICodeCoordinates iCodeCoordinates) {
        this.renderComment(iCodeCoordinates, -1, true);
    }

    public void renderInlineComment(ICodeCoordinates iCodeCoordinates, boolean bl) {
        this.renderComment(iCodeCoordinates, 0, bl);
    }

    public void renderComment(ICodeCoordinates iCodeCoordinates, int n2, boolean bl) {
        IDynamicContentManager iDynamicContentManager = this.getDynamicContentManager();
        if (iDynamicContentManager != null) {
            String string;
            String string2 = string = n2 >= 0 ? iDynamicContentManager.getComment(iCodeCoordinates) : iDynamicContentManager.getPreComment(iCodeCoordinates);
            if (string != null && !string.isEmpty()) {
                this.appendMultiLineComment(string, false, bl);
            }
        }
    }

    @Override
    public void validate() {
        super.validate();
    }
}

