/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.CEntityType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.COutputSink;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jebglobal.aeb;

@Ser
public enum CKeyword {
    ABSTRACT,
    ASSERT,
    BOOLEAN,
    BREAK,
    BYTE,
    CASE,
    CATCH,
    CHAR,
    CLASS,
    CONST,
    CONTINUE,
    DEFAULT,
    DO,
    DOUBLE,
    ELSE,
    ENUM,
    EXTENDS,
    FINAL,
    FINALLY,
    FLOAT,
    FOR,
    GOTO,
    IF,
    IMPLEMENTS,
    IMPORT,
    INSTANCEOF,
    INT,
    INTERFACE,
    LONG,
    NATIVE,
    NEW,
    PACKAGE,
    PRIVATE,
    PROTECTED,
    PUBLIC,
    RETURN,
    SHORT,
    STATIC,
    STRICTFP,
    SUPER,
    SWITCH,
    SYNCHRONIZED,
    THIS,
    THROW,
    THROWS,
    TRANSIENT,
    TRY,
    VOID,
    VOLATILE,
    WHILE,
    TRUE,
    FALSE,
    NULL,
    VIRTUAL;

    private static final StructuredLogger logger;

    public static void generateClassAccessFlags(COutputSink cOutputSink, int n2, int n3) {
        CKeyword.generateAccessFlags(cOutputSink, n2, n3, CEntityType.CLASS);
    }

    public static void generateMethodAccessFlags(COutputSink cOutputSink, int n2, int n3) {
        CKeyword.generateAccessFlags(cOutputSink, n2, n3, CEntityType.METHOD);
    }

    public static void generateFieldAccessFlags(COutputSink cOutputSink, int n2, int n3) {
        CKeyword.generateAccessFlags(cOutputSink, n2, n3, CEntityType.FIELD);
    }

    public static void generateAccessFlags(COutputSink cOutputSink, int n2, int n3, CEntityType cEntityType) {
        int[] nArray = new int[]{0};
        switch (cEntityType) {
            case CLASS: {
                n2 &= 0x761F;
                break;
            }
            case METHOD: {
                n2 &= 0x31DFF;
                break;
            }
            case FIELD: {
                n2 &= 0x50DF;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        CKeyword.appendAccessKeyword(cOutputSink, nArray, n2, 1, PUBLIC);
        CKeyword.appendAccessKeyword(cOutputSink, nArray, n2, 2, PRIVATE);
        CKeyword.appendAccessKeyword(cOutputSink, nArray, n2, 4, PROTECTED);
        CKeyword.appendAccessKeyword(cOutputSink, nArray, n2, 8, STATIC);
        CKeyword.appendAccessKeyword(cOutputSink, nArray, n2, 16, FINAL);
        CKeyword.appendAccessKeyword(cOutputSink, nArray, n2, 1024, ABSTRACT);
        CKeyword.appendAccessKeyword(cOutputSink, nArray, n2, 512, INTERFACE);
        CKeyword.appendAccessKeyword(cOutputSink, nArray, n2, 16384, ENUM);
        CKeyword.appendAccessKeyword(cOutputSink, nArray, n2, 32, SYNCHRONIZED);
        if (cEntityType == CEntityType.FIELD) {
            CKeyword.appendAccessKeyword(cOutputSink, nArray, n2, 64, VOLATILE);
        } else if (cEntityType == CEntityType.METHOD) {
            CKeyword.appendAccessKeyword(cOutputSink, nArray, n2, 128, null);
        }
        CKeyword.appendAccessKeyword(cOutputSink, nArray, n2, 4096, null);
        CKeyword.appendAccessKeyword(cOutputSink, nArray, n2, 65536, null);
        CKeyword.appendAccessKeyword(cOutputSink, nArray, n2, 0x20000000, null);
        CKeyword.appendAccessKeyword(cOutputSink, nArray, n2, 0x10000000, null);
        if (n3 == 1 || n3 == -1 && nArray[0] > 0) {
            cOutputSink.append(" ");
        }
    }

    private static void appendAccessKeyword(COutputSink cOutputSink, int[] nArray, int n2, int n3, CKeyword cKeyword) {
        if (cKeyword != null && (n2 & n3) != 0) {
            if (nArray[0] > 0) {
                cOutputSink.append(" ");
            }
            cOutputSink.appendKeyword(cKeyword);
            nArray[0] = nArray[0] + 1;
        }
    }

    public static void appendAccessKeyword(COutputSink cOutputSink, CKeyword cKeyword) {
        cOutputSink.appendKeyword(cKeyword);
    }

    static {
        logger = aeb.ce(CKeyword.class);
    }
}

