/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast;

import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.events.PropertyChangeNotification;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.CoordinatesConversionPrecision;
import com.pnfsoftware.jeb.core.output.code.CodeDocument;
import com.pnfsoftware.jeb.core.output.code.CodeLine;
import com.pnfsoftware.jeb.core.output.code.coordinates.CodeCoordinatesUtil;
import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.InstructionCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.MethodCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.NativeCoordinates;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionGroup;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeSourceUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.COutputSink;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICClass;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICElement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICField;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICMethod;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jebglobal.adr;
import com.pnfsoftware.jebglobal.aeb;
import java.util.List;
import java.util.Map;

public class CDocument
extends CodeDocument {
    private static final StructuredLogger logger = aeb.ce(CDocument.class);
    public static final String propnameSpaceOutCompounds = "SpaceOutCompounds";
    public static final String propnameMergeAdjacentDefinitions = "MergeAdjacentDefinitions";
    public static final String propnameHideCasts = "HideCasts";
    public static final String propnameHideTopLevelNamespaceElements = "HideTopLevelNamespaceElements";
    boolean optionSpaceOutCompounds = false;
    boolean optionMergeAdjacentDefinitions = false;
    boolean optionHideCasts = false;
    boolean optionHideTopLevelNamespaceElements = true;
    private boolean disposed;
    private INativeCodeUnit<?> codeunit;
    private IPropertyManager pm;
    private adr<?> decomp;
    private INativeSourceUnit srcUnit;
    private IEventListener unitListener;
    private IEventListener pmListener;
    private COutputSink singlePart;

    public static void buildPDM(IPropertyDefinitionManager iPropertyDefinitionManager) {
        IPropertyDefinitionGroup iPropertyDefinitionGroup = iPropertyDefinitionManager.addGroup("text");
        iPropertyDefinitionGroup.addDefinition(propnameSpaceOutCompounds, PropertyTypeBoolean.create(true), "Insert blank lines between compounds");
        iPropertyDefinitionGroup.addDefinition(propnameMergeAdjacentDefinitions, PropertyTypeBoolean.create(), "Merge same type definitions on a single line, e.g.: int i = 0, j = 1;");
        iPropertyDefinitionGroup.addDefinition(propnameHideCasts, PropertyTypeBoolean.create(), "Hide casts (the output will be incorrect)");
        iPropertyDefinitionGroup.addDefinition(propnameHideTopLevelNamespaceElements, PropertyTypeBoolean.create(true), "Hide top-level namespace elements in raw method names (C++)");
    }

    public CDocument(INativeSourceUnit iNativeSourceUnit) {
        this.srcUnit = iNativeSourceUnit;
        this.decomp = (adr)iNativeSourceUnit.getParent();
        this.codeunit = (INativeCodeUnit)this.decomp.getParent();
        this.setupOptions(false);
        this.unitListener = new IEventListener(){

            @Override
            public void onEvent(IEvent iEvent) {
                JebEvent jebEvent = (JebEvent)iEvent;
                if (jebEvent.getType() == J.UnitChange) {
                    CDocument.this.notifyListeners(jebEvent);
                }
            }
        };
        iNativeSourceUnit.addListener(this.unitListener);
        this.pm = this.decomp.getPropertyManager();
        this.pmListener = new IEventListener(){

            @Override
            public void onEvent(IEvent iEvent) {
                if (iEvent instanceof JebEvent && iEvent.getType() == J.PropertyChange && iEvent.getData() instanceof PropertyChangeNotification) {
                    PropertyChangeNotification propertyChangeNotification = (PropertyChangeNotification)iEvent.getData();
                    (new Object[1])[0] = propertyChangeNotification;
                    CDocument.this.setupOptions(true);
                }
            }
        };
        this.pm.addListener(this.pmListener);
    }

    private void setupOptions(boolean bl) {
        IPropertyManager iPropertyManager = this.decomp.getPropertyManager();
        this.optionSpaceOutCompounds = iPropertyManager.getBoolean(propnameSpaceOutCompounds);
        this.optionMergeAdjacentDefinitions = iPropertyManager.getBoolean(propnameMergeAdjacentDefinitions);
        this.optionHideCasts = iPropertyManager.getBoolean(propnameHideCasts);
        this.optionHideTopLevelNamespaceElements = iPropertyManager.getBoolean(propnameHideTopLevelNamespaceElements);
        if (bl) {
            this.notifyListeners(new JebEvent(J.UnitChange));
        }
    }

    @Override
    public void dispose() {
        if (!this.disposed) {
            super.dispose();
            this.srcUnit.removeListener(this.unitListener);
            this.pm.removeListener(this.pmListener);
            this.disposed = true;
        }
    }

    @Override
    public IUnit getUnit() {
        return this.srcUnit;
    }

    @Override
    public long getAnchorCount() {
        return 1L;
    }

    @Override
    public COutputSink getDocumentPart(long l2, int n2, int n3) {
        COutputSink cOutputSink = new COutputSink(0L, this, this.decomp);
        cOutputSink.registerAnchor("single_anchor");
        ICElement iCElement = this.srcUnit.getASTItem();
        if (!(iCElement instanceof ICClass || iCElement instanceof ICMethod || iCElement instanceof ICField)) {
            throw new RuntimeException(Strings.ff("The generation of a top-level %s node is not supported yet", new Object[]{iCElement.getElementType()}));
        }
        cOutputSink.setDynamicContentManager(this.decomp.ce());
        cOutputSink.setSourceCustomizer(this.decomp.ok());
        iCElement.generate(cOutputSink);
        cOutputSink.validate();
        this.singlePart = cOutputSink;
        return cOutputSink;
    }

    @Override
    public String coordinatesToAddress(ICoordinates iCoordinates, AddressConversionPrecision addressConversionPrecision) {
        ICodeCoordinates iCodeCoordinates = this.coordinatesToCodeCoordinates(iCoordinates);
        if (iCodeCoordinates == null) {
            return null;
        }
        return this.codeunit.getAddressFromCodeCoordinates(iCodeCoordinates, addressConversionPrecision);
    }

    private ICodeCoordinates coordinatesToCodeCoordinates(ICoordinates iCoordinates) {
        InstructionCoordinates instructionCoordinates;
        ICodeCoordinates iCodeCoordinates;
        InstructionCoordinates instructionCoordinates2;
        if (iCoordinates == null) {
            return null;
        }
        int n2 = iCoordinates.getLineDelta();
        if (this.singlePart == null || n2 < 0 || n2 >= this.singlePart.getLines().size()) {
            return null;
        }
        List<CodeLine> list = this.singlePart.getLines();
        CodeLine codeLine = list.get(n2);
        ICodeCoordinates iCodeCoordinates2 = codeLine.getCoordinates(iCoordinates.getColumnOffset());
        ICodeCoordinates iCodeCoordinates3 = codeLine.getLineCoordinates();
        if (iCodeCoordinates2 == null && iCodeCoordinates3 == null) {
            int n3;
            int n4 = Math.min(n3 + 10, list.size());
            for (n3 = n2 + 1; n3 < n4 && (iCodeCoordinates3 = (codeLine = list.get(n3)).getLineCoordinates()) == null; ++n3) {
            }
            if (iCodeCoordinates3 == null) {
                return null;
            }
        }
        if (iCodeCoordinates2 instanceof InstructionCoordinates && (instructionCoordinates2 = (InstructionCoordinates)iCodeCoordinates2).getMethodId() < 0) {
            iCodeCoordinates2 = null;
        }
        if ((iCodeCoordinates = iCodeCoordinates2) == null) {
            iCodeCoordinates = iCodeCoordinates3;
        }
        if (iCodeCoordinates == null) {
            return null;
        }
        if (iCodeCoordinates3 instanceof NativeCoordinates && iCodeCoordinates2 instanceof NativeCoordinates) {
            NativeCoordinates nativeCoordinates = (NativeCoordinates)iCodeCoordinates3;
            NativeCoordinates nativeCoordinates2 = (NativeCoordinates)iCodeCoordinates2;
            if (nativeCoordinates.getAddress() > nativeCoordinates2.getAddress() && nativeCoordinates2.getAddress() > 0L) {
                iCodeCoordinates = iCodeCoordinates3;
            }
        }
        if (iCodeCoordinates instanceof InstructionCoordinates && (instructionCoordinates = (InstructionCoordinates)iCodeCoordinates).getOffset() < 0) {
            iCodeCoordinates = new MethodCoordinates(instructionCoordinates.getMethodId());
        }
        return iCodeCoordinates;
    }

    @Override
    public ICoordinates addressToCoordinates(String string, CoordinatesConversionPrecision coordinatesConversionPrecision) {
        ICodeCoordinates iCodeCoordinates = this.codeunit.getCodeCoordinatesFromAddress(string);
        if (iCodeCoordinates == null) {
            return null;
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (CodeLine codeLine : this.singlePart.getLines()) {
            ICodeCoordinates iCodeCoordinates2 = codeLine.getLineCoordinates();
            if (iCodeCoordinates.equals(iCodeCoordinates2)) {
                return new Coordinates(0L, n5, 0);
            }
            int n6 = CodeCoordinatesUtil.distance(iCodeCoordinates, iCodeCoordinates2);
            if (n6 < n2) {
                n2 = n6;
                n3 = n5;
                n4 = 0;
            }
            Map<Integer, ICodeCoordinates> map = codeLine.getCoordinates();
            for (Integer n7 : map.keySet()) {
                iCodeCoordinates2 = map.get(n7);
                if (iCodeCoordinates.equals(iCodeCoordinates2)) {
                    return new Coordinates(0L, n5, n7);
                }
                n6 = CodeCoordinatesUtil.distance(iCodeCoordinates, iCodeCoordinates2);
                if (n6 >= n2) continue;
                n2 = n6;
                n3 = n5;
                n4 = n7;
            }
            ++n5;
        }
        if (n2 < Integer.MAX_VALUE) {
            (new Object[1])[0] = n2;
            return new Coordinates(0L, n3, n4);
        }
        return null;
    }
}

