/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.units.code.AddressableInstruction;
import com.pnfsoftware.jeb.core.units.code.IBasicBlock;
import com.pnfsoftware.jeb.core.units.code.IDFA;
import com.pnfsoftware.jeb.core.units.code.IFlowInformation;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.INativeContext;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ACS;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ConverterInstructionEntry;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEConverter;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEGlobalContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.exceptions.DecompilerException;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.exceptions.UnsupportedConversionException;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EBranchDetails;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.ELocation;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EPrototypeHandler;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EState;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EVarCopyFinder;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEAssign;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEBranchDetails;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECall;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECond;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEMem;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEOperation;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEPrototypeHandler;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEReturn;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEUntranslatedInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IWildcardPrototype;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IWildcardType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IWildcardTypeManager;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.OperationType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.SimulationPointInformation;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeInstructionItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.InstructionHints;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IProcessor;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterBank;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterDescriptionEntry;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterUtil;
import com.pnfsoftware.jeb.core.units.code.asm.type.CallingConventionUtil;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConventionManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStorageEntryGenerator;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.StorageEntry;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.collect.Maps;
import com.pnfsoftware.jeb.util.collect.ReferenceCounter;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jeb.util.math.MathUtil;
import com.pnfsoftware.jeb.util.primitives.Booleans;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.pnfsoftware.jebglobal.adw;
import com.pnfsoftware.jebglobal.aeb;
import com.pnfsoftware.jebglobal.ale;
import com.pnfsoftware.jebglobal.alf;
import com.pnfsoftware.jebglobal.ali;
import com.pnfsoftware.jebglobal.alm;
import com.pnfsoftware.jebglobal.amg;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Ser
public abstract class AbstractConverter<InsnType extends IInstruction>
implements IEConverter<InsnType> {
    private static final StructuredLogger logger = aeb.ce(AbstractConverter.class);
    @SerId(value=1)
    private INativeDecompilerContext decompiler;
    @SerId(value=2)
    protected IEGlobalContext gCtx;
    @SerId(value=3)
    protected INativeContext nctx;
    @SerId(value=4)
    protected IProcessor<InsnType> proc;
    @SerId(value=5)
    protected int regNormalBitsize;
    @SerId(value=6)
    protected boolean doNotGenerateNops;
    @SerId(value=7)
    protected int methodConversionCountFailure;
    @SerId(value=8)
    protected int methodConversionCountSuccess;
    @SerId(value=9)
    ReferenceCounter<String> missedInsnCounter;
    @SerId(value=10)
    int insnConversionCount;
    @SerId(value=11)
    int insnConversionCountFailure;
    @SerId(value=12)
    int insnConversionCountUntranslated;
    @SerTransient
    protected IERoutineContext ctx;
    @SerTransient
    protected Set<Long> parameterRegistersForAllCC;
    @SerTransient
    protected Set<Long> spoiledRegistersForAllCC;

    protected AbstractConverter(IProcessor<InsnType> iProcessor) {
        this(iProcessor, iProcessor.getGPRegisterBitsize(), iProcessor.getPCRegisterBitsize());
    }

    protected AbstractConverter(IProcessor<InsnType> iProcessor, int n2) {
        this(iProcessor, n2, n2);
    }

    protected AbstractConverter(IProcessor<InsnType> iProcessor, int n2, int n3) {
        this.proc = iProcessor;
        this.regNormalBitsize = n2;
        this.gCtx = new alm(this, n2, n3, iProcessor.getEndianness().isBig());
    }

    protected AbstractConverter(INativeContext iNativeContext) {
        this(iNativeContext.getProcessor());
        this.nctx = iNativeContext;
    }

    @Override
    public void initialize() {
    }

    public void setNativeContext(INativeContext iNativeContext) {
        this.nctx = iNativeContext;
    }

    @Override
    public INativeContext getNativeContext() {
        return this.nctx;
    }

    @Override
    public IEGlobalContext getGlobalContext() {
        return this.gCtx;
    }

    public void setDoNotGenerateNops(boolean bl) {
        this.doNotGenerateNops = bl;
    }

    public boolean isDoNotGenerateNops() {
        return this.doNotGenerateNops;
    }

    public void setDecompiler(INativeDecompilerContext iNativeDecompilerContext) {
        if (iNativeDecompilerContext == null) {
            throw new IllegalArgumentException();
        }
        if (this.decompiler != null && iNativeDecompilerContext != this.decompiler) {
            throw new IllegalArgumentException();
        }
        this.decompiler = iNativeDecompilerContext;
    }

    @Override
    public INativeDecompilerContext getDecompiler() {
        return this.decompiler;
    }

    protected final boolean insertOptionalEntryPointTrampoline(IERoutineContext iERoutineContext, List<IEStatement> list) {
        long l2;
        CFG<? extends IInstruction> cFG = iERoutineContext.getRoutine().getData().getCFG();
        long l3 = cFG.getEntryAddress();
        if (l3 == (l2 = cFG.getFirstAddress())) {
            return false;
        }
        IEAssign iEAssign = iERoutineContext.createBranchAssign(this.getProgramCounter(), EUtil.imm(l3, this.getAddressBitsize()), false);
        iEAssign.setLowerLevelAddress(-1L);
        list.add(iEAssign);
        return true;
    }

    @Override
    public int getAddressBitsize() {
        return this.getProgramCounter().getBitsize();
    }

    @Override
    public int getRegisterBitsize() {
        return this.getAddressBitsize();
    }

    @Override
    public int getStackSlotSize() {
        return this.getRegisterBitsize() / 8;
    }

    @Override
    public IWildcardType.Group getWildcardTypeManagerDefaultResolutionGroup() {
        return IWildcardType.Group.INTEGER;
    }

    @Override
    public final IEGeneric getRegister(String string) {
        return this.getRegister(string, null);
    }

    @Override
    public IEGeneric getRegister(String string, ELocation eLocation) {
        return this.gCtx.getVariableByName(string);
    }

    @Override
    public final IEGeneric getRegisterVariableFromNativeRegisterId(long l2) {
        return this.getRegisterVariableFromNativeRegisterId(l2, null);
    }

    @Override
    public IEGeneric getRegisterVariableFromNativeRegisterId(long l2, ELocation eLocation) {
        RegisterDescriptionEntry registerDescriptionEntry;
        IRegisterBank iRegisterBank = this.proc.getRegisterBank();
        if (iRegisterBank != null && (registerDescriptionEntry = (l2 & 0xFFFFFFFFFFFF0000L) == 0L ? iRegisterBank.getDescriptionEntry((int)l2) : iRegisterBank.getDescriptionEntryById(l2)) != null) {
            for (String object : registerDescriptionEntry.getNames()) {
                IEGeneric iEGeneric = this.getRegister(object, eLocation);
                if (iEGeneric == null) continue;
                return iEGeneric;
            }
            if (registerDescriptionEntry.isRegisterSlice()) {
                RegisterDescriptionEntry registerDescriptionEntry2 = registerDescriptionEntry.getContainer();
                for (String string : registerDescriptionEntry2.getNames()) {
                    IEGeneric iEGeneric = this.getRegister(string, eLocation);
                    if (iEGeneric == null) continue;
                    return iEGeneric.slice(registerDescriptionEntry.getBitstart(), registerDescriptionEntry.getBitend());
                }
            }
        }
        int n2 = RegisterUtil.getRegisterGroup(l2);
        int n3 = RegisterUtil.getRegisterIndex(l2);
        throw new DecompilerException(Strings.ff("Cannot convert native register id %d (grp:%d,index:%d) to its corresponding IEVar", l2, n2, n3));
    }

    @Override
    public long getNativeRegisterIdFromRegisterVariable(IEVar iEVar, boolean bl) {
        RegisterDescriptionEntry registerDescriptionEntry;
        IRegisterBank iRegisterBank = this.proc.getRegisterBank();
        if (iRegisterBank != null && (registerDescriptionEntry = iRegisterBank.getDescriptionEntryByName(iEVar.getName())) != null) {
            if (bl) {
                return registerDescriptionEntry.getNumber();
            }
            return registerDescriptionEntry.getId();
        }
        throw new DecompilerException(Strings.ff("Cannot convert variable '%s' to native register id", iEVar));
    }

    @Override
    public final long getNativeRegisterIdFromRegisterVariable(IEVar iEVar) {
        return this.getNativeRegisterIdFromRegisterVariable(iEVar, false);
    }

    @Override
    public String getSlicedRegisterName(String string, int n2, int n3) {
        RegisterDescriptionEntry registerDescriptionEntry;
        IRegisterBank iRegisterBank = this.proc.getRegisterBank();
        if (iRegisterBank != null && (registerDescriptionEntry = iRegisterBank.getDescriptionEntryByName(string)) != null && registerDescriptionEntry.isPhysicalRegister() && (registerDescriptionEntry = registerDescriptionEntry.getSlice(n2, n3)) != null) {
            return registerDescriptionEntry.getName();
        }
        return null;
    }

    public void setCurrentContext(IERoutineContext iERoutineContext) {
        this.ctx = iERoutineContext;
    }

    protected void preRoutineConversion(INativeMethodItem iNativeMethodItem, IERoutineContext iERoutineContext, List<IEStatement> list) {
        this.insertOptionalEntryPointTrampoline(iERoutineContext, list);
    }

    protected void postRoutineConversion(INativeMethodItem iNativeMethodItem, IERoutineContext iERoutineContext) {
    }

    @Override
    public IERoutineContext convert(INativeMethodItem iNativeMethodItem) {
        IERoutineContext iERoutineContext = this.gCtx.createRoutineContext(iNativeMethodItem);
        this.setCurrentContext(iERoutineContext);
        try {
            BasicBlock<? extends IInstruction> basicBlock;
            CFG<? extends IInstruction> cFG = iNativeMethodItem.getData().getCFG();
            long l2 = 0L;
            ArrayList<IEStatement> arrayList = new ArrayList<IEStatement>();
            this.preRoutineConversion(iNativeMethodItem, iERoutineContext, arrayList);
            for (int i = 0; i < cFG.size(); ++i) {
                basicBlock = cFG.get(i);
                if (Long.compareUnsigned(basicBlock.getBase(), l2) < 0) continue;
                basicBlock = this.preBlockConversion(cFG, basicBlock, arrayList);
                int n2 = arrayList.size();
                this.convertBlock(basicBlock, arrayList);
                this.postBlockConversion(cFG, basicBlock, arrayList, arrayList.size() - n2);
                l2 = basicBlock.getEndAddress();
            }
            iERoutineContext.setStatements(arrayList);
            this.postRoutineConversion(iNativeMethodItem, iERoutineContext);
            alf alf2 = new alf(iERoutineContext);
            alf2.ce();
            iERoutineContext.setStatements(arrayList, true, true, true);
            this.gCtx.addRoutineContext(iERoutineContext);
            ++this.methodConversionCountSuccess;
            basicBlock = iERoutineContext;
            return basicBlock;
        }
        catch (Exception exception) {
            ++this.methodConversionCountFailure;
            throw exception;
        }
        finally {
            this.setCurrentContext(null);
        }
    }

    protected BasicBlock<InsnType> preBlockConversion(CFG<InsnType> cFG, BasicBlock<InsnType> basicBlock, List<IEStatement> list) {
        return basicBlock;
    }

    protected void convertBlock(BasicBlock<InsnType> basicBlock, List<IEStatement> list) {
        long l2;
        long l3 = l2 = basicBlock.getFirstAddress();
        ArrayList<IEStatement> arrayList = new ArrayList<IEStatement>();
        ConverterInstructionEntry converterInstructionEntry = new ConverterInstructionEntry();
        converterInstructionEntry.r = arrayList;
        IInstruction iInstruction = null;
        try {
            for (int i = 0; i < basicBlock.size(); ++i) {
                iInstruction = (IInstruction)basicBlock.get(i);
                int n2 = list.size();
                converterInstructionEntry.insn = iInstruction;
                converterInstructionEntry.address = l3;
                converterInstructionEntry.irAddress = n2;
                arrayList.clear();
                converterInstructionEntry.r = arrayList;
                this.convertInstruction(converterInstructionEntry);
                for (IEStatement iEStatement : arrayList) {
                    if (iEStatement.getPrimaryLowerLevelAddress() != null) continue;
                    iEStatement.setLowerLevelAddress(l3);
                }
                list.addAll(arrayList);
                l3 += (long)iInstruction.getSize();
            }
        }
        catch (Throwable throwable) {
            logger.error("Error: Instruction cannot be converted: %s %s", Formatter.byteArrayToHex(iInstruction.getCode()), iInstruction.format(l3));
            logger.catchingSilent(throwable);
            throw throwable;
        }
    }

    public void convertInstruction(ConverterInstructionEntry<InsnType> converterInstructionEntry) {
        ++this.insnConversionCount;
        try {
            if (!this.attemptConversionByExtension(converterInstructionEntry) && !this.convertInstructionFirstChance(converterInstructionEntry, converterInstructionEntry.insn.getMnemonic(), true)) {
                this.convertInstructionLastChance(converterInstructionEntry);
                ++this.insnConversionCountUntranslated;
                UnsupportedConversionException unsupportedConversionException = new UnsupportedConversionException("Cannot convert instruction: " + converterInstructionEntry.insn);
                if (Licensing.isDebugBuild()) {
                    throw unsupportedConversionException;
                }
                adw.ce(unsupportedConversionException);
            }
        }
        catch (RuntimeException runtimeException) {
            if (Licensing.isDebugBuild()) {
                throw runtimeException;
            }
            String string = Strings.ff("%s @ 0x%X: %s", converterInstructionEntry.insn.getMnemonic(), converterInstructionEntry.address, Formatter.byteArrayToHex(converterInstructionEntry.insn.getCode()));
            JebCoreService.notifySilentExceptionToClient((Throwable)runtimeException, Maps.toMap("instruction", string));
            ++this.insnConversionCountFailure;
            if (this.missedInsnCounter != null) {
                this.missedInsnCounter.inc(converterInstructionEntry.insn.getMnemonic());
            }
            this.convertInstructionLastChance(converterInstructionEntry);
        }
    }

    protected boolean convertInstructionFirstChance(ConverterInstructionEntry<InsnType> converterInstructionEntry, String string, boolean bl) {
        throw new RuntimeException("Not implemented");
    }

    protected boolean convertInstructionLastChance(ConverterInstructionEntry<InsnType> converterInstructionEntry) {
        throw new RuntimeException("Not implemented");
    }

    protected IEGeneric convertOperand(long l2, InsnType InsnType, int n2) {
        throw new RuntimeException("Not implemented");
    }

    protected boolean attemptConversionByExtension(ConverterInstructionEntry<InsnType> converterInstructionEntry) {
        if (this.decompiler == null) {
            return false;
        }
        return this.decompiler.getExtensionsManager().convertInstruction(this, this.ctx, converterInstructionEntry).getResult();
    }

    protected boolean attemptCallInliningByExtension(ConverterInstructionEntry<InsnType> converterInstructionEntry, long l2) {
        if (this.decompiler == null) {
            return false;
        }
        return this.decompiler.getExtensionsManager().convertToInlinedCall(this, this.ctx, converterInstructionEntry, l2).getResult();
    }

    protected void postBlockConversion(CFG<InsnType> cFG, BasicBlock<InsnType> basicBlock, List<IEStatement> list, int n2) {
        InstructionHints instructionHints;
        long l2;
        INativeContinuousItem iNativeContinuousItem;
        AddressableInstruction<InsnType> addressableInstruction = basicBlock.getBranchingInstruction2();
        if (addressableInstruction != null && (iNativeContinuousItem = this.nctx.getNativeItemAt(l2 = addressableInstruction.getOffset())) instanceof INativeInstructionItem && (instructionHints = ((INativeInstructionItem)iNativeContinuousItem).getHints(false)) != null) {
            if (addressableInstruction.getRoutineCall().isBroken()) {
                if (instructionHints.isFakeCall()) {
                    this.sanitizeFakeBranch(l2, iNativeContinuousItem, list.subList(list.size() - n2, list.size()), true);
                }
            } else if (addressableInstruction.getBreakingFlow().isBroken() && instructionHints.isActualCall()) {
                this.sanitizeFakeBranch(l2, iNativeContinuousItem, list.subList(list.size() - n2, list.size()), false);
            }
        }
    }

    private void sanitizeFakeBranch(long l2, INativeContinuousItem iNativeContinuousItem, List<IEStatement> list, boolean bl) {
        int n2;
        int n3;
        if (bl) {
            n3 = 2;
            n2 = 1;
        } else {
            n3 = 1;
            n2 = 2;
        }
        for (int i = 0; i < list.size(); ++i) {
            IEStatement iEStatement = list.get(i);
            Long l3 = iEStatement.getPrimaryLowerLevelAddress();
            if (l3 == null || l3 != l2 || !(iEStatement instanceof ale) || ((ale)iEStatement).Rs() != n3) continue;
            ((ale)iEStatement).ce(n2);
        }
    }

    public final List<IEStatement> convertBlockForTest(BasicBlock<InsnType> basicBlock) {
        try {
            amg amg2 = new amg((alm)this.gCtx);
            this.setCurrentContext(amg2);
            ArrayList<IEStatement> arrayList = new ArrayList<IEStatement>();
            basicBlock = this.preBlockConversion(null, basicBlock, arrayList);
            this.convertBlock(basicBlock, arrayList);
            amg2.setStatements(arrayList);
            this.gCtx.addRoutineContext(amg2);
            ArrayList<IEStatement> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.setCurrentContext(null);
        }
    }

    @Override
    public IEMem createStackMemoryAccess(IEGeneric iEGeneric, int n2) {
        return this.getGlobalContext().createMem(null, iEGeneric, n2);
    }

    @Override
    public long sanitizeNativeAddress(long l2) {
        if (this.getAddressBitsize() >= 64) {
            return l2;
        }
        return MathUtil.zeroExtend(l2, this.getAddressBitsize());
    }

    @Override
    public Boolean isSegmentEMemReferencingPrimaryMemory(IEMem iEMem) {
        return true;
    }

    @Override
    public IEPrototypeHandler getPrototypeHandler(IERoutineContext iERoutineContext) {
        return new EPrototypeHandler(iERoutineContext);
    }

    @Override
    public boolean canCreateCalls() {
        return true;
    }

    @Override
    public IEGeneric convertReturnLocation(IERoutineContext iERoutineContext, IWildcardPrototype iWildcardPrototype) {
        ICallingConvention iCallingConvention = iWildcardPrototype.getCallingConvention();
        IEVar iEVar = this.getStackPointer();
        IEGlobalContext iEGlobalContext = this.getGlobalContext();
        StorageEntry storageEntry = iCallingConvention.getReturnAddressSlot();
        if (storageEntry == null) {
            return null;
        }
        switch (storageEntry.getType()) {
            case REGISTER: {
                IEGeneric iEGeneric = this.getRegisterVariableFromNativeRegisterId(storageEntry.getValue());
                return iEGeneric;
            }
            case STACK: {
                int n2 = storageEntry.getValueAsStackIndex();
                if (n2 == 0) {
                    return iEGlobalContext.createMem(iEVar, this.getAddressBitsize());
                }
                int n3 = n2 * this.getAddressBitsize() / 8;
                return iEGlobalContext.createMem(iEGlobalContext.createOperation(OperationType.ADD, (IEGeneric)iEVar, (IEGeneric)iEGlobalContext.createImm(n3, iEVar.getBitsize())), this.getAddressBitsize());
            }
        }
        throw new DecompilerException("Cannot convert return location");
    }

    @Override
    public List<IEGeneric> convertReturnExpressions(IERoutineContext iERoutineContext, IWildcardPrototype iWildcardPrototype, INativeMethodItem iNativeMethodItem, List<IWildcardType> list, List<IEGeneric> list2) {
        ICallingConvention iCallingConvention = iWildcardPrototype.getCallingConvention();
        IEVar iEVar = this.getStackPointer();
        IEGlobalContext iEGlobalContext = this.getGlobalContext();
        ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>(iCallingConvention.getSpoiledRegisters());
        int n2 = EUtil.determineArgumentStackSlotCount(iWildcardPrototype, list);
        IStorageEntryGenerator iStorageEntryGenerator = iCallingConvention.getOutputsGenerator(n2);
        int n3 = 0;
        for (IWildcardType iWildcardType : iWildcardPrototype.getReturnTypes()) {
            IEGeneric iEGeneric = iERoutineContext.getConverter().getOutputVariableByIndex(iERoutineContext, n3);
            if (iEGeneric != null) {
                ++n3;
            } else {
                int n4 = iWildcardType.getBitsize();
                StorageEntry storageEntry = iStorageEntryGenerator.next(iWildcardType.getLayoutInfo());
                switch (storageEntry.getType()) {
                    case REGISTER: {
                        long l2 = storageEntry.getValue();
                        iEGeneric = this.getRegisterVariableFromNativeRegisterId(l2);
                        arrayList2.remove(l2);
                        break;
                    }
                    case REGISTER_PAIR: {
                        Endianness endianness = this.gCtx.isBigEndian() ? Endianness.BIG_ENDIAN : Endianness.LITTLE_ENDIAN;
                        long l3 = storageEntry.getValue(endianness);
                        long l4 = storageEntry.getValue2(endianness);
                        IEGeneric iEGeneric2 = this.getRegisterVariableFromNativeRegisterId(l3);
                        IEGeneric iEGeneric3 = this.getRegisterVariableFromNativeRegisterId(l4);
                        iEGeneric = this.gCtx.createCompose(iEGeneric2, iEGeneric3);
                        arrayList2.remove(l3);
                        arrayList2.remove(l4);
                        break;
                    }
                    case STACK: {
                        int n5 = storageEntry.getValueAsStackIndex();
                        int n6 = n5 * this.getStackSlotSize();
                        iEGeneric = this.createStackMemoryAccess(EUtil.add(iEVar, iEGlobalContext.createImm(n6, iEVar.getBitsize())), n4);
                        break;
                    }
                    default: {
                        throw new DecompilerException("Cannot convert return");
                    }
                }
                n3 += storageEntry.getSlotCount();
            }
            iEGeneric.setType(iWildcardType);
            arrayList.add(iEGeneric);
        }
        if (list2 != null) {
            Iterator<IWildcardType> iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                long l5 = (Long)((Object)iterator.next());
                IEGeneric iEGeneric = this.getRegisterVariableFromNativeRegisterId(l5);
                if (iEGeneric == null) continue;
                list2.add(iEGeneric);
            }
        }
        return arrayList;
    }

    @Override
    public List<IEGeneric> convertParameterExpressions(IERoutineContext iERoutineContext, IWildcardPrototype iWildcardPrototype, INativeMethodItem iNativeMethodItem, List<IWildcardType> list) {
        ICallingConvention iCallingConvention = iWildcardPrototype.getCallingConvention();
        IEVar iEVar = this.getStackPointer();
        IEGlobalContext iEGlobalContext = this.getGlobalContext();
        ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
        IStorageEntryGenerator iStorageEntryGenerator = iCallingConvention.getInputsGenerator();
        int n2 = 0;
        for (IWildcardType iWildcardType : EUtil.gatherArgumentTypes(iWildcardPrototype, list)) {
            IEGeneric iEGeneric = iERoutineContext.getConverter().getInputVariableByIndex(iERoutineContext, n2);
            if (iEGeneric != null) {
                ++n2;
            } else {
                int n3 = iWildcardType.getBitsize();
                StorageEntry storageEntry = iStorageEntryGenerator.next(iWildcardType.getLayoutInfo());
                switch (storageEntry.getType()) {
                    case REGISTER: {
                        iEGeneric = this.getRegisterVariableFromNativeRegisterId(storageEntry.getValue());
                        iEGeneric = iEGeneric.part(n3);
                        break;
                    }
                    case REGISTER_PAIR: {
                        Endianness endianness = this.gCtx.isBigEndian() ? Endianness.BIG_ENDIAN : Endianness.LITTLE_ENDIAN;
                        IEGeneric iEGeneric2 = this.getRegisterVariableFromNativeRegisterId(storageEntry.getValue(endianness));
                        IEGeneric iEGeneric3 = this.getRegisterVariableFromNativeRegisterId(storageEntry.getValue2(endianness));
                        iEGeneric = this.gCtx.createCompose(iEGeneric2, iEGeneric3);
                        break;
                    }
                    case STACK: {
                        int n4 = storageEntry.getValueAsStackIndex();
                        int n5 = n4 * this.getStackSlotSize();
                        iEGeneric = this.createStackMemoryAccess(EUtil.add(iEVar, iEGlobalContext.createImm(n5, iEVar.getBitsize())), n3);
                        break;
                    }
                    default: {
                        throw new RuntimeException("TBI");
                    }
                }
                n2 += storageEntry.getSlotCount();
            }
            iEGeneric.setType(iWildcardType);
            arrayList.add(iEGeneric);
        }
        return arrayList;
    }

    @Override
    public IEVar getInputVariableByIndex(IERoutineContext iERoutineContext, int n2) {
        return null;
    }

    @Override
    public IEVar getOutputVariableByIndex(IERoutineContext iERoutineContext, int n2) {
        return null;
    }

    @Override
    public Integer determineStackPointerDeltaAfterIRCall(IWildcardPrototype iWildcardPrototype, List<IWildcardType> list) {
        ICallingConvention iCallingConvention = iWildcardPrototype.getCallingConvention();
        if (iCallingConvention == null || iCallingConvention.getReturnAddressSlot() == null) {
            return null;
        }
        int n2 = 0;
        if (iCallingConvention.getReturnAddressSlot().getType() == StorageEntry.Type.STACK) {
            ++n2;
        }
        if (iCallingConvention.isStackCleanedByCallee()) {
            int n3 = EUtil.determineArgumentStackSlotCount(iWildcardPrototype, list);
            n2 += n3;
            n2 += EUtil.determineReturnValuesStackSlotCount(iWildcardPrototype, n3);
        }
        return n2 * this.getStackSlotSize();
    }

    @Override
    public Integer determineStackBytesUsedByCall(IWildcardPrototype iWildcardPrototype, List<IWildcardType> list) {
        ICallingConvention iCallingConvention = iWildcardPrototype.getCallingConvention();
        int n2 = 0;
        if (iCallingConvention.getReturnAddressSlot().getType() == StorageEntry.Type.STACK) {
            ++n2;
        }
        int n3 = EUtil.determineArgumentStackSlotCount(iWildcardPrototype, list);
        n2 += n3;
        return (n2 += EUtil.determineReturnValuesStackSlotCount(iWildcardPrototype, n3)) * this.getStackSlotSize();
    }

    @Override
    public Integer determineStackPointerDeltaFromSimulation(SimulationPointInformation simulationPointInformation) {
        return null;
    }

    @Override
    public IEBranchDetails getDefaultBranchToRoutineSideEffects(INativeMethodItem iNativeMethodItem) {
        return new EBranchDetails();
    }

    @Override
    public IWildcardPrototype buildFailsafePrototype(IERoutineContext iERoutineContext, IEStatement iEStatement) {
        IWildcardTypeManager iWildcardTypeManager = iERoutineContext.getWildcardTypeManager();
        IPrototypeItem iPrototypeItem = iWildcardTypeManager.getNativeTypeManager().createPrototype(null, null, null, null);
        IWildcardPrototype iWildcardPrototype = iWildcardTypeManager.createPrototype(iPrototypeItem);
        return iWildcardPrototype;
    }

    private IEGeneric findReturnAddrVar(IERoutineContext iERoutineContext, CFG<IEStatement> cFG, BasicBlock<IEStatement> basicBlock, IEGeneric iEGeneric, StorageEntry storageEntry, Collection<Integer> collection) {
        IEGeneric iEGeneric2;
        switch (storageEntry.getType()) {
            case REGISTER: {
                IDFA<IEStatement> iDFA = cFG.doDataFlowAnalysis();
                iEGeneric2 = iERoutineContext.getInputVariableForRegister(iDFA, storageEntry.getValue());
                if (iEGeneric2 != null) break;
                IEGeneric iEGeneric3 = this.getRegisterVariableFromNativeRegisterId(storageEntry.getValue());
                iEGeneric2 = iERoutineContext.retrieveVariableForRegister(iEGeneric3, collection, false);
                break;
            }
            case STACK: {
                int n2 = storageEntry.getValueAsStackIndex();
                iEGeneric2 = iERoutineContext.getStackManager().getVariableAtSlot(n2);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported entry type for location of return address: " + storageEntry);
            }
        }
        return iEGeneric2;
    }

    @Override
    public int insertReturns(IERoutineContext iERoutineContext) {
        IWildcardPrototype iWildcardPrototype = iERoutineContext.getPrototype();
        if (iWildcardPrototype == null) {
            throw new IllegalStateException("Prototype discovery must be performed first");
        }
        ICallingConvention iCallingConvention = iWildcardPrototype.getCallingConvention();
        (new Object[1])[0] = iCallingConvention;
        CFG<IEStatement> cFG = iERoutineContext.getCfg();
        IDFA<IEStatement> iDFA = cFG.doDataFlowAnalysis();
        int n2 = 0;
        int n3 = 0;
        block5: while (n3 < cFG.size()) {
            IEGeneric iEGeneric;
            IEGeneric iEGeneric2;
            Object object;
            IBasicBlock iBasicBlock;
            AddressableInstruction addressableInstruction;
            IEStatement iEStatement;
            if (!((iEStatement = (IEStatement)(addressableInstruction = ((BasicBlock)(iBasicBlock = cFG.get(n3++))).getLast2()).getInstruction()) instanceof IECall) && !EUtil.isPCAssign(iEStatement)) continue;
            boolean bl = false;
            if (((BasicBlock)iBasicBlock).outsize() != 0) {
                if (!iEStatement.isCall() || !Boolean.FALSE.equals(EUtil.checkCallReturnAddress(iERoutineContext, cFG, (BasicBlock<IEStatement>)iBasicBlock, ((BasicBlock)iBasicBlock).size() - 1))) continue;
                bl = true;
            }
            int n4 = EUtil.determineArgumentStackSlotCount(iWildcardPrototype, null);
            Collection<Integer> collection = iDFA.getOutputs(iBasicBlock);
            StorageEntry storageEntry = iCallingConvention.getReturnAddressSlot(n4);
            if (iEStatement instanceof IECall) {
                object = (IECall)iEStatement;
                if (Booleans.isTrue(object.getNonReturning())) continue;
                iEGeneric2 = object.getReturnLocation();
            } else {
                if (!(iEStatement instanceof IEAssign) || (object = (IEAssign)iEStatement).getLeftOperand() != this.getProgramCounter() || !addressableInstruction.getBreakingFlow().isBroken()) continue;
                iEGeneric2 = object.getSrcOperand();
            }
            if ((iEGeneric = this.findReturnAddrVar(iERoutineContext, cFG, (BasicBlock<IEStatement>)iBasicBlock, iEGeneric2, storageEntry, collection)) == null || (iEGeneric = this.normalizeBranchingExpression(iDFA, (BasicBlock<IEStatement>)iBasicBlock, iEGeneric2, iEGeneric)) == null) continue;
            logger.iH("Will insert a return in instruction: '%s'", iEStatement);
            object = iCallingConvention.getOutputsGenerator(n4);
            ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
            IEGeneric iEGeneric3 = null;
            for (IWildcardType iWildcardType : iWildcardPrototype.getReturnTypes()) {
                storageEntry = object.next(iWildcardType.getLayoutInfo());
                if (storageEntry == null) {
                    logger.warn("Cannot find storage location for output: %s", iWildcardType.getLayoutInfo());
                    continue;
                }
                switch (storageEntry.getType()) {
                    case REGISTER: {
                        EVarCopyFinder eVarCopyFinder = iERoutineContext.copyFinder(storageEntry, collection, addressableInstruction.getOffset());
                        iEGeneric3 = eVarCopyFinder.getIRForSlicedReg(true);
                        if (iEGeneric3 != null) break;
                        logger.debug("Retval in register is missing", new Object[0]);
                        break;
                    }
                    case REGISTER_PAIR: {
                        EVarCopyFinder eVarCopyFinder = iERoutineContext.copyFinder(storageEntry, collection, addressableInstruction.getOffset());
                        iEGeneric3 = eVarCopyFinder.getVarForRegPair(true);
                        if (iEGeneric3 != null) break;
                        logger.debug("Retval in register-pair is missing", new Object[0]);
                        break;
                    }
                    case STACK: {
                        int n5 = storageEntry.getValueAsStackIndex();
                        iEGeneric3 = iERoutineContext.getStackManager().getVariableAtSlot(n5);
                        if (iEGeneric3 != null) break;
                        logger.debug("Retval on stack is missing", new Object[0]);
                    }
                }
                if (iEGeneric3 == null) continue block5;
                arrayList.add(iEGeneric3);
            }
            IEReturn iEReturn = iERoutineContext.createReturn(arrayList);
            if (iEStatement instanceof IECall) {
                if (iEStatement.getSize() <= 1) {
                    logger.warn("Cannot insert EReturn (ECall cannot be split)", new Object[0]);
                    continue;
                }
                if (bl) {
                    cFG.deleteOutEdges((BasicBlock<IEStatement>)iBasicBlock);
                }
                long l2 = ((BasicBlock)iBasicBlock).getEndAddress() - 1L;
                iEStatement.adjustSize(-1);
                ((IECall)iEStatement).setTentativeCall(false);
                ((ali)iEStatement).setReturnLocation(null);
                BasicBlock<Object> basicBlock = new BasicBlock<Object>(l2);
                basicBlock.add(iEReturn);
                iEReturn.copyLowerLevelAddresses(iEStatement);
                cFG.addBlock(cFG.indexOf((BasicBlock<IEStatement>)iBasicBlock) + 1, basicBlock);
                ++n3;
                cFG.addEdge((BasicBlock<IEStatement>)iBasicBlock, basicBlock, 0);
            } else {
                iEReturn.copyProperties(iEStatement);
                ((BasicBlock)iBasicBlock).set(((BasicBlock)iBasicBlock).size() - 1, iEReturn);
            }
            ++n2;
        }
        if (n2 != 0) {
            cFG.invalidateDataFlowAnalysis();
        }
        return n2;
    }

    @Override
    public IEGeneric normalizeBranchingExpression(IDFA<IEStatement> iDFA, BasicBlock<IEStatement> basicBlock, IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        if (iEGeneric == null) {
            return null;
        }
        if (iEGeneric2 == null) {
            return iEGeneric;
        }
        if (!this.isPCRightValueCompatibleReturnValue(iDFA, basicBlock, iEGeneric, iEGeneric2)) {
            return null;
        }
        return iEGeneric;
    }

    protected final boolean isPCRightValueCompatibleReturnValue(IDFA<IEStatement> iDFA, BasicBlock<IEStatement> basicBlock, IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        if (iEGeneric == iEGeneric2) {
            return true;
        }
        if (iEGeneric instanceof IEVar) {
            Object object = (IEVar)iEGeneric;
            long l2 = basicBlock.getLastAddress();
            while (true) {
                Collection<Long> collection = iDFA.getUseDefs(l2, object.getId());
                long l3 = -1L;
                IEStatement iEStatement = null;
                Object object2 = collection.iterator();
                while (object2.hasNext()) {
                    long l4 = object2.next();
                    IEStatement iEStatement2 = iDFA.getCfg().getInstruction(l4);
                    if (!(iEStatement2 instanceof IEAssign) || ((IEAssign)iEStatement2).getDstOperand() instanceof IEMem) continue;
                    if (iEStatement != null) {
                        iEStatement = null;
                        break;
                    }
                    iEStatement = iEStatement2;
                    l3 = l4;
                }
                if (iEStatement == null || !(((IEAssign)iEStatement).getSrcOperand() instanceof IEVar)) break;
                object2 = (IEVar)((IEAssign)iEStatement).getSrcOperand();
                if (object2.equalsEx(iEGeneric2, false)) {
                    return true;
                }
                object = object2;
                l2 = l3;
            }
        }
        return false;
    }

    @Override
    public int defaultPCConversion(IERoutineContext iERoutineContext) {
        CFG<IEStatement> cFG = iERoutineContext.getCfg();
        int n2 = 0;
        for (BasicBlock<IEStatement> basicBlock : cFG.getBlocks()) {
            IEGeneric iEGeneric;
            IFlowInformation iFlowInformation;
            IEAssign iEAssign;
            AddressableInstruction<IEStatement> addressableInstruction = basicBlock.getLast2();
            if (!(addressableInstruction.getInstruction() instanceof IEAssign) || (iEAssign = (IEAssign)addressableInstruction.getInstruction()).getLeftOperand() != this.getProgramCounter() || !(iFlowInformation = iEAssign.getBreakingFlow(addressableInstruction.getOffset(), true)).isBroken()) continue;
            IEGeneric iEGeneric2 = null;
            IEGeneric iEGeneric3 = iEAssign.getRightOperand();
            if (iEGeneric3 instanceof IECond) {
                iEGeneric = ((IECond)iEGeneric3).getCondition();
                IEGeneric iEGeneric4 = ((IECond)iEGeneric3).getExpressionTrue();
                IEGeneric iEGeneric5 = ((IECond)iEGeneric3).getExpressionFalse();
                long l2 = addressableInstruction.getOffset() + (long)iEAssign.getSize();
                Long l3 = null;
                Long l4 = null;
                if (EUtil.isLikeLongImmediate(iEGeneric4)) {
                    l3 = iERoutineContext.convertNativeAddress(EUtil.evaluateAddress_preVerified(iEGeneric4));
                }
                if (EUtil.isLikeLongImmediate(iEGeneric5)) {
                    l4 = iERoutineContext.convertNativeAddress(EUtil.evaluateAddress_preVerified(iEGeneric5));
                }
                if (l3 != null && l3 == l2) {
                    iEGeneric2 = iERoutineContext.createOperation(OperationType.LOG_NOT, iEGeneric);
                    iEGeneric3 = iEGeneric5;
                } else if (l4 != null && l4 == l2) {
                    iEGeneric2 = iEGeneric;
                    iEGeneric3 = iEGeneric4;
                }
            }
            iEGeneric = iERoutineContext.createJumpFar(iEGeneric3, iEGeneric2);
            iEGeneric.setPossibleTargets(iFlowInformation.getTargets());
            iEGeneric.copyProperties(iEAssign);
            basicBlock.set(basicBlock.size() - 1, (IEStatement)iEGeneric);
            ++n2;
        }
        if (n2 != 0) {
            cFG.invalidateDataFlowAnalysis();
        }
        return n2;
    }

    @Override
    public boolean resolveCustomCalls(IERoutineContext iERoutineContext) {
        return false;
    }

    @Override
    public final void initializeStateRegisters(EState eState, Long l2) {
        for (IEVar iEVar : this.getGlobalContext().getAllRegisters()) {
            try {
                long l3 = this.getNativeRegisterIdFromRegisterVariable(iEVar);
                if (this.isPossibleParameterRegisterForProcessorCallingConventions(l3)) continue;
                eState.setValue(iEVar, 0L);
            }
            catch (DecompilerException decompilerException) {
                eState.setValue(iEVar, 0L);
            }
        }
        if (l2 != null) {
            eState.setValue(this.getProgramCounter(), (long)l2);
        }
        this.customInitStateRegisters(eState, l2);
    }

    @Override
    public void customInitStateRegisters(EState eState, Long l2) {
    }

    private void initParameterRegistersForProcessorCallingConventions() {
        ICallingConventionManager iCallingConventionManager;
        this.parameterRegistersForAllCC = Collections.emptySet();
        ITypeManager iTypeManager = this.nctx.getTypeManager();
        if (iTypeManager != null && (iCallingConventionManager = iTypeManager.getCallingConventionManager()) != null) {
            this.parameterRegistersForAllCC = CallingConventionUtil.getParameterRegisters(iCallingConventionManager, this.gCtx.isBigEndian() ? Endianness.BIG_ENDIAN : Endianness.LITTLE_ENDIAN);
        }
    }

    public boolean isPossibleParameterRegisterForProcessorCallingConventions(long l2) {
        if (this.parameterRegistersForAllCC == null) {
            this.initParameterRegistersForProcessorCallingConventions();
        }
        return this.parameterRegistersForAllCC.contains(l2);
    }

    private void initSpoiledRegistersForProcessorCallingConventions() {
        ICallingConventionManager iCallingConventionManager;
        this.spoiledRegistersForAllCC = Collections.emptySet();
        ITypeManager iTypeManager = this.nctx.getTypeManager();
        if (iTypeManager != null && (iCallingConventionManager = iTypeManager.getCallingConventionManager()) != null) {
            this.spoiledRegistersForAllCC = CallingConventionUtil.getSpoiledRegisters(iCallingConventionManager);
        }
    }

    public boolean isPossibleSpoiledRegistersForProcessorCallingConventions(long l2) {
        if (this.spoiledRegistersForAllCC == null) {
            this.initSpoiledRegistersForProcessorCallingConventions();
        }
        return this.spoiledRegistersForAllCC.contains(l2);
    }

    @Override
    public int getStateProcessorMode(EState eState) {
        return this.proc.getMode();
    }

    @Override
    public IEVar getReturnAddressRegister() {
        return null;
    }

    @Override
    public IEVar getGPRegister(int n2) {
        return null;
    }

    @Override
    public IEVar getFPRegister(int n2) {
        return null;
    }

    @Override
    public IEVar getTempRegister(int n2) {
        return null;
    }

    @Override
    public String formatStatistics() {
        StringBuilder stringBuilder = new StringBuilder();
        Strings.ff(stringBuilder, "Method conversion count: %d success, %d failure", this.methodConversionCountSuccess, this.methodConversionCountFailure);
        int n2 = this.methodConversionCountFailure + this.methodConversionCountSuccess;
        if (n2 > 0) {
            double d = (double)this.methodConversionCountSuccess / (double)n2 * 100.0;
            Strings.ff(stringBuilder, " (success rate: %.1f%%)", d);
        }
        return stringBuilder.toString();
    }

    @Override
    public ICStatement generateASTForUntranslatedIR(IEUntranslatedInstruction iEUntranslatedInstruction, IERoutineContext iERoutineContext, ICMethod iCMethod) {
        return null;
    }

    @Override
    public IEImm evaluateUntranslatedIR(IEUntranslatedInstruction iEUntranslatedInstruction, IERoutineContext iERoutineContext, EState eState) {
        return null;
    }

    public final boolean autoConvert(ConverterInstructionEntry<InsnType> converterInstructionEntry, ACS aCS) {
        return new AutoConverter(aCS).convert(converterInstructionEntry);
    }

    @SerDisabled
    private class AutoConverter {
        ACS acs;
        List<IEGeneric> _opnds;

        AutoConverter(ACS aCS) {
            this.acs = aCS;
        }

        boolean convert(ConverterInstructionEntry<InsnType> converterInstructionEntry) {
            ACS.OPS oPS = this.acs.getOpcodeSemantic();
            this._opnds = new ArrayList<IEGeneric>(converterInstructionEntry.insn.getOperands().length);
            for (int i = 0; i < converterInstructionEntry.insn.getCountOfOperands(); ++i) {
                this._opnds.add(AbstractConverter.this.convertOperand(converterInstructionEntry.address, converterInstructionEntry.insn, i));
            }
            IEGeneric iEGeneric = this.findDst();
            IEGeneric iEGeneric2 = this.findSrc1();
            IEGeneric iEGeneric3 = this.findSrc2();
            IEGeneric iEGeneric4 = this.findSrc3();
            Object object = oPS.getDirectConversionOperationType();
            if (object != null) {
                Integer n2 = this.acs.operationBitsize();
                if (n2 == null) {
                    this.asg(converterInstructionEntry, iEGeneric, AbstractConverter.this.gCtx.createOperation((OperationType)((Object)object), iEGeneric2, iEGeneric3));
                } else {
                    IEGeneric iEGeneric5 = AbstractConverter.this.gCtx.createOperation((OperationType)((Object)object), iEGeneric2.part(n2), iEGeneric3 == null ? null : iEGeneric3.part(n2));
                    if (this.acs.extensionMode() == null) {
                        iEGeneric = iEGeneric.part(n2);
                    } else if (this.acs.extensionMode() == 0) {
                        iEGeneric5 = iEGeneric5.zeroExtend(iEGeneric.getBitsize());
                    } else if (this.acs.extensionMode() == 1) {
                        iEGeneric5 = iEGeneric5.signExtend(iEGeneric.getBitsize());
                    }
                    this.asg(converterInstructionEntry, iEGeneric, iEGeneric5);
                }
                return true;
            }
            switch (oPS) {
                case NOP: {
                    converterInstructionEntry.r.add(AbstractConverter.this.ctx.createNop());
                    break;
                }
                case MOVE: {
                    this.asg(converterInstructionEntry, iEGeneric, iEGeneric2);
                    break;
                }
                case STORE: {
                    object = this.acs.operationBitsize();
                    if (object == null) {
                        object = this.findSrc1().getBitsize();
                    }
                    if (iEGeneric != null) {
                        Assert.a(iEGeneric instanceof IEMem);
                        Assert.a(iEGeneric.getBitsize() == ((Integer)object).intValue());
                        this.asg(converterInstructionEntry, iEGeneric, iEGeneric2.part((Integer)object));
                        break;
                    }
                    if (iEGeneric4 == null) {
                        this.asg(converterInstructionEntry, AbstractConverter.this.gCtx.createMem(iEGeneric3, (Integer)object), iEGeneric2.part((Integer)object));
                        break;
                    }
                    IEOperation iEOperation = AbstractConverter.this.gCtx.createOperation(OperationType.ADD, iEGeneric3, iEGeneric4);
                    this.asg(converterInstructionEntry, AbstractConverter.this.gCtx.createMem(iEOperation, (Integer)object), iEGeneric2.part((Integer)object));
                    break;
                }
                case LOAD: {
                    Integer n3;
                    if (iEGeneric2 instanceof IEMem) {
                        object = iEGeneric2;
                    } else if (iEGeneric3 == null) {
                        n3 = this.acs.operationBitsize();
                        object = AbstractConverter.this.gCtx.createMem(iEGeneric2, n3);
                    } else {
                        n3 = this.acs.operationBitsize();
                        object = AbstractConverter.this.gCtx.createMem(AbstractConverter.this.gCtx.createOperation(OperationType.ADD, iEGeneric2, iEGeneric3), n3);
                    }
                    boolean bl = this.acs.isSignedExtension(true);
                    object = bl ? object.signExtend(iEGeneric.getBitsize()) : object.zeroExtend(iEGeneric.getBitsize());
                    this.asg(converterInstructionEntry, iEGeneric, (IEGeneric)object);
                    break;
                }
                case SET_IF_EQ: 
                case SET_IF_NE: 
                case SET_IF_LT_S: 
                case SET_IF_LT_U: 
                case SET_IF_LE_S: 
                case SET_IF_LE_U: 
                case SET_IF_GT_S: 
                case SET_IF_GT_U: 
                case SET_IF_GE_S: 
                case SET_IF_GE_U: {
                    switch (oPS) {
                        case SET_IF_EQ: {
                            object = OperationType.LOG_EQ;
                            break;
                        }
                        case SET_IF_NE: {
                            object = OperationType.LOG_NEQ;
                            break;
                        }
                        case SET_IF_LT_S: {
                            object = OperationType.LT_S;
                            break;
                        }
                        case SET_IF_LT_U: {
                            object = OperationType.LT_U;
                            break;
                        }
                        case SET_IF_LE_S: {
                            object = OperationType.LE_S;
                            break;
                        }
                        case SET_IF_LE_U: {
                            object = OperationType.LE_U;
                            break;
                        }
                        case SET_IF_GT_S: {
                            object = OperationType.GT_S;
                            break;
                        }
                        case SET_IF_GT_U: {
                            object = OperationType.GT_U;
                            break;
                        }
                        case SET_IF_GE_S: {
                            object = OperationType.GE_S;
                            break;
                        }
                        case SET_IF_GE_U: {
                            object = OperationType.GE_U;
                            break;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                    int n4 = iEGeneric.getBitsize();
                    this.asg(converterInstructionEntry, iEGeneric, AbstractConverter.this.gCtx.createCond(EUtil.op(object, iEGeneric2, iEGeneric3), EUtil.one(n4), EUtil.zero(n4)));
                    break;
                }
                case JUMP_IF_EQ: 
                case JUMP_IF_NE: 
                case JUMP_IF_LT_S: 
                case JUMP_IF_LT_U: 
                case JUMP_IF_LE_S: 
                case JUMP_IF_LE_U: 
                case JUMP_IF_GT_S: 
                case JUMP_IF_GT_U: 
                case JUMP_IF_GE_S: 
                case JUMP_IF_GE_U: {
                    switch (oPS) {
                        case JUMP_IF_EQ: {
                            object = OperationType.LOG_EQ;
                            break;
                        }
                        case JUMP_IF_NE: {
                            object = OperationType.LOG_NEQ;
                            break;
                        }
                        case JUMP_IF_LT_S: {
                            object = OperationType.LT_S;
                            break;
                        }
                        case JUMP_IF_LT_U: {
                            object = OperationType.LT_U;
                            break;
                        }
                        case JUMP_IF_LE_S: {
                            object = OperationType.LE_S;
                            break;
                        }
                        case JUMP_IF_LE_U: {
                            object = OperationType.LE_U;
                            break;
                        }
                        case JUMP_IF_GT_S: {
                            object = OperationType.GT_S;
                            break;
                        }
                        case JUMP_IF_GT_U: {
                            object = OperationType.GT_U;
                            break;
                        }
                        case JUMP_IF_GE_S: {
                            object = OperationType.GE_S;
                            break;
                        }
                        case JUMP_IF_GE_U: {
                            object = OperationType.GE_U;
                            break;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                    IEImm iEImm = EUtil.imm(converterInstructionEntry.address + (long)converterInstructionEntry.insn.getSize(), AbstractConverter.this.getAddressBitsize());
                    IECond iECond = AbstractConverter.this.gCtx.createCond(EUtil.op(object, iEGeneric2, iEGeneric3), iEGeneric4, iEImm);
                    converterInstructionEntry.r.add(AbstractConverter.this.ctx.createBranchAssign(AbstractConverter.this.getProgramCounter(), iECond, false));
                    break;
                }
                case JUMP: {
                    Object object2;
                    Assert.a(iEGeneric2 != null);
                    object = null;
                    if (iEGeneric != null) {
                        if (iEGeneric.equals(iEGeneric2)) {
                            object = AbstractConverter.this.getTempRegister(0);
                            this.asg(converterInstructionEntry, (IEGeneric)object, iEGeneric);
                        }
                        object2 = EUtil.imm(converterInstructionEntry.address + (long)converterInstructionEntry.insn.getSize(), AbstractConverter.this.getAddressBitsize());
                        this.asg(converterInstructionEntry, iEGeneric, (IEGeneric)object2);
                    }
                    Object object3 = object2 = object != null ? object : iEGeneric2;
                    if (iEGeneric3 != null) {
                        object2 = EUtil.add((IEGeneric)object2, iEGeneric3);
                    }
                    if (this.acs.maskOnSource() != null) {
                        IEImm iEImm = EUtil.imm(BigInteger.valueOf(this.acs.maskOnSource()), object2.getBitsize());
                        object2 = EUtil.andB((IEGeneric)object2, iEImm);
                    }
                    converterInstructionEntry.r.add(AbstractConverter.this.ctx.createBranchAssign(AbstractConverter.this.getProgramCounter(), (IEGeneric)object2, iEGeneric != null));
                    break;
                }
                default: {
                    throw new RuntimeException("TBI: AUTOCONV: " + oPS);
                }
            }
            return true;
        }

        void asg(ConverterInstructionEntry<InsnType> converterInstructionEntry, IEGeneric iEGeneric, IEGeneric iEGeneric2) {
            converterInstructionEntry.r.add(AbstractConverter.this.ctx.createAssign(iEGeneric, iEGeneric2));
        }

        IEGeneric findSrc1() {
            return this.find(this._opnds, 2);
        }

        IEGeneric findSrc2() {
            return this.find(this._opnds, 4);
        }

        IEGeneric findSrc3() {
            return this.find(this._opnds, 8);
        }

        IEGeneric findDst() {
            return this.find(this._opnds, 1);
        }

        private IEGeneric find(List<IEGeneric> list, int n2) {
            int n3 = this.acs.findOperandIndexByFlag(n2);
            if (n3 < 0) {
                return null;
            }
            if (n3 < list.size()) {
                return list.get(n3);
            }
            int n4 = this.acs.getOperandSemanticFlags(n3);
            if ((n4 & 0xFF) != 0) {
                if ((n4 & 0x10000) == 65536) {
                    return EUtil.zero(AbstractConverter.this.getRegisterBitsize());
                }
                if ((n4 & 0xF000000) != 0) {
                    return AbstractConverter.this.getGPRegister((n4 >> 24) - 1);
                }
            }
            return null;
        }
    }
}

