/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.OperationType;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.math.MathUtil;

public class ACS {
    public static final int dst = 1;
    public static final int src1 = 2;
    public static final int src2 = 4;
    public static final int src3 = 8;
    public static final int dst_src1 = 3;
    public static final int IMM0 = 65536;
    public static final int GPR_MASK = 0xF000000;
    public static final int GPR0 = 0x1000000;
    public static final int GPR1 = 0x2000000;
    public static final int GPR2 = 0x3000000;
    public static final int GPR3 = 0x4000000;
    public static final int GPR4 = 0x5000000;
    public static final int GPR5 = 0x6000000;
    public static final int GPR6 = 0x7000000;
    public static final int GPR7 = 0x8000000;
    private OPS opcodeSem;
    private int[] opndSemFlags;
    private Integer operationBitsize;
    private Integer extensionMode;
    private Long maskOnSource;

    public static int regSlice(int n2, int n3) {
        Assert.a(n2 >= 0 && n3 > n2);
        int n4 = 0;
        if (n2 != 0) {
            n4 = MathUtil.log2(n2);
            Assert.a(n2 == 1 << n4 && n4 <= 15);
        }
        int n5 = 0;
        if (n3 != 0) {
            n5 = MathUtil.log2(n3);
            Assert.a(n3 == 1 << n5 && n5 <= 15);
        }
        return n4 << 8 | n5 << 12;
    }

    public static ACS make(OPS oPS, int ... nArray) {
        return new ACS(oPS, nArray);
    }

    public ACS(OPS oPS, int[] nArray) {
        if (oPS == null) {
            throw new RuntimeException();
        }
        this.opcodeSem = oPS;
        this.opndSemFlags = nArray;
    }

    public ACS(OPS oPS, Integer n2, Integer n3, int[] nArray) {
        if (oPS == null) {
            throw new RuntimeException();
        }
        this.opcodeSem = oPS;
        this.opndSemFlags = nArray;
        this.operationBitsize = n2;
        this.extensionMode = n3;
    }

    public OPS getOpcodeSemantic() {
        return this.opcodeSem;
    }

    public int getOperandSemanticFlags(int n2) {
        return this.opndSemFlags[n2];
    }

    public int findOperandIndexByFlag(int n2) {
        for (int i = 0; i < this.opndSemFlags.length; ++i) {
            if ((this.opndSemFlags[i] & n2) != n2) continue;
            return i;
        }
        return -1;
    }

    public ACS operationBitsize(Integer n2) {
        this.operationBitsize = n2;
        return this;
    }

    public ACS operationBitsizeAndSignExtendToDest(Integer n2) {
        this.operationBitsize = n2;
        this.extensionMode = 1;
        return this;
    }

    public ACS operationBitsizeAndZeroExtendToDest(Integer n2) {
        this.operationBitsize = n2;
        this.extensionMode = 0;
        return this;
    }

    public Integer operationBitsize() {
        return this.operationBitsize;
    }

    public int getBitsize(int n2) {
        if (this.operationBitsize == null) {
            return n2;
        }
        return this.operationBitsize;
    }

    public ACS extensionMode(Integer n2) {
        this.extensionMode = n2;
        return this;
    }

    public Integer extensionMode() {
        return this.extensionMode;
    }

    public boolean isSignedExtension(boolean bl) {
        if (this.extensionMode == null) {
            return bl;
        }
        if (this.extensionMode == 0) {
            return false;
        }
        if (this.extensionMode == 1) {
            return true;
        }
        return bl;
    }

    public ACS maskOnSource(Long l2) {
        this.maskOnSource = l2;
        return this;
    }

    public Long maskOnSource() {
        return this.maskOnSource;
    }

    public static enum ExtensionMode {
        NONE,
        SIGN_EXTEND,
        ZERO_EXTEND;

    }

    public static enum OPS {
        CUSTOM,
        NOP,
        MOVE,
        STORE,
        LOAD,
        ADD(OperationType.ADD),
        SUB(OperationType.SUB),
        MUL(OperationType.MUL),
        DIV_S(OperationType.DIV_S),
        DIV_U(OperationType.DIV_U),
        REM_S(OperationType.REM_S),
        REM_U(OperationType.REM_U),
        AND(OperationType.AND),
        OR(OperationType.OR),
        XOR(OperationType.XOR),
        NOT(OperationType.NOT),
        SHL(OperationType.SHL),
        SHR(OperationType.SHR),
        SAR(OperationType.SAR),
        SET_IF_EQ,
        SET_IF_NE,
        SET_IF_LT_S,
        SET_IF_LT_U,
        SET_IF_LE_S,
        SET_IF_LE_U,
        SET_IF_GT_S,
        SET_IF_GT_U,
        SET_IF_GE_S,
        SET_IF_GE_U,
        JUMP_IF_EQ,
        JUMP_IF_NE,
        JUMP_IF_LT_S,
        JUMP_IF_LT_U,
        JUMP_IF_LE_S,
        JUMP_IF_LE_U,
        JUMP_IF_GT_S,
        JUMP_IF_GT_U,
        JUMP_IF_GE_S,
        JUMP_IF_GE_U,
        JUMP;

        private final OperationType op;

        private OPS() {
            this.op = null;
        }

        private OPS(OperationType operationType) {
            this.op = operationType;
        }

        public OperationType getDirectConversionOperationType() {
            return this.op;
        }
    }
}

