/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.cfg;

import com.pnfsoftware.jeb.core.units.code.IVariable;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IVariableProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class FineChainsConverter {
    private IVariableProvider varprv;

    public FineChainsConverter(IVariableProvider iVariableProvider) {
        this.varprv = iVariableProvider;
    }

    public Map<Integer, Set<Integer>> convertToCoarseSimpleChains(Map<Integer, Set<Integer>> map) {
        return this.convertToCoarseChains(map);
    }

    public Map<Integer, Set<Long>> convertToCoarseFullChains(Map<Integer, Set<Long>> map) {
        return this.convertToCoarseChains(map);
    }

    private <T extends Number> Map<Integer, Set<T>> convertToCoarseChains(Map<Integer, Set<T>> map) {
        HashMap<Integer, Set<T>> hashMap = new HashMap<Integer, Set<T>>();
        for (int n2 : map.keySet()) {
            IVariable iVariable = this.varprv.getContaining(n2);
            if (iVariable == null) {
                throw new RuntimeException("No variable contains the vbit " + n2);
            }
            int n3 = iVariable.getId();
            HashSet hashSet = (HashSet)hashMap.get(n3);
            if (hashSet == null) {
                hashSet = new HashSet();
                hashMap.put(n3, hashSet);
            }
            hashSet.addAll(map.get(n2));
        }
        return hashMap;
    }
}

