/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.cfg;

import com.pnfsoftware.jeb.core.units.code.ICodePointer;
import com.pnfsoftware.jeb.core.units.code.IFlowInformation;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CfgVerificationException;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.primitives.Longs;
import com.pnfsoftware.jebglobal.alg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

public class CFGVerifier<InsnType extends IInstruction> {
    private static final ILogger logger = GlobalLog.getLogger(CFGVerifier.class);
    protected CFG<InsnType> cfg;

    public CFGVerifier(CFG<InsnType> cFG) {
        this.cfg = cFG;
    }

    protected void customVerification() throws CfgVerificationException {
    }

    protected boolean shouldExpectFallthrough(InsnType InsnType) {
        return false;
    }

    public void verify() throws CfgVerificationException {
        this.customVerification();
        for (BasicBlock<InsnType> basicBlock : this.cfg) {
            int n2;
            boolean bl = false;
            for (n2 = 0; n2 < basicBlock.size(); ++n2) {
                InsnType InsnType = basicBlock.get(n2);
                IFlowInformation iFlowInformation = InsnType.getBreakingFlow(basicBlock.getAddressOfInstruction(n2));
                if (iFlowInformation.isBroken()) {
                    if (bl) {
                        throw new CfgVerificationException("Block %X: Multiple branching statements", basicBlock.getBase());
                    }
                    bl = true;
                    if (n2 + iFlowInformation.getDelaySlotCount() + 1 != basicBlock.size()) {
                        throw new CfgVerificationException("Block %X: Illegal location for branching", basicBlock.getBase());
                    }
                    this.verifyBranchingInstruction(basicBlock, InsnType, iFlowInformation);
                }
                if (!(iFlowInformation = InsnType.getRoutineCall(basicBlock.getAddressOfInstruction(n2))).isBroken() || (this.cfg.getFlags() & 1) != 0) continue;
                if (bl) {
                    throw new CfgVerificationException("Block %X: Multiple branching statements", basicBlock.getBase());
                }
                bl = true;
                if (n2 + iFlowInformation.getDelaySlotCount() + 1 == basicBlock.size()) continue;
                throw new CfgVerificationException("Block %X: Illegal location for branching statement", basicBlock.getBase());
            }
            if (bl || (n2 = basicBlock.outsize()) == 0) continue;
            if (n2 == 1) {
                this.verifyFallthrough(basicBlock, null);
                continue;
            }
            throw new CfgVerificationException("Block %X: Not expecting multiple out-edges", basicBlock.getBase());
        }
    }

    private void verifyBranchingInstruction(BasicBlock<InsnType> basicBlock, InsnType InsnType, IFlowInformation iFlowInformation) throws CfgVerificationException {
        List<ICodePointer> list = iFlowInformation.getTargets();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        HashSet<Long> hashSet = new HashSet<Long>();
        TreeSet<Long> treeSet = new TreeSet<Long>();
        for (ICodePointer object2 : list) {
            if (object2.isUnknownAddress()) continue;
            arrayList.add(object2.getAddress());
            hashSet.add(object2.getAddress());
            if (this.cfg.getInstruction(object2.getAddress()) != null) continue;
            treeSet.add(object2.getAddress());
        }
        if (iFlowInformation.mustComputeFallThrough()) {
            arrayList.add(0, basicBlock.getEndAddress());
            hashSet.add(basicBlock.getEndAddress());
        }
        if (!treeSet.isEmpty()) {
            throw new CfgVerificationException("Block %X: Targets do not point to instructions: %s (instruction: %s)", basicBlock.getBase(), Longs.formatHexCollection(treeSet), InsnType);
        }
        if (arrayList.size() != hashSet.size()) {
            throw new CfgVerificationException("Block %X: Duplicate targets: %s", basicBlock.getBase(), Longs.formatHexCollection(arrayList));
        }
        List<Long> list2 = basicBlock.getOutputOffsets();
        HashSet<Long> hashSet2 = new HashSet<Long>(list2);
        if (list2.size() != hashSet2.size()) {
            throw new CfgVerificationException("Block %X: Duplicate edges: %s", basicBlock.getBase(), Longs.formatHexCollection((Collection<Long>)list2));
        }
        boolean bl = false;
        if (arrayList.size() != basicBlock.outsize()) {
            if (this instanceof alg && ((alg)this).ce().getRoutine().getData().getTrampolineTarget() != null && this.cfg.size() == 1 && arrayList.size() == 1 && basicBlock.outsize() == 0) {
                bl = true;
            }
            if (!bl) {
                throw new CfgVerificationException("Block %X: Number of targets (%d) differ from number of edges (%d)", basicBlock.getBase(), arrayList.size(), basicBlock.outsize());
            }
        }
        if (!bl && !hashSet.equals(hashSet2)) {
            throw new CfgVerificationException("Block %X: Targets are not synchronized with edges: targets=%s / edges=%s", basicBlock.getBase(), Longs.formatHexCollection(hashSet), Longs.formatHexCollection(hashSet2));
        }
        if (this.shouldExpectFallthrough(InsnType)) {
            this.verifyFallthrough(basicBlock, arrayList);
        }
    }

    private void verifyFallthrough(BasicBlock<InsnType> basicBlock, List<Long> list) throws CfgVerificationException {
        long l2 = basicBlock.getEndAddress();
        int n2 = 0;
        for (BasicBlock<InsnType> comparable : basicBlock.getOutputBlocks()) {
            if (comparable.getBase() == l2) {
                if (n2 != 0) {
                    throw new CfgVerificationException("Block %X: Fallthrough is not the first edge (index %d in list: %s)", basicBlock.getBase(), n2, Longs.formatHexCollection(basicBlock.getOutputOffsets()));
                }
                if (list == null || list.isEmpty() || list.get(0) == l2) break;
                throw new CfgVerificationException("Block %X: Fallthrough is not the first target (but is correct in the CFG)", basicBlock.getBase());
            }
            ++n2;
        }
        if (list != null) {
            n2 = 0;
            for (Long l3 : list) {
                if (l3 == l2) {
                    if (n2 != 0) {
                        throw new CfgVerificationException("Block %X: Fallthrough is not the first target (index %d in list: %s)", basicBlock.getBase(), n2, Longs.formatHexCollection(list));
                    }
                    if (basicBlock.outsize() <= 0 || ((BasicBlock)basicBlock.getOutputBlock(0)).getBase() == l2) break;
                    throw new CfgVerificationException("Block %X: Fallthrough is not the first edge (but is correct in targets)", basicBlock.getBase());
                }
                ++n2;
            }
        }
    }
}

