/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.cfg;

import com.pnfsoftware.jeb.core.units.code.IBasicBlock;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.IResizableInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;

public class CFGUtil {
    private static final ILogger logger = GlobalLog.getLogger(CFGUtil.class);

    public static <T extends IInstruction> boolean compare(CFG<T> cFG, CFG<T> cFG2) {
        return CFGUtil.compare(0, null, cFG, cFG2);
    }

    public static <T extends IInstruction> boolean compare(int n2, Comparator<T> comparator, CFG<T> cFG, CFG<T> cFG2) {
        if (cFG.getFlags() != cFG2.getFlags()) {
            return CFGUtil.failComp(n2, "Flags differ: %X, %X", cFG.getFlags(), cFG2.getFlags());
        }
        if (cFG.getEntryAddress() != cFG2.getEntryAddress()) {
            return CFGUtil.failComp(n2, "Entry-point address differ: 0x%X, 0x%X", cFG.getEntryAddress(), cFG2.getEntryAddress());
        }
        if (cFG.size() != cFG2.size()) {
            return CFGUtil.failComp(n2, "Block count differ: %d, %d", cFG.size(), cFG2.size());
        }
        for (int i = 0; i < cFG.size(); ++i) {
            IBasicBlock iBasicBlock = cFG.get(i);
            IBasicBlock iBasicBlock2 = cFG2.get(i);
            if (((BasicBlock)iBasicBlock).getFirstAddress() != ((BasicBlock)iBasicBlock2).getFirstAddress()) {
                return CFGUtil.failComp(n2, "Block #%d address differ: 0x%X, 0x%X", i, ((BasicBlock)iBasicBlock).getFirstAddress(), ((BasicBlock)iBasicBlock2).getFirstAddress());
            }
            if (((BasicBlock)iBasicBlock).size() != ((BasicBlock)iBasicBlock2).size()) {
                return CFGUtil.failComp(n2, "Block #%d count of instructions differ: %d, %d", i, ((BasicBlock)iBasicBlock).size(), ((BasicBlock)iBasicBlock2).size());
            }
            for (int j = 0; j < ((BasicBlock)iBasicBlock).size(); ++j) {
                boolean bl;
                Object InsnType = ((BasicBlock)iBasicBlock).get(j);
                Object InsnType2 = ((BasicBlock)iBasicBlock2).get(j);
                if (comparator == null) {
                    bl = InsnType.equals(InsnType2);
                } else {
                    boolean bl2 = bl = comparator.compare(InsnType, InsnType2) == 0;
                }
                if (bl) continue;
                comparator.compare(InsnType, InsnType2);
                return CFGUtil.failComp(n2, "Block #%d Instruction #%d differ: '%s', '%s'", i, j, InsnType, InsnType2);
            }
        }
        return true;
    }

    private static boolean failComp(int n2, String string, Object ... objectArray) {
        if (n2 != 0) {
            String string2 = "CFG comparison failed: " + Strings.ff(string, objectArray);
            if (n2 == 1) {
                logger.debug(string2, new Object[0]);
            } else if (n2 == 2) {
                throw new RuntimeException(string2);
            }
        }
        return false;
    }

    public static <T extends IInstruction> CFG<T> duplicateShallow(CFG<T> cFG) {
        BasicBlock basicBlock;
        CFG<T> cFG2 = cFG.shallowCopy(false);
        IdentityHashMap identityHashMap = new IdentityHashMap();
        int n2 = 0;
        for (BasicBlock basicBlock2 : cFG.bblist) {
            identityHashMap.put(basicBlock2, n2);
            basicBlock = basicBlock2.shallowCopy(false);
            cFG2.bblist.add(basicBlock);
            ++n2;
        }
        n2 = 0;
        for (BasicBlock basicBlock2 : cFG.bblist) {
            int n3;
            basicBlock = cFG2.bblist.get(n2);
            for (BasicBlock basicBlock3 : basicBlock2.getInputBlocks()) {
                n3 = (Integer)identityHashMap.get(basicBlock3);
                basicBlock.src.add(cFG2.bblist.get(n3));
            }
            for (BasicBlock basicBlock3 : basicBlock2.getOutputBlocks()) {
                n3 = (Integer)identityHashMap.get(basicBlock3);
                basicBlock.dst.add(cFG2.bblist.get(n3));
            }
            for (BasicBlock basicBlock3 : basicBlock2.getIrregularInputBlocks()) {
                n3 = (Integer)identityHashMap.get(basicBlock3);
                basicBlock.irrsrc.add(cFG2.bblist.get(n3));
            }
            for (BasicBlock basicBlock3 : basicBlock2.getIrregularOutputBlocks()) {
                n3 = (Integer)identityHashMap.get(basicBlock3);
                basicBlock.irrdst.add(cFG2.bblist.get(n3));
            }
            ++n2;
        }
        return cFG2;
    }

    public static <T extends IInstruction> Collection<BasicBlock<T>> getReachableBlocks(CFG<T> cFG) {
        HashSet<BasicBlock<T>> hashSet = new HashSet<BasicBlock<T>>();
        ArrayList<IBasicBlock> arrayList = new ArrayList<IBasicBlock>();
        arrayList.add(cFG.getEntryBlock());
        while (!arrayList.isEmpty()) {
            BasicBlock basicBlock = (BasicBlock)arrayList.remove(0);
            if (!hashSet.add(basicBlock)) continue;
            arrayList.addAll(basicBlock.getOutputs());
            arrayList.addAll(basicBlock.getIrregularOutputs());
        }
        return hashSet;
    }

    public static <T extends IInstruction> int removeUnreachableBlocks(CFG<T> cFG) {
        List<BasicBlock<T>> list = cFG.getBlocks();
        list.removeAll(CFGUtil.getReachableBlocks(cFG));
        if (list.isEmpty()) {
            return 0;
        }
        return CFGUtil.removeUnreachableBlocks(cFG, list);
    }

    public static <T extends IInstruction> int removeUnreachableBlocks(CFG<T> cFG, List<BasicBlock<T>> list) {
        Iterable<Object> iterable;
        long l2;
        BasicBlock<T> basicBlock;
        HashSet<Long> hashSet = new HashSet<Long>();
        long l3 = cFG.getEntryAddress();
        while (!list.isEmpty()) {
            basicBlock = list.remove(0);
            l2 = basicBlock.getBase();
            if (l2 == l3 || !hashSet.add(l2)) continue;
            iterable = basicBlock.getAllOutputBlocks();
            for (BasicBlock basicBlock2 : basicBlock.getOutputBlocks()) {
                cFG.deleteEdges(basicBlock, basicBlock2);
            }
            for (BasicBlock basicBlock3 : basicBlock.getIrregularOutputBlocks()) {
                cFG.deleteIrregularEdges(basicBlock, basicBlock3);
            }
            for (BasicBlock<Object> basicBlock4 : iterable) {
                if (basicBlock4.allinsize() != 0) continue;
                list.add(basicBlock4);
            }
        }
        basicBlock = hashSet.iterator();
        while (basicBlock.hasNext()) {
            Object InsnType;
            l2 = (Long)basicBlock.next();
            iterable = cFG.getBlockAt(l2);
            cFG.removeBlock((BasicBlock<T>)iterable);
            IBasicBlock iBasicBlock = cFG.getBlockEndingAt(((BasicBlock)iterable).getFirstAddress());
            if (iBasicBlock == null || !((InsnType = ((BasicBlock)iBasicBlock).getLast()) instanceof IResizableInstruction)) continue;
            ((IResizableInstruction)InsnType).adjustSize(((BasicBlock)iterable).getSizeOfInstructions());
        }
        return hashSet.size();
    }
}

