/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.cfg;

import com.pnfsoftware.jeb.core.units.code.AddressableInstruction;
import com.pnfsoftware.jeb.core.units.code.IDFA;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.IVariable;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IFormattingContextFactory;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IVariableProvider;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.VarLocations;
import com.pnfsoftware.jeb.util.collect.Bitmap;
import com.pnfsoftware.jeb.util.collect.CollectionOrder;
import com.pnfsoftware.jeb.util.collect.MultiMap;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public class CFGFormatter<InsnType extends IInstruction> {
    private static final ILogger logger = GlobalLog.getLogger(CFGFormatter.class);
    public static final AtomicInteger cfgfwccnt = new AtomicInteger();
    private CFG<InsnType> cfg;
    private IVariableProvider varprv;
    private boolean formatFineGrained;

    public CFGFormatter(CFG<InsnType> cFG) {
        this(cFG, null, false);
    }

    public CFGFormatter(CFG<InsnType> cFG, IVariableProvider iVariableProvider, boolean bl) {
        this.cfg = cFG;
        this.varprv = iVariableProvider;
        this.formatFineGrained = bl;
    }

    public final CFG<InsnType> getCfg() {
        return this.cfg;
    }

    public final String formatSimple() {
        return this.format(true, false, false, null, null);
    }

    public String format(boolean bl, boolean bl2, boolean bl3, IDFA<InsnType> iDFA, IFormattingContextFactory<InsnType> iFormattingContextFactory) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl3 || bl2) {
            if (iDFA == null && (iDFA = this.cfg.doDataFlowAnalysis(false)) == null) {
                throw new IllegalArgumentException();
            }
            cfgfwccnt.incrementAndGet();
        }
        this.genHeader(stringBuilder);
        if (bl3) {
            String string = this.formatChain(iDFA.getInputMap());
            Strings.ff(stringBuilder, "CFG{%d blk, %d insn} %s\n", this.cfg.size(), this.cfg.getInstructionCount(), iDFA.toString());
            Strings.ff(stringBuilder, ">> IN(@%X): %s\n", this.cfg.getEntryAddress(), string);
        }
        for (BasicBlock<InsnType> basicBlock : this.cfg) {
            int n2 = 0;
            for (AddressableInstruction<InsnType> addressableInstruction : basicBlock.addressableInstructions()) {
                InsnType InsnType = addressableInstruction.getInstruction();
                long l2 = addressableInstruction.getOffset();
                this.genBOL(stringBuilder, l2, InsnType);
                if (bl) {
                    this.genPreAddress(stringBuilder, l2, InsnType);
                    this.genAddress(stringBuilder, l2, InsnType);
                    this.genAddressCharacter(stringBuilder, l2, InsnType, basicBlock, n2);
                    this.genPostAddress(stringBuilder, l2, InsnType);
                }
                this.genPreInstruction(stringBuilder, l2, InsnType);
                Object object = iFormattingContextFactory == null ? Long.valueOf(l2) : iFormattingContextFactory.createFormattingContext(InsnType);
                stringBuilder.append(InsnType.format(object));
                this.genPostInstruction(stringBuilder, l2, InsnType);
                if (bl2) {
                    this.genPreChains(stringBuilder, l2, InsnType);
                    object = this.formatChain(iDFA.getDefUseChains(l2));
                    String string = this.formatChain(iDFA.getUseDefChains(l2));
                    Strings.ff(stringBuilder, "DU: %-30s | UD: %s", object, string);
                    this.genPostChains(stringBuilder, l2, InsnType);
                }
                this.genEOL(stringBuilder, l2, InsnType);
                ++n2;
            }
        }
        if (bl3) {
            for (BasicBlock<InsnType> basicBlock : this.cfg.getExitBlocks()) {
                String string = this.formatChain(iDFA.getOutputMap(basicBlock));
                Strings.ff(stringBuilder, "<< OUT(@%X): %s\n", basicBlock.getEndAddress(), string);
            }
        }
        this.genTrailer(stringBuilder);
        return stringBuilder.toString();
    }

    private <T extends Number> String formatChain(Map<Integer, Collection<T>> map) {
        if (this.varprv == null) {
            return CFGFormatter.formatChainsInternalLegacy(map);
        }
        return CFGFormatter.formatChainsInternal(map, this.varprv, this.formatFineGrained);
    }

    public static <T extends Number> String formatChains(Map<Integer, Collection<T>> map, IVariableProvider iVariableProvider) {
        return CFGFormatter.formatChainsInternal(map, iVariableProvider, false);
    }

    private static <T extends Number> String formatChainsInternal(Map<Integer, Collection<T>> map, IVariableProvider iVariableProvider, boolean bl) {
        ArrayList<Number> arrayList;
        Object object62;
        LinkedHashMap<Integer, Object> linkedHashMap = new LinkedHashMap<Integer, Object>();
        Object object2 = map.keySet().iterator();
        while (object2.hasNext()) {
            int n2 = object2.next();
            Object object3 = iVariableProvider.getContaining(n2);
            if (object3 == null) {
                throw new RuntimeException("Cannot retrieve variable containing vbit " + n2);
            }
            object62 = (VarLocations)linkedHashMap.get(object3.getId());
            if (object62 == null) {
                object62 = new VarLocations((IVariable)object3);
                linkedHashMap.put(object3.getId(), object62);
            }
            for (Iterator iterator : map.get(n2)) {
                ((VarLocations)object62).record(iterator, n2);
            }
        }
        object2 = new MultiMap(CollectionOrder.INSERTION);
        if (!bl) {
            for (Object object3 : linkedHashMap.values()) {
                ((MultiMap)object2).createKey(((VarLocations)object3).var.getName());
                ((MultiMap)object2).putMulti(((VarLocations)object3).var.getName(), ((VarLocations)object3).touched.keySet());
            }
        } else {
            for (Object object3 : linkedHashMap.values()) {
                object62 = new ArrayList();
                arrayList = new MultiMap();
                for (Object object4 : ((VarLocations)object3).touched.keySet()) {
                    Bitmap object5 = ((VarLocations)object3).touched.get(object4);
                    if (object5.isFull()) {
                        object62.add(object4);
                        continue;
                    }
                    ((MultiMap)((Object)arrayList)).put(object5, object4);
                }
                ((MultiMap)object2).createKey(((VarLocations)object3).var.getName());
                ((MultiMap)object2).putMulti(((VarLocations)object3).var.getName(), object62);
                for (Object object4 : ((MultiMap)((Object)arrayList)).keySet()) {
                    ((MultiMap)object2).putMulti(((VarLocations)object3).var.getName() + ((Bitmap)object4).formatAsRanges(), ((MultiMap)((Object)arrayList)).get(object4));
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object62 : ((MultiMap)object2).keySet()) {
            Strings.ff(stringBuilder, "%s={", object62);
            arrayList = new ArrayList<Number>(((MultiMap)object2).get(object62));
            Collections.sort(arrayList, new Comparator<T>(){

                @Override
                public int compare(T t, T t2) {
                    return Long.compare(((Number)t).longValue(), ((Number)t2).longValue());
                }
            });
            int n3 = 0;
            for (Number number : arrayList) {
                if (n3 >= 1) {
                    stringBuilder.append(",");
                }
                if (number instanceof Integer) {
                    Strings.ff(stringBuilder, "%X", number.intValue());
                } else if (number instanceof Long) {
                    if (number.longValue() == -1L) {
                        stringBuilder.append("@init");
                    } else {
                        Strings.ff(stringBuilder, "@%X", number.longValue());
                    }
                }
                ++n3;
            }
            stringBuilder.append("} ");
        }
        return stringBuilder.toString();
    }

    private static <T extends Number> String formatChainsInternalLegacy(Map<Integer, Collection<T>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        Map<Integer, Collection<T>> map2 = map instanceof HashMap ? new TreeMap<Integer, Collection<T>>(map) : map;
        for (int n2 : map2.keySet()) {
            stringBuilder.append("(").append((String)(n2 >= 0 ? Integer.toHexString(n2) : "-" + Integer.toHexString(-n2))).append(")={");
            ArrayList<T> arrayList = new ArrayList<T>(map2.get(n2));
            Collections.sort(arrayList, new Comparator<T>(){

                @Override
                public int compare(T t, T t2) {
                    return Long.compare(((Number)t).longValue(), ((Number)t2).longValue());
                }
            });
            int n3 = 0;
            for (Number number : arrayList) {
                if (n3 >= 1) {
                    stringBuilder.append(",");
                }
                if (number instanceof Integer) {
                    stringBuilder.append(Integer.toHexString(number.intValue()).toUpperCase());
                } else if (number instanceof Long) {
                    if (number.longValue() == -1L) {
                        stringBuilder.append("@init");
                    } else {
                        stringBuilder.append("@").append(Long.toHexString(number.longValue()).toUpperCase());
                    }
                }
                ++n3;
            }
            stringBuilder.append("} ");
        }
        return stringBuilder.toString();
    }

    protected final void padLine(StringBuilder stringBuilder, int n2) {
        int n3 = Math.max(0, stringBuilder.lastIndexOf("\n"));
        int n4 = stringBuilder.length() - n3;
        if (n4 < n2) {
            stringBuilder.append(Strings.spaces(n2 - n4));
        }
        stringBuilder.append("  ");
    }

    protected void genHeader(StringBuilder stringBuilder) {
    }

    protected void genBOL(StringBuilder stringBuilder, long l2, InsnType InsnType) {
    }

    protected void genPreAddress(StringBuilder stringBuilder, long l2, InsnType InsnType) {
    }

    protected void genAddress(StringBuilder stringBuilder, long l2, InsnType InsnType) {
        Strings.ff(stringBuilder, "%04X/%X", l2, InsnType.getSize());
    }

    protected void genAddressCharacter(StringBuilder stringBuilder, long l2, InsnType InsnType, BasicBlock<InsnType> basicBlock, int n2) {
        int n3 = 58;
        if (n2 == 0) {
            n3 = basicBlock.getFirstAddress() == this.getCfg().getEntryAddress() ? 62 : (basicBlock.irrinsize() == 0 ? 43 : 42);
        } else if (n2 == basicBlock.size() - 1) {
            List<BasicBlock<InsnType>> list = basicBlock.getOutputBlocks();
            if (list.isEmpty()) {
                n3 = 120;
            } else if (list.size() == 1 || list.size() == 2) {
                long l3 = list.get(list.size() - 1).getBase();
                if (l3 > l2) {
                    n3 = 118;
                } else if (l3 < l2) {
                    n3 = 94;
                }
            }
        }
        Strings.ff(stringBuilder, "%c", Character.valueOf((char)n3));
    }

    protected void genPostAddress(StringBuilder stringBuilder, long l2, InsnType InsnType) {
        stringBuilder.append("  ");
    }

    protected void genPreInstruction(StringBuilder stringBuilder, long l2, InsnType InsnType) {
    }

    protected void genPostInstruction(StringBuilder stringBuilder, long l2, InsnType InsnType) {
        this.padLine(stringBuilder, 120);
    }

    protected void genPreChains(StringBuilder stringBuilder, long l2, InsnType InsnType) {
    }

    protected void genPostChains(StringBuilder stringBuilder, long l2, InsnType InsnType) {
        this.padLine(stringBuilder, 200);
    }

    protected void genEOL(StringBuilder stringBuilder, long l2, InsnType InsnType) {
        stringBuilder.append('\n');
    }

    protected void genTrailer(StringBuilder stringBuilder) {
    }
}

