/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.cfg;

import com.pnfsoftware.jeb.core.units.code.AddressableInstruction;
import com.pnfsoftware.jeb.core.units.code.DFA4;
import com.pnfsoftware.jeb.core.units.code.IBasicBlock;
import com.pnfsoftware.jeb.core.units.code.ICodePointer;
import com.pnfsoftware.jeb.core.units.code.IControlFlowGraph;
import com.pnfsoftware.jeb.core.units.code.IDFA;
import com.pnfsoftware.jeb.core.units.code.IFlowInformation;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.InstructionFlags;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.BranchTarget;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IBranchResolution;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IInstructionAugmenter;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFGUtil;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IFormattingContextFactory;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IVariableInformationProvider;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IrregularFlowData;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.collect.CollectionUtil;
import com.pnfsoftware.jeb.util.concurrent.TimedOperationVerifier;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;

@Ser
public class CFG<InsnType extends IInstruction>
implements IControlFlowGraph<InsnType, BasicBlock<InsnType>>,
Iterable<BasicBlock<InsnType>> {
    private static final ILogger logger = GlobalLog.getLogger(CFG.class);
    public static final int FLAG_SUBROUTINE_CALL_NOT_BREAKING = 1;
    public static final int FLAG_ALLOW_ARTIFICIAL_BLOCK_END = 2;
    public static final int FLAG_ALLOW_UNREACHABLE_BLOCKS = 4;
    @SerId(value=1)
    List<BasicBlock<InsnType>> bblist;
    @SerId(value=2)
    long entry;
    @SerId(value=3)
    int flags;
    @SerId(value=4)
    WeakReference<IVariableInformationProvider> varInfoProvider;
    @SerId(value=5)
    private int defaultCollectionFlags = 3;
    @SerId(value=6)
    private boolean defaultIntegrateInputs = true;
    @SerTransient
    TimedOperationVerifier tov;
    @SerTransient
    int dfaVersion;
    @SerTransient
    List<IDFA<InsnType>> dfaObjects;

    private CFG(long l2, int n2) {
        this.entry = l2;
        this.flags = n2;
    }

    public CFG(long l2, List<BasicBlock<InsnType>> list) {
        this.entry = l2;
        this.flags = 0;
        this.bblist = list;
        HashMap<Long, BasicBlock<InsnType>> hashMap = new HashMap<Long, BasicBlock<InsnType>>();
        for (BasicBlock<InsnType> basicBlock : list) {
            long l3 = basicBlock.base;
            for (IInstruction iInstruction : basicBlock) {
                hashMap.put(l3, basicBlock);
                l3 += (long)iInstruction.getSize();
            }
        }
        this.buildGraphSecondPass(hashMap);
    }

    public CFG<InsnType> shallowCopy(boolean bl) {
        CFG<InsnType> cFG = new CFG<InsnType>(this.entry, this.flags);
        cFG.bblist = new ArrayList<BasicBlock<InsnType>>(this.bblist.size());
        if (bl) {
            cFG.bblist.addAll(this.bblist);
        }
        return cFG;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public BasicBlock<InsnType> get(int n2) {
        return this.bblist.get(n2);
    }

    @Override
    public int indexOf(BasicBlock<InsnType> basicBlock) {
        return this.bblist.indexOf(basicBlock);
    }

    @Override
    public int size() {
        return this.bblist.size();
    }

    @Override
    public long getEntryAddress() {
        return this.entry;
    }

    @Override
    public long getFirstAddress() {
        return this.bblist.get(0).getFirstAddress();
    }

    @Override
    public long getLastAddress() {
        return this.bblist.get(this.bblist.size() - 1).getLastAddress();
    }

    @Override
    public long getEndAddress() {
        return this.bblist.get(this.bblist.size() - 1).getEndAddress();
    }

    @Override
    public int getEffectiveSize() {
        int n2 = 0;
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            n2 += (int)(basicBlock.getEndAddress() - basicBlock.getFirstAddress());
        }
        return n2;
    }

    public List<Couple<Long, Long>> getGaps() {
        ArrayList<Couple<Long, Long>> arrayList = new ArrayList<Couple<Long, Long>>();
        long l2 = this.bblist.get(0).getEndAddress();
        for (int i = 1; i < this.bblist.size(); ++i) {
            BasicBlock<InsnType> basicBlock = this.bblist.get(i);
            long l3 = basicBlock.getFirstAddress() - l2;
            if (l3 > 0L) {
                arrayList.add(new Couple<Long, Long>(l2, l2 + l3));
            }
            l2 = basicBlock.getEndAddress();
        }
        return arrayList;
    }

    @Override
    public BasicBlock<InsnType> getBlock(int n2) {
        return this.bblist.get(n2);
    }

    @Override
    public List<BasicBlock<InsnType>> getBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.bblist);
    }

    @Override
    public List<BasicBlock<InsnType>> getBlocksView() {
        return Collections.unmodifiableList(this.bblist);
    }

    @Override
    public BasicBlock<InsnType> getBlockAt(long l2) {
        int n2 = 0;
        int n3 = this.bblist.size();
        while (n3 > n2) {
            int n4 = n2 + (n3 - n2) / 2;
            BasicBlock<InsnType> basicBlock = this.bblist.get(n4);
            if (l2 < basicBlock.getFirstAddress()) {
                n3 = n4;
                continue;
            }
            if (l2 >= basicBlock.getEndAddress()) {
                n2 = n4 + 1;
                continue;
            }
            return l2 == basicBlock.getFirstAddress() ? basicBlock : null;
        }
        return null;
    }

    BasicBlock<InsnType> getBlockAt_slow(long l2) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (basicBlock.base > l2) {
                return null;
            }
            if (basicBlock.base != l2) continue;
            return basicBlock;
        }
        return null;
    }

    @Override
    public BasicBlock<InsnType> getBlockEndingAt(long l2) {
        int n2 = 0;
        int n3 = this.bblist.size();
        while (n3 > n2) {
            int n4 = n2 + (n3 - n2) / 2;
            BasicBlock<InsnType> basicBlock = this.bblist.get(n4);
            if (l2 <= basicBlock.getFirstAddress()) {
                n3 = n4;
                continue;
            }
            if (l2 > basicBlock.getEndAddress()) {
                n2 = n4 + 1;
                continue;
            }
            return l2 == basicBlock.getEndAddress() ? basicBlock : null;
        }
        return null;
    }

    BasicBlock<InsnType> getBlockEndingAt_slow(long l2) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (basicBlock.getEndAddress() != l2) continue;
            return basicBlock;
        }
        return null;
    }

    @Override
    public BasicBlock<InsnType> getBlockContaining(long l2) {
        int n2 = 0;
        int n3 = this.bblist.size();
        while (n3 > n2) {
            int n4 = n2 + (n3 - n2) / 2;
            BasicBlock<InsnType> basicBlock = this.bblist.get(n4);
            if (l2 < basicBlock.getFirstAddress()) {
                n3 = n4;
                continue;
            }
            if (l2 >= basicBlock.getEndAddress()) {
                n2 = n4 + 1;
                continue;
            }
            return basicBlock;
        }
        return null;
    }

    BasicBlock<InsnType> getBlockContaining_slow(long l2) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (basicBlock.getFirstAddress() > l2) {
                return null;
            }
            if (basicBlock.getEndAddress() <= l2) continue;
            return basicBlock;
        }
        return null;
    }

    @Override
    public BasicBlock<InsnType> getEntryBlock() {
        IBasicBlock iBasicBlock = this.getBlockAt(this.entry);
        if (iBasicBlock == null) {
            throw new IllegalStateException("Cannot find the entry block");
        }
        return iBasicBlock;
    }

    @Override
    public List<BasicBlock<InsnType>> getExitBlocks() {
        ArrayList<BasicBlock<InsnType>> arrayList = new ArrayList<BasicBlock<InsnType>>();
        block0: for (BasicBlock<InsnType> basicBlock : this.bblist) {
            IFlowInformation iFlowInformation;
            List<BasicBlock<InsnType>> list = basicBlock.getOutputBlocks();
            if (list.isEmpty()) {
                arrayList.add(basicBlock);
                continue;
            }
            AddressableInstruction<InsnType> addressableInstruction = basicBlock.getBranchingInstruction2();
            if (addressableInstruction == null || !addressableInstruction.getInstructionFlags().contains((Object)InstructionFlags.CONDITIONAL_EXEC) || list.size() != 1 || !(iFlowInformation = addressableInstruction.getInstruction().getBreakingFlow(addressableInstruction.getOffset())).isBroken()) continue;
            for (ICodePointer iCodePointer : iFlowInformation.getTargets()) {
                if (!iCodePointer.isUnknownAddress() && this.getBlockAt(iCodePointer.getAddress()) != null) continue;
                arrayList.add(basicBlock);
                continue block0;
            }
        }
        return arrayList;
    }

    @Override
    public BasicBlock<InsnType> getBlockByLastAddress(long l2) {
        IBasicBlock iBasicBlock = this.getBlockContaining(l2);
        if (iBasicBlock != null && ((BasicBlock)iBasicBlock).getLastAddress() == l2) {
            return iBasicBlock;
        }
        return null;
    }

    BasicBlock<InsnType> getBlockByLastAddress_slow(long l2) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (basicBlock.getLastAddress() != l2) continue;
            return basicBlock;
        }
        return null;
    }

    public boolean hasExit() {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (!basicBlock.getOutputBlocks().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNoExit() {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (!basicBlock.getOutputBlocks().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Map<Long, BasicBlock<InsnType>> getAddressBlockMap() {
        HashMap<Long, BasicBlock<InsnType>> hashMap = new HashMap<Long, BasicBlock<InsnType>>();
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            hashMap.put(basicBlock.base, basicBlock);
        }
        return hashMap;
    }

    @Override
    public List<InsnType> getInstructions() {
        ArrayList arrayList = new ArrayList();
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            arrayList.addAll(basicBlock.insns);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public Map<Long, InsnType> getInstructionsMap() {
        HashMap<Long, InsnType> hashMap = new HashMap<Long, InsnType>();
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            for (AddressableInstruction<InsnType> addressableInstruction : basicBlock.addressableInstructions()) {
                hashMap.put(addressableInstruction.getOffset(), addressableInstruction.getInstruction());
            }
        }
        return hashMap;
    }

    @Override
    public int getInstructionCount() {
        int n2 = 0;
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            n2 += basicBlock.size();
        }
        return n2;
    }

    @Override
    public InsnType getInstruction(long l2) {
        IBasicBlock iBasicBlock = this.getBlockContaining(l2);
        if (iBasicBlock != null) {
            return ((BasicBlock)iBasicBlock).getInstruction(l2);
        }
        return null;
    }

    public AddressableInstruction<InsnType> getAddressableInstruction(long l2) {
        InsnType InsnType = this.getInstruction(l2);
        return InsnType == null ? null : new AddressableInstruction<InsnType>(l2, InsnType);
    }

    public AddressableInstruction<InsnType> findInstruction(InsnType InsnType) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            int n2 = basicBlock.getIndexOfInstruction(InsnType);
            if (n2 < 0) continue;
            long l2 = basicBlock.getAddressOfInstruction(n2);
            return new AddressableInstruction<InsnType>(l2, InsnType);
        }
        return null;
    }

    public Couple<BasicBlock<InsnType>, Integer> getInstructionLocation(InsnType InsnType) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            int n2 = basicBlock.getIndexOfInstruction(InsnType);
            if (n2 < 0) continue;
            return new Couple<BasicBlock<InsnType>, Integer>(basicBlock, n2);
        }
        return null;
    }

    @Override
    public Couple<BasicBlock<InsnType>, Integer> getInstructionLocation(long l2) {
        IBasicBlock iBasicBlock = this.getBlockContaining(l2);
        if (iBasicBlock == null) {
            return null;
        }
        int n2 = ((BasicBlock)iBasicBlock).getIndexOfInstruction(l2);
        if (n2 < 0) {
            return null;
        }
        return new Couple<IBasicBlock, Integer>(iBasicBlock, n2);
    }

    Couple<BasicBlock<InsnType>, Integer> getInstructionLocation_slow(long l2) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (l2 < basicBlock.getFirstAddress() || l2 >= basicBlock.getEndAddress()) continue;
            int n2 = basicBlock.getIndexOfInstruction(l2);
            if (n2 < 0) break;
            return new Couple<BasicBlock<InsnType>, Integer>(basicBlock, n2);
        }
        return null;
    }

    @Override
    public void getGraphRepresentation(List<int[]> list, List<int[]> list2) {
        list.clear();
        list2.clear();
        LinkedHashMap<BasicBlock<InsnType>, Integer> linkedHashMap = new LinkedHashMap<BasicBlock<InsnType>, Integer>();
        int n2 = 1;
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            linkedHashMap.put(basicBlock, n2);
            ++n2;
        }
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            IBasicBlock iBasicBlock;
            int n3;
            for (n3 = basicBlock.outsize() - 1; n3 >= 0; --n3) {
                iBasicBlock = basicBlock.getOutputBlock(n3);
                list.add(new int[]{(Integer)linkedHashMap.get(basicBlock), (Integer)linkedHashMap.get(iBasicBlock)});
            }
            for (n3 = basicBlock.irroutsize() - 1; n3 >= 0; --n3) {
                iBasicBlock = basicBlock.getIrregularOutputBlock(n3);
                list2.add(new int[]{(Integer)linkedHashMap.get(basicBlock), (Integer)linkedHashMap.get(iBasicBlock)});
            }
        }
    }

    public CFG(List<? extends InsnType> list, List<IrregularFlowData> list2) {
        this(list, list2, null, 0L, 0L, 0);
    }

    public CFG(List<? extends InsnType> list, List<IrregularFlowData> list2, IInstructionAugmenter iInstructionAugmenter, long l2, long l3, int n2) {
        if (l3 < l2) {
            throw new NullPointerException(Strings.ff("Illegal entry-point (%Xh), cannot be less than base (%Xh)", l3, l2));
        }
        HashMap<Long, IInstruction> hashMap = new HashMap<Long, IInstruction>();
        long l4 = l2;
        for (IInstruction iInstruction : list) {
            hashMap.put(l4, iInstruction);
            l4 += (long)iInstruction.getSize();
        }
        this.buildCFG(hashMap, list2, iInstructionAugmenter, l3, n2);
    }

    public CFG(Map<Long, InsnType> map, List<IrregularFlowData> list, IInstructionAugmenter iInstructionAugmenter, long l2, int n2) {
        this.buildCFG(map, list, iInstructionAugmenter, l2, n2);
    }

    private void buildCFG(Map<Long, InsnType> map, List<IrregularFlowData> list, IInstructionAugmenter iInstructionAugmenter, long l2, int n2) {
        long l3;
        if (map == null) {
            throw new NullPointerException("No instructions were provided");
        }
        boolean bl = (n2 & 1) != 0;
        boolean bl2 = (n2 & 2) != 0;
        boolean bl3 = (n2 & 4) != 0;
        this.flags = n2;
        this.entry = l2;
        if (!map.containsKey(l2)) {
            throw new RuntimeException(Strings.ff("The entry-point instruction (%Xh) is not present!", l2));
        }
        long l4 = 0L;
        Object object = map.keySet().iterator();
        while (object.hasNext()) {
            long l5 = object.next();
            if (l5 <= l4) continue;
            l4 = l5;
        }
        object = null;
        if (bl3) {
            object = new TreeSet<Long>(map.keySet());
        }
        this.bblist = new ArrayList<BasicBlock<InsnType>>();
        HashMap<Long, BasicBlock<InsnType>> hashMap = new HashMap<Long, BasicBlock<InsnType>>();
        ArrayDeque<Long> arrayDeque = new ArrayDeque<Long>();
        arrayDeque.push(l2);
        ArrayDeque<Long> arrayDeque2 = arrayDeque;
        int n3 = 0;
        block1: while (true) {
            Object object2;
            if (!arrayDeque.isEmpty()) {
                BasicBlock<InsnType> basicBlock;
                long l6 = (Long)arrayDeque.pop();
                object2 = (BasicBlock)hashMap.get(l6);
                if (object2 != null) {
                    if (((BasicBlock)object2).getFirstAddress() == l6) continue;
                    basicBlock = ((BasicBlock)object2).splitBlock(l6);
                    if (basicBlock == null) {
                        throw new RuntimeException();
                    }
                    this.bblist.add(basicBlock);
                    l3 = l6;
                    int n4 = 0;
                    while (true) {
                        if (n4 >= basicBlock.insns.size()) continue block1;
                        IInstruction iInstruction = (IInstruction)basicBlock.insns.get(n4);
                        hashMap.put(l3, basicBlock);
                        l3 += (long)iInstruction.getSize();
                        ++n4;
                    }
                }
                object2 = new BasicBlock(l6);
                this.bblist.add((BasicBlock<InsnType>)object2);
                while (true) {
                    if ((basicBlock = hashMap.get(l6)) != null) {
                        if (((BasicBlock)object2).isEmpty()) {
                            throw new RuntimeException("Unexpected empty basic block");
                        }
                        ((BasicBlock)object2).dst_offsets.add(basicBlock.getFirstAddress());
                        continue block1;
                    }
                    IInstruction iInstruction = (IInstruction)map.get(l6);
                    if (object != null) {
                        object.remove(l6);
                    }
                    if (iInstruction == null) {
                        if (!bl2) {
                            throw new RuntimeException(Strings.ff("No instruction at offset %Xh", l6));
                        }
                        if (!((BasicBlock)object2).isEmpty()) continue block1;
                        this.bblist.remove(object2);
                        continue block1;
                    }
                    ((BasicBlock)object2).insns.add(iInstruction);
                    hashMap.put(l6, (BasicBlock<InsnType>)object2);
                    if (iInstructionAugmenter != null && iInstructionAugmenter.isArtificialEndOfBlock(l6)) continue block1;
                    IFlowInformation iFlowInformation = iInstruction.getBreakingFlow(l6);
                    IFlowInformation iFlowInformation2 = null;
                    if (iInstructionAugmenter != null && iInstructionAugmenter.isReversedBranchSemantic(l6)) {
                        IFlowInformation iFlowInformation3;
                        iFlowInformation2 = iFlowInformation = (iFlowInformation3 = iInstruction.getRoutineCall(l6));
                    }
                    if (iFlowInformation.isBroken()) {
                        Assert.a(iFlowInformation.getDelaySlotCount() == 0, "Instructions with delay-slot are not supported by this CFG constructor");
                        if (iFlowInformation.mustComputeFallThrough()) {
                            long l7 = l6 + (long)iInstruction.getSize();
                            ((BasicBlock)object2).dst_offsets.add(l7);
                            arrayDeque2.push(l7);
                        }
                        if (iFlowInformation.isBrokenUnknown()) {
                            ((BasicBlock)object2).unknownDst = true;
                        }
                        boolean bl4 = false;
                        Iterator<ICodePointer> iterator = iFlowInformation.getTargets().iterator();
                        while (true) {
                            long l8;
                            if (!iterator.hasNext()) continue block1;
                            ICodePointer iCodePointer = iterator.next();
                            if (iCodePointer.isUnknownAddress() && !bl4) {
                                IBranchResolution iBranchResolution;
                                bl4 = true;
                                if (iInstructionAugmenter != null && (iBranchResolution = iInstructionAugmenter.getDynamicBranchResolution(l6)) != null) {
                                    for (BranchTarget branchTarget : iBranchResolution.getTargets()) {
                                        if (!branchTarget.isInternal()) continue;
                                        l8 = branchTarget.getInternalAddress().getAddress();
                                        if (((BasicBlock)object2).dst_offsets.isEmpty() || l8 < l6 || l8 > ((BasicBlock)object2).dst_offsets.get(0)) {
                                            ((BasicBlock)object2).dst_offsets.add(l8);
                                        } else {
                                            ((BasicBlock)object2).dst_offsets.add(0, l8);
                                        }
                                        arrayDeque2.push(l8);
                                    }
                                }
                                ((BasicBlock)object2).unknownDst = true;
                                continue;
                            }
                            l8 = iCodePointer.getAddress();
                            ((BasicBlock)object2).dst_offsets.add(l8);
                            arrayDeque2.push(l8);
                        }
                    }
                    if (iFlowInformation2 == null) {
                        iFlowInformation2 = iInstruction.getRoutineCall(l6);
                    }
                    if (iFlowInformation2.isBroken()) {
                        Assert.a(iFlowInformation2.getDelaySlotCount() == 0, "Instructions with delay-slot are not supported by this CFG constructor");
                        if (iFlowInformation2.noFallThrough()) continue block1;
                        if (!bl) {
                            long l9 = l6 + (long)iInstruction.getSize();
                            ((BasicBlock)object2).dst_offsets.add(l9);
                            arrayDeque2.push(l9);
                            continue block1;
                        }
                    }
                    l6 += (long)iInstruction.getSize();
                }
            }
            if (list == null || n3 > 0) {
                if (object == null || object.isEmpty()) break;
                long l10 = (Long)object.iterator().next();
                arrayDeque.add(l10);
                continue;
            }
            for (IrregularFlowData irregularFlowData : list) {
                arrayDeque2.push(irregularFlowData.target);
                arrayDeque2.push(irregularFlowData.first);
                object2 = (IInstruction)map.get(irregularFlowData.last);
                long l11 = irregularFlowData.last + (long)object2.getSize();
                if (l11 >= l4) continue;
                arrayDeque2.push(l11);
            }
            ++n3;
        }
        if (list != null) {
            for (IrregularFlowData irregularFlowData : list) {
                for (BasicBlock<InsnType> basicBlock : this.bblist) {
                    l3 = basicBlock.getFirstAddress();
                    if (l3 < irregularFlowData.first || l3 > irregularFlowData.last || basicBlock.irrdst_offsets.contains(irregularFlowData.target)) continue;
                    basicBlock.irrdst_offsets.add(irregularFlowData.target);
                }
            }
        }
        this.buildGraphSecondPass(hashMap);
    }

    private void buildGraphSecondPass(Map<Long, BasicBlock<InsnType>> map) {
        boolean bl = (this.flags & 2) != 0;
        BasicBlock<InsnType> basicBlock = null;
        for (BasicBlock<InsnType> basicBlock2 : this.bblist) {
            BasicBlock<InsnType> basicBlock3;
            if (basicBlock2.isEmpty()) {
                throw new RuntimeException(Strings.ff("Illegal graph: the block at address %Xh is empty!", basicBlock2.base));
            }
            for (long l2 : basicBlock2.dst_offsets) {
                basicBlock3 = map.get(l2);
                if (basicBlock3 == null) {
                    if (bl) continue;
                    throw new RuntimeException(Strings.ff("block@%X was not found", l2));
                }
                basicBlock2.dst.add(basicBlock3);
                basicBlock3.src.add(basicBlock2);
            }
            for (long l2 : basicBlock2.irrdst_offsets) {
                basicBlock3 = map.get(l2);
                basicBlock2.irrdst.add(basicBlock3);
                basicBlock3.irrsrc.add(basicBlock2);
            }
            basicBlock2.dst_offsets = null;
            basicBlock2.irrdst_offsets = null;
            if (basicBlock != null || basicBlock2.base != this.entry) continue;
            basicBlock = basicBlock2;
        }
        if (basicBlock == null) {
            throw new RuntimeException(Strings.ff("Invalid entry address %Xh (does not match any block)", this.entry));
        }
        Collections.sort(this.bblist, new Comparator<BasicBlock<InsnType>>(){

            @Override
            public int compare(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
                return Long.compare(basicBlock.base, basicBlock2.base);
            }
        });
    }

    public int simplify() {
        return this.simplify(false, false, false);
    }

    public int simplify(boolean bl, boolean bl2, boolean bl3) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.bblist.size()) {
            boolean bl4;
            BasicBlock<InsnType> basicBlock = this.bblist.get(n3);
            boolean bl5 = bl4 = !basicBlock.hasUnknownDst() && (basicBlock.outsize() == 1 || basicBlock.outsize() == 2 && basicBlock.getOutputBlock(0) == basicBlock.getOutputBlock(1));
            if (bl4 && basicBlock.irroutsize() == 0 && basicBlock.size() >= 1 && (bl2 || basicBlock.getBranchingInstruction2(true, false) == null) && (bl || basicBlock.getBranchingInstruction2(false, true) == null)) {
                boolean bl6;
                IBasicBlock iBasicBlock = basicBlock.getOutputBlock(0);
                boolean bl7 = bl6 = ((BasicBlock)iBasicBlock).insize() == 1 || ((BasicBlock)iBasicBlock).insize() == 2 && ((BasicBlock)iBasicBlock).getInputBlock(0) == ((BasicBlock)iBasicBlock).getInputBlock(1);
                if (bl6 && ((BasicBlock)iBasicBlock).irrinsize() == 0 && ((BasicBlock)iBasicBlock).irroutsize() == 0) {
                    boolean bl8;
                    boolean bl9 = bl8 = ((BasicBlock)iBasicBlock).base == basicBlock.getEndAddress();
                    if (!bl8 && bl3 && ((BasicBlock)iBasicBlock).outsize() == 0 && basicBlock.base < ((BasicBlock)iBasicBlock).base) {
                        boolean bl10 = false;
                        for (BasicBlock basicBlock2 : this.bblist) {
                            if (basicBlock2 == basicBlock || basicBlock2 == iBasicBlock || basicBlock2.base <= basicBlock.base || basicBlock2.base >= ((BasicBlock)iBasicBlock).base) continue;
                            bl10 = true;
                        }
                        if (!bl10) {
                            bl8 = true;
                        }
                    }
                    if (bl8) {
                        if (((BasicBlock)iBasicBlock).insize() == 2 && ((BasicBlock)iBasicBlock).getInputBlock(0) == ((BasicBlock)iBasicBlock).getInputBlock(1) && !this.deleteDuplicateEdge(basicBlock, (BasicBlock<InsnType>)iBasicBlock)) {
                            Object[] cfr_ignored_0 = new Object[0];
                            throw new RuntimeException();
                        }
                        for (Object object : iBasicBlock) {
                            basicBlock.insns.add(object);
                        }
                        this.removeBlock((BasicBlock<InsnType>)iBasicBlock);
                        this.invalidateDataFlowAnalysis();
                        ++n2;
                        continue;
                    }
                }
            }
            ++n3;
        }
        return n2;
    }

    public void removeBlock(BasicBlock<InsnType> basicBlock) {
        Object object;
        if (basicBlock == null) {
            throw new IllegalArgumentException("Null block");
        }
        if (basicBlock.irrinsize() != 0) {
            Object[] cfr_ignored_0 = new Object[0];
            throw new RuntimeException();
        }
        if (basicBlock.outsize() == 1) {
            object = basicBlock.getOutputBlock(0);
            if (object == basicBlock) {
                Object[] cfr_ignored_1 = new Object[0];
                throw new RuntimeException();
            }
            int n2 = 0;
            while (n2 < ((BasicBlock)object).insize()) {
                if (((BasicBlock)object).getInputBlock(n2) == basicBlock) {
                    ((BasicBlock)object).src.remove(n2);
                    continue;
                }
                ++n2;
            }
            for (BasicBlock<InsnType> basicBlock2 : basicBlock.getInputBlocks()) {
                for (n2 = 0; n2 < basicBlock2.outsize(); ++n2) {
                    if (basicBlock2.getOutputBlock(n2) != basicBlock) continue;
                    basicBlock2.dst.set(n2, object);
                    ((BasicBlock)object).src.add(basicBlock2);
                }
            }
        } else if (basicBlock.insize() == 1) {
            object = basicBlock.getInputBlock(0);
            if (object == basicBlock) {
                Object[] cfr_ignored_2 = new Object[0];
                throw new RuntimeException();
            }
            int n3 = 0;
            while (n3 < ((BasicBlock)object).outsize()) {
                if (((BasicBlock)object).getOutputBlock(n3) == basicBlock) {
                    ((BasicBlock)object).dst.remove(n3);
                    continue;
                }
                ++n3;
            }
            for (BasicBlock<InsnType> basicBlock2 : basicBlock.getOutputBlocks()) {
                for (n3 = 0; n3 < basicBlock2.insize(); ++n3) {
                    if (basicBlock2.getInputBlock(n3) != basicBlock) continue;
                    basicBlock2.src.set(n3, object);
                    ((BasicBlock)object).dst.add(basicBlock2);
                }
            }
        } else if (basicBlock.insize() == 0) {
            for (BasicBlock<InsnType> basicBlock3 : basicBlock.getOutputBlocks()) {
                int n4 = 0;
                while (n4 < basicBlock3.insize()) {
                    if (basicBlock3.getInputBlock(n4) == basicBlock) {
                        basicBlock3.src.remove(n4);
                        continue;
                    }
                    ++n4;
                }
            }
        }
        for (BasicBlock<InsnType> basicBlock4 : basicBlock.getIrregularOutputBlocks()) {
            int n5 = 0;
            while (n5 < basicBlock4.irrinsize()) {
                if (basicBlock4.getIrregularInputBlock(n5) == basicBlock) {
                    basicBlock4.irrsrc.remove(n5);
                    continue;
                }
                ++n5;
            }
        }
        this.bblist.remove(basicBlock);
    }

    public BasicBlock<InsnType> splitBlock(BasicBlock<InsnType> basicBlock, int n2) {
        if (basicBlock == null) {
            throw new IllegalArgumentException("Null block");
        }
        int n3 = this.bblist.indexOf(basicBlock);
        if (n3 < 0) {
            throw new IllegalArgumentException("The input block does not belong to this CFG");
        }
        long l2 = basicBlock.getAddressOfInstruction(n2);
        BasicBlock basicBlock2 = new BasicBlock(l2);
        while (n2 < basicBlock.insns.size()) {
            basicBlock2.insns.add((IInstruction)basicBlock.insns.remove(n2));
        }
        basicBlock2.dst.addAll(basicBlock.dst);
        basicBlock.dst.clear();
        for (BasicBlock basicBlock4 : basicBlock2.dst) {
            basicBlock4.src.replaceAll(basicBlock3 -> basicBlock3 == basicBlock ? basicBlock2 : basicBlock3);
        }
        basicBlock2.irrdst.addAll(basicBlock.irrdst);
        for (BasicBlock basicBlock4 : basicBlock2.irrdst) {
            basicBlock4.irrsrc.add(basicBlock2);
        }
        basicBlock.dst.add(basicBlock2);
        basicBlock2.src.add(basicBlock);
        this.bblist.add(n3 + 1, basicBlock2);
        return basicBlock2;
    }

    public void addBlock(int n2, BasicBlock<InsnType> basicBlock) {
        if (basicBlock == null) {
            throw new IllegalArgumentException("Null block");
        }
        if (n2 < 0) {
            n2 += this.bblist.size() + 1;
        }
        this.bblist.add(n2, basicBlock);
    }

    public void addBlock(BasicBlock<InsnType> basicBlock) {
        if (basicBlock == null) {
            throw new IllegalArgumentException("Null block");
        }
        this.bblist.add(basicBlock);
    }

    public boolean addEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
        if (basicBlock == null || basicBlock2 == null) {
            throw new IllegalArgumentException("Null block");
        }
        if (basicBlock.dst.contains(basicBlock2)) {
            return false;
        }
        basicBlock.dst.add(basicBlock2);
        basicBlock2.src.add(basicBlock);
        return true;
    }

    public int addEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, int n2) {
        if (basicBlock == null || basicBlock2 == null) {
            throw new IllegalArgumentException("Null block");
        }
        if (n2 < 0) {
            n2 += basicBlock.dst.size() + 1;
        }
        int n3 = CollectionUtil.identityCount(basicBlock.dst, basicBlock2);
        basicBlock.dst.add(n2, basicBlock2);
        basicBlock2.src.add(basicBlock);
        return n3 + 1;
    }

    public boolean addIrregularEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
        if (basicBlock == null || basicBlock2 == null) {
            throw new IllegalArgumentException("Null block");
        }
        if (basicBlock.irrdst.contains(basicBlock2)) {
            return false;
        }
        basicBlock.irrdst.add(basicBlock2);
        basicBlock2.irrsrc.add(basicBlock);
        return true;
    }

    public int addIrregularEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, int n2) {
        if (basicBlock == null || basicBlock2 == null) {
            throw new IllegalArgumentException("Null block");
        }
        if (n2 < 0) {
            n2 += basicBlock.irrdst.size() + 1;
        }
        int n3 = CollectionUtil.identityCount(basicBlock.irrdst, basicBlock2);
        basicBlock.irrdst.add(n2, basicBlock2);
        basicBlock2.irrsrc.add(basicBlock);
        return n3 + 1;
    }

    private int reconnectEdges(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, BasicBlock<InsnType> basicBlock3) {
        int n2;
        int n3 = 0;
        while ((n2 = this.reconnectEdge(basicBlock, basicBlock2, basicBlock3, 0)) != 0) {
            ++n3;
        }
        return n3;
    }

    public int reconnectEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, BasicBlock<InsnType> basicBlock3) {
        return this.reconnectEdge(basicBlock, basicBlock2, basicBlock3, null);
    }

    public int reconnectEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, BasicBlock<InsnType> basicBlock3, Integer n2) {
        if (basicBlock == null || basicBlock2 == null) {
            throw new IllegalArgumentException("Null block");
        }
        int n3 = -1;
        int n4 = 0;
        for (int i = 0; i < basicBlock.dst.size(); ++i) {
            BasicBlock basicBlock4 = basicBlock.dst.get(i);
            if (basicBlock4 == basicBlock2) {
                if (n2 == null) {
                    if (n3 != -1) {
                        return -2;
                    }
                    n3 = i;
                } else if (n2 == n4) {
                    n3 = i;
                    break;
                }
                ++n4;
                continue;
            }
            if (basicBlock3 == null || basicBlock4 != basicBlock3 || n2 != null) continue;
            return -1;
        }
        if (n3 < 0) {
            return 0;
        }
        if (basicBlock3 == null) {
            basicBlock.dst.remove(n3);
            basicBlock2.src.remove(basicBlock);
        } else {
            basicBlock.dst.set(n3, basicBlock3);
            basicBlock2.src.remove(basicBlock);
            basicBlock3.src.add(basicBlock);
        }
        return 1;
    }

    public int reconnectIrregularEdges(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, BasicBlock<InsnType> basicBlock3) {
        int n2;
        int n3 = 0;
        while ((n2 = this.reconnectIrregularEdge(basicBlock, basicBlock2, basicBlock3, 0)) != 0) {
            ++n3;
        }
        return n3;
    }

    public int reconnectIrregularEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, BasicBlock<InsnType> basicBlock3) {
        return this.reconnectIrregularEdge(basicBlock, basicBlock2, basicBlock3, null);
    }

    public int reconnectIrregularEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, BasicBlock<InsnType> basicBlock3, Integer n2) {
        if (basicBlock == null || basicBlock2 == null) {
            throw new IllegalArgumentException("Null block");
        }
        int n3 = -1;
        int n4 = 0;
        for (int i = 0; i < basicBlock.irrdst.size(); ++i) {
            BasicBlock basicBlock4 = basicBlock.irrdst.get(i);
            if (basicBlock4 == basicBlock2) {
                if (n2 == null) {
                    if (n3 != -1) {
                        return -2;
                    }
                    n3 = i;
                } else if (n2 == n4) {
                    n3 = i;
                    break;
                }
                ++n4;
                continue;
            }
            if (basicBlock3 == null || basicBlock4 != basicBlock3 || n2 != null) continue;
            return -1;
        }
        if (n3 < 0) {
            return 0;
        }
        if (basicBlock3 == null) {
            basicBlock.irrdst.remove(n3);
            basicBlock2.irrsrc.remove(basicBlock);
        } else {
            basicBlock.irrdst.set(n3, basicBlock3);
            basicBlock2.irrsrc.remove(basicBlock);
            basicBlock3.irrsrc.add(basicBlock);
        }
        return 1;
    }

    public int deleteEdges(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
        return this.reconnectEdges(basicBlock, basicBlock2, null);
    }

    public boolean deleteEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
        return this.reconnectEdge(basicBlock, basicBlock2, null, 0) == 1;
    }

    public int deleteEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, int n2) {
        return this.reconnectEdge(basicBlock, basicBlock2, null, n2);
    }

    public int deleteIrregularEdges(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
        return this.reconnectIrregularEdges(basicBlock, basicBlock2, null);
    }

    public boolean deleteIrregularEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
        return this.reconnectIrregularEdge(basicBlock, basicBlock2, null, 0) == 1;
    }

    public int deleteIrregularEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, int n2) {
        return this.reconnectIrregularEdge(basicBlock, basicBlock2, null, n2);
    }

    public void deleteOutEdges(BasicBlock<InsnType> basicBlock) {
        if (basicBlock == null) {
            throw new IllegalArgumentException("Null block");
        }
        for (BasicBlock basicBlock2 : basicBlock.dst) {
            basicBlock2.src.remove(basicBlock);
        }
        basicBlock.dst.clear();
    }

    public void deleteIrregularOutEdges(BasicBlock<InsnType> basicBlock) {
        if (basicBlock == null) {
            throw new IllegalArgumentException("Null block");
        }
        for (BasicBlock basicBlock2 : basicBlock.irrdst) {
            basicBlock2.irrsrc.remove(basicBlock);
        }
        basicBlock.irrdst.clear();
    }

    public boolean deleteDuplicateEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
        if (basicBlock == null || basicBlock2 == null) {
            throw new IllegalArgumentException("Null block");
        }
        int n2 = -1;
        boolean bl = false;
        for (int i = 0; i < basicBlock.outsize(); ++i) {
            IBasicBlock iBasicBlock = basicBlock.getOutputBlock(i);
            if (iBasicBlock != basicBlock2) continue;
            if (n2 != -1) {
                bl = true;
                break;
            }
            n2 = i;
        }
        if (!bl) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        basicBlock.dst.remove(n2);
        basicBlock2.src.remove(basicBlock);
        return true;
    }

    public void deleteAllEdges() {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            basicBlock.src.clear();
            basicBlock.dst.clear();
            basicBlock.irrsrc.clear();
            basicBlock.irrdst.clear();
        }
    }

    public int removeUnreachableBlocks() {
        return this.removeUnreachableBlocks(true);
    }

    public int removeUnreachableBlocks(boolean bl) {
        if (!bl && (this.flags & 4) != 0) {
            return 0;
        }
        return CFGUtil.removeUnreachableBlocks(this);
    }

    public InsnType replaceInstruction(long l2, InsnType InsnType) {
        if (InsnType == null) {
            throw new IllegalArgumentException("Null instruction");
        }
        IBasicBlock iBasicBlock = this.getBlockContaining(l2);
        if (iBasicBlock == null) {
            return null;
        }
        int n2 = ((BasicBlock)iBasicBlock).getIndexOfInstruction(l2);
        if (n2 < 0) {
            return null;
        }
        InsnType InsnType2 = ((BasicBlock)iBasicBlock).set(n2, InsnType);
        return InsnType2;
    }

    public boolean replaceInstructionsInBlock(long l2, int n2, Collection<InsnType> collection) {
        int n3;
        IBasicBlock iBasicBlock = this.getBlockContaining(l2);
        if (iBasicBlock == null) {
            return false;
        }
        int n4 = ((BasicBlock)iBasicBlock).getIndexOfInstruction(l2);
        if (n4 < 0) {
            return false;
        }
        int n5 = n4 + n2;
        if (n5 > ((BasicBlock)iBasicBlock).size()) {
            return false;
        }
        int n6 = 0;
        for (n3 = n4; n3 < n5; ++n3) {
            IInstruction iInstruction = (IInstruction)((BasicBlock)iBasicBlock).insns.get(n3);
            n6 += iInstruction.getSize();
        }
        n3 = 0;
        for (IInstruction iInstruction : collection) {
            n3 += iInstruction.getSize();
        }
        if (n3 != n6) {
            return false;
        }
        while (n2-- > 0) {
            ((BasicBlock)iBasicBlock).insns.remove(n4);
        }
        ((BasicBlock)iBasicBlock).insns.addAll(n4, collection);
        return true;
    }

    public IVariableInformationProvider setVariableInformationProvider(IVariableInformationProvider iVariableInformationProvider) {
        IVariableInformationProvider iVariableInformationProvider2 = this.getVariableInformationProvider();
        this.varInfoProvider = new WeakReference<IVariableInformationProvider>(iVariableInformationProvider);
        return iVariableInformationProvider2;
    }

    public IVariableInformationProvider getVariableInformationProvider() {
        return this.varInfoProvider == null ? null : (IVariableInformationProvider)this.varInfoProvider.get();
    }

    public void setTimedOperationVerifier(TimedOperationVerifier timedOperationVerifier) {
        this.tov = timedOperationVerifier;
    }

    public TimedOperationVerifier getTimedOperationVerifier() {
        return this.tov;
    }

    public List<IDFA<InsnType>> getCurrentDFAs() {
        if (this.dfaObjects == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.dfaObjects);
    }

    public IDFA<InsnType> doDataFlowAnalysis() {
        return this.doDataFlowAnalysis(false);
    }

    public int setDFADefaultCollectionFlags(int n2) {
        int n3 = this.defaultCollectionFlags;
        this.defaultCollectionFlags = n2;
        return n3;
    }

    public int getDFADefaultCollectionFlags() {
        return this.defaultCollectionFlags;
    }

    public boolean setDFADefaultIntegrateInputs(boolean bl) {
        boolean bl2 = this.defaultIntegrateInputs;
        this.defaultIntegrateInputs = bl;
        return bl2;
    }

    public boolean isDFADefaultIntegrateInputs() {
        return this.defaultIntegrateInputs;
    }

    public IDFA<InsnType> doDataFlowAnalysis(boolean bl) {
        return this.doDataFlowAnalysis(bl, this.defaultCollectionFlags);
    }

    public IDFA<InsnType> doDataFlowAnalysis(boolean bl, int n2) {
        return this.doDataFlowAnalysis(bl, n2, this.defaultIntegrateInputs);
    }

    public IDFA<InsnType> doDataFlowAnalysis(boolean bl, int n2, boolean bl2) {
        this.dfaPrep(bl);
        for (IDFA<InsnType> iDFA : this.dfaObjects) {
            if (!iDFA.isValid() || iDFA.getVariableCollectionFlags() != n2 || iDFA.isIntegrateCalculatedInputRegisters() != bl2 || iDFA.getVariableInformationProvider() != this.getVariableInformationProvider()) continue;
            return iDFA;
        }
        IDFA<InsnType> iDFA = this.createDataFlowAnalysisHelperObject();
        iDFA.setVariableCollectionFlags(n2);
        iDFA.setIntegrateCalculatedInputRegisters(bl2);
        iDFA.setVariableInformationProvider(this.getVariableInformationProvider());
        iDFA.perform();
        this.dfaObjects.add(iDFA);
        return iDFA;
    }

    private void dfaPrep(boolean bl) {
        if (this.dfaObjects == null) {
            this.dfaObjects = new ArrayList<IDFA<InsnType>>();
        } else {
            int n2 = 0;
            while (n2 < this.dfaObjects.size()) {
                if (bl || !this.dfaObjects.get(n2).isValid()) {
                    this.dfaObjects.remove(n2);
                    continue;
                }
                ++n2;
            }
        }
    }

    public IDFA<InsnType> getDataFlowAnalysis() {
        return this.getDataFlowAnalysis(this.defaultCollectionFlags, this.defaultIntegrateInputs);
    }

    public IDFA<InsnType> getDataFlowAnalysis(int n2, boolean bl) {
        this.dfaPrep(false);
        for (IDFA<InsnType> iDFA : this.dfaObjects) {
            if (!iDFA.isValid() || iDFA.getVariableCollectionFlags() != n2 || iDFA.isIntegrateCalculatedInputRegisters() != bl || iDFA.getVariableInformationProvider() != this.getVariableInformationProvider()) continue;
            return iDFA;
        }
        return null;
    }

    public IDFA<InsnType> createDataFlowAnalysisHelperObject() {
        DFA4 dFA4 = new DFA4(this);
        dFA4.setVariableCollectionFlags(this.getDFADefaultCollectionFlags());
        dFA4.setIntegrateCalculatedInputRegisters(this.isDFADefaultIntegrateInputs());
        dFA4.setVariableInformationProvider(this.getVariableInformationProvider());
        dFA4.perform();
        return dFA4;
    }

    public void invalidateDataFlowAnalysis() {
        if (this.dfaObjects != null) {
            for (IDFA<InsnType> iDFA : this.dfaObjects) {
                iDFA.invalidate();
            }
            this.dfaObjects.clear();
        }
    }

    public void invalidateDataFlowAnalysis(long l2) {
        if (this.dfaObjects != null) {
            for (IDFA<InsnType> iDFA : this.dfaObjects) {
                iDFA.notifyInstructionUpdate(l2);
            }
        }
    }

    public String formatInstructions() {
        return this.format(false);
    }

    public String format() {
        return this.format(true);
    }

    private String format(boolean bl) {
        return this.format(bl, null);
    }

    private String format(boolean bl, IFormattingContextFactory<InsnType> iFormattingContextFactory) {
        StringBuilder stringBuilder = new StringBuilder();
        for (BasicBlock<InsnType> basicBlock : this.getBlocks()) {
            int n2 = 0;
            for (IInstruction iInstruction : basicBlock) {
                long l2 = basicBlock.getAddressOfInstruction(n2);
                if (bl) {
                    char c2 = n2 >= 1 ? (char)':' : (basicBlock.getFirstAddress() == this.entry ? (char)'>' : (basicBlock.irrinsize() == 0 ? (char)'+' : '*'));
                    Strings.ff(stringBuilder, "%04X/%X%c  ", l2, iInstruction.getSize(), Character.valueOf(c2));
                }
                Object object = iFormattingContextFactory == null ? Long.valueOf(l2) : iFormattingContextFactory.createFormattingContext(iInstruction);
                stringBuilder.append(iInstruction.format(object));
                stringBuilder.append("\n");
                ++n2;
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Strings.ff("CFG(%d): ", this.bblist.size()));
        int n2 = 0;
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(basicBlock);
            ++n2;
        }
        return stringBuilder.toString();
    }

    @Override
    public Iterator<BasicBlock<InsnType>> iterator() {
        return this.bblist.iterator();
    }

    @Override
    public Iterable<InsnType> instructions() {
        return new Iterable<InsnType>(){

            @Override
            public Iterator<InsnType> iterator() {
                return new InstructionsIterator();
            }
        };
    }

    @Override
    public Iterable<AddressableInstruction<InsnType>> addressableInstructions() {
        return new Iterable<AddressableInstruction<InsnType>>(){

            @Override
            public Iterator<AddressableInstruction<InsnType>> iterator() {
                return new AddressableInstructionsIterator();
            }
        };
    }

    public Iterable<Couple<Integer, BasicBlock<InsnType>>> indexedBlocks() {
        return new Iterable<Couple<Integer, BasicBlock<InsnType>>>(){

            @Override
            public Iterator<Couple<Integer, BasicBlock<InsnType>>> iterator() {
                return new IndexedBlocksIterator();
            }
        };
    }

    private class IndexedBlocksIterator
    implements Iterator<Couple<Integer, BasicBlock<InsnType>>> {
        private int i = 0;
        private int end;
        private boolean canRemove;

        private IndexedBlocksIterator() {
            this.end = CFG.this.bblist.size();
        }

        @Override
        public boolean hasNext() {
            return this.i < this.end;
        }

        @Override
        public Couple<Integer, BasicBlock<InsnType>> next() {
            Couple couple = new Couple(this.i, CFG.this.bblist.get(this.i));
            ++this.i;
            this.canRemove = true;
            return couple;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            --this.i;
            CFG.this.bblist.remove(this.i);
            --this.end;
            this.canRemove = false;
        }
    }

    private class AddressableInstructionsIterator
    implements Iterator<AddressableInstruction<InsnType>> {
        private int blkIndex;
        private int insnIndex;
        private BasicBlock<InsnType> blk;
        private long address;

        private AddressableInstructionsIterator() {
            if (CFG.this.bblist.size() > 0) {
                this.blk = CFG.this.bblist.get(0);
                this.address = this.blk.base;
            }
        }

        @Override
        public boolean hasNext() {
            return this.blk != null;
        }

        @Override
        public AddressableInstruction<InsnType> next() {
            if (this.blk == null) {
                throw new NoSuchElementException();
            }
            Object InsnType = this.blk.get(this.insnIndex);
            AddressableInstruction addressableInstruction = new AddressableInstruction(this.address, InsnType);
            ++this.insnIndex;
            if (this.insnIndex >= this.blk.size()) {
                this.insnIndex = 0;
                ++this.blkIndex;
                if (this.blkIndex >= CFG.this.bblist.size()) {
                    this.blk = null;
                } else {
                    this.blk = CFG.this.bblist.get(this.blkIndex);
                    this.address = this.blk.base;
                }
            } else {
                this.address += (long)InsnType.getSize();
            }
            return addressableInstruction;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class InstructionsIterator
    implements Iterator<InsnType> {
        private int blkIndex;
        private int insnIndex;
        private BasicBlock<InsnType> blk;

        private InstructionsIterator() {
            if (CFG.this.bblist.size() > 0) {
                this.blk = CFG.this.bblist.get(0);
            }
        }

        @Override
        public boolean hasNext() {
            return this.blk != null;
        }

        @Override
        public InsnType next() {
            if (this.blk == null) {
                throw new NoSuchElementException();
            }
            Object InsnType = this.blk.get(this.insnIndex);
            ++this.insnIndex;
            if (this.insnIndex >= this.blk.size()) {
                this.insnIndex = 0;
                ++this.blkIndex;
                this.blk = this.blkIndex >= CFG.this.bblist.size() ? null : CFG.this.bblist.get(this.blkIndex);
            }
            return InsnType;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

