/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.cfg;

import com.pnfsoftware.jeb.core.units.code.AddressableInstruction;
import com.pnfsoftware.jeb.core.units.code.IBasicBlock;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.util.collect.CollectionUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Ser
public class BasicBlock<InsnType extends IInstruction>
implements IBasicBlock<InsnType>,
Comparable<BasicBlock<InsnType>> {
    private static final ILogger logger = GlobalLog.getLogger(BasicBlock.class);
    @SerId(value=1)
    long base;
    @SerId(value=2)
    List<InsnType> insns;
    @SerTransient
    List<Long> dst_offsets;
    @SerTransient
    List<Long> irrdst_offsets;
    @SerId(value=3)
    List<BasicBlock<InsnType>> src;
    @SerId(value=4)
    List<BasicBlock<InsnType>> dst;
    @SerId(value=5)
    List<BasicBlock<InsnType>> irrsrc;
    @SerId(value=6)
    List<BasicBlock<InsnType>> irrdst;
    @SerId(value=7)
    boolean unknownDst;
    @SerTransient
    Map<String, Object> datamap;

    public BasicBlock(long l2) {
        this.base = l2;
        this.insns = new ArrayList<InsnType>();
        this.dst_offsets = new ArrayList<Long>();
        this.irrdst_offsets = new ArrayList<Long>();
        this.src = new ArrayList<BasicBlock<InsnType>>();
        this.dst = new ArrayList<BasicBlock<InsnType>>();
        this.irrsrc = new ArrayList<BasicBlock<InsnType>>();
        this.irrdst = new ArrayList<BasicBlock<InsnType>>();
    }

    public BasicBlock(long l2, List<InsnType> list, List<Long> list2, List<Long> list3, boolean bl) {
        this.base = l2;
        this.insns = list;
        this.dst_offsets = list2;
        this.irrdst_offsets = list3;
        this.unknownDst = bl;
        this.src = new ArrayList<BasicBlock<InsnType>>();
        this.dst = new ArrayList<BasicBlock<InsnType>>();
        this.irrsrc = new ArrayList<BasicBlock<InsnType>>();
        this.irrdst = new ArrayList<BasicBlock<InsnType>>();
    }

    public BasicBlock<InsnType> shallowCopy(boolean bl) {
        BasicBlock<InsnType> basicBlock = new BasicBlock<InsnType>(this.base);
        basicBlock.insns.addAll(this.insns);
        if (bl) {
            basicBlock.src.addAll(this.src);
            basicBlock.dst.addAll(this.dst);
            basicBlock.irrsrc.addAll(this.irrsrc);
            basicBlock.irrdst.addAll(this.irrdst);
        }
        basicBlock.dst_offsets = this.dst_offsets == null ? null : new ArrayList<Long>(this.dst_offsets);
        basicBlock.irrdst_offsets = this.irrdst_offsets == null ? null : new ArrayList<Long>(this.irrdst_offsets);
        basicBlock.unknownDst = this.unknownDst;
        return basicBlock;
    }

    @Override
    public long getBase() {
        return this.base;
    }

    @Override
    public long getFirstAddress() {
        return this.base;
    }

    @Override
    public long getLastAddress() {
        long l2 = this.base;
        for (int i = 0; i < this.insns.size() - 1; ++i) {
            l2 += (long)((IInstruction)this.insns.get(i)).getSize();
        }
        return l2;
    }

    @Override
    public long getEndAddress() {
        long l2 = this.base;
        for (IInstruction iInstruction : this.insns) {
            l2 += (long)iInstruction.getSize();
        }
        return l2;
    }

    @Override
    public long getAddressOfInstruction(int n2) {
        if (n2 < 0 || n2 >= this.insns.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long l2 = this.base;
        for (int i = 0; i < n2; ++i) {
            l2 += (long)((IInstruction)this.insns.get(i)).getSize();
        }
        return l2;
    }

    public long[] getAddresses() {
        long[] lArray = new long[this.insns.size()];
        int n2 = 0;
        long l2 = this.base;
        for (IInstruction iInstruction : this.insns) {
            lArray[n2] = l2;
            ++n2;
            l2 += (long)iInstruction.getSize();
        }
        return lArray;
    }

    @Override
    public int getIndexOfInstruction(long l2) {
        long l3 = this.base;
        for (int i = 0; i < this.insns.size(); ++i) {
            if (l3 >= l2) {
                return l3 == l2 ? i : -1;
            }
            l3 += (long)((IInstruction)this.insns.get(i)).getSize();
        }
        return -1;
    }

    public int getIndexOfInstruction(InsnType InsnType) {
        int n2 = 0;
        for (IInstruction iInstruction : this.insns) {
            if (iInstruction == InsnType) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    @Override
    public boolean canThrow() {
        for (IInstruction iInstruction : this.insns) {
            if (!iInstruction.canThrow()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.insns.size();
    }

    @Override
    public boolean isEmpty() {
        return this.insns.isEmpty();
    }

    @Override
    public InsnType get(int n2) {
        if (n2 < 0) {
            n2 += this.insns.size();
        }
        return (InsnType)((IInstruction)this.insns.get(n2));
    }

    public AddressableInstruction<InsnType> get2(int n2) {
        if (n2 < 0 || n2 >= this.insns.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long l2 = this.base;
        IInstruction iInstruction = (IInstruction)this.insns.get(0);
        for (int i = 0; i < n2; ++i) {
            l2 += (long)iInstruction.getSize();
            iInstruction = (IInstruction)this.insns.get(i + 1);
        }
        return new AddressableInstruction<IInstruction>(l2, iInstruction);
    }

    @Override
    public InsnType getLast() {
        return this.get(this.insns.size() - 1);
    }

    @Override
    public int getSizeOfInstructions() {
        int n2 = 0;
        for (IInstruction iInstruction : this.insns) {
            n2 += iInstruction.getSize();
        }
        return n2;
    }

    public AddressableInstruction<InsnType> getLast2() {
        return this.get2(this.insns.size() - 1);
    }

    @Override
    public InsnType getInstruction(long l2) {
        long l3 = this.base;
        for (IInstruction iInstruction : this.insns) {
            if (l3 >= l2) {
                return (InsnType)(l3 == l2 ? iInstruction : null);
            }
            l3 += (long)iInstruction.getSize();
        }
        return null;
    }

    @Override
    public List<InsnType> getInstructions() {
        return new ArrayList<InsnType>(this.insns);
    }

    public AddressableInstruction<InsnType> getBranchingInstruction2(boolean bl, boolean bl2) {
        long l2 = this.base;
        for (int i = 0; i < this.insns.size(); ++i) {
            IInstruction iInstruction = (IInstruction)this.insns.get(i);
            if (bl && iInstruction.getBreakingFlow(l2).isBroken()) {
                return new AddressableInstruction<IInstruction>(l2, iInstruction);
            }
            if (bl2 && iInstruction.getRoutineCall(l2).isBroken()) {
                return new AddressableInstruction<IInstruction>(l2, iInstruction);
            }
            l2 += (long)iInstruction.getSize();
        }
        return null;
    }

    public AddressableInstruction<InsnType> getBranchingInstruction2() {
        return this.getBranchingInstruction2(true, true);
    }

    public boolean remove(int n2) {
        this.insns.remove(n2);
        return this.insns.isEmpty();
    }

    public void add(InsnType InsnType) {
        this.insns.add(InsnType);
    }

    public void add(int n2, InsnType InsnType) {
        this.insns.add(n2, InsnType);
    }

    public void addAll(Collection<InsnType> collection) {
        this.insns.addAll(collection);
    }

    public void addAll(int n2, Collection<InsnType> collection) {
        this.insns.addAll(n2, collection);
    }

    public InsnType set(int n2, InsnType InsnType) {
        if (((IInstruction)this.insns.get(n2)).getSize() != InsnType.getSize()) {
            throw new IllegalArgumentException("Replacement of instruction with different sizes");
        }
        return (InsnType)((IInstruction)this.insns.set(n2, InsnType));
    }

    public InsnType setLast(InsnType InsnType) {
        return (InsnType)((IInstruction)this.insns.set(this.insns.size() - 1, InsnType));
    }

    @Override
    public int insize() {
        return this.src.size();
    }

    @Override
    public int irrinsize() {
        return this.irrsrc.size();
    }

    @Override
    public int allinsize() {
        return this.src.size() + this.irrsrc.size();
    }

    @Override
    public BasicBlock<InsnType> getInputBlock(int n2) {
        return this.src.get(n2);
    }

    @Override
    public List<BasicBlock<InsnType>> getInputBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.src);
    }

    @Override
    public BasicBlock<InsnType> getIrregularInputBlock(int n2) {
        return this.irrsrc.get(n2);
    }

    @Override
    public List<BasicBlock<InsnType>> getIrregularInputBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.irrsrc);
    }

    @Override
    public List<BasicBlock<InsnType>> getAllInputBlocks() {
        ArrayList<BasicBlock<InsnType>> arrayList = new ArrayList<BasicBlock<InsnType>>(this.src);
        arrayList.addAll(this.irrsrc);
        return arrayList;
    }

    @Override
    public int outsize() {
        return this.dst.size();
    }

    @Override
    public int irroutsize() {
        return this.irrdst.size();
    }

    @Override
    public int alloutsize() {
        return this.dst.size() + this.irrdst.size();
    }

    @Override
    public BasicBlock<InsnType> getOutputBlock(int n2) {
        return this.dst.get(n2);
    }

    @Override
    public List<BasicBlock<InsnType>> getOutputBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.dst);
    }

    public List<Long> getOutputOffsets() {
        ArrayList<Long> arrayList = new ArrayList<Long>(this.dst.size());
        this.dst.forEach(basicBlock -> arrayList.add(basicBlock.getFirstAddress()));
        return arrayList;
    }

    @Override
    public BasicBlock<InsnType> getIrregularOutputBlock(int n2) {
        return this.irrdst.get(n2);
    }

    @Override
    public List<BasicBlock<InsnType>> getIrregularOutputBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.irrdst);
    }

    public List<Long> getIrregularOutputOffsets() {
        ArrayList<Long> arrayList = new ArrayList<Long>(this.irrdst.size());
        this.irrdst.forEach(basicBlock -> arrayList.add(basicBlock.getFirstAddress()));
        return arrayList;
    }

    @Override
    public List<BasicBlock<InsnType>> getAllOutputBlocks() {
        ArrayList<BasicBlock<InsnType>> arrayList = new ArrayList<BasicBlock<InsnType>>(this.dst);
        arrayList.addAll(this.irrdst);
        return arrayList;
    }

    @Override
    public List<BasicBlock<InsnType>> getInputs() {
        return Collections.unmodifiableList(this.src);
    }

    public List<Long> getInputOffsets() {
        ArrayList<Long> arrayList = new ArrayList<Long>(this.src.size());
        this.src.forEach(basicBlock -> arrayList.add(basicBlock.getFirstAddress()));
        return arrayList;
    }

    @Override
    public List<BasicBlock<InsnType>> getIrregularInputs() {
        return Collections.unmodifiableList(this.irrsrc);
    }

    public List<Long> getIrregularInputOffsets() {
        ArrayList<Long> arrayList = new ArrayList<Long>(this.irrsrc.size());
        this.irrsrc.forEach(basicBlock -> arrayList.add(basicBlock.getFirstAddress()));
        return arrayList;
    }

    @Override
    public List<BasicBlock<InsnType>> getOutputs() {
        return Collections.unmodifiableList(this.dst);
    }

    @Override
    public List<BasicBlock<InsnType>> getIrregularOutputs() {
        return Collections.unmodifiableList(this.irrdst);
    }

    @Override
    public Iterable<BasicBlock<InsnType>> getAllInputs() {
        return CollectionUtil.doubleCollectionIterable(this.src, this.irrsrc);
    }

    @Override
    public Iterable<BasicBlock<InsnType>> getAllOutputs() {
        return CollectionUtil.doubleCollectionIterable(this.dst, this.irrdst);
    }

    public void setUnknownDst(boolean bl) {
        this.unknownDst = bl;
    }

    public boolean hasUnknownDst() {
        return this.unknownDst;
    }

    public boolean isSelfReferencing() {
        if (this.dst.size() > 0 && this.src.size() > 0) {
            for (BasicBlock<InsnType> basicBlock : this.dst) {
                if (!this.src.contains(basicBlock)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInfiniteLoop() {
        return this.dst.size() == 1 && this.isSelfReferencing();
    }

    public String toString() {
        return Strings.ff("%Xh(%d)", this.base, this.insns.size());
    }

    BasicBlock<InsnType> splitBlock(long l2) {
        int n2;
        int n3 = this.getSplitIndex(l2);
        BasicBlock<InsnType> basicBlock = new BasicBlock<InsnType>(l2);
        for (n2 = n3; n2 < this.insns.size(); ++n2) {
            basicBlock.insns.add((IInstruction)this.insns.get(n2));
        }
        basicBlock.dst_offsets = new ArrayList<Long>(this.dst_offsets);
        basicBlock.unknownDst = this.unknownDst;
        n2 = this.insns.size() - n3;
        for (int i = 0; i < n2; ++i) {
            this.insns.remove(n3);
        }
        this.dst_offsets.clear();
        this.dst_offsets.add(l2);
        this.unknownDst = false;
        return basicBlock;
    }

    private int getSplitIndex(long l2) {
        long l3 = this.getFirstAddress();
        int n2 = 0;
        for (IInstruction iInstruction : this.insns) {
            if (l3 == l2) {
                return n2;
            }
            l3 += (long)iInstruction.getSize();
            ++n2;
        }
        return -1;
    }

    public void setData(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.datamap == null) {
            this.datamap = new HashMap<String, Object>();
        }
        this.datamap.put(string, object);
    }

    public Object getData(String string) {
        if (this.datamap == null) {
            return null;
        }
        return this.datamap.get(string);
    }

    public boolean removeData(String string) {
        if (this.datamap == null) {
            return false;
        }
        return this.datamap.remove(string) != null;
    }

    @Override
    public Iterator<InsnType> iterator() {
        return this.insns.iterator();
    }

    public Iterable<AddressableInstruction<InsnType>> addressableInstructions() {
        return new Iterable<AddressableInstruction<InsnType>>(){

            @Override
            public Iterator<AddressableInstruction<InsnType>> iterator() {
                return new AddressableInstructionsIterator();
            }
        };
    }

    @Override
    public int compareTo(BasicBlock<InsnType> basicBlock) {
        return Long.compareUnsigned(this.base, basicBlock.base);
    }

    private class AddressableInstructionsIterator
    implements Iterator<AddressableInstruction<InsnType>> {
        private long address;
        private Iterator<InsnType> iter;

        private AddressableInstructionsIterator() {
            this.address = BasicBlock.this.base;
            this.iter = BasicBlock.this.insns.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public AddressableInstruction<InsnType> next() {
            IInstruction iInstruction = (IInstruction)this.iter.next();
            AddressableInstruction<IInstruction> addressableInstruction = new AddressableInstruction<IInstruction>(this.address, iInstruction);
            this.address += (long)iInstruction.getSize();
            return addressableInstruction;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

