/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.cfg;

import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractCFGReorganizer<InsnType extends IInstruction> {
    private static final ILogger logger = GlobalLog.getLogger(AbstractCFGReorganizer.class);
    private CFG<InsnType> cfg;
    private CFG<InsnType> reorganizedCfg;
    private Map<Long, Long> conversionMap;

    public AbstractCFGReorganizer(CFG<InsnType> cFG) {
        this.cfg = cFG;
    }

    private static int verifyOrder(int n2, int[] nArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int n3 : nArray) {
            if (n3 >= 0 && n3 < n2 && hashSet.add(n3)) continue;
            return 0;
        }
        if (hashSet.size() != n2) {
            return 0;
        }
        int n4 = 0;
        for (int n5 : nArray) {
            if (n5 != n4) {
                return 1;
            }
            ++n4;
        }
        return -1;
    }

    public CFG<InsnType> reorder(int[] nArray) {
        Object object;
        boolean bl;
        if (this.conversionMap != null) {
            throw new IllegalStateException();
        }
        int n2 = AbstractCFGReorganizer.verifyOrder(this.cfg.size(), nArray);
        if (n2 <= 0) {
            if (n2 == 0) {
                throw new IllegalArgumentException();
            }
            return null;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<List<Long>> arrayList2 = new ArrayList<List<Long>>();
        ArrayList<List<Long>> arrayList3 = new ArrayList<List<Long>>();
        for (BasicBlock<InsnType> basicBlock : this.cfg) {
            arrayList.add(basicBlock.getFirstAddress());
            arrayList2.add(basicBlock.getOutputOffsets());
            arrayList3.add(basicBlock.getIrregularOutputOffsets());
        }
        long l2 = 0L;
        long l3 = -1L;
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        HashMap<Long, Long> hashMap2 = new HashMap<Long, Long>();
        TreeMap<Long, Object> treeMap = new TreeMap<Long, Object>();
        HashMap hashMap3 = new HashMap();
        HashMap<Object, Integer> hashMap4 = new HashMap<Object, Integer>();
        boolean bl2 = bl = nArray[0] != 0;
        if (bl) {
            BBB bBB2 = new BBB();
            bBB2.insns.add(this.createTrampoline(0L));
            treeMap.put(l2, bBB2);
            hashMap4.put(bBB2, 0);
            hashMap2.put(l3, l2);
            ++l2;
            --l3;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            boolean bl3 = i + 1 < nArray.length && nArray[i + 1] == n3 + 1;
            object = this.cfg.get(n3);
            hashMap.put(l2, ((BasicBlock)object).getFirstAddress());
            hashMap2.put(((BasicBlock)object).getFirstAddress(), l2);
            BBB bBB3 = new BBB();
            treeMap.put(l2, bBB3);
            hashMap3.put(bBB3, n3);
            Object object2 = ((BasicBlock)object).iterator();
            while (object2.hasNext()) {
                IInstruction iInstruction = (IInstruction)object2.next();
                l2 += (long)iInstruction.getSize();
                bBB3.insns.add(iInstruction);
            }
            if (bl3 || !this.needsTrampoline((BasicBlock<InsnType>)object)) continue;
            if (this.isFallthrough((BasicBlock<InsnType>)object)) {
                bBB3.insns.add(this.createTrampoline((Long)((List)arrayList2.get(n3)).get(0)));
                ++l2;
                continue;
            }
            object2 = new BBB();
            ((BBB)object2).insns.add(this.createTrampoline((Long)((List)arrayList2.get(n3)).get(0)));
            treeMap.put(l2, object2);
            hashMap4.put(object2, n3 + 1);
            ((List)arrayList2.get(n3)).set(0, l3);
            hashMap2.put(l3, l2);
            ++l2;
            --l3;
        }
        for (BBB bBB4 : treeMap.values()) {
            IInstruction iInstruction = (IInstruction)bBB4.insns.get(bBB4.insns.size() - 1);
            object = (Integer)hashMap4.get(bBB4);
            if (object != null) {
                long l4 = (Long)arrayList.get((Integer)object);
                long l5 = (Long)hashMap2.get(l4);
                this.updateTrampolineTarget(iInstruction, l5);
                continue;
            }
            this.updateTargets(iInstruction, hashMap2);
        }
        ArrayList arrayList4 = new ArrayList();
        treeMap.values().forEach(bBB -> arrayList4.addAll(bBB.insns));
        CFG<InsnType> cFG = this.buildCFG(arrayList4);
        this.reorganizedCfg = cFG;
        this.conversionMap = hashMap2;
        return cFG;
    }

    public CFG<InsnType> getReorganizedCfg() {
        return this.reorganizedCfg;
    }

    public Map<Long, Long> getConversionMap() {
        return this.conversionMap;
    }

    private boolean isFallthrough(BasicBlock<InsnType> basicBlock) {
        return !basicBlock.getLast().getBreakingFlow(basicBlock.getLastAddress()).isBroken() && basicBlock.outsize() >= 1;
    }

    private boolean needsTrampoline(BasicBlock<InsnType> basicBlock) {
        return this.isFallthrough(basicBlock) || this.canFallthrough(basicBlock.getLast());
    }

    protected abstract boolean canFallthrough(InsnType var1);

    protected abstract InsnType createTrampoline(long var1);

    protected abstract InsnType createNop(int var1);

    protected abstract void updateTrampolineTarget(InsnType var1, long var2);

    protected abstract boolean hasTargets(InsnType var1);

    protected abstract void updateTargets(InsnType var1, Map<Long, Long> var2);

    protected abstract CFG<InsnType> buildCFG(List<InsnType> var1);

    private static class BBB<InsnType extends IInstruction> {
        List<InsnType> insns = new ArrayList<InsnType>();

        private BBB() {
        }
    }
}

