/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.analyzer;

import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class ReferenceLocation {
    @SerId(value=1)
    private final Object location;

    private ReferenceLocation(long l2) {
        this.location = l2;
    }

    private ReferenceLocation(INativeMethodItem iNativeMethodItem) {
        if (iNativeMethodItem == null) {
            throw new NullPointerException();
        }
        this.location = iNativeMethodItem;
    }

    public static ReferenceLocation create(long l2) {
        return new ReferenceLocation(l2);
    }

    public static ReferenceLocation createFromExternalRoutine(INativeMethodItem iNativeMethodItem) {
        Assert.a(iNativeMethodItem.getData() == null);
        return new ReferenceLocation(iNativeMethodItem);
    }

    public boolean isInternalAddress() {
        return this.location instanceof Long;
    }

    public Long getInternalAddress() {
        if (this.location instanceof Long) {
            return (Long)this.location;
        }
        return null;
    }

    public boolean isExternalMethod() {
        return this.location instanceof INativeMethodItem && ((INativeMethodItem)this.location).getData() == null;
    }

    public INativeMethodItem getExternalMethod() {
        if (this.location instanceof INativeMethodItem) {
            return (INativeMethodItem)this.location;
        }
        return null;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.location == null ? 0 : this.location.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReferenceLocation referenceLocation = (ReferenceLocation)object;
        return !(this.location == null ? referenceLocation.location != null : !this.location.equals(referenceLocation.location));
    }

    public String toString() {
        if (this.location instanceof Long) {
            return Strings.ff("0x%X", (Long)this.location);
        }
        if (this.location instanceof INativeMethodItem) {
            return ((INativeMethodItem)this.location).getName();
        }
        return "" + this.location;
    }
}

