/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.analyzer;

import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.collect.ISegment;
import com.pnfsoftware.jeb.util.collect.SegmentMap;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.primitives.Longs;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import javax.annotation.concurrent.Immutable;

@Ser
public class MemoryRanges {
    @SerId(value=1)
    private SegmentMap<BigInteger, Range> map = new SegmentMap();
    @SerId(value=2)
    private BigInteger endaddr;
    @SerId(value=3)
    private boolean cacheValid;
    @SerId(value=4)
    private long cacheRangeBegin;
    @SerId(value=5)
    private long cacheRangeEnd;

    public MemoryRanges(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.endaddr = BigInteger.ONE.shiftLeft(n2);
    }

    public MemoryRanges() {
        this(64);
    }

    public MemoryRanges(IVirtualMemory iVirtualMemory) {
        this(iVirtualMemory.getSpaceBits());
        long l2 = iVirtualMemory.getPageSize();
        for (Long l3 : iVirtualMemory.getAllocatedPageBases()) {
            this.add(l3, l3 + l2);
        }
    }

    private void verifyRange(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger.compareTo(bigInteger2) >= 0) {
            throw new IllegalArgumentException(Strings.ff("Wrong range [%s,%s[ : begin address must be < than the end addres", bigInteger.toString(16), bigInteger2.toString(16)));
        }
        if (bigInteger2.compareTo(this.endaddr) >= 0) {
            throw new IllegalArgumentException(Strings.ff("Invalid end address %s: The end address must be stricly < %s", bigInteger2.toString(16), this.endaddr.toString(16)));
        }
    }

    private void updateCache() {
        if (this.count() == 1) {
            this.cacheRangeBegin = this.min();
            this.cacheRangeEnd = this.max();
            if (this.cacheRangeEnd > 0L) {
                this.cacheValid = true;
                return;
            }
        }
        this.cacheValid = false;
    }

    public void add(long l2, long l3) {
        ArrayList<Range> arrayList;
        BigInteger bigInteger = Longs.toUnsignedBigInteger(l2);
        BigInteger bigInteger2 = Longs.toUnsignedBigInteger(l3);
        this.verifyRange(bigInteger, bigInteger2);
        SortedMap<BigInteger, Range> sortedMap = this.map.getOverlappingSegmentsMap(bigInteger, true, bigInteger2, true);
        if (!sortedMap.isEmpty()) {
            arrayList = new ArrayList<Range>(sortedMap.values());
            Range range = (Range)arrayList.get(0);
            if (range.getBegin().compareTo(bigInteger) < 0) {
                bigInteger = range.getBegin();
            }
            if ((range = (Range)arrayList.get(arrayList.size() - 1)).getEnd().compareTo(bigInteger2) > 0) {
                bigInteger2 = range.getEnd();
            }
            for (BigInteger bigInteger3 : sortedMap.keySet()) {
                this.map.remove(bigInteger3);
            }
        }
        arrayList = new Range(bigInteger, bigInteger2);
        this.map.add((Range)((Object)arrayList));
        boolean bl = false;
        Object object = (Range)this.map.get(bigInteger2);
        if (object != null) {
            bigInteger2 = ((Range)object).getEnd();
            bl = true;
            this.map.remove(((Range)object).getBegin());
        }
        if ((object = this.map.getSegmentContaining(bigInteger.subtract(BigInteger.ONE))) != null) {
            bigInteger = ((Range)object).getBegin();
            bl = true;
            this.map.remove(((Range)object).getBegin());
        }
        if (bl) {
            this.map.remove(((Range)((Object)arrayList)).getBegin());
            this.map.add(new Range(bigInteger, bigInteger2));
        }
        this.updateCache();
    }

    public void remove(long l2, long l3) {
        BigInteger bigInteger = Longs.toUnsignedBigInteger(l2);
        BigInteger bigInteger2 = Longs.toUnsignedBigInteger(l3);
        this.verifyRange(bigInteger, bigInteger2);
        SortedMap<BigInteger, Range> sortedMap = this.map.getOverlappingSegmentsMap(bigInteger, true, bigInteger2, true);
        if (sortedMap.isEmpty()) {
            return;
        }
        Range range = null;
        Range range2 = null;
        ArrayList<Range> arrayList = new ArrayList<Range>(sortedMap.values());
        Range range3 = (Range)arrayList.get(0);
        if (range3.getBegin().compareTo(bigInteger) < 0) {
            range = new Range(range3.getBegin(), bigInteger);
        }
        if ((range3 = (Range)arrayList.get(arrayList.size() - 1)).getEnd().compareTo(bigInteger2) > 0) {
            range2 = new Range(bigInteger2, range3.getEnd());
        }
        for (BigInteger bigInteger3 : sortedMap.keySet()) {
            this.map.remove(bigInteger3);
        }
        if (range != null) {
            this.map.add(range);
        }
        if (range2 != null) {
            this.map.add(range2);
        }
        this.updateCache();
    }

    public void clear() {
        this.map.clear();
        this.cacheValid = false;
    }

    public Long min() {
        if (this.map.isEmpty()) {
            return null;
        }
        return ((BigInteger)this.map.firstKey()).longValue();
    }

    public Long max() {
        if (this.map.isEmpty()) {
            return null;
        }
        return ((Range)this.map.lastEntry().getValue()).getEnd().longValue();
    }

    public int count() {
        return this.map.size();
    }

    public List<Couple<Long, Long>> asList() {
        ArrayList<Couple<Long, Long>> arrayList = new ArrayList<Couple<Long, Long>>(this.map.size());
        for (Range range : this.map.values()) {
            arrayList.add(new Couple<Long, Long>(range.getBegin().longValue(), range.getEnd().longValue()));
        }
        return arrayList;
    }

    public boolean contains(long l2) {
        if (this.cacheValid && l2 >= 0L) {
            return l2 >= this.cacheRangeBegin && l2 < this.cacheRangeEnd;
        }
        BigInteger bigInteger = Longs.toUnsignedBigInteger(l2);
        return this.map.getSegmentContaining(bigInteger) != null;
    }

    public boolean intersects(long l2, long l3) {
        return !this.map.getOverlappingSegmentsMap(Longs.toUnsignedBigInteger(l2), true, Longs.toUnsignedBigInteger(l3), false).isEmpty();
    }

    public Long getLocalBegin(long l2) {
        BigInteger bigInteger = Longs.toUnsignedBigInteger(l2);
        Range range = this.map.getSegmentContaining(bigInteger);
        return range == null ? null : Long.valueOf(range.getBegin().longValue());
    }

    public Long getLocalEnd(long l2) {
        BigInteger bigInteger = Longs.toUnsignedBigInteger(l2);
        Range range = this.map.getSegmentContaining(bigInteger);
        return range == null ? null : Long.valueOf(range.getEnd().longValue());
    }

    public Couple<Long, Long> getNextRange(long l2) {
        BigInteger bigInteger = Longs.toUnsignedBigInteger(l2);
        Range range = this.map.getSegmentAfter(bigInteger);
        return range == null ? null : new Couple<Long, Long>(range.getBegin().longValue(), range.getEnd().longValue());
    }

    public Couple<Long, Long> getPreviousRange(long l2) {
        BigInteger bigInteger = Longs.toUnsignedBigInteger(l2);
        Range range = this.map.getSegmentBefore(bigInteger);
        return range == null ? null : new Couple<Long, Long>(range.getBegin().longValue(), range.getEnd().longValue());
    }

    public Couple<Long, Long> getLocalRange(long l2) {
        BigInteger bigInteger = Longs.toUnsignedBigInteger(l2);
        Range range = this.map.getSegmentContaining(bigInteger);
        return range == null ? null : new Couple<Long, Long>(range.getBegin().longValue(), range.getEnd().longValue());
    }

    public long spanSize() {
        if (this.map.isEmpty()) {
            return 0L;
        }
        BigInteger bigInteger = ((Range)this.map.lastEntry().getValue()).getEnd().subtract((BigInteger)this.map.firstKey());
        return bigInteger.longValue();
    }

    public long aggregatedRangesSize() {
        BigInteger bigInteger = BigInteger.ZERO;
        for (Range range : this.map.values()) {
            BigInteger bigInteger2 = range.getEnd().subtract(range.getBegin());
            bigInteger = bigInteger.add(bigInteger2);
        }
        return bigInteger.longValue();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.count() + " ranges: ");
        int n2 = 0;
        for (Range range : this.map.values()) {
            if (n2 >= 1) {
                stringBuilder.append(", ");
            }
            Strings.ff(stringBuilder, "%X-%X", range.getBegin().longValue(), range.getEnd().longValue());
            ++n2;
        }
        return stringBuilder.toString();
    }

    @Ser
    @Immutable
    public static class Range
    implements ISegment<BigInteger> {
        @SerId(value=1)
        BigInteger begin;
        @SerId(value=2)
        BigInteger end;

        Range(BigInteger bigInteger, BigInteger bigInteger2) {
            Assert.a(bigInteger.compareTo(bigInteger2) < 0);
            this.begin = bigInteger;
            this.end = bigInteger2;
        }

        @Override
        public BigInteger getBegin() {
            return this.begin;
        }

        @Override
        public BigInteger getEnd() {
            return this.end;
        }
    }
}

