/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.analyzer;

import com.pnfsoftware.jeb.core.units.code.CodePointer;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.BranchTarget;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import javax.annotation.concurrent.Immutable;

@Ser
@Immutable
public class CallGraphVertex
extends BranchTarget {
    @SerId(value=1)
    private long dereferencedAddress = -1L;

    private CallGraphVertex(CodePointer codePointer) {
        super(codePointer);
    }

    public static CallGraphVertex buildFromInternalTarget(CodePointer codePointer) {
        return new CallGraphVertex(codePointer);
    }

    private CallGraphVertex(INativeMethodItem iNativeMethodItem) {
        super(iNativeMethodItem);
    }

    public static CallGraphVertex buildFromExternalTarget(INativeMethodItem iNativeMethodItem) {
        Assert.a(iNativeMethodItem.getData() == null, "Only external routines can be given to this constructor");
        return new CallGraphVertex(iNativeMethodItem);
    }

    private CallGraphVertex(long l2) {
        this.dereferencedAddress = l2;
    }

    public static CallGraphVertex buildFromUnresolvedTarget(long l2) {
        return new CallGraphVertex(l2);
    }

    public boolean isResolved() {
        return this.dereferencedAddress == -1L;
    }

    public long getDereferencedAddress() {
        return this.dereferencedAddress;
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 31 * n2 + (int)(this.dereferencedAddress ^ this.dereferencedAddress >>> 32);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CallGraphVertex callGraphVertex = (CallGraphVertex)object;
        return this.dereferencedAddress == callGraphVertex.dereferencedAddress;
    }
}

