/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.analyzer;

import com.pnfsoftware.jeb.core.units.code.CodePointer;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IBranchTarget;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import javax.annotation.concurrent.Immutable;

@Ser
@Immutable
public class BranchTarget
implements IBranchTarget {
    @SerId(value=1)
    private CodePointer codeptr;
    @SerId(value=2)
    private INativeMethodItem routine;

    public BranchTarget() {
    }

    public BranchTarget(CodePointer codePointer) {
        if (codePointer == null) {
            throw new NullPointerException("Null Entry Point");
        }
        if (codePointer.isUnknownAddress()) {
            throw new IllegalArgumentException("Entry point is an unknown address");
        }
        this.codeptr = codePointer;
    }

    public BranchTarget(INativeMethodItem iNativeMethodItem) {
        if (iNativeMethodItem == null) {
            throw new NullPointerException();
        }
        if (iNativeMethodItem.getData() != null) {
            this.codeptr = CodePointer.createFrom(iNativeMethodItem);
        }
        this.routine = iNativeMethodItem;
    }

    @Override
    public boolean isInternal() {
        return this.codeptr != null;
    }

    @Override
    public CodePointer getInternalAddress() {
        return this.codeptr;
    }

    @Override
    public INativeMethodItem getRoutine() {
        return this.routine;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.routine == null ? 0 : this.routine.hashCode());
        n2 = 31 * n2 + (this.codeptr == null ? 0 : this.codeptr.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BranchTarget branchTarget = (BranchTarget)object;
        if (this.routine != branchTarget.routine) {
            return false;
        }
        return !(this.codeptr == null ? branchTarget.codeptr != null : !this.codeptr.equals(branchTarget.codeptr));
    }

    public String toString() {
        if (this.routine != null) {
            return this.routine.getAddress();
        }
        return this.codeptr.toString();
    }
}

