/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.analyzer;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.CodePointer;
import com.pnfsoftware.jeb.core.units.code.IBasicBlockSkeleton;
import com.pnfsoftware.jeb.core.units.code.IFlowInformation;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.Pointer;
import com.pnfsoftware.jeb.core.units.code.PointerLocation;
import com.pnfsoftware.jeb.core.units.code.asm.ChainedOperationResult;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.BinaryPatternVerifier;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.CodeAnalyzerUtil;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IBinaryPattern;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeAnalyzer;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeAnalyzerExtension;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.SwitchInformation;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.NativeDecompilationStage;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeInstructionItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrimitiveSizes;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.core.units.codeobject.CompilerType;
import com.pnfsoftware.jeb.core.units.codeobject.SubsystemType;
import com.pnfsoftware.jeb.util.collect.ISegmentMap;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.pnfsoftware.jebglobal.aab;
import com.pnfsoftware.jebglobal.vS;
import java.util.List;

@Ser
public abstract class AbstractAnalyzerExtension<InsnType extends IInstruction>
implements INativeCodeAnalyzerExtension<InsnType> {
    @SerId(value=1)
    protected INativeCodeAnalyzer<InsnType> gca;
    @SerTransient
    protected BinaryPatternVerifier prologueVerifier;
    @SerTransient
    protected BinaryPatternVerifier paddingVerifier;

    @Override
    public void initialize(INativeCodeAnalyzer<InsnType> iNativeCodeAnalyzer) {
        if (iNativeCodeAnalyzer == null) {
            throw new NullPointerException();
        }
        if (this.gca != null && this.gca != iNativeCodeAnalyzer) {
            throw new IllegalStateException();
        }
        this.gca = iNativeCodeAnalyzer;
        this.prologueVerifier = new BinaryPatternVerifier();
        this.initializeProloguePatterns(this.prologueVerifier);
        this.paddingVerifier = new BinaryPatternVerifier();
        this.initializePaddingPatterns(this.paddingVerifier);
    }

    @Override
    public INativeCodeUnit<InsnType> getUnit() {
        return ((aab)this.gca).Rs().Rs();
    }

    protected void initializeProloguePatterns(BinaryPatternVerifier binaryPatternVerifier) {
    }

    @Override
    public IPrimitiveSizes getPrimitiveSizes(SubsystemType subsystemType, CompilerType compilerType) {
        return null;
    }

    @Override
    public void typeManagerInitialized(ITypeManager iTypeManager) {
    }

    @Override
    public ChainedOperationResult<Boolean> preprocessImage(int n2) {
        return ChainedOperationResult.FALSE_CONTINUE;
    }

    @Override
    public ChainedOperationResult<Boolean> postprocessImage(int n2) {
        return ChainedOperationResult.FALSE_CONTINUE;
    }

    @Override
    public ChainedOperationResult<Boolean> sigMatchingPostProcess(int n2) {
        return ChainedOperationResult.FALSE_CONTINUE;
    }

    @Override
    public ChainedOperationResult<CodePointer> getPrologueLooking(long l2, long l3) {
        IBinaryPattern iBinaryPattern = CodeAnalyzerUtil.checkBinaryPattern(this.gca, this.prologueVerifier, l2, l3);
        if (iBinaryPattern != null) {
            return new ChainedOperationResult<CodePointer>(new CodePointer(l2, iBinaryPattern.getProcessorMode()));
        }
        return ChainedOperationResult.ignore();
    }

    @Override
    public ChainedOperationResult<Boolean> verifyGapRoutineCandidate(long l2) {
        return ChainedOperationResult.TRUE_CONTINUE;
    }

    protected void initializePaddingPatterns(BinaryPatternVerifier binaryPatternVerifier) {
    }

    @Override
    public ChainedOperationResult<Long> getPossiblePaddingSize(long l2, long l3) {
        long l4;
        vS vS2;
        IBinaryPattern iBinaryPattern = CodeAnalyzerUtil.checkBinaryPattern(this.gca, this.paddingVerifier, l2, l3);
        if (iBinaryPattern == null) {
            return ChainedOperationResult.ZEROL_CONTINUE;
        }
        ISegmentMap<Long, vS> iSegmentMap = ((aab)this.gca).mm();
        boolean bl = false;
        if (iSegmentMap != null && (vS2 = iSegmentMap.getSegmentContaining(l2)) != null && (l4 = vS2.ce()) != 0L && l4 != 1L) {
            bl = true;
            if (l2 % l4 != 0L) {
                return new ChainedOperationResult<Long>((long)iBinaryPattern.getBinary().length & 0xFFFFFFFFL);
            }
        }
        if (!bl) {
            return new ChainedOperationResult<Long>((long)iBinaryPattern.getBinary().length & 0xFFFFFFFFL);
        }
        return ChainedOperationResult.ZEROL_CONTINUE;
    }

    @Override
    public ChainedOperationResult<List<CodePointer>> getProbableEntryPoints(long l2, long l3) {
        return ChainedOperationResult.ignore();
    }

    @Override
    public ChainedOperationResult<? extends Pointer> getTrampolineTarget(CFG<InsnType> cFG) {
        return ChainedOperationResult.continue_();
    }

    @Override
    public ChainedOperationResult<Integer> determineRoutineStackPointerDelta(CFG<InsnType> cFG) {
        return ChainedOperationResult.continue_();
    }

    @Override
    public ChainedOperationResult<Boolean> determinePotentialPointers(long l2, InsnType InsnType, List<Pointer> list) {
        return ChainedOperationResult.FALSE_CONTINUE;
    }

    @Override
    public ChainedOperationResult<Boolean> determinePotentialPointersInProtoBlock(IBasicBlockSkeleton<InsnType> iBasicBlockSkeleton, List<PointerLocation> list) {
        return ChainedOperationResult.FALSE_CONTINUE;
    }

    @Override
    public ChainedOperationResult<Boolean> shouldForceRoutineEnd(long l2, InsnType InsnType) {
        return ChainedOperationResult.FALSE_CONTINUE;
    }

    @Override
    public ChainedOperationResult<Boolean> isNonReturningRoutine(INativeMethodItem iNativeMethodItem) {
        return ChainedOperationResult.ignore();
    }

    @Override
    public ChainedOperationResult<Boolean> isCandidateSwitchDispatcher(long l2, InsnType InsnType, IBasicBlockSkeleton<InsnType> iBasicBlockSkeleton) {
        return ChainedOperationResult.FALSE_CONTINUE;
    }

    @Override
    public ChainedOperationResult<SwitchInformation> determineSwitchInformation(long l2, IBasicBlockSkeleton<InsnType> iBasicBlockSkeleton, List<IBasicBlockSkeleton<InsnType>> list) {
        return ChainedOperationResult.continue_();
    }

    @Override
    public ChainedOperationResult<IFlowInformation> getPreferredBreakingFlow(long l2, InsnType InsnType) {
        return ChainedOperationResult.continue_();
    }

    @Override
    public ChainedOperationResult<NativeDecompilationStage> getPreferredAdvancedAnalysisStage(INativeMethodItem iNativeMethodItem) {
        return new ChainedOperationResult<NativeDecompilationStage>(NativeDecompilationStage.SIMULATION, ChainedOperationResult.ContinuationStatus.CONTINUE);
    }

    @Override
    public ChainedOperationResult<Boolean> customizeInstructionItem(INativeInstructionItem iNativeInstructionItem) {
        return ChainedOperationResult.FALSE_CONTINUE;
    }
}

