/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm;

import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.InstructionCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.MethodCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.NativeCoordinates;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.CallGraphVertex;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.ICallGraph;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.util.collect.MultiMap;
import com.pnfsoftware.jeb.util.collect.WeakIdentityHashMap;
import com.pnfsoftware.jeb.util.collect.WeakValueMap;
import com.pnfsoftware.jeb.util.graph.Digraph;
import com.pnfsoftware.jeb.util.graph.IAddressableDigraphBuilder;
import java.util.Iterator;
import java.util.List;

public class NativeCallgraphBuilder
implements IAddressableDigraphBuilder {
    private INativeCodeUnit<IInstruction> unit;
    private Digraph model;
    private WeakValueMap<Integer, INativeMethodItem> vertexIdToMethodObject;
    private WeakIdentityHashMap<INativeMethodItem, Integer> methodObjectToVertexId;

    public NativeCallgraphBuilder(INativeCodeUnit<IInstruction> iNativeCodeUnit) {
        this.unit = iNativeCodeUnit;
    }

    @Override
    public Digraph buildModel() {
        List<INativeMethodItem> list = this.unit.getInternalMethods();
        ICallGraph iCallGraph = this.unit.getCodeModel().getCallGraphManager().getGlobalCallGraph();
        MultiMap<Integer, Integer> multiMap = new MultiMap<Integer, Integer>();
        for (INativeMethodItem iterator2 : list) {
            List<CallGraphVertex> list2 = iCallGraph.getCallees(iterator2, false);
            for (CallGraphVertex callGraphVertex : list2) {
                if (!callGraphVertex.isInternal()) continue;
                int n2 = list.indexOf(iterator2);
                INativeMethodItem iNativeMethodItem = this.unit.getInternalMethod(callGraphVertex.getInternalAddress().getAddress(), true);
                if (iNativeMethodItem == null) continue;
                int n3 = list.indexOf(iNativeMethodItem);
                if (multiMap.getSafe(n2).contains(n3)) continue;
                multiMap.put(n2, n3);
            }
        }
        this.model = new Digraph();
        this.vertexIdToMethodObject = new WeakValueMap();
        this.methodObjectToVertexId = new WeakIdentityHashMap();
        int n4 = 0;
        for (INativeMethodItem iNativeMethodItem : list) {
            int n5 = iNativeMethodItem.getData().getCFG().getInstructionCount();
            this.model.v(n4, Double.valueOf(n5), iNativeMethodItem.getName(true));
            this.vertexIdToMethodObject.put(n4, iNativeMethodItem);
            this.methodObjectToVertexId.put(iNativeMethodItem, n4);
            ++n4;
        }
        Iterator iterator = multiMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n6 = (Integer)iterator.next();
            Iterator iterator2 = multiMap.getSafe(n6).iterator();
            while (iterator2.hasNext()) {
                int n7 = (Integer)iterator2.next();
                this.model.e(n6, n7);
            }
        }
        return this.model;
    }

    @Override
    public String getAddressForVertexId(int n2) {
        INativeMethodItem iNativeMethodItem;
        INativeMethodItem iNativeMethodItem2 = iNativeMethodItem = this.vertexIdToMethodObject == null ? null : this.vertexIdToMethodObject.get(n2);
        if (iNativeMethodItem == null) {
            return null;
        }
        return iNativeMethodItem.getAddress();
    }

    @Override
    public Integer getVertexIdForAddress(String string) {
        INativeMethodItem iNativeMethodItem;
        ICodeCoordinates iCodeCoordinates = this.unit.getCodeCoordinatesFromAddress(string);
        if (iCodeCoordinates instanceof MethodCoordinates) {
            int n2 = ((MethodCoordinates)iCodeCoordinates).getMethodId();
            iNativeMethodItem = this.unit.getMethodByIndex(n2);
        } else if (iCodeCoordinates instanceof InstructionCoordinates) {
            int n3 = ((InstructionCoordinates)iCodeCoordinates).getMethodId();
            iNativeMethodItem = this.unit.getMethodByIndex(n3);
        } else if (iCodeCoordinates instanceof NativeCoordinates) {
            long l2 = ((NativeCoordinates)iCodeCoordinates).getAddress();
            iNativeMethodItem = this.unit.getInternalMethod(l2, false);
        } else {
            return null;
        }
        if (iNativeMethodItem == null) {
            return null;
        }
        return this.methodObjectToVertexId.get(iNativeMethodItem);
    }
}

