/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm;

import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IInstructionOperandGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterBank;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterBankService;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jebglobal.cql;
import java.util.HashMap;
import java.util.Map;

public class LinuxSyscallResolver {
    private static Map<Integer, LinuxSyscallResolver> instances = new HashMap<Integer, LinuxSyscallResolver>();
    private ProcessorType procType;
    private Map<Integer, String> map = new HashMap<Integer, String>();
    private static Map<Integer, String> map_X86 = new HashMap<Integer, String>();
    private static Map<Integer, String> map_X86_64;
    private static Map<Integer, String> map_ARM;
    private static Map<Integer, String> map_ARM64;
    private static Map<Integer, String> map_32;
    private static Map<Integer, String> map_64;

    public static synchronized LinuxSyscallResolver getInstance(ProcessorType processorType) {
        LinuxSyscallResolver linuxSyscallResolver = instances.get(processorType.id());
        if (linuxSyscallResolver == null) {
            if (processorType == ProcessorType.X86) {
                linuxSyscallResolver = new LinuxSyscallResolver(processorType, map_X86);
            } else if (processorType == ProcessorType.X86_64) {
                linuxSyscallResolver = new LinuxSyscallResolver(processorType, map_X86_64);
            } else if (processorType == ProcessorType.ARM) {
                linuxSyscallResolver = new LinuxSyscallResolver(processorType, map_ARM);
            } else if (processorType == ProcessorType.ARM64) {
                linuxSyscallResolver = new LinuxSyscallResolver(processorType, map_ARM64);
            } else {
                return null;
            }
            instances.put(processorType.id(), linuxSyscallResolver);
        }
        return linuxSyscallResolver;
    }

    private LinuxSyscallResolver(ProcessorType processorType, Map<Integer, String> map) {
        this.procType = processorType;
        this.map = map;
        map.putAll(map_32);
        map.putAll(map_64);
    }

    public boolean isSyscall(IInstruction iInstruction) {
        if (this.procType.isIntel() && ((cql)iInstruction).ce() == 205 && ((IInstructionOperandGeneric)iInstruction.getOperand(0)).isImmediate() && (((IInstructionOperandGeneric)iInstruction.getOperand(0)).getOperandValue() & 0xFFL) == 128L) {
            return true;
        }
        if (this.procType == ProcessorType.X86_64) {
            return iInstruction.getMnemonic().equalsIgnoreCase("syscall");
        }
        if (this.procType.isARM()) {
            return iInstruction.getMnemonic().equalsIgnoreCase("svc") && ((IInstructionOperandGeneric)iInstruction.getOperand(0)).isImmediate() && ((IInstructionOperandGeneric)iInstruction.getOperand(0)).getOperandValue() == 0L;
        }
        return false;
    }

    public long getSyscallRegisterId(IInstruction iInstruction) {
        IRegisterBank iRegisterBank = RegisterBankService.getInstance().get(this.procType);
        if (this.procType.isIntel()) {
            return iRegisterBank.getDescriptionEntryByName(iInstruction.getMnemonic().equalsIgnoreCase("syscall") ? "rax" : "eax").getId();
        }
        if (this.procType.isARM()) {
            return iRegisterBank.getDescriptionEntryByName(this.procType.is64Bit() ? "x8" : "r7").getId();
        }
        return -1L;
    }

    public String getName(int n2) {
        return this.map.get(n2);
    }

    public IPrototypeItem getPrototype(int n2, ITypeManager iTypeManager) {
        INativeMethodItem iNativeMethodItem = this.getRoutine(n2, iTypeManager);
        if (iNativeMethodItem == null) {
            return null;
        }
        return iNativeMethodItem.getPrototype();
    }

    public INativeMethodItem getRoutine(int n2, ITypeManager iTypeManager) {
        String string = this.getName(n2);
        if (string == null) {
            return null;
        }
        INativeMethodItem iNativeMethodItem = iTypeManager.getTypeLibraryService().findRoutineByName(string, this.procType);
        return iNativeMethodItem;
    }

    static {
        map_X86.put(0, "restart_syscall");
        map_X86.put(1, "exit");
        map_X86.put(2, "fork");
        map_X86.put(3, "read");
        map_X86.put(4, "write");
        map_X86.put(5, "open");
        map_X86.put(6, "close");
        map_X86.put(7, "waitpid");
        map_X86.put(8, "creat");
        map_X86.put(9, "link");
        map_X86.put(10, "unlink");
        map_X86.put(11, "execve");
        map_X86.put(12, "chdir");
        map_X86.put(13, "time");
        map_X86.put(14, "mknod");
        map_X86.put(15, "chmod");
        map_X86.put(16, "lchown");
        map_X86.put(17, "break");
        map_X86.put(18, "oldstat");
        map_X86.put(19, "lseek");
        map_X86.put(20, "getpid");
        map_X86.put(21, "mount");
        map_X86.put(22, "umount");
        map_X86.put(23, "setuid");
        map_X86.put(24, "getuid");
        map_X86.put(25, "stime");
        map_X86.put(26, "ptrace");
        map_X86.put(27, "alarm");
        map_X86.put(28, "oldfstat");
        map_X86.put(29, "pause");
        map_X86.put(30, "utime");
        map_X86.put(31, "stty");
        map_X86.put(32, "gtty");
        map_X86.put(33, "access");
        map_X86.put(34, "nice");
        map_X86.put(35, "ftime");
        map_X86.put(36, "sync");
        map_X86.put(37, "kill");
        map_X86.put(38, "rename");
        map_X86.put(39, "mkdir");
        map_X86.put(40, "rmdir");
        map_X86.put(41, "dup");
        map_X86.put(42, "pipe");
        map_X86.put(43, "times");
        map_X86.put(44, "prof");
        map_X86.put(45, "brk");
        map_X86.put(46, "setgid");
        map_X86.put(47, "getgid");
        map_X86.put(48, "signal");
        map_X86.put(49, "geteuid");
        map_X86.put(50, "getegid");
        map_X86.put(51, "acct");
        map_X86.put(52, "umount2");
        map_X86.put(53, "lock");
        map_X86.put(54, "ioctl");
        map_X86.put(55, "fcntl");
        map_X86.put(56, "mpx");
        map_X86.put(57, "setpgid");
        map_X86.put(58, "ulimit");
        map_X86.put(59, "oldolduname");
        map_X86.put(60, "umask");
        map_X86.put(61, "chroot");
        map_X86.put(62, "ustat");
        map_X86.put(63, "dup2");
        map_X86.put(64, "getppid");
        map_X86.put(65, "getpgrp");
        map_X86.put(66, "setsid");
        map_X86.put(67, "sigaction");
        map_X86.put(68, "sgetmask");
        map_X86.put(69, "ssetmask");
        map_X86.put(70, "setreuid");
        map_X86.put(71, "setregid");
        map_X86.put(72, "sigsuspend");
        map_X86.put(73, "sigpending");
        map_X86.put(74, "sethostname");
        map_X86.put(75, "setrlimit");
        map_X86.put(76, "getrlimit");
        map_X86.put(77, "getrusage");
        map_X86.put(78, "gettimeofday");
        map_X86.put(79, "settimeofday");
        map_X86.put(80, "getgroups");
        map_X86.put(81, "setgroups");
        map_X86.put(82, "select");
        map_X86.put(83, "symlink");
        map_X86.put(84, "oldlstat");
        map_X86.put(85, "readlink");
        map_X86.put(86, "uselib");
        map_X86.put(87, "swapon");
        map_X86.put(88, "reboot");
        map_X86.put(89, "readdir");
        map_X86.put(90, "mmap");
        map_X86.put(91, "munmap");
        map_X86.put(92, "truncate");
        map_X86.put(93, "ftruncate");
        map_X86.put(94, "fchmod");
        map_X86.put(95, "fchown");
        map_X86.put(96, "getpriority");
        map_X86.put(97, "setpriority");
        map_X86.put(98, "profil");
        map_X86.put(99, "statfs");
        map_X86.put(100, "fstatfs");
        map_X86.put(101, "ioperm");
        map_X86.put(102, "socketcall");
        map_X86.put(103, "syslog");
        map_X86.put(104, "setitimer");
        map_X86.put(105, "getitimer");
        map_X86.put(106, "stat");
        map_X86.put(107, "lstat");
        map_X86.put(108, "fstat");
        map_X86.put(109, "olduname");
        map_X86.put(110, "iopl");
        map_X86.put(111, "vhangup");
        map_X86.put(112, "idle");
        map_X86.put(113, "vm86old");
        map_X86.put(114, "wait4");
        map_X86.put(115, "swapoff");
        map_X86.put(116, "sysinfo");
        map_X86.put(117, "ipc");
        map_X86.put(118, "fsync");
        map_X86.put(119, "sigreturn");
        map_X86.put(120, "clone");
        map_X86.put(121, "setdomainname");
        map_X86.put(122, "uname");
        map_X86.put(123, "modify_ldt");
        map_X86.put(124, "adjtimex");
        map_X86.put(125, "mprotect");
        map_X86.put(126, "sigprocmask");
        map_X86.put(127, "create_module");
        map_X86.put(128, "init_module");
        map_X86.put(129, "delete_module");
        map_X86.put(130, "get_kernel_syms");
        map_X86.put(131, "quotactl");
        map_X86.put(132, "getpgid");
        map_X86.put(133, "fchdir");
        map_X86.put(134, "bdflush");
        map_X86.put(135, "sysfs");
        map_X86.put(136, "personality");
        map_X86.put(137, "afs_syscall");
        map_X86.put(138, "setfsuid");
        map_X86.put(139, "setfsgid");
        map_X86.put(140, "_llseek");
        map_X86.put(141, "getdents");
        map_X86.put(142, "_newselect");
        map_X86.put(143, "flock");
        map_X86.put(144, "msync");
        map_X86.put(145, "readv");
        map_X86.put(146, "writev");
        map_X86.put(147, "getsid");
        map_X86.put(148, "fdatasync");
        map_X86.put(149, "_sysctl");
        map_X86.put(150, "mlock");
        map_X86.put(151, "munlock");
        map_X86.put(152, "mlockall");
        map_X86.put(153, "munlockall");
        map_X86.put(154, "sched_setparam");
        map_X86.put(155, "sched_getparam");
        map_X86.put(156, "sched_setscheduler");
        map_X86.put(157, "sched_getscheduler");
        map_X86.put(158, "sched_yield");
        map_X86.put(159, "sched_get_priority_max");
        map_X86.put(160, "sched_get_priority_min");
        map_X86.put(161, "sched_rr_get_interval");
        map_X86.put(162, "nanosleep");
        map_X86.put(163, "mremap");
        map_X86.put(164, "setresuid");
        map_X86.put(165, "getresuid");
        map_X86.put(166, "vm86");
        map_X86.put(167, "query_module");
        map_X86.put(168, "poll");
        map_X86.put(169, "nfsservctl");
        map_X86.put(170, "setresgid");
        map_X86.put(171, "getresgid");
        map_X86.put(172, "prctl");
        map_X86.put(173, "rt_sigreturn");
        map_X86.put(174, "rt_sigaction");
        map_X86.put(175, "rt_sigprocmask");
        map_X86.put(176, "rt_sigpending");
        map_X86.put(177, "rt_sigtimedwait");
        map_X86.put(178, "rt_sigqueueinfo");
        map_X86.put(179, "rt_sigsuspend");
        map_X86.put(180, "pread64");
        map_X86.put(181, "pwrite64");
        map_X86.put(182, "chown");
        map_X86.put(183, "getcwd");
        map_X86.put(184, "capget");
        map_X86.put(185, "capset");
        map_X86.put(186, "sigaltstack");
        map_X86.put(187, "sendfile");
        map_X86.put(188, "getpmsg");
        map_X86.put(189, "putpmsg");
        map_X86.put(190, "vfork");
        map_X86.put(191, "ugetrlimit");
        map_X86.put(192, "mmap2");
        map_X86.put(193, "truncate64");
        map_X86.put(194, "ftruncate64");
        map_X86.put(195, "stat64");
        map_X86.put(196, "lstat64");
        map_X86.put(197, "fstat64");
        map_X86.put(198, "lchown32");
        map_X86.put(199, "getuid32");
        map_X86.put(200, "getgid32");
        map_X86.put(201, "geteuid32");
        map_X86.put(202, "getegid32");
        map_X86.put(203, "setreuid32");
        map_X86.put(204, "setregid32");
        map_X86.put(205, "getgroups32");
        map_X86.put(206, "setgroups32");
        map_X86.put(207, "fchown32");
        map_X86.put(208, "setresuid32");
        map_X86.put(209, "getresuid32");
        map_X86.put(210, "setresgid32");
        map_X86.put(211, "getresgid32");
        map_X86.put(212, "chown32");
        map_X86.put(213, "setuid32");
        map_X86.put(214, "setgid32");
        map_X86.put(215, "setfsuid32");
        map_X86.put(216, "setfsgid32");
        map_X86.put(217, "pivot_root");
        map_X86.put(218, "mincore");
        map_X86.put(219, "madvise");
        map_X86.put(220, "getdents64");
        map_X86.put(221, "fcntl64");
        map_X86.put(224, "gettid");
        map_X86.put(225, "readahead");
        map_X86.put(226, "setxattr");
        map_X86.put(227, "lsetxattr");
        map_X86.put(228, "fsetxattr");
        map_X86.put(229, "getxattr");
        map_X86.put(230, "lgetxattr");
        map_X86.put(231, "fgetxattr");
        map_X86.put(232, "listxattr");
        map_X86.put(233, "llistxattr");
        map_X86.put(234, "flistxattr");
        map_X86.put(235, "removexattr");
        map_X86.put(236, "lremovexattr");
        map_X86.put(237, "fremovexattr");
        map_X86.put(238, "tkill");
        map_X86.put(239, "sendfile64");
        map_X86.put(240, "futex");
        map_X86.put(241, "sched_setaffinity");
        map_X86.put(242, "sched_getaffinity");
        map_X86.put(243, "set_thread_area");
        map_X86.put(244, "get_thread_area");
        map_X86.put(245, "io_setup");
        map_X86.put(246, "io_destroy");
        map_X86.put(247, "io_getevents");
        map_X86.put(248, "io_submit");
        map_X86.put(249, "io_cancel");
        map_X86.put(250, "fadvise64");
        map_X86.put(252, "exit_group");
        map_X86.put(253, "lookup_dcookie");
        map_X86.put(254, "epoll_create");
        map_X86.put(255, "epoll_ctl");
        map_X86.put(256, "epoll_wait");
        map_X86.put(257, "remap_file_pages");
        map_X86.put(258, "set_tid_address");
        map_X86.put(259, "timer_create");
        map_X86.put(260, "timer_settime");
        map_X86.put(261, "timer_gettime");
        map_X86.put(262, "timer_getoverrun");
        map_X86.put(263, "timer_delete");
        map_X86.put(264, "clock_settime");
        map_X86.put(265, "clock_gettime");
        map_X86.put(266, "clock_getres");
        map_X86.put(267, "clock_nanosleep");
        map_X86.put(268, "statfs64");
        map_X86.put(269, "fstatfs64");
        map_X86.put(270, "tgkill");
        map_X86.put(271, "utimes");
        map_X86.put(272, "fadvise64_64");
        map_X86.put(273, "vserver");
        map_X86.put(274, "mbind");
        map_X86.put(275, "get_mempolicy");
        map_X86.put(276, "set_mempolicy");
        map_X86.put(277, "mq_open");
        map_X86.put(278, "mq_unlink");
        map_X86.put(279, "mq_timedsend");
        map_X86.put(280, "mq_timedreceive");
        map_X86.put(281, "mq_notify");
        map_X86.put(282, "mq_getsetattr");
        map_X86.put(283, "kexec_load");
        map_X86.put(284, "waitid");
        map_X86.put(286, "add_key");
        map_X86.put(287, "request_key");
        map_X86.put(288, "keyctl");
        map_X86.put(289, "ioprio_set");
        map_X86.put(290, "ioprio_get");
        map_X86.put(291, "inotify_init");
        map_X86.put(292, "inotify_add_watch");
        map_X86.put(293, "inotify_rm_watch");
        map_X86.put(294, "migrate_pages");
        map_X86.put(295, "openat");
        map_X86.put(296, "mkdirat");
        map_X86.put(297, "mknodat");
        map_X86.put(298, "fchownat");
        map_X86.put(299, "futimesat");
        map_X86.put(300, "fstatat64");
        map_X86.put(301, "unlinkat");
        map_X86.put(302, "renameat");
        map_X86.put(303, "linkat");
        map_X86.put(304, "symlinkat");
        map_X86.put(305, "readlinkat");
        map_X86.put(306, "fchmodat");
        map_X86.put(307, "faccessat");
        map_X86.put(308, "pselect6");
        map_X86.put(309, "ppoll");
        map_X86.put(310, "unshare");
        map_X86.put(311, "set_robust_list");
        map_X86.put(312, "get_robust_list");
        map_X86.put(313, "splice");
        map_X86.put(314, "sync_file_range");
        map_X86.put(315, "tee");
        map_X86.put(316, "vmsplice");
        map_X86.put(317, "move_pages");
        map_X86.put(318, "getcpu");
        map_X86.put(319, "epoll_pwait");
        map_X86.put(320, "utimensat");
        map_X86.put(321, "signalfd");
        map_X86.put(322, "timerfd_create");
        map_X86.put(323, "eventfd");
        map_X86.put(324, "fallocate");
        map_X86.put(325, "timerfd_settime");
        map_X86.put(326, "timerfd_gettime");
        map_X86.put(327, "signalfd4");
        map_X86.put(328, "eventfd2");
        map_X86.put(329, "epoll_create1");
        map_X86.put(330, "dup3");
        map_X86.put(331, "pipe2");
        map_X86.put(332, "inotify_init1");
        map_X86.put(333, "preadv");
        map_X86.put(334, "pwritev");
        map_X86.put(335, "rt_tgsigqueueinfo");
        map_X86.put(336, "perf_event_open");
        map_X86.put(337, "recvmmsg");
        map_X86.put(338, "fanotify_init");
        map_X86.put(339, "fanotify_mark");
        map_X86.put(340, "prlimit64");
        map_X86.put(341, "name_to_handle_at");
        map_X86.put(342, "open_by_handle_at");
        map_X86.put(343, "clock_adjtime");
        map_X86.put(344, "syncfs");
        map_X86.put(345, "sendmmsg");
        map_X86.put(346, "setns");
        map_X86.put(347, "process_vm_readv");
        map_X86.put(348, "process_vm_writev");
        map_X86.put(349, "kcmp");
        map_X86.put(350, "finit_module");
        map_X86.put(351, "sched_setattr");
        map_X86.put(352, "sched_getattr");
        map_X86.put(353, "renameat2");
        map_X86.put(354, "seccomp");
        map_X86.put(355, "getrandom");
        map_X86.put(356, "memfd_create");
        map_X86.put(357, "bpf");
        map_X86.put(358, "execveat");
        map_X86.put(359, "socket");
        map_X86.put(360, "socketpair");
        map_X86.put(361, "bind");
        map_X86.put(362, "connect");
        map_X86.put(363, "listen");
        map_X86.put(364, "accept4");
        map_X86.put(365, "getsockopt");
        map_X86.put(366, "setsockopt");
        map_X86.put(367, "getsockname");
        map_X86.put(368, "getpeername");
        map_X86.put(369, "sendto");
        map_X86.put(370, "sendmsg");
        map_X86.put(371, "recvfrom");
        map_X86.put(372, "recvmsg");
        map_X86.put(373, "shutdown");
        map_X86.put(374, "userfaultfd");
        map_X86.put(375, "membarrier");
        map_X86.put(376, "mlock2");
        map_X86.put(377, "copy_file_range");
        map_X86.put(378, "preadv2");
        map_X86.put(379, "pwritev2");
        map_X86.put(380, "pkey_mprotect");
        map_X86.put(381, "pkey_alloc");
        map_X86.put(382, "pkey_free");
        map_X86.put(383, "statx");
        map_X86.put(384, "arch_prctl");
        map_X86.put(385, "io_pgetevents");
        map_X86.put(386, "rseq");
        map_X86.put(393, "semget");
        map_X86.put(394, "semctl");
        map_X86.put(395, "shmget");
        map_X86.put(396, "shmctl");
        map_X86.put(397, "shmat");
        map_X86.put(398, "shmdt");
        map_X86.put(399, "msgget");
        map_X86.put(400, "msgsnd");
        map_X86.put(401, "msgrcv");
        map_X86.put(402, "msgctl");
        map_X86_64 = new HashMap<Integer, String>();
        map_X86_64.put(0, "read");
        map_X86_64.put(1, "write");
        map_X86_64.put(2, "open");
        map_X86_64.put(3, "close");
        map_X86_64.put(4, "stat");
        map_X86_64.put(5, "fstat");
        map_X86_64.put(6, "lstat");
        map_X86_64.put(7, "poll");
        map_X86_64.put(8, "lseek");
        map_X86_64.put(9, "mmap");
        map_X86_64.put(10, "mprotect");
        map_X86_64.put(11, "munmap");
        map_X86_64.put(12, "brk");
        map_X86_64.put(13, "rt_sigaction");
        map_X86_64.put(14, "rt_sigprocmask");
        map_X86_64.put(15, "rt_sigreturn");
        map_X86_64.put(16, "ioctl");
        map_X86_64.put(17, "pread64");
        map_X86_64.put(18, "pwrite64");
        map_X86_64.put(19, "readv");
        map_X86_64.put(20, "writev");
        map_X86_64.put(21, "access");
        map_X86_64.put(22, "pipe");
        map_X86_64.put(23, "select");
        map_X86_64.put(24, "sched_yield");
        map_X86_64.put(25, "mremap");
        map_X86_64.put(26, "msync");
        map_X86_64.put(27, "mincore");
        map_X86_64.put(28, "madvise");
        map_X86_64.put(29, "shmget");
        map_X86_64.put(30, "shmat");
        map_X86_64.put(31, "shmctl");
        map_X86_64.put(32, "dup");
        map_X86_64.put(33, "dup2");
        map_X86_64.put(34, "pause");
        map_X86_64.put(35, "nanosleep");
        map_X86_64.put(36, "getitimer");
        map_X86_64.put(37, "alarm");
        map_X86_64.put(38, "setitimer");
        map_X86_64.put(39, "getpid");
        map_X86_64.put(40, "sendfile");
        map_X86_64.put(41, "socket");
        map_X86_64.put(42, "connect");
        map_X86_64.put(43, "accept");
        map_X86_64.put(44, "sendto");
        map_X86_64.put(45, "recvfrom");
        map_X86_64.put(46, "sendmsg");
        map_X86_64.put(47, "recvmsg");
        map_X86_64.put(48, "shutdown");
        map_X86_64.put(49, "bind");
        map_X86_64.put(50, "listen");
        map_X86_64.put(51, "getsockname");
        map_X86_64.put(52, "getpeername");
        map_X86_64.put(53, "socketpair");
        map_X86_64.put(54, "setsockopt");
        map_X86_64.put(55, "getsockopt");
        map_X86_64.put(56, "clone");
        map_X86_64.put(57, "fork");
        map_X86_64.put(58, "vfork");
        map_X86_64.put(59, "execve");
        map_X86_64.put(60, "exit");
        map_X86_64.put(61, "wait4");
        map_X86_64.put(62, "kill");
        map_X86_64.put(63, "uname");
        map_X86_64.put(64, "semget");
        map_X86_64.put(65, "semop");
        map_X86_64.put(66, "semctl");
        map_X86_64.put(67, "shmdt");
        map_X86_64.put(68, "msgget");
        map_X86_64.put(69, "msgsnd");
        map_X86_64.put(70, "msgrcv");
        map_X86_64.put(71, "msgctl");
        map_X86_64.put(72, "fcntl");
        map_X86_64.put(73, "flock");
        map_X86_64.put(74, "fsync");
        map_X86_64.put(75, "fdatasync");
        map_X86_64.put(76, "truncate");
        map_X86_64.put(77, "ftruncate");
        map_X86_64.put(78, "getdents");
        map_X86_64.put(79, "getcwd");
        map_X86_64.put(80, "chdir");
        map_X86_64.put(81, "fchdir");
        map_X86_64.put(82, "rename");
        map_X86_64.put(83, "mkdir");
        map_X86_64.put(84, "rmdir");
        map_X86_64.put(85, "creat");
        map_X86_64.put(86, "link");
        map_X86_64.put(87, "unlink");
        map_X86_64.put(88, "symlink");
        map_X86_64.put(89, "readlink");
        map_X86_64.put(90, "chmod");
        map_X86_64.put(91, "fchmod");
        map_X86_64.put(92, "chown");
        map_X86_64.put(93, "fchown");
        map_X86_64.put(94, "lchown");
        map_X86_64.put(95, "umask");
        map_X86_64.put(96, "gettimeofday");
        map_X86_64.put(97, "getrlimit");
        map_X86_64.put(98, "getrusage");
        map_X86_64.put(99, "sysinfo");
        map_X86_64.put(100, "times");
        map_X86_64.put(101, "ptrace");
        map_X86_64.put(102, "getuid");
        map_X86_64.put(103, "syslog");
        map_X86_64.put(104, "getgid");
        map_X86_64.put(105, "setuid");
        map_X86_64.put(106, "setgid");
        map_X86_64.put(107, "geteuid");
        map_X86_64.put(108, "getegid");
        map_X86_64.put(109, "setpgid");
        map_X86_64.put(110, "getppid");
        map_X86_64.put(111, "getpgrp");
        map_X86_64.put(112, "setsid");
        map_X86_64.put(113, "setreuid");
        map_X86_64.put(114, "setregid");
        map_X86_64.put(115, "getgroups");
        map_X86_64.put(116, "setgroups");
        map_X86_64.put(117, "setresuid");
        map_X86_64.put(118, "getresuid");
        map_X86_64.put(119, "setresgid");
        map_X86_64.put(120, "getresgid");
        map_X86_64.put(121, "getpgid");
        map_X86_64.put(122, "setfsuid");
        map_X86_64.put(123, "setfsgid");
        map_X86_64.put(124, "getsid");
        map_X86_64.put(125, "capget");
        map_X86_64.put(126, "capset");
        map_X86_64.put(127, "rt_sigpending");
        map_X86_64.put(128, "rt_sigtimedwait");
        map_X86_64.put(129, "rt_sigqueueinfo");
        map_X86_64.put(130, "rt_sigsuspend");
        map_X86_64.put(131, "sigaltstack");
        map_X86_64.put(132, "utime");
        map_X86_64.put(133, "mknod");
        map_X86_64.put(134, "uselib");
        map_X86_64.put(135, "personality");
        map_X86_64.put(136, "ustat");
        map_X86_64.put(137, "statfs");
        map_X86_64.put(138, "fstatfs");
        map_X86_64.put(139, "sysfs");
        map_X86_64.put(140, "getpriority");
        map_X86_64.put(141, "setpriority");
        map_X86_64.put(142, "sched_setparam");
        map_X86_64.put(143, "sched_getparam");
        map_X86_64.put(144, "sched_setscheduler");
        map_X86_64.put(145, "sched_getscheduler");
        map_X86_64.put(146, "sched_get_priority_max");
        map_X86_64.put(147, "sched_get_priority_min");
        map_X86_64.put(148, "sched_rr_get_interval");
        map_X86_64.put(149, "mlock");
        map_X86_64.put(150, "munlock");
        map_X86_64.put(151, "mlockall");
        map_X86_64.put(152, "munlockall");
        map_X86_64.put(153, "vhangup");
        map_X86_64.put(154, "modify_ldt");
        map_X86_64.put(155, "pivot_root");
        map_X86_64.put(156, "_sysctl");
        map_X86_64.put(157, "prctl");
        map_X86_64.put(158, "arch_prctl");
        map_X86_64.put(159, "adjtimex");
        map_X86_64.put(160, "setrlimit");
        map_X86_64.put(161, "chroot");
        map_X86_64.put(162, "sync");
        map_X86_64.put(163, "acct");
        map_X86_64.put(164, "settimeofday");
        map_X86_64.put(165, "mount");
        map_X86_64.put(166, "umount2");
        map_X86_64.put(167, "swapon");
        map_X86_64.put(168, "swapoff");
        map_X86_64.put(169, "reboot");
        map_X86_64.put(170, "sethostname");
        map_X86_64.put(171, "setdomainname");
        map_X86_64.put(172, "iopl");
        map_X86_64.put(173, "ioperm");
        map_X86_64.put(174, "create_module");
        map_X86_64.put(175, "init_module");
        map_X86_64.put(176, "delete_module");
        map_X86_64.put(177, "get_kernel_syms");
        map_X86_64.put(178, "query_module");
        map_X86_64.put(179, "quotactl");
        map_X86_64.put(180, "nfsservctl");
        map_X86_64.put(181, "getpmsg");
        map_X86_64.put(182, "putpmsg");
        map_X86_64.put(183, "afs_syscall");
        map_X86_64.put(184, "tuxcall");
        map_X86_64.put(185, "security");
        map_X86_64.put(186, "gettid");
        map_X86_64.put(187, "readahead");
        map_X86_64.put(188, "setxattr");
        map_X86_64.put(189, "lsetxattr");
        map_X86_64.put(190, "fsetxattr");
        map_X86_64.put(191, "getxattr");
        map_X86_64.put(192, "lgetxattr");
        map_X86_64.put(193, "fgetxattr");
        map_X86_64.put(194, "listxattr");
        map_X86_64.put(195, "llistxattr");
        map_X86_64.put(196, "flistxattr");
        map_X86_64.put(197, "removexattr");
        map_X86_64.put(198, "lremovexattr");
        map_X86_64.put(199, "fremovexattr");
        map_X86_64.put(200, "tkill");
        map_X86_64.put(201, "time");
        map_X86_64.put(202, "futex");
        map_X86_64.put(203, "sched_setaffinity");
        map_X86_64.put(204, "sched_getaffinity");
        map_X86_64.put(205, "set_thread_area");
        map_X86_64.put(206, "io_setup");
        map_X86_64.put(207, "io_destroy");
        map_X86_64.put(208, "io_getevents");
        map_X86_64.put(209, "io_submit");
        map_X86_64.put(210, "io_cancel");
        map_X86_64.put(211, "get_thread_area");
        map_X86_64.put(212, "lookup_dcookie");
        map_X86_64.put(213, "epoll_create");
        map_X86_64.put(214, "epoll_ctl_old");
        map_X86_64.put(215, "epoll_wait_old");
        map_X86_64.put(216, "remap_file_pages");
        map_X86_64.put(217, "getdents64");
        map_X86_64.put(218, "set_tid_address");
        map_X86_64.put(219, "restart_syscall");
        map_X86_64.put(220, "semtimedop");
        map_X86_64.put(221, "fadvise64");
        map_X86_64.put(222, "timer_create");
        map_X86_64.put(223, "timer_settime");
        map_X86_64.put(224, "timer_gettime");
        map_X86_64.put(225, "timer_getoverrun");
        map_X86_64.put(226, "timer_delete");
        map_X86_64.put(227, "clock_settime");
        map_X86_64.put(228, "clock_gettime");
        map_X86_64.put(229, "clock_getres");
        map_X86_64.put(230, "clock_nanosleep");
        map_X86_64.put(231, "exit_group");
        map_X86_64.put(232, "epoll_wait");
        map_X86_64.put(233, "epoll_ctl");
        map_X86_64.put(234, "tgkill");
        map_X86_64.put(235, "utimes");
        map_X86_64.put(236, "vserver");
        map_X86_64.put(237, "mbind");
        map_X86_64.put(238, "set_mempolicy");
        map_X86_64.put(239, "get_mempolicy");
        map_X86_64.put(240, "mq_open");
        map_X86_64.put(241, "mq_unlink");
        map_X86_64.put(242, "mq_timedsend");
        map_X86_64.put(243, "mq_timedreceive");
        map_X86_64.put(244, "mq_notify");
        map_X86_64.put(245, "mq_getsetattr");
        map_X86_64.put(246, "kexec_load");
        map_X86_64.put(247, "waitid");
        map_X86_64.put(248, "add_key");
        map_X86_64.put(249, "request_key");
        map_X86_64.put(250, "keyctl");
        map_X86_64.put(251, "ioprio_set");
        map_X86_64.put(252, "ioprio_get");
        map_X86_64.put(253, "inotify_init");
        map_X86_64.put(254, "inotify_add_watch");
        map_X86_64.put(255, "inotify_rm_watch");
        map_X86_64.put(256, "migrate_pages");
        map_X86_64.put(257, "openat");
        map_X86_64.put(258, "mkdirat");
        map_X86_64.put(259, "mknodat");
        map_X86_64.put(260, "fchownat");
        map_X86_64.put(261, "futimesat");
        map_X86_64.put(262, "fstatat64");
        map_X86_64.put(263, "unlinkat");
        map_X86_64.put(264, "renameat");
        map_X86_64.put(265, "linkat");
        map_X86_64.put(266, "symlinkat");
        map_X86_64.put(267, "readlinkat");
        map_X86_64.put(268, "fchmodat");
        map_X86_64.put(269, "faccessat");
        map_X86_64.put(270, "pselect6");
        map_X86_64.put(271, "ppoll");
        map_X86_64.put(272, "unshare");
        map_X86_64.put(273, "set_robust_list");
        map_X86_64.put(274, "get_robust_list");
        map_X86_64.put(275, "splice");
        map_X86_64.put(276, "tee");
        map_X86_64.put(277, "sync_file_range");
        map_X86_64.put(278, "vmsplice");
        map_X86_64.put(279, "move_pages");
        map_X86_64.put(280, "utimensat");
        map_X86_64.put(281, "epoll_pwait");
        map_X86_64.put(282, "signalfd");
        map_X86_64.put(283, "timerfd_create");
        map_X86_64.put(284, "eventfd");
        map_X86_64.put(285, "fallocate");
        map_X86_64.put(286, "timerfd_settime");
        map_X86_64.put(287, "timerfd_gettime");
        map_X86_64.put(288, "accept4");
        map_X86_64.put(289, "signalfd4");
        map_X86_64.put(290, "eventfd2");
        map_X86_64.put(291, "epoll_create1");
        map_X86_64.put(292, "dup3");
        map_X86_64.put(293, "pipe2");
        map_X86_64.put(294, "inotify_init1");
        map_X86_64.put(295, "preadv");
        map_X86_64.put(296, "pwritev");
        map_X86_64.put(297, "rt_tgsigqueueinfo");
        map_X86_64.put(298, "perf_event_open");
        map_X86_64.put(299, "recvmmsg");
        map_X86_64.put(300, "fanotify_init");
        map_X86_64.put(301, "fanotify_mark");
        map_X86_64.put(302, "prlimit64");
        map_X86_64.put(303, "name_to_handle_at");
        map_X86_64.put(304, "open_by_handle_at");
        map_X86_64.put(305, "clock_adjtime");
        map_X86_64.put(306, "syncfs");
        map_X86_64.put(307, "sendmmsg");
        map_X86_64.put(308, "setns");
        map_X86_64.put(309, "getcpu");
        map_X86_64.put(310, "process_vm_readv");
        map_X86_64.put(311, "process_vm_writev");
        map_X86_64.put(312, "kcmp");
        map_X86_64.put(313, "finit_module");
        map_X86_64.put(314, "sched_setattr");
        map_X86_64.put(315, "sched_getattr");
        map_X86_64.put(316, "renameat2");
        map_X86_64.put(317, "seccomp");
        map_X86_64.put(318, "getrandom");
        map_X86_64.put(319, "memfd_create");
        map_X86_64.put(320, "kexec_file_load");
        map_X86_64.put(321, "bpf");
        map_X86_64.put(322, "execveat");
        map_X86_64.put(323, "userfaultfd");
        map_X86_64.put(324, "membarrier");
        map_X86_64.put(325, "mlock2");
        map_X86_64.put(326, "copy_file_range");
        map_X86_64.put(327, "preadv2");
        map_X86_64.put(328, "pwritev2");
        map_X86_64.put(329, "pkey_mprotect");
        map_X86_64.put(330, "pkey_alloc");
        map_X86_64.put(331, "pkey_free");
        map_X86_64.put(332, "statx");
        map_X86_64.put(333, "io_pgetevents");
        map_X86_64.put(334, "rseq");
        map_ARM = new HashMap<Integer, String>();
        map_ARM.put(0, "restart_syscall");
        map_ARM.put(1, "exit");
        map_ARM.put(2, "fork");
        map_ARM.put(3, "read");
        map_ARM.put(4, "write");
        map_ARM.put(5, "open");
        map_ARM.put(6, "close");
        map_ARM.put(7, "waitpid");
        map_ARM.put(8, "creat");
        map_ARM.put(9, "link");
        map_ARM.put(10, "unlink");
        map_ARM.put(11, "execve");
        map_ARM.put(12, "chdir");
        map_ARM.put(13, "time");
        map_ARM.put(14, "mknod");
        map_ARM.put(15, "chmod");
        map_ARM.put(16, "lchown");
        map_ARM.put(17, "break");
        map_ARM.put(18, "oldstat");
        map_ARM.put(19, "lseek");
        map_ARM.put(20, "getpid");
        map_ARM.put(21, "mount");
        map_ARM.put(22, "umount");
        map_ARM.put(23, "setuid");
        map_ARM.put(24, "getuid");
        map_ARM.put(25, "stime");
        map_ARM.put(26, "ptrace");
        map_ARM.put(27, "alarm");
        map_ARM.put(28, "oldfstat");
        map_ARM.put(29, "pause");
        map_ARM.put(30, "utime");
        map_ARM.put(31, "stty");
        map_ARM.put(32, "gtty");
        map_ARM.put(33, "access");
        map_ARM.put(34, "nice");
        map_ARM.put(35, "ftime");
        map_ARM.put(36, "sync");
        map_ARM.put(37, "kill");
        map_ARM.put(38, "rename");
        map_ARM.put(39, "mkdir");
        map_ARM.put(40, "rmdir");
        map_ARM.put(41, "dup");
        map_ARM.put(42, "pipe");
        map_ARM.put(43, "times");
        map_ARM.put(44, "prof");
        map_ARM.put(45, "brk");
        map_ARM.put(46, "setgid");
        map_ARM.put(47, "getgid");
        map_ARM.put(48, "signal");
        map_ARM.put(49, "geteuid");
        map_ARM.put(50, "getegid");
        map_ARM.put(51, "acct");
        map_ARM.put(52, "umount2");
        map_ARM.put(53, "lock");
        map_ARM.put(54, "ioctl");
        map_ARM.put(55, "fcntl");
        map_ARM.put(56, "mpx");
        map_ARM.put(57, "setpgid");
        map_ARM.put(58, "ulimit");
        map_ARM.put(59, "oldolduname");
        map_ARM.put(60, "umask");
        map_ARM.put(61, "chroot");
        map_ARM.put(62, "ustat");
        map_ARM.put(63, "dup2");
        map_ARM.put(64, "getppid");
        map_ARM.put(65, "getpgrp");
        map_ARM.put(66, "setsid");
        map_ARM.put(67, "sigaction");
        map_ARM.put(68, "sgetmask");
        map_ARM.put(69, "ssetmask");
        map_ARM.put(70, "setreuid");
        map_ARM.put(71, "setregid");
        map_ARM.put(72, "sigsuspend");
        map_ARM.put(73, "sigpending");
        map_ARM.put(74, "sethostname");
        map_ARM.put(75, "setrlimit");
        map_ARM.put(76, "getrlimit");
        map_ARM.put(77, "getrusage");
        map_ARM.put(78, "gettimeofday");
        map_ARM.put(79, "settimeofday");
        map_ARM.put(80, "getgroups");
        map_ARM.put(81, "setgroups");
        map_ARM.put(82, "select");
        map_ARM.put(83, "symlink");
        map_ARM.put(84, "oldlstat");
        map_ARM.put(85, "readlink");
        map_ARM.put(86, "uselib");
        map_ARM.put(87, "swapon");
        map_ARM.put(88, "reboot");
        map_ARM.put(89, "readdir");
        map_ARM.put(90, "mmap");
        map_ARM.put(91, "munmap");
        map_ARM.put(92, "truncate");
        map_ARM.put(93, "ftruncate");
        map_ARM.put(94, "fchmod");
        map_ARM.put(95, "fchown");
        map_ARM.put(96, "getpriority");
        map_ARM.put(97, "setpriority");
        map_ARM.put(98, "profil");
        map_ARM.put(99, "statfs");
        map_ARM.put(100, "fstatfs");
        map_ARM.put(101, "ioperm");
        map_ARM.put(102, "socketcall");
        map_ARM.put(103, "syslog");
        map_ARM.put(104, "setitimer");
        map_ARM.put(105, "getitimer");
        map_ARM.put(106, "stat");
        map_ARM.put(107, "lstat");
        map_ARM.put(108, "fstat");
        map_ARM.put(109, "olduname");
        map_ARM.put(110, "iopl");
        map_ARM.put(111, "vhangup");
        map_ARM.put(112, "idle");
        map_ARM.put(113, "syscall");
        map_ARM.put(114, "wait4");
        map_ARM.put(115, "swapoff");
        map_ARM.put(116, "sysinfo");
        map_ARM.put(117, "ipc");
        map_ARM.put(118, "fsync");
        map_ARM.put(119, "sigreturn");
        map_ARM.put(120, "clone");
        map_ARM.put(121, "setdomainname");
        map_ARM.put(122, "uname");
        map_ARM.put(123, "modify_ldt");
        map_ARM.put(124, "adjtimex");
        map_ARM.put(125, "mprotect");
        map_ARM.put(126, "sigprocmask");
        map_ARM.put(127, "create_module");
        map_ARM.put(128, "init_module");
        map_ARM.put(129, "delete_module");
        map_ARM.put(130, "get_kernel_syms");
        map_ARM.put(131, "quotactl");
        map_ARM.put(132, "getpgid");
        map_ARM.put(133, "fchdir");
        map_ARM.put(134, "bdflush");
        map_ARM.put(135, "sysfs");
        map_ARM.put(136, "personality");
        map_ARM.put(137, "afs_syscall");
        map_ARM.put(138, "setfsuid");
        map_ARM.put(139, "setfsgid");
        map_ARM.put(140, "_llseek");
        map_ARM.put(141, "getdents");
        map_ARM.put(142, "_newselect");
        map_ARM.put(143, "flock");
        map_ARM.put(144, "msync");
        map_ARM.put(145, "readv");
        map_ARM.put(146, "writev");
        map_ARM.put(147, "getsid");
        map_ARM.put(148, "fdatasync");
        map_ARM.put(149, "_sysctl");
        map_ARM.put(150, "mlock");
        map_ARM.put(151, "munlock");
        map_ARM.put(152, "mlockall");
        map_ARM.put(153, "munlockall");
        map_ARM.put(154, "sched_setparam");
        map_ARM.put(155, "sched_getparam");
        map_ARM.put(156, "sched_setscheduler");
        map_ARM.put(157, "sched_getscheduler");
        map_ARM.put(158, "sched_yield");
        map_ARM.put(159, "sched_get_priority_max");
        map_ARM.put(160, "sched_get_priority_min");
        map_ARM.put(161, "sched_rr_get_interval");
        map_ARM.put(162, "nanosleep");
        map_ARM.put(163, "mremap");
        map_ARM.put(164, "setresuid");
        map_ARM.put(165, "getresuid");
        map_ARM.put(166, "vm86");
        map_ARM.put(167, "query_module");
        map_ARM.put(168, "poll");
        map_ARM.put(169, "nfsservctl");
        map_ARM.put(170, "setresgid");
        map_ARM.put(171, "getresgid");
        map_ARM.put(172, "prctl");
        map_ARM.put(173, "rt_sigreturn");
        map_ARM.put(174, "rt_sigaction");
        map_ARM.put(175, "rt_sigprocmask");
        map_ARM.put(176, "rt_sigpending");
        map_ARM.put(177, "rt_sigtimedwait");
        map_ARM.put(178, "rt_sigqueueinfo");
        map_ARM.put(179, "rt_sigsuspend");
        map_ARM.put(180, "pread64");
        map_ARM.put(181, "pwrite64");
        map_ARM.put(182, "chown");
        map_ARM.put(183, "getcwd");
        map_ARM.put(184, "capget");
        map_ARM.put(185, "capset");
        map_ARM.put(186, "sigaltstack");
        map_ARM.put(187, "sendfile");
        map_ARM.put(188, "getpmsg");
        map_ARM.put(189, "putpmsg");
        map_ARM.put(190, "vfork");
        map_ARM.put(191, "ugetrlimit");
        map_ARM.put(192, "mmap2");
        map_ARM.put(193, "truncate64");
        map_ARM.put(194, "ftruncate64");
        map_ARM.put(195, "stat64");
        map_ARM.put(196, "lstat64");
        map_ARM.put(197, "fstat64");
        map_ARM.put(198, "lchown32");
        map_ARM.put(199, "getuid32");
        map_ARM.put(200, "getgid32");
        map_ARM.put(201, "geteuid32");
        map_ARM.put(202, "getegid32");
        map_ARM.put(203, "setreuid32");
        map_ARM.put(204, "setregid32");
        map_ARM.put(205, "getgroups32");
        map_ARM.put(206, "setgroups32");
        map_ARM.put(207, "fchown32");
        map_ARM.put(208, "setresuid32");
        map_ARM.put(209, "getresuid32");
        map_ARM.put(210, "setresgid32");
        map_ARM.put(211, "getresgid32");
        map_ARM.put(212, "chown32");
        map_ARM.put(213, "setuid32");
        map_ARM.put(214, "setgid32");
        map_ARM.put(215, "setfsuid32");
        map_ARM.put(216, "setfsgid32");
        map_ARM.put(217, "getdents64");
        map_ARM.put(218, "pivot_root");
        map_ARM.put(219, "mincore");
        map_ARM.put(220, "madvise");
        map_ARM.put(221, "fcntl64");
        map_ARM.put(224, "gettid");
        map_ARM.put(225, "readahead");
        map_ARM.put(226, "setxattr");
        map_ARM.put(227, "lsetxattr");
        map_ARM.put(228, "fsetxattr");
        map_ARM.put(229, "getxattr");
        map_ARM.put(230, "lgetxattr");
        map_ARM.put(231, "fgetxattr");
        map_ARM.put(232, "listxattr");
        map_ARM.put(233, "llistxattr");
        map_ARM.put(234, "flistxattr");
        map_ARM.put(235, "removexattr");
        map_ARM.put(236, "lremovexattr");
        map_ARM.put(237, "fremovexattr");
        map_ARM.put(238, "tkill");
        map_ARM.put(239, "sendfile64");
        map_ARM.put(240, "futex");
        map_ARM.put(241, "sched_setaffinity");
        map_ARM.put(242, "sched_getaffinity");
        map_ARM.put(243, "io_setup");
        map_ARM.put(244, "io_destroy");
        map_ARM.put(245, "io_getevents");
        map_ARM.put(246, "io_submit");
        map_ARM.put(247, "io_cancel");
        map_ARM.put(248, "exit_group");
        map_ARM.put(249, "lookup_dcookie");
        map_ARM.put(250, "epoll_create");
        map_ARM.put(251, "epoll_ctl");
        map_ARM.put(252, "epoll_wait");
        map_ARM.put(253, "remap_file_pages");
        map_ARM.put(256, "set_tid_address");
        map_ARM.put(257, "timer_create");
        map_ARM.put(258, "timer_settime");
        map_ARM.put(259, "timer_gettime");
        map_ARM.put(260, "timer_getoverrun");
        map_ARM.put(261, "timer_delete");
        map_ARM.put(262, "clock_settime");
        map_ARM.put(263, "clock_gettime");
        map_ARM.put(264, "clock_getres");
        map_ARM.put(265, "clock_nanosleep");
        map_ARM.put(266, "statfs64");
        map_ARM.put(267, "fstatfs64");
        map_ARM.put(268, "tgkill");
        map_ARM.put(269, "utimes");
        map_ARM.put(270, "fadvise64_64");
        map_ARM.put(271, "pciconfig_iobase");
        map_ARM.put(272, "pciconfig_read");
        map_ARM.put(273, "pciconfig_write");
        map_ARM.put(274, "mq_open");
        map_ARM.put(275, "mq_unlink");
        map_ARM.put(276, "mq_timedsend");
        map_ARM.put(277, "mq_timedreceive");
        map_ARM.put(278, "mq_notify");
        map_ARM.put(279, "mq_getsetattr");
        map_ARM.put(280, "waitid");
        map_ARM.put(281, "socket");
        map_ARM.put(282, "bind");
        map_ARM.put(283, "connect");
        map_ARM.put(284, "listen");
        map_ARM.put(285, "accept");
        map_ARM.put(286, "getsockname");
        map_ARM.put(287, "getpeername");
        map_ARM.put(288, "socketpair");
        map_ARM.put(289, "send");
        map_ARM.put(290, "sendto");
        map_ARM.put(291, "recv");
        map_ARM.put(292, "recvfrom");
        map_ARM.put(293, "shutdown");
        map_ARM.put(294, "setsockopt");
        map_ARM.put(295, "getsockopt");
        map_ARM.put(296, "sendmsg");
        map_ARM.put(297, "recvmsg");
        map_ARM.put(298, "semop");
        map_ARM.put(299, "semget");
        map_ARM.put(300, "semctl");
        map_ARM.put(301, "msgsnd");
        map_ARM.put(302, "msgrcv");
        map_ARM.put(303, "msgget");
        map_ARM.put(304, "msgctl");
        map_ARM.put(305, "shmat");
        map_ARM.put(306, "shmdt");
        map_ARM.put(307, "shmget");
        map_ARM.put(308, "shmctl");
        map_ARM.put(309, "add_key");
        map_ARM.put(310, "request_key");
        map_ARM.put(311, "keyctl");
        map_ARM.put(312, "semtimedop");
        map_ARM.put(313, "vserver");
        map_ARM.put(314, "ioprio_set");
        map_ARM.put(315, "ioprio_get");
        map_ARM.put(316, "inotify_init");
        map_ARM.put(317, "inotify_add_watch");
        map_ARM.put(318, "inotify_rm_watch");
        map_ARM.put(319, "mbind");
        map_ARM.put(320, "get_mempolicy");
        map_ARM.put(321, "set_mempolicy");
        map_ARM.put(322, "openat");
        map_ARM.put(323, "mkdirat");
        map_ARM.put(324, "mknodat");
        map_ARM.put(325, "fchownat");
        map_ARM.put(326, "futimesat");
        map_ARM.put(327, "fstatat64");
        map_ARM.put(328, "unlinkat");
        map_ARM.put(329, "renameat");
        map_ARM.put(330, "linkat");
        map_ARM.put(331, "symlinkat");
        map_ARM.put(332, "readlinkat");
        map_ARM.put(333, "fchmodat");
        map_ARM.put(334, "faccessat");
        map_ARM.put(335, "pselect6");
        map_ARM.put(336, "ppoll");
        map_ARM.put(337, "unshare");
        map_ARM.put(338, "set_robust_list");
        map_ARM.put(339, "get_robust_list");
        map_ARM.put(340, "splice");
        map_ARM.put(341, "sync_file_range2");
        map_ARM.put(342, "tee");
        map_ARM.put(343, "vmsplice");
        map_ARM.put(344, "move_pages");
        map_ARM.put(345, "getcpu");
        map_ARM.put(346, "epoll_pwait");
        map_ARM.put(347, "kexec_load");
        map_ARM.put(348, "utimensat");
        map_ARM.put(349, "signalfd");
        map_ARM.put(350, "timerfd_create");
        map_ARM.put(351, "eventfd");
        map_ARM.put(352, "fallocate");
        map_ARM.put(353, "timerfd_settime");
        map_ARM.put(354, "timerfd_gettime");
        map_ARM.put(355, "signalfd4");
        map_ARM.put(356, "eventfd2");
        map_ARM.put(357, "epoll_create1");
        map_ARM.put(358, "dup3");
        map_ARM.put(359, "pipe2");
        map_ARM.put(360, "inotify_init1");
        map_ARM.put(361, "preadv");
        map_ARM.put(362, "pwritev");
        map_ARM.put(363, "rt_tgsigqueueinfo");
        map_ARM.put(364, "perf_event_open");
        map_ARM.put(365, "recvmmsg");
        map_ARM.put(366, "accept4");
        map_ARM.put(367, "fanotify_init");
        map_ARM.put(368, "fanotify_mark");
        map_ARM.put(369, "prlimit64");
        map_ARM.put(370, "name_to_handle_at");
        map_ARM.put(371, "open_by_handle_at");
        map_ARM.put(372, "clock_adjtime");
        map_ARM.put(373, "syncfs");
        map_ARM.put(374, "sendmmsg");
        map_ARM.put(375, "setns");
        map_ARM.put(376, "process_vm_readv");
        map_ARM.put(377, "process_vm_writev");
        map_ARM.put(378, "kcmp");
        map_ARM.put(379, "finit_module");
        map_ARM.put(380, "sched_setattr");
        map_ARM.put(381, "sched_getattr");
        map_ARM.put(382, "renameat2");
        map_ARM.put(383, "seccomp");
        map_ARM.put(384, "getrandom");
        map_ARM.put(385, "memfd_create");
        map_ARM.put(386, "bpf");
        map_ARM.put(387, "execveat");
        map_ARM.put(388, "userfaultfd");
        map_ARM.put(389, "membarrier");
        map_ARM.put(390, "mlock2");
        map_ARM.put(391, "copy_file_range");
        map_ARM.put(392, "preadv2");
        map_ARM.put(393, "pwritev2");
        map_ARM.put(394, "pkey_mprotect");
        map_ARM.put(395, "pkey_alloc");
        map_ARM.put(396, "pkey_free");
        map_ARM.put(397, "statx");
        map_ARM.put(398, "rseq");
        map_ARM.put(399, "io_pgetevents");
        map_ARM.put(400, "migrate_pages");
        map_ARM.put(401, "kexec_file_load");
        map_ARM64 = new HashMap<Integer, String>();
        map_ARM64.put(0, "io_setup");
        map_ARM64.put(1, "io_destroy");
        map_ARM64.put(2, "io_submit");
        map_ARM64.put(3, "io_cancel");
        map_ARM64.put(4, "io_getevents");
        map_ARM64.put(5, "setxattr");
        map_ARM64.put(6, "lsetxattr");
        map_ARM64.put(7, "fsetxattr");
        map_ARM64.put(8, "getxattr");
        map_ARM64.put(9, "lgetxattr");
        map_ARM64.put(10, "fgetxattr");
        map_ARM64.put(11, "listxattr");
        map_ARM64.put(12, "llistxattr");
        map_ARM64.put(13, "flistxattr");
        map_ARM64.put(14, "removexattr");
        map_ARM64.put(15, "lremovexattr");
        map_ARM64.put(16, "fremovexattr");
        map_ARM64.put(17, "getcwd");
        map_ARM64.put(18, "lookup_dcookie");
        map_ARM64.put(19, "eventfd2");
        map_ARM64.put(20, "epoll_create1");
        map_ARM64.put(21, "epoll_ctl");
        map_ARM64.put(22, "epoll_pwait");
        map_ARM64.put(23, "dup");
        map_ARM64.put(24, "dup3");
        map_ARM64.put(25, "fcntl");
        map_ARM64.put(26, "inotify_init1");
        map_ARM64.put(27, "inotify_add_watch");
        map_ARM64.put(28, "inotify_rm_watch");
        map_ARM64.put(29, "ioctl");
        map_ARM64.put(30, "ioprio_set");
        map_ARM64.put(31, "ioprio_get");
        map_ARM64.put(32, "flock");
        map_ARM64.put(33, "mknodat");
        map_ARM64.put(34, "mkdirat");
        map_ARM64.put(35, "unlinkat");
        map_ARM64.put(36, "symlinkat");
        map_ARM64.put(37, "linkat");
        map_ARM64.put(38, "renameat");
        map_ARM64.put(39, "umount2");
        map_ARM64.put(40, "mount");
        map_ARM64.put(41, "pivot_root");
        map_ARM64.put(42, "nfsservctl");
        map_ARM64.put(43, "statfs");
        map_ARM64.put(44, "fstatfs");
        map_ARM64.put(45, "truncate");
        map_ARM64.put(46, "ftruncate");
        map_ARM64.put(47, "fallocate");
        map_ARM64.put(48, "faccessat");
        map_ARM64.put(49, "chdir");
        map_ARM64.put(50, "fchdir");
        map_ARM64.put(51, "chroot");
        map_ARM64.put(52, "fchmod");
        map_ARM64.put(53, "fchmodat");
        map_ARM64.put(54, "fchownat");
        map_ARM64.put(55, "fchown");
        map_ARM64.put(56, "openat");
        map_ARM64.put(57, "close");
        map_ARM64.put(58, "vhangup");
        map_ARM64.put(59, "pipe2");
        map_ARM64.put(60, "quotactl");
        map_ARM64.put(61, "getdents64");
        map_ARM64.put(62, "lseek");
        map_ARM64.put(63, "read");
        map_ARM64.put(64, "write");
        map_ARM64.put(65, "readv");
        map_ARM64.put(66, "writev");
        map_ARM64.put(67, "pread64");
        map_ARM64.put(68, "pwrite64");
        map_ARM64.put(69, "preadv");
        map_ARM64.put(70, "pwritev");
        map_ARM64.put(71, "sendfile");
        map_ARM64.put(72, "pselect6");
        map_ARM64.put(73, "ppoll");
        map_ARM64.put(74, "signalfd4");
        map_ARM64.put(75, "vmsplice");
        map_ARM64.put(76, "splice");
        map_ARM64.put(77, "tee");
        map_ARM64.put(78, "readlinkat");
        map_ARM64.put(79, "fstatat64");
        map_ARM64.put(80, "fstat");
        map_ARM64.put(81, "sync");
        map_ARM64.put(82, "fsync");
        map_ARM64.put(83, "fdatasync");
        map_ARM64.put(84, "sync_file_range");
        map_ARM64.put(85, "timerfd_create");
        map_ARM64.put(86, "timerfd_settime");
        map_ARM64.put(87, "timerfd_gettime");
        map_ARM64.put(88, "utimensat");
        map_ARM64.put(89, "acct");
        map_ARM64.put(90, "capget");
        map_ARM64.put(91, "capset");
        map_ARM64.put(92, "personality");
        map_ARM64.put(93, "exit");
        map_ARM64.put(94, "exit_group");
        map_ARM64.put(95, "waitid");
        map_ARM64.put(96, "set_tid_address");
        map_ARM64.put(97, "unshare");
        map_ARM64.put(98, "futex");
        map_ARM64.put(99, "set_robust_list");
        map_ARM64.put(100, "get_robust_list");
        map_ARM64.put(101, "nanosleep");
        map_ARM64.put(102, "getitimer");
        map_ARM64.put(103, "setitimer");
        map_ARM64.put(104, "kexec_load");
        map_ARM64.put(105, "init_module");
        map_ARM64.put(106, "delete_module");
        map_ARM64.put(107, "timer_create");
        map_ARM64.put(108, "timer_gettime");
        map_ARM64.put(109, "timer_getoverrun");
        map_ARM64.put(110, "timer_settime");
        map_ARM64.put(111, "timer_delete");
        map_ARM64.put(112, "clock_settime");
        map_ARM64.put(113, "clock_gettime");
        map_ARM64.put(114, "clock_getres");
        map_ARM64.put(115, "clock_nanosleep");
        map_ARM64.put(116, "syslog");
        map_ARM64.put(117, "ptrace");
        map_ARM64.put(118, "sched_setparam");
        map_ARM64.put(119, "sched_setscheduler");
        map_ARM64.put(120, "sched_getscheduler");
        map_ARM64.put(121, "sched_getparam");
        map_ARM64.put(122, "sched_setaffinity");
        map_ARM64.put(123, "sched_getaffinity");
        map_ARM64.put(124, "sched_yield");
        map_ARM64.put(125, "sched_get_priority_max");
        map_ARM64.put(126, "sched_get_priority_min");
        map_ARM64.put(127, "sched_rr_get_interval");
        map_ARM64.put(128, "restart_syscall");
        map_ARM64.put(129, "kill");
        map_ARM64.put(130, "tkill");
        map_ARM64.put(131, "tgkill");
        map_ARM64.put(132, "sigaltstack");
        map_ARM64.put(133, "rt_sigsuspend");
        map_ARM64.put(134, "rt_sigaction");
        map_ARM64.put(135, "rt_sigprocmask");
        map_ARM64.put(136, "rt_sigpending");
        map_ARM64.put(137, "rt_sigtimedwait");
        map_ARM64.put(138, "rt_sigqueueinfo");
        map_ARM64.put(139, "rt_sigreturn");
        map_ARM64.put(140, "setpriority");
        map_ARM64.put(141, "getpriority");
        map_ARM64.put(142, "reboot");
        map_ARM64.put(143, "setregid");
        map_ARM64.put(144, "setgid");
        map_ARM64.put(145, "setreuid");
        map_ARM64.put(146, "setuid");
        map_ARM64.put(147, "setresuid");
        map_ARM64.put(148, "getresuid");
        map_ARM64.put(149, "setresgid");
        map_ARM64.put(150, "getresgid");
        map_ARM64.put(151, "setfsuid");
        map_ARM64.put(152, "setfsgid");
        map_ARM64.put(153, "times");
        map_ARM64.put(154, "setpgid");
        map_ARM64.put(155, "getpgid");
        map_ARM64.put(156, "getsid");
        map_ARM64.put(157, "setsid");
        map_ARM64.put(158, "getgroups");
        map_ARM64.put(159, "setgroups");
        map_ARM64.put(160, "uname");
        map_ARM64.put(161, "sethostname");
        map_ARM64.put(162, "setdomainname");
        map_ARM64.put(163, "getrlimit");
        map_ARM64.put(164, "setrlimit");
        map_ARM64.put(165, "getrusage");
        map_ARM64.put(166, "umask");
        map_ARM64.put(167, "prctl");
        map_ARM64.put(168, "getcpu");
        map_ARM64.put(169, "gettimeofday");
        map_ARM64.put(170, "settimeofday");
        map_ARM64.put(171, "adjtimex");
        map_ARM64.put(172, "getpid");
        map_ARM64.put(173, "getppid");
        map_ARM64.put(174, "getuid");
        map_ARM64.put(175, "geteuid");
        map_ARM64.put(176, "getgid");
        map_ARM64.put(177, "getegid");
        map_ARM64.put(178, "gettid");
        map_ARM64.put(179, "sysinfo");
        map_ARM64.put(180, "mq_open");
        map_ARM64.put(181, "mq_unlink");
        map_ARM64.put(182, "mq_timedsend");
        map_ARM64.put(183, "mq_timedreceive");
        map_ARM64.put(184, "mq_notify");
        map_ARM64.put(185, "mq_getsetattr");
        map_ARM64.put(186, "msgget");
        map_ARM64.put(187, "msgctl");
        map_ARM64.put(188, "msgrcv");
        map_ARM64.put(189, "msgsnd");
        map_ARM64.put(190, "semget");
        map_ARM64.put(191, "semctl");
        map_ARM64.put(192, "semtimedop");
        map_ARM64.put(193, "semop");
        map_ARM64.put(194, "shmget");
        map_ARM64.put(195, "shmctl");
        map_ARM64.put(196, "shmat");
        map_ARM64.put(197, "shmdt");
        map_ARM64.put(198, "socket");
        map_ARM64.put(199, "socketpair");
        map_ARM64.put(200, "bind");
        map_ARM64.put(201, "listen");
        map_ARM64.put(202, "accept");
        map_ARM64.put(203, "connect");
        map_ARM64.put(204, "getsockname");
        map_ARM64.put(205, "getpeername");
        map_ARM64.put(206, "sendto");
        map_ARM64.put(207, "recvfrom");
        map_ARM64.put(208, "setsockopt");
        map_ARM64.put(209, "getsockopt");
        map_ARM64.put(210, "shutdown");
        map_ARM64.put(211, "sendmsg");
        map_ARM64.put(212, "recvmsg");
        map_ARM64.put(213, "readahead");
        map_ARM64.put(214, "brk");
        map_ARM64.put(215, "munmap");
        map_ARM64.put(216, "mremap");
        map_ARM64.put(217, "add_key");
        map_ARM64.put(218, "request_key");
        map_ARM64.put(219, "keyctl");
        map_ARM64.put(220, "clone");
        map_ARM64.put(221, "execve");
        map_ARM64.put(222, "mmap");
        map_ARM64.put(223, "fadvise64");
        map_ARM64.put(224, "swapon");
        map_ARM64.put(225, "swapoff");
        map_ARM64.put(226, "mprotect");
        map_ARM64.put(227, "msync");
        map_ARM64.put(228, "mlock");
        map_ARM64.put(229, "munlock");
        map_ARM64.put(230, "mlockall");
        map_ARM64.put(231, "munlockall");
        map_ARM64.put(232, "mincore");
        map_ARM64.put(233, "madvise");
        map_ARM64.put(234, "remap_file_pages");
        map_ARM64.put(235, "mbind");
        map_ARM64.put(236, "get_mempolicy");
        map_ARM64.put(237, "set_mempolicy");
        map_ARM64.put(238, "migrate_pages");
        map_ARM64.put(239, "move_pages");
        map_ARM64.put(240, "rt_tgsigqueueinfo");
        map_ARM64.put(241, "perf_event_open");
        map_ARM64.put(242, "accept4");
        map_ARM64.put(243, "recvmmsg");
        map_ARM64.put(260, "wait4");
        map_ARM64.put(261, "prlimit64");
        map_ARM64.put(262, "fanotify_init");
        map_ARM64.put(263, "fanotify_mark");
        map_ARM64.put(264, "name_to_handle_at");
        map_ARM64.put(265, "open_by_handle_at");
        map_ARM64.put(266, "clock_adjtime");
        map_ARM64.put(267, "syncfs");
        map_ARM64.put(268, "setns");
        map_ARM64.put(269, "sendmmsg");
        map_ARM64.put(270, "process_vm_readv");
        map_ARM64.put(271, "process_vm_writev");
        map_ARM64.put(272, "kcmp");
        map_ARM64.put(273, "finit_module");
        map_ARM64.put(274, "sched_setattr");
        map_ARM64.put(275, "sched_getattr");
        map_ARM64.put(276, "renameat2");
        map_ARM64.put(277, "seccomp");
        map_ARM64.put(278, "getrandom");
        map_ARM64.put(279, "memfd_create");
        map_ARM64.put(280, "bpf");
        map_ARM64.put(281, "execveat");
        map_ARM64.put(282, "userfaultfd");
        map_ARM64.put(283, "membarrier");
        map_ARM64.put(284, "mlock2");
        map_ARM64.put(285, "copy_file_range");
        map_ARM64.put(286, "preadv2");
        map_ARM64.put(287, "pwritev2");
        map_ARM64.put(288, "pkey_mprotect");
        map_ARM64.put(289, "pkey_alloc");
        map_ARM64.put(290, "pkey_free");
        map_ARM64.put(291, "statx");
        map_ARM64.put(292, "io_pgetevents");
        map_ARM64.put(293, "rseq");
        map_ARM64.put(294, "kexec_file_load");
        map_32 = new HashMap<Integer, String>();
        map_32.put(403, "clock_gettime64");
        map_32.put(404, "clock_settime64");
        map_32.put(405, "clock_adjtime64");
        map_32.put(406, "clock_getres_time64");
        map_32.put(407, "clock_nanosleep_time64");
        map_32.put(408, "timer_gettime64");
        map_32.put(409, "timer_settime64");
        map_32.put(410, "timerfd_gettime64");
        map_32.put(411, "timerfd_settime64");
        map_32.put(412, "utimensat_time64");
        map_32.put(413, "pselect6_time64");
        map_32.put(414, "ppoll_time64");
        map_32.put(416, "io_pgetevents_time64");
        map_32.put(417, "recvmmsg_time64");
        map_32.put(418, "mq_timedsend_time64");
        map_32.put(419, "mq_timedreceive_time64");
        map_32.put(420, "semtimedop_time64");
        map_32.put(421, "rt_sigtimedwait_time64");
        map_32.put(422, "futex_time64");
        map_32.put(423, "sched_rr_get_interval_time64");
        map_64 = new HashMap<Integer, String>();
        map_64.put(424, "pidfd_send_signal");
        map_64.put(425, "io_uring_setup");
        map_64.put(426, "io_uring_enter");
        map_64.put(427, "io_uring_register");
        map_64.put(428, "open_tree");
        map_64.put(429, "move_mount");
        map_64.put(430, "fsopen");
        map_64.put(431, "fsconfig");
        map_64.put(432, "fsmount");
        map_64.put(433, "fspick");
        map_64.put(434, "pidfd_open");
        map_64.put(435, "clone3");
        map_64.put(436, "close_range");
        map_64.put(437, "openat2");
        map_64.put(438, "pidfd_getfd");
        map_64.put(439, "faccessat2");
        map_64.put(440, "process_madvise");
        map_64.put(441, "epoll_pwait2");
        map_64.put(442, "mount_setattr");
        map_64.put(443, "quotactl_fd");
        map_64.put(444, "landlock_create_ruleset");
        map_64.put(445, "landlock_add_rule");
        map_64.put(446, "landlock_restrict_self");
        map_64.put(447, "memfd_secret");
        map_64.put(448, "process_mrelease");
        map_64.put(449, "futex_waitv");
        map_64.put(450, "set_mempolicy_home_node");
    }
}

