/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm;

import com.pnfsoftware.jeb.util.format.Strings;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ChainedOperationResult<T> {
    public static final ChainedOperationResult<Boolean> TRUE_STOP = new ChainedOperationResult<Boolean>(true, ContinuationStatus.STOP);
    public static final ChainedOperationResult<Boolean> TRUE_CONTINUE = new ChainedOperationResult<Boolean>(true, ContinuationStatus.CONTINUE);
    public static final ChainedOperationResult<Boolean> FALSE_STOP = new ChainedOperationResult<Boolean>(false, ContinuationStatus.STOP);
    public static final ChainedOperationResult<Boolean> FALSE_CONTINUE = new ChainedOperationResult<Boolean>(false, ContinuationStatus.CONTINUE);
    public static final ChainedOperationResult<Boolean> FALSE_IGNORE = new ChainedOperationResult<Boolean>(false, ContinuationStatus.IGNORE);
    public static final ChainedOperationResult<Long> ZEROL_CONTINUE = new ChainedOperationResult<Long>(0L, ContinuationStatus.CONTINUE);
    private static final ChainedOperationResult NULL_STOP = new ChainedOperationResult<Object>(null, ContinuationStatus.STOP);
    private static final ChainedOperationResult NULL_CONTINUE = new ChainedOperationResult<Object>(null, ContinuationStatus.CONTINUE);
    private static final ChainedOperationResult NULL_IGNORE = new ChainedOperationResult<Object>(null, ContinuationStatus.IGNORE);
    private T result;
    private ContinuationStatus continutationStatus;

    public ChainedOperationResult(T t) {
        this.result = t;
        this.continutationStatus = ContinuationStatus.STOP;
    }

    public ChainedOperationResult(T t, ContinuationStatus continuationStatus) {
        this.result = t;
        this.continutationStatus = continuationStatus;
    }

    public T getResult() {
        return this.result;
    }

    public ContinuationStatus getContinuationStatus() {
        return this.continutationStatus;
    }

    public String toString() {
        return Strings.ff("%s(%s)", new Object[]{this.result, this.continutationStatus});
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.continutationStatus == null ? 0 : this.continutationStatus.hashCode());
        n2 = 31 * n2 + (this.result == null ? 0 : this.result.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChainedOperationResult chainedOperationResult = (ChainedOperationResult)object;
        if (this.continutationStatus != chainedOperationResult.continutationStatus) {
            return false;
        }
        return !(this.result == null ? chainedOperationResult.result != null : !this.result.equals(chainedOperationResult.result));
    }

    public static ChainedOperationResult<Boolean> stop(boolean bl) {
        return bl ? TRUE_STOP : FALSE_STOP;
    }

    public static <T> ChainedOperationResult<T> stop() {
        return NULL_STOP;
    }

    public static <T> ChainedOperationResult<T> continue_() {
        return NULL_CONTINUE;
    }

    public static <T> ChainedOperationResult<T> ignore() {
        return NULL_IGNORE;
    }

    public static enum ContinuationStatus {
        CONTINUE,
        IGNORE,
        STOP;


        public boolean isIgnore() {
            return this == IGNORE;
        }

        public boolean isContinue() {
            return this == CONTINUE;
        }

        public boolean isStop() {
            return this == STOP;
        }
    }
}

