/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.ir;

import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDalvikInstruction;
import com.pnfsoftware.jeb.util.format.Strings;

public class DexDecConversionException
extends JebRuntimeException {
    private static final long serialVersionUID = 1L;
    private IDalvikInstruction insn;
    private Integer opcode;
    private String details;

    public DexDecConversionException() {
    }

    public DexDecConversionException(int n2) {
        this.opcode = n2;
    }

    public DexDecConversionException(IDalvikInstruction iDalvikInstruction) {
        this(iDalvikInstruction, null);
    }

    public DexDecConversionException(IDalvikInstruction iDalvikInstruction, String string) {
        if (iDalvikInstruction == null) {
            throw new IllegalArgumentException();
        }
        this.insn = iDalvikInstruction;
        this.opcode = iDalvikInstruction.getOpcode();
        this.details = string;
    }

    public IDalvikInstruction getInstruction() {
        return this.insn;
    }

    public Integer getOpcode() {
        return this.opcode;
    }

    @Override
    public String getMessage() {
        Object object = "Failed conversion";
        if (this.insn != null) {
            object = (String)object + ": " + this.insn.format(null);
        } else if (this.opcode != null) {
            object = (String)object + Strings.ff(": opcode= 0x%X", this.opcode);
        }
        if (this.details != null) {
            object = (String)object + ": " + this.details;
        }
        return object;
    }
}

