/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.ir;

import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.InstructionCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.MethodCoordinates;
import com.pnfsoftware.jeb.core.units.code.CFGUtil;
import com.pnfsoftware.jeb.core.units.code.IBasicBlock;
import com.pnfsoftware.jeb.core.units.code.IDFA;
import com.pnfsoftware.jeb.core.units.code.IFlowInformation;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.IVisitResults;
import com.pnfsoftware.jeb.core.units.code.android.ContextAccessType;
import com.pnfsoftware.jeb.core.units.code.android.EffectiveFinalityType;
import com.pnfsoftware.jeb.core.units.code.android.IDexContextInfoProvider;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.CFG;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexField;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexType;
import com.pnfsoftware.jeb.core.units.code.android.ir.DOpcodeType;
import com.pnfsoftware.jeb.core.units.code.android.ir.DexDecEvaluationException;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDArrayElt;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDCallInfo;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDElement;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDExceptionHandler;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDExpression;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDField;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDGlobalContext;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDImm;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDInstanceField;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDInstruction;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDInvokeInfo;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDMethodContext;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDNewArrayInfo;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDStaticField;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDTarget;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDTryData;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDVar;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDVisitor;
import com.pnfsoftware.jeb.core.units.code.java.IJavaType;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.collect.IdentityHashSet;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.primitives.Integers;
import com.pnfsoftware.jeb.util.primitives.Longs;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DUtil {
    public static int createRegisterVarId(int n2, boolean bl) {
        if (bl) {
            Assert.a(n2 >= 0 && n2 < 65535);
            return 65536 + n2;
        }
        Assert.a(n2 >= 0 && n2 < 65536);
        return n2;
    }

    public static boolean isRegisterVarId(int n2) {
        if (n2 >= 0) {
            if (n2 <= 65535) {
                return true;
            }
            if (n2 >= 65536 && n2 <= 131070) {
                return true;
            }
        }
        return false;
    }

    public static boolean isVirtualVarId(int n2) {
        if (n2 >= 0) {
            if (n2 >= 131072 && n2 <= 589823) {
                return true;
            }
            if (n2 >= 589824 && n2 <= 1048574) {
                return true;
            }
        }
        return false;
    }

    public static boolean isLegalVarId(int n2) {
        return DUtil.isSingleSlotVarId(n2) || DUtil.isDoubleSlotVarId(n2);
    }

    public static boolean isSingleSlotVarId(int n2) {
        if (n2 >= 0) {
            if (n2 <= 65535) {
                return true;
            }
            if (n2 >= 131072 && n2 <= 589823) {
                return true;
            }
        }
        return false;
    }

    public static boolean isDoubleSlotVarId(int n2) {
        if (n2 >= 0) {
            if (n2 >= 65536 && n2 <= 131070) {
                return true;
            }
            if (n2 >= 589824 && n2 <= 1048574) {
                return true;
            }
        }
        return false;
    }

    public static String formatVarId(int n2) {
        if (n2 >= 0 && n2 < 65536) {
            return "v" + n2;
        }
        if (n2 >= 65536 && n2 < 131071) {
            return "V" + (n2 - 65536);
        }
        if (n2 >= 131072 && n2 < 589824) {
            return "x" + (n2 - 131072);
        }
        if (n2 >= 589824 && n2 < 1048575) {
            return "X" + (n2 - 589824);
        }
        throw new IllegalArgumentException(Strings.ff("Illegal variable id: 0x%X", n2));
    }

    public static int parseVarIdFromStandardName(String string, boolean bl) {
        block10: {
            try {
                char c2 = string.charAt(0);
                int n2 = Integer.parseInt(string.substring(1));
                if (c2 == 'v') {
                    if (n2 >= 0 && n2 < 65536) {
                        return n2;
                    }
                    break block10;
                }
                if (c2 == 'V') {
                    if (n2 >= 0 && n2 < 65535) {
                        return 65536 + n2;
                    }
                    break block10;
                }
                if (c2 == 'x') {
                    if (n2 >= 0 && n2 < 458752) {
                        return 131072 + n2;
                    }
                    break block10;
                }
                if (c2 != 'X' || n2 < 0 || n2 >= 458751) break block10;
                return 589824 + n2;
            }
            catch (Exception exception) {
                if (bl) {
                    return -1;
                }
                throw new IllegalArgumentException("Illegal variable name: " + string);
            }
        }
        throw new RuntimeException();
    }

    public static String formatVarIds(Collection<Integer> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (int n3 : collection) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(DUtil.formatVarId(n3));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static boolean replaceInExpression(IDExpression iDExpression, final IDExpression iDExpression2, final IDExpression iDExpression3) {
        if (iDExpression == null || iDExpression2 == null || iDExpression3 == null) {
            throw new IllegalArgumentException();
        }
        if (iDExpression == iDExpression2) {
            return false;
        }
        return !iDExpression.visitDepthPre(new IDVisitor(){

            @Override
            public void process(IDExpression iDExpression, IDExpression iDExpression22, IVisitResults<IDExpression> iVisitResults) {
                if (iDExpression == iDExpression2) {
                    if (!iDExpression22.replaceSubExpression(iDExpression, iDExpression3)) {
                        iVisitResults.interrupt(true);
                    } else {
                        iVisitResults.setReplacedNode(iDExpression3);
                        iVisitResults.interrupt(false);
                    }
                }
            }
        });
    }

    public static int countVariable(IDExpression iDExpression, final IDVar iDVar) {
        final AtomicInteger atomicInteger = new AtomicInteger();
        iDExpression.visitDepthPost(new IDVisitor(){

            @Override
            public void process(IDExpression iDExpression, IDExpression iDExpression2, IVisitResults<IDExpression> iVisitResults) {
                if (iDExpression instanceof IDVar && iDExpression.equals(iDVar)) {
                    atomicInteger.incrementAndGet();
                }
            }
        });
        return atomicInteger.get();
    }

    public static boolean usesReferences(IDExpression iDExpression) {
        return !iDExpression.visitDepthPost(new IDVisitor(){

            @Override
            public void process(IDExpression iDExpression, IDExpression iDExpression2, IVisitResults<IDExpression> iVisitResults) {
                if (iDExpression instanceof IDField || iDExpression instanceof IDArrayElt || iDExpression instanceof IDNewArrayInfo) {
                    iVisitResults.interrupt(false);
                }
            }
        });
    }

    public static List<IDVar> collectVars(IDExpression iDExpression) {
        final ArrayList<IDVar> arrayList = new ArrayList<IDVar>();
        iDExpression.visitDepthPost(new IDVisitor(){

            @Override
            public void process(IDExpression iDExpression, IDExpression iDExpression2, IVisitResults<IDExpression> iVisitResults) {
                if (iDExpression instanceof IDVar) {
                    arrayList.add((IDVar)iDExpression);
                }
            }
        });
        return arrayList;
    }

    public static Set<Integer> collectUniqueVarIds(IDExpression iDExpression) {
        final HashSet<Integer> hashSet = new HashSet<Integer>();
        iDExpression.visitDepthPost(new IDVisitor(){

            @Override
            public void process(IDExpression iDExpression, IDExpression iDExpression2, IVisitResults<IDExpression> iVisitResults) {
                if (iDExpression instanceof IDVar) {
                    hashSet.add(((IDVar)iDExpression).getId());
                }
            }
        });
        return hashSet;
    }

    public static int calculateComplexity(IDExpression iDExpression) {
        int n2 = 1;
        ArrayList<IDExpression> arrayList = new ArrayList<IDExpression>();
        iDExpression.collectSubExpressions(arrayList);
        for (IDExpression iDExpression2 : arrayList) {
            n2 += DUtil.calculateComplexity(iDExpression2);
        }
        return n2;
    }

    public static boolean hasInvokeInfo(IDExpression iDExpression) {
        return !iDExpression.visitDepthPost(new IDVisitor(){

            @Override
            public void process(IDExpression iDExpression, IDExpression iDExpression2, IVisitResults<IDExpression> iVisitResults) {
                if (iDExpression instanceof IDInvokeInfo) {
                    iVisitResults.interrupt(false);
                }
            }
        });
    }

    public static boolean hasVariables(IDExpression iDExpression) {
        return iDExpression instanceof IDVar || !iDExpression.visitDepthPre(new IDVisitor(){

            @Override
            public void process(IDExpression iDExpression, IDExpression iDExpression2, IVisitResults<IDExpression> iVisitResults) {
                if (iDExpression instanceof IDVar) {
                    iVisitResults.interrupt(false);
                }
            }
        });
    }

    public static boolean hasVariable(IDExpression iDExpression, final int n2) {
        return iDExpression.isVar(n2) || !iDExpression.visitDepthPre(new IDVisitor(){

            @Override
            public void process(IDExpression iDExpression, IDExpression iDExpression2, IVisitResults<IDExpression> iVisitResults) {
                if (iDExpression.isVar(n2)) {
                    iVisitResults.interrupt(false);
                }
            }
        });
    }

    public static boolean checkBlock(BasicBlock<IDInstruction> basicBlock, DOpcodeType ... dOpcodeTypeArray) {
        if (basicBlock.size() == dOpcodeTypeArray.length) {
            for (int i = 0; i < dOpcodeTypeArray.length; ++i) {
                if (((IDInstruction)basicBlock.get(i)).getOpcode() == dOpcodeTypeArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int checkSequence(CFG<IDInstruction> cFG, int n2, DOpcodeType ... dOpcodeTypeArray) {
        int n3 = dOpcodeTypeArray.length;
        int n4 = 0;
        IBasicBlock iBasicBlock = cFG.get(n2);
        int n5 = 0;
        while (iBasicBlock != null) {
            int n6 = 0;
            while (n6 < ((BasicBlock)iBasicBlock).size() && n3 > 0) {
                if (((IDInstruction)((BasicBlock)iBasicBlock).get(n6)).getOpcode() != dOpcodeTypeArray[n4]) {
                    return 0;
                }
                --n3;
                ++n6;
                ++n4;
            }
            ++n5;
            if (n3 == 0) {
                if (n6 == ((BasicBlock)iBasicBlock).size()) {
                    return n5;
                }
                return 0;
            }
            if (((BasicBlock)iBasicBlock).outsize() != 1) {
                return 0;
            }
            if (++n2 >= cFG.size()) {
                return 0;
            }
            iBasicBlock = cFG.get(n2);
        }
        return 0;
    }

    public static boolean mayBeFinal(IDField iDField, IDexUnit iDexUnit) {
        if (iDField.getIndex() == null) {
            return true;
        }
        IDexField iDexField = iDexUnit.getField(iDField.getIndex().getValue());
        if (iDexField.isInternal()) {
            return iDexField.getData().isFinal();
        }
        String string = iDexField.getSignature(false);
        EffectiveFinalityType effectiveFinalityType = iDexUnit.getContextInfoProvider().getFieldEFInfo(string);
        return effectiveFinalityType.isFinalLike();
    }

    public static int cleanGraph(IDMethodContext iDMethodContext) {
        int n2 = 0;
        n2 += DUtil.removeUnreachableBlocks(iDMethodContext);
        return n2 += DUtil.simplifyJCondsAndSwitches(iDMethodContext);
    }

    public static int removeGaps(CFG<IDInstruction> cFG) {
        int n2 = 0;
        List<BasicBlock<IDInstruction>> list = cFG.getBlocksView();
        IBasicBlock iBasicBlock = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            IDInstruction iDInstruction = (IDInstruction)iBasicBlock.getLast();
            IBasicBlock iBasicBlock2 = list.get(i);
            IDInstruction iDInstruction2 = (IDInstruction)iBasicBlock2.get(0);
            int n3 = (int)(iDInstruction2.getOffset() - iDInstruction.getOffsetEnd());
            if (n3 != 0) {
                iDInstruction.adjustSize(n3);
                ++n2;
            }
            iBasicBlock = iBasicBlock2;
        }
        return n2;
    }

    public static int removeUnreachableBlocks(IDMethodContext iDMethodContext) {
        return DUtil.removeUnreachableBlocks(iDMethodContext.getCfg(), iDMethodContext.getExceptionData());
    }

    public static int removeUnreachableBlocks(CFG<IDInstruction> cFG, IDTryData iDTryData) {
        List<BasicBlock<IDInstruction>> list = cFG.getBlocks();
        list.removeAll(DUtil.getReachableBlocks(cFG));
        if (list.isEmpty()) {
            return 0;
        }
        return DUtil.removeUnreachableBlocks(list, cFG, iDTryData);
    }

    public static Collection<BasicBlock<IDInstruction>> getReachableBlocks(CFG<IDInstruction> cFG) {
        HashSet<BasicBlock<IDInstruction>> hashSet = new HashSet<BasicBlock<IDInstruction>>();
        ArrayList<IBasicBlock> arrayList = new ArrayList<IBasicBlock>();
        arrayList.add(cFG.get(0));
        while (!arrayList.isEmpty()) {
            BasicBlock basicBlock = (BasicBlock)arrayList.remove(0);
            if (!hashSet.add(basicBlock)) continue;
            arrayList.addAll(basicBlock.getOutputs());
            arrayList.addAll(basicBlock.getIrregularOutputs());
        }
        return hashSet;
    }

    private static int removeUnreachableBlocks(List<BasicBlock<IDInstruction>> list, CFG<IDInstruction> cFG, IDTryData iDTryData) {
        Iterable<Object> iterable;
        long l2;
        BasicBlock<IDInstruction> basicBlock;
        HashSet<Long> hashSet = new HashSet<Long>();
        while (!list.isEmpty()) {
            basicBlock = list.remove(0);
            l2 = basicBlock.getAddress();
            if (l2 == 0L || !hashSet.add(l2)) continue;
            iterable = basicBlock.getAllOutputBlocks();
            cFG.deleteOutEdges(basicBlock);
            cFG.deleteIrregularOutEdges(basicBlock);
            if (iDTryData != null) {
                iDTryData.unprotectBlock((int)basicBlock.getAddress());
            }
            for (BasicBlock basicBlock2 : iterable) {
                if (basicBlock2.allinsize() != 0) continue;
                list.add(basicBlock2);
            }
        }
        basicBlock = hashSet.iterator();
        while (basicBlock.hasNext()) {
            l2 = (Long)basicBlock.next();
            iterable = cFG.getBlockAt(l2);
            cFG.removeBlock((BasicBlock<IDInstruction>)iterable);
            IBasicBlock iBasicBlock = cFG.getBlockEndingAt(((BasicBlock)iterable).getFirstAddress());
            ((IDInstruction)((BasicBlock)iBasicBlock).getLast()).adjustSize(((BasicBlock)iterable).getSizeOfInstructions());
        }
        return hashSet.size();
    }

    public static int simplifyJCondsAndSwitches(IDMethodContext iDMethodContext) {
        CFG<IDInstruction> cFG = iDMethodContext.getCfg();
        int n2 = 0;
        for (int i = 0; i < cFG.size() - 1; ++i) {
            IDElement iDElement;
            IBasicBlock iBasicBlock = cFG.get(i);
            IDInstruction iDInstruction = (IDInstruction)((BasicBlock)iBasicBlock).getLast();
            if (iDInstruction.getOpcode() == DOpcodeType.IR_JCOND) {
                if ((long)iDInstruction.getBranchTarget() != iDInstruction.getOffsetEnd()) continue;
                iDElement = iDInstruction.getJcondCondition();
                if (iDElement.hasSideEffects(iDMethodContext, true)) {
                    IJavaType iJavaType = iDElement.getType() != null ? iDElement.getType() : iDMethodContext.getTypeFactory().getBoolean();
                    IDVar iDVar = iDMethodContext.createVirtualVar(iJavaType);
                    iDInstruction.transformJcondToAssign(iDVar);
                } else {
                    iDInstruction.transformToNop();
                }
                cFG.deleteOutEdges((BasicBlock<IDInstruction>)iBasicBlock);
                cFG.addEdge((BasicBlock<IDInstruction>)iBasicBlock, (BasicBlock<IDInstruction>)cFG.get(i + 1));
                ++n2;
                continue;
            }
            if (iDInstruction.getOpcode() != DOpcodeType.IR_SWITCH || (iDElement = iDInstruction.getSwitchData()).deleteCasesTo((int)iDInstruction.getOffsetEnd()) <= 0) continue;
            cFG.deleteOutEdges((BasicBlock<IDInstruction>)iBasicBlock);
            cFG.addEdge((BasicBlock<IDInstruction>)iBasicBlock, (BasicBlock<IDInstruction>)cFG.get(i + 1));
            for (IDTarget iDTarget : iDElement.getTargets(true)) {
                cFG.addEdge((BasicBlock<IDInstruction>)iBasicBlock, (BasicBlock<IDInstruction>)cFG.getBlockAt(iDTarget.getOffset()));
            }
            ++n2;
        }
        return n2;
    }

    public static String getExceptionSignature(IDMethodContext iDMethodContext, IDExceptionHandler iDExceptionHandler) {
        int n2 = iDExceptionHandler.getTypeIndex();
        if (n2 < 0) {
            return "Ljava/lang/Throwable;";
        }
        IDexType iDexType = iDMethodContext.getDex().getType(n2);
        if (iDexType == null) {
            return null;
        }
        return iDexType.getSignature(false);
    }

    public static boolean canHandlerCatchException(IDMethodContext iDMethodContext, IDExceptionHandler iDExceptionHandler, String string) {
        if (iDExceptionHandler.isCatchAll(iDMethodContext)) {
            return true;
        }
        String string2 = DUtil.getExceptionSignature(iDMethodContext, iDExceptionHandler);
        if (string2 == null) {
            return false;
        }
        return iDMethodContext.getTypeInfoProvider().isCompatible(string, string2);
    }

    public static boolean unprotectBlock(CFG<IDInstruction> cFG, IDTryData iDTryData, int n2) {
        IBasicBlock iBasicBlock = cFG.getBlockAt(n2);
        if (iBasicBlock == null) {
            throw new IllegalArgumentException();
        }
        if (!iDTryData.unprotectBlock(n2)) {
            return false;
        }
        cFG.deleteIrregularOutEdges((BasicBlock<IDInstruction>)iBasicBlock);
        DUtil.removeUnreachableBlocks(cFG, iDTryData);
        return true;
    }

    public static ContextAccessType getCAT(IDInstruction iDInstruction, boolean bl) {
        IDexContextInfoProvider iDexContextInfoProvider = iDInstruction.getContext().getDex().getContextInfoProvider();
        CATDeterminer cATDeterminer = new CATDeterminer(iDexContextInfoProvider);
        iDInstruction.visitInstructionPostOrder(cATDeterminer, true);
        if (bl && iDInstruction.getOpcode() == DOpcodeType.IR_ASSIGN && !cATDeterminer.cat.isAllAccess()) {
            IDExpression iDExpression = iDInstruction.getAssignDestination();
            if (iDExpression instanceof IDArrayElt) {
                cATDeterminer.cat = cATDeterminer.cat.addAccess(ContextAccessType.WRITE_ONLY);
                if (!cATDeterminer.cat.isAllAccess()) {
                    IDExpression iDExpression2 = ((IDArrayElt)iDExpression).getArray();
                    iDExpression2.visitDepthPost(cATDeterminer);
                    if (!cATDeterminer.cat.isAllAccess()) {
                        iDExpression2 = ((IDArrayElt)iDExpression).getIndex();
                        iDExpression2.visitDepthPost(cATDeterminer);
                    }
                }
            } else if (iDExpression instanceof IDInstanceField) {
                cATDeterminer.cat = cATDeterminer.cat.addAccess(ContextAccessType.WRITE_ONLY);
                if (!cATDeterminer.cat.isAllAccess()) {
                    IDExpression iDExpression3 = ((IDInstanceField)iDExpression).getInstance();
                    iDExpression3.visitDepthPost(cATDeterminer);
                }
            } else if (iDExpression instanceof IDStaticField) {
                cATDeterminer.cat = cATDeterminer.cat.addAccess(ContextAccessType.WRITE_ONLY);
            }
        }
        return cATDeterminer.cat;
    }

    public static boolean isUsingCaughtException(IDMethodContext iDMethodContext, BasicBlock<IDInstruction> basicBlock) {
        int n2;
        for (n2 = 0; n2 < basicBlock.size() && ((IDInstruction)basicBlock.get(n2)).getOpcode() == DOpcodeType.IR_NOP; ++n2) {
        }
        if (n2 >= basicBlock.size()) {
            return true;
        }
        IDInstruction iDInstruction = (IDInstruction)basicBlock.get(n2);
        if (iDInstruction.getOpcode() != DOpcodeType.IR_STORE_EXCEPTION) {
            return false;
        }
        IDVar iDVar = (IDVar)iDInstruction.getOperand1();
        IDFA<IDInstruction> iDFA = iDMethodContext.getCfg().doDataFlowAnalysis(true);
        return !iDFA.checkNoUse(iDInstruction.getOffset(), iDVar.getId());
    }

    public static String generateNativeAddress(IDMethodContext iDMethodContext, IDExpression iDExpression) {
        String string = iDMethodContext.getMethodSignature();
        if (iDExpression == null) {
            return string;
        }
        int n2 = iDExpression.getPhysicalOffset();
        if (n2 < 0) {
            n2 = 0;
        }
        return Strings.ff("%s+%Xh", string, n2);
    }

    public static ICodeCoordinates generateNativeCoordinates(IDMethodContext iDMethodContext, IDExpression iDExpression) {
        int n2 = iDMethodContext.getMethod().getIndex();
        if (iDExpression == null) {
            return new MethodCoordinates(n2);
        }
        int n3 = iDExpression.getPhysicalOffset();
        if (n3 < 0) {
            n3 = 0;
        }
        return new InstructionCoordinates(n2, n3);
    }

    public static void verifyGraph(IDMethodContext iDMethodContext) {
        DUtil.verifyGraph(iDMethodContext, iDMethodContext.getMethodSignature());
    }

    public static void verifyGraph(IDMethodContext iDMethodContext, String string) {
        DUtil.verifyGraph(iDMethodContext, "failed", string);
    }

    public static void verifyGraph(IDMethodContext iDMethodContext, String string, String string2) {
        DUtil.verifyGraph(iDMethodContext, iDMethodContext.getCfg(), iDMethodContext.getExceptionData(), string, string2);
    }

    public static void verifyGraph(IDMethodContext iDMethodContext, CFG<IDInstruction> cFG, IDTryData iDTryData, String string, String string2) {
        try {
            DUtil.verifyInstructions(cFG, iDMethodContext);
            DUtil.verifyUnicity(cFG);
            CFGUtil.verify(cFG, true, true, true, true, false);
            DUtil.verifyBasicConsistency(cFG);
            if (iDTryData != null) {
                DUtil.verifyProtectedBlocks(cFG, iDTryData);
            }
        }
        catch (RuntimeException runtimeException) {
            if (string != null) {
                String string3 = "INFO: " + string2 + "\nERROR: " + runtimeException.getMessage();
                DUtil.dump(cFG, string, string3);
            }
            throw runtimeException;
        }
    }

    static void verifyInstructions(CFG<IDInstruction> cFG, IDMethodContext iDMethodContext) {
        long l2 = cFG.getFirstAddress();
        for (IDInstruction iDInstruction : cFG.instructions()) {
            iDInstruction.verify();
            if (iDMethodContext != null && iDInstruction.getContext() != iDMethodContext) {
                throw new IllegalStateException(Strings.ff("Unexpected context in instruction: 0x%X: %s", iDInstruction.getOffset(), iDInstruction));
            }
            if (iDInstruction.getOffset() < l2) {
                throw new IllegalStateException("Instruction is overlapping the previous instruction: " + iDInstruction);
            }
            if (iDInstruction.getSize() < 0) {
                throw new IllegalStateException("Instruction cannot have a 0 or negative size: " + iDInstruction);
            }
            long l3 = iDInstruction.getOffset() + (long)iDInstruction.getSize();
            if (iDInstruction.getOffsetEnd() != l3) {
                throw new IllegalStateException("Instruction size inconsistency: " + iDInstruction);
            }
            l2 = l3;
        }
    }

    public static int verifyUnicity(CFG<IDInstruction> cFG) {
        IdentityHashSet<IDExpression> identityHashSet = new IdentityHashSet<IDExpression>();
        for (IDInstruction iDInstruction : cFG.instructions()) {
            DUtil.verifyUnicity(iDInstruction, identityHashSet);
        }
        return identityHashSet.size();
    }

    public static int verifyUnicity(IDExpression iDExpression) {
        IdentityHashSet<IDExpression> identityHashSet = new IdentityHashSet<IDExpression>();
        return DUtil.verifyUnicity(iDExpression, identityHashSet);
    }

    private static int verifyUnicity(IDExpression iDExpression, Set<IDExpression> set) {
        ArrayList<IDExpression> arrayList = new ArrayList<IDExpression>();
        arrayList.add(iDExpression);
        while (!arrayList.isEmpty()) {
            IDExpression iDExpression2 = (IDExpression)arrayList.remove(0);
            if (!(iDExpression2 instanceof IDVar) && !set.add(iDExpression2)) {
                throw new IllegalStateException(Strings.ff("Duplicate found: %s (type:%s) in: %s", iDExpression2, iDExpression2.getClass().getSimpleName(), iDExpression));
            }
            if (iDExpression2 instanceof IDNewArrayInfo && ((IDNewArrayInfo)iDExpression2).areSubExpsAllImms()) continue;
            iDExpression2.collectSubExpressions(arrayList);
        }
        return set.size();
    }

    static void verifyBasicConsistency(CFG<IDInstruction> cFG) {
        LinkedHashSet<BasicBlock<IDInstruction>> linkedHashSet = new LinkedHashSet<BasicBlock<IDInstruction>>(cFG.getBlocksView());
        if (linkedHashSet.size() != cFG.size()) {
            throw new IllegalArgumentException("Duplicate blocks were found");
        }
        for (BasicBlock<IDInstruction> basicBlock : cFG) {
            for (BasicBlock<IDInstruction> n2 : basicBlock.getInputs()) {
                if (linkedHashSet.contains(n2)) continue;
                throw new IllegalArgumentException(Strings.ff("Input block not part of graph! %s", n2));
            }
            for (BasicBlock<IDInstruction> n2 : basicBlock.getOutputs()) {
                if (linkedHashSet.contains(n2)) continue;
                throw new IllegalArgumentException(Strings.ff("Output block not part of graph! %s", n2));
            }
            for (BasicBlock<IDInstruction> n2 : basicBlock.getIrregularInputs()) {
                if (linkedHashSet.contains(n2)) continue;
                throw new IllegalArgumentException(Strings.ff("Irr.input block not part of graph! %s", n2));
            }
            for (BasicBlock<IDInstruction> n2 : basicBlock.getIrregularOutputs()) {
                if (linkedHashSet.contains(n2)) continue;
                throw new IllegalArgumentException(Strings.ff("Irr.output block not part of graph! %s", n2));
            }
        }
        for (BasicBlock<IDInstruction> basicBlock : cFG) {
            Set<Long> set;
            long l2;
            long l3;
            Iterator<BasicBlock<IDInstruction>> iterator = (IDInstruction)basicBlock.getLast();
            int n2 = basicBlock.outsize();
            long l4 = basicBlock.getAddress();
            IFlowInformation iFlowInformation = iterator.getBreakingFlow();
            if (!iFlowInformation.isBroken()) {
                l3 = basicBlock.getEndAddress();
                if (n2 != 1) {
                    throw new IllegalArgumentException(Strings.ff("Block 0x%X: Expected a single fall-through block at 0x%X", l4, l3));
                }
                if (((BasicBlock)basicBlock.getOutputBlock(0)).getAddress() == l3) continue;
                throw new IllegalArgumentException(Strings.ff("Block 0x%X: The FT block is at 0x%X, whereas it should be at 0x%X", l4, ((BasicBlock)basicBlock.getOutputBlock(0)).getAddress(), l3));
            }
            if (n2 != iFlowInformation.getTargets().size()) {
                throw new IllegalArgumentException(Strings.ff("Block 0x%X: Found %d out-edges, expected %d", l4, n2, iFlowInformation.getTargets().size()));
            }
            if (n2 <= 0) continue;
            l3 = basicBlock.getOutputOffsets().get(0);
            if (l3 != (l2 = iFlowInformation.getTargets().get(0).getAddress())) {
                throw new IllegalArgumentException(Strings.ff("Block 0x%X: Unexpected target: 0x%X / 0x%X", l4, l3, l2));
            }
            HashSet<Long> hashSet = new HashSet<Long>(basicBlock.getOutputOffsets());
            if (hashSet.equals(set = iFlowInformation.getTargets().stream().map(iCodePointer -> iCodePointer.getAddress()).collect(Collectors.toSet()))) continue;
            throw new IllegalArgumentException(Strings.ff("Block 0x%X: Unexpected targets: %s / %s", l4, Longs.formatHexCollection(hashSet), Longs.formatHexCollection(set)));
        }
    }

    static void verifyProtectedBlocks(CFG<IDInstruction> cFG, IDTryData iDTryData) throws IllegalArgumentException {
        iDTryData.isEmpty();
        List<Integer> list = iDTryData.getProtectedBlocks();
        for (BasicBlock<IDInstruction> basicBlock : cFG) {
            int n2 = (int)basicBlock.getAddress();
            list.remove((Object)n2);
            List<IDExceptionHandler> list2 = iDTryData.getBlockHandlers(n2);
            List<Long> list3 = basicBlock.getIrregularOutputOffsets();
            if (list2.size() != list3.size()) {
                throw new IllegalArgumentException(Strings.ff("Ex: Block 0x%X: Mismatched count: handlers:%d, irredges:%d", n2, list2.size(), list3.size()));
            }
            int n3 = 0;
            for (IDExceptionHandler iDExceptionHandler : list2) {
                int n4 = list3.get(n3).intValue();
                if (iDExceptionHandler.getAddress() != n4) {
                    throw new IllegalArgumentException(Strings.ff("Ex: Block 0x%X: Mismatched address: 0x%X, 0x%X", n2, iDExceptionHandler.getAddress(), n4));
                }
                ++n3;
            }
        }
        if (!list.isEmpty()) {
            throw new IllegalArgumentException(Strings.ff("Ex: Protected block(s) not reflected in CFG: %s", Integers.formatHexIntegerCollection(list)));
        }
    }

    public static void dump(CFG<IDInstruction> cFG, String string) {
        DUtil.dump(cFG, string, null);
    }

    public static void dump(CFG<IDInstruction> cFG, String object, String string) {
        try {
            if (object == null || ((String)object).isEmpty()) {
                throw new RuntimeException("Provide a name!");
            }
            if (!((String)object).endsWith(".dot")) {
                object = (String)object + ".dot";
            }
            final IDMethodContext iDMethodContext = ((IDInstruction)((BasicBlock)cFG.get(0)).get(0)).getContext();
            final IDTryData iDTryData = iDMethodContext.getExceptionData();
            if (string == null) {
                string = iDMethodContext.getMethodSignature();
            }
            CFGUtil.DotFileGenerator dotFileGenerator = new CFGUtil.DotFileGenerator(cFG){

                @Override
                protected String generateIrregularEdgeLabel(IBasicBlock<? extends IInstruction> iBasicBlock, int n2) {
                    try {
                        IDExceptionHandler iDExceptionHandler = iDTryData.getBlockHandlers((int)iBasicBlock.getBase()).get(n2);
                        Assert.a(iDExceptionHandler.getAddress() == (int)iBasicBlock.getIrregularOutputBlock(n2).getBase());
                        int n3 = iDExceptionHandler.getTypeIndex();
                        if (n3 < 0) {
                            return "*";
                        }
                        IDexType iDexType = iDMethodContext.getDex().getType(n3);
                        String string = iDexType.getSignature(true, false, false);
                        if (string.endsWith("Exception")) {
                            string = string.substring(0, string.length() - 9);
                        }
                        return string;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }

                @Override
                protected String generateNodeBackgroundColor(IBasicBlock<? extends IInstruction> iBasicBlock) {
                    IDInstruction iDInstruction = (IDInstruction)iBasicBlock.getLast();
                    if (Boolean.TRUE.equals(iDInstruction.getData("KEEP_INSTRUCTION"))) {
                        return "orange";
                    }
                    return null;
                }
            };
            dotFileGenerator.setLineLimit(-60);
            dotFileGenerator.setTitle(string);
            dotFileGenerator.setGenerateBlockIndices(0);
            String string2 = dotFileGenerator.generate();
            File file = IO.createTempFile(IO.sanitizePathUnsafe((String)object));
            IO.writeFile(file, Strings.encodeUTF8(string2));
        }
        catch (IOException iOException) {}
    }

    public static boolean removeInstruction(BasicBlock<IDInstruction> basicBlock, int n2) {
        IDInstruction iDInstruction;
        int n3;
        IDInstruction iDInstruction2 = (IDInstruction)basicBlock.get(n2);
        if (iDInstruction2 == null) {
            throw new RuntimeException();
        }
        IDMethodContext iDMethodContext = iDInstruction2.getContext();
        if (basicBlock.size() >= 2) {
            n3 = iDInstruction2.getSize();
            if (n2 == 0) {
                iDInstruction = (IDInstruction)basicBlock.get(1);
                iDInstruction.setOffset(iDInstruction2.getOffset());
            } else {
                iDInstruction = (IDInstruction)basicBlock.get(n2 - 1);
            }
            iDInstruction.adjustSize(n3);
        }
        basicBlock.remove(n2);
        if (!basicBlock.isEmpty()) {
            return true;
        }
        if (basicBlock.outsize() != 1) {
            throw new RuntimeException();
        }
        n3 = (int)((BasicBlock)basicBlock.getOutputBlock(0)).getBase();
        iDInstruction = iDMethodContext.createJump(n3);
        iDInstruction.setOffset(iDInstruction2.getOffset());
        iDInstruction.setSize(iDInstruction2.getSize());
        basicBlock.add(iDInstruction);
        return false;
    }

    public static boolean removeUnreachableTrampoline(CFG<IDInstruction> cFG, BasicBlock<IDInstruction> basicBlock) {
        if (basicBlock.size() != 1 && !((IDInstruction)basicBlock.get(0)).isJumpOrJcond()) {
            throw new IllegalArgumentException("Not a trampoline");
        }
        IDMethodContext iDMethodContext = ((IDInstruction)basicBlock.get(0)).getContext();
        if (basicBlock.allinsize() != 0) {
            return false;
        }
        BasicBlock<IDInstruction> basicBlock2 = null;
        int n2 = (int)((IDInstruction)basicBlock.get(0)).getOffset();
        for (BasicBlock<IDInstruction> basicBlock3 : cFG) {
            if (basicBlock3 == basicBlock || basicBlock3.size() < 1 || ((IDInstruction)basicBlock3.getLast()).getOffsetEnd() != (long)n2) continue;
            basicBlock2 = basicBlock3;
            break;
        }
        if (basicBlock2 == null) {
            return false;
        }
        IDTryData iDTryData = iDMethodContext.getExceptionData();
        iDTryData.unprotectBlock((int)basicBlock.getAddress());
        cFG.removeBlock(basicBlock);
        ((IDInstruction)basicBlock2.getLast()).adjustSize(((IDInstruction)basicBlock.get(0)).getSize());
        return true;
    }

    public static CFG<IDInstruction> copyGraph(CFG<IDInstruction> cFG, boolean bl, IDMethodContext iDMethodContext) {
        CFG<IDInstruction> cFG2 = new CFG<IDInstruction>(cFG);
        if (iDMethodContext != null) {
            cFG2.setVariableInformationProvider(iDMethodContext);
        }
        if (bl) {
            for (BasicBlock<IDInstruction> basicBlock : cFG2) {
                for (int i = 0; i < basicBlock.size(); ++i) {
                    IDInstruction iDInstruction = ((IDInstruction)basicBlock.get(i)).duplicate();
                    if (iDMethodContext != null) {
                        iDInstruction.setContext(iDMethodContext);
                    }
                    basicBlock.set(i, iDInstruction);
                }
            }
        }
        return cFG2;
    }

    public static int normalizeGraph(IDMethodContext iDMethodContext) {
        return DUtil.normalizeGraph(iDMethodContext, 1);
    }

    public static int normalizeGraph(IDMethodContext iDMethodContext, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        CFG<IDInstruction> cFG = iDMethodContext.getCfg();
        int n3 = 0;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n4 = 0;
        for (IDInstruction object : cFG.instructions()) {
            if (object.getSize() != n2) {
                ++n3;
            }
            hashMap.put((int)object.getOffset(), n4);
            n4 += n2;
        }
        if (n3 == 0) {
            return 0;
        }
        n4 = 0;
        for (BasicBlock basicBlock : cFG) {
            for (IDInstruction iDInstruction : basicBlock) {
                iDInstruction.setSize(n2);
                iDInstruction.setOffset(n4);
                if (iDInstruction.getBreakingFlow().isBroken()) {
                    iDInstruction.updateTargets(hashMap);
                }
                n4 += n2;
            }
        }
        IDTryData iDTryData = iDMethodContext.getExceptionData();
        iDTryData.updateTargets(hashMap);
        cFG.invalidateDataFlowAnalysis();
        return n3;
    }

    /*
     * WARNING - void declaration
     */
    public static int modifyInstructionSizes(IDMethodContext iDMethodContext, Function<IDInstruction, Integer> function) {
        CFG<IDInstruction> cFG = iDMethodContext.getCfg();
        int n2 = 0;
        ArrayList<void> arrayList = new ArrayList<void>(cFG.getInstructionCount());
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n3 = 0;
        for (IDInstruction object2 : cFG.instructions()) {
            void var9_12;
            Integer n4 = function.apply(object2);
            if (n4 == null) {
                Integer n5 = object2.getSize();
            } else if (n4.intValue() != object2.getSize()) {
                ++n2;
            }
            arrayList.add(var9_12);
            hashMap.put((int)object2.getOffset(), n3);
            n3 += var9_12.intValue();
        }
        if (n2 == 0) {
            return 0;
        }
        int n4 = 0;
        n3 = 0;
        for (IDInstruction iDInstruction : cFG.instructions()) {
            int n6 = (Integer)arrayList.get(n4);
            iDInstruction.setSize(n6);
            iDInstruction.setOffset(n3);
            if (iDInstruction.getBreakingFlow().isBroken()) {
                iDInstruction.updateTargets(hashMap);
            }
            n3 += n6;
            ++n4;
        }
        IDTryData iDTryData = iDMethodContext.getExceptionData();
        iDTryData.updateTargets(hashMap);
        cFG.invalidateDataFlowAnalysis();
        return n2;
    }

    public static boolean modifyInstructionSize(IDMethodContext iDMethodContext, IDInstruction iDInstruction, int n2) {
        if (iDInstruction.getSize() < n2) {
            DUtil.modifyInstructionSizes(iDMethodContext, iDInstruction2 -> {
                if (iDInstruction2 == iDInstruction) {
                    return n2;
                }
                return null;
            });
            return true;
        }
        return false;
    }

    public static int updateTargets(IDMethodContext iDMethodContext, Map<Integer, Integer> map) {
        int n2 = 0;
        for (IDInstruction iDInstruction : iDMethodContext.getCfg().instructions()) {
            if (!iDInstruction.getBreakingFlow().isBroken()) continue;
            n2 += iDInstruction.updateTargets(map);
        }
        IDTryData iDTryData = iDMethodContext.getExceptionData();
        return n2 += iDTryData.updateTargets(map);
    }

    public static void insertHeaderBlock(IDMethodContext iDMethodContext, int n2, int n3) {
        Object object;
        int n4;
        int n5;
        Object object2;
        if (iDMethodContext == null || n2 < 0 || n3 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n2 == 0) {
            return;
        }
        int n6 = n2 * n3;
        int n7 = 1 + n6;
        CFG<IDInstruction> cFG = iDMethodContext.getCfg();
        IBasicBlock iBasicBlock = cFG.get(0);
        IDInstruction iDInstruction = (IDInstruction)((BasicBlock)iBasicBlock).get(0);
        if (iDInstruction.getSize() < n7) {
            object2 = new HashMap();
            n5 = 0;
            n4 = 0;
            for (IDInstruction object3 : cFG.instructions()) {
                object2.put((int)object3.getOffset(), n5);
                n5 = n4 == 0 ? n7 : ++n5;
                ++n4;
            }
            n5 = 0;
            n4 = 0;
            for (BasicBlock<IDInstruction> basicBlock : cFG) {
                for (IDInstruction iDInstruction2 : basicBlock) {
                    if (n4 == 0) {
                        iDInstruction2.setSize(n7);
                    } else {
                        iDInstruction2.setSize(1);
                    }
                    iDInstruction2.setOffset(n5);
                    if (iDInstruction2.getBreakingFlow().isBroken()) {
                        iDInstruction2.updateTargets((Map<Integer, Integer>)object2);
                    }
                    n5 += iDInstruction2.getSize();
                    ++n4;
                }
            }
            object = iDMethodContext.getExceptionData();
            object.updateTargets((Map<Integer, Integer>)object2);
        }
        object2 = new BasicBlock();
        n5 = 0;
        for (n4 = 0; n4 < n2; ++n4) {
            object = iDMethodContext.createNop().withOffset(n5).withSize(n3);
            ((BasicBlock)object2).add(object);
            n5 += n3;
        }
        cFG.addBlock(0, (BasicBlock<IDInstruction>)object2);
        cFG.addEdge((BasicBlock<IDInstruction>)object2, (BasicBlock<IDInstruction>)iBasicBlock);
        iDInstruction.adjustSize(-n6);
        iDInstruction.setOffset(n6);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        hashMap.put(0, n6);
        DUtil.updateTargets(iDMethodContext, hashMap);
        cFG.invalidateDataFlowAnalysis();
    }

    public static BasicBlock<IDInstruction> splitBlock(IDMethodContext iDMethodContext, BasicBlock<IDInstruction> basicBlock, int n2) {
        boolean bl = false;
        IDTryData iDTryData = iDMethodContext.getExceptionData();
        if (iDTryData.isProtectedBlock((int)basicBlock.getBase())) {
            bl = true;
        }
        BasicBlock<IDInstruction> basicBlock2 = iDMethodContext.getCfg().splitBlock(basicBlock, n2);
        if (bl) {
            iDTryData.copyProtectedBlock((int)basicBlock.getBase(), (int)basicBlock2.getBase());
        }
        return basicBlock2;
    }

    public static boolean mergeBlocks(IDMethodContext iDMethodContext, BasicBlock<IDInstruction> basicBlock) {
        int n2;
        BasicBlock<IDInstruction> basicBlock2 = basicBlock;
        if (basicBlock2.outsize() != 1 || ((IDInstruction)basicBlock2.getLast()).getBreakingFlow().isBroken()) {
            return false;
        }
        IBasicBlock iBasicBlock = basicBlock2.getOutputBlock(0);
        if (((BasicBlock)iBasicBlock).irrinsize() != 0 || ((BasicBlock)iBasicBlock).insize() != 1 || ((BasicBlock)iBasicBlock).getBase() != basicBlock2.getEndAddress()) {
            return false;
        }
        int n3 = (int)basicBlock2.getBase();
        int n4 = (int)((BasicBlock)iBasicBlock).getBase();
        IDTryData iDTryData = iDMethodContext.getExceptionData();
        if (basicBlock2.irroutsize() == 0) {
            if (((BasicBlock)iBasicBlock).irroutsize() != 0 && basicBlock2.canThrow()) {
                return false;
            }
            n2 = 1;
        } else if (((BasicBlock)iBasicBlock).irroutsize() == 0) {
            if (((BasicBlock)iBasicBlock).canThrow()) {
                return false;
            }
            n2 = 2;
        } else {
            if (!iDTryData.compareHandlers(n3, n4)) {
                return false;
            }
            n2 = 3;
        }
        basicBlock2.addAll(((BasicBlock)iBasicBlock).getInstructions());
        ((BasicBlock)iBasicBlock).removeAll();
        CFG<IDInstruction> cFG = iDMethodContext.getCfg();
        if (n2 == 1) {
            for (BasicBlock basicBlock3 : ((BasicBlock)iBasicBlock).getIrregularOutputs()) {
                cFG.addIrregularEdge(basicBlock2, basicBlock3, -1);
            }
            iDTryData.moveProtectedBlock(n4, n3);
        } else if (n2 != 2 && n2 == 3) {
            cFG.deleteIrregularOutEdges((BasicBlock<IDInstruction>)iBasicBlock);
            iDTryData.unprotectBlock(n4);
        }
        cFG.removeBlock((BasicBlock<IDInstruction>)iBasicBlock);
        return true;
    }

    public static SortedMap<Integer, Integer> generateBlockOffsetMap(IDMethodContext iDMethodContext) {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        for (BasicBlock<IDInstruction> basicBlock : iDMethodContext.getCfg()) {
            IDInstruction iDInstruction = (IDInstruction)basicBlock.get(0);
            int n2 = (int)iDInstruction.getOffset();
            int n3 = iDInstruction.getPhysicalOffset();
            treeMap.put(n2, n3);
        }
        return treeMap;
    }

    public static boolean isImmZero(IDExpression iDExpression) {
        return DUtil.isImmValue(iDExpression, 0L);
    }

    public static boolean isImmValue(IDExpression iDExpression, long l2) {
        try {
            return iDExpression instanceof IDImm && ((IDImm)iDExpression).toLong(true) == l2;
        }
        catch (DexDecEvaluationException dexDecEvaluationException) {
            return false;
        }
    }

    public static boolean isImmNonZero(IDExpression iDExpression) {
        try {
            return iDExpression instanceof IDImm && ((IDImm)iDExpression).toLong(true) != 0L;
        }
        catch (DexDecEvaluationException dexDecEvaluationException) {
            return false;
        }
    }

    public static IDInstruction nextInstruction(CFG<IDInstruction> cFG, BasicBlock<IDInstruction> iBasicBlock, int n2) {
        IDInstruction iDInstruction;
        ++n2;
        while (true) {
            if (n2 == iBasicBlock.size()) {
                if (iBasicBlock.outsize() != 1) {
                    return null;
                }
                iBasicBlock = iBasicBlock.getOutputBlock(0);
                n2 = 0;
            }
            if ((iDInstruction = (IDInstruction)iBasicBlock.get(n2)).isJump()) {
                iBasicBlock = cFG.getBlockAt(iDInstruction.getBranchTarget());
                n2 = 0;
                continue;
            }
            if (!iDInstruction.isNop()) break;
            ++n2;
        }
        return iDInstruction;
    }

    public static List<IDInstruction> unroll(IDMethodContext iDMethodContext, IDVar iDVar, long l3, long l4, int n3, int n4, int n5) {
        CFG<IDInstruction> cFG = iDMethodContext.getCfg();
        IDGlobalContext iDGlobalContext = iDMethodContext.getGlobalContext();
        HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
        boolean bl = false;
        ArrayList<IDInstruction> arrayList = new ArrayList<IDInstruction>();
        HashMap<Integer, IDImm> hashMap2 = new HashMap<Integer, IDImm>();
        long l5 = l3;
        for (int i = 0; l5 != l4 && i < n3 && arrayList.size() < n4; ++i) {
            IDInstruction iDInstruction = (IDInstruction)cFG.getInstruction(l5);
            if (iDInstruction == null) {
                return null;
            }
            Integer n6 = hashMap.compute(l5, (l2, n2) -> {
                if (n2 == null) {
                    return 1;
                }
                return n2 + 1;
            });
            if (n6 > n5) {
                bl = true;
            }
            Integer n7 = null;
            if (!iDInstruction.isNop()) {
                if (iDInstruction.isJump()) {
                    n7 = iDInstruction.getBranchTarget();
                } else {
                    Object object;
                    if (iDInstruction.isJcondOrSwitch()) {
                        object = iDInstruction.getVarIds();
                        if (object.size() != 1 || ((Integer)object.iterator().next()).intValue() != iDVar.getId()) {
                            return null;
                        }
                        try {
                            n7 = iDInstruction.evaluate(hashMap2);
                        }
                        catch (DexDecEvaluationException dexDecEvaluationException) {
                            return null;
                        }
                    }
                    if (iDInstruction.isAssign()) {
                        object = iDInstruction.getAssignDestination();
                        if (object.equals(iDVar)) {
                            IDExpression iDExpression = iDInstruction.getAssignSource();
                            if (DUtil.hasInvokeInfo(iDExpression) || DUtil.usesReferences(iDExpression)) {
                                return null;
                            }
                            try {
                                IDImm iDImm = iDExpression.evaluate(iDGlobalContext, hashMap2);
                                hashMap2.put(iDVar.getId(), iDImm);
                            }
                            catch (DexDecEvaluationException dexDecEvaluationException) {
                                return null;
                            }
                        }
                        if (bl && n6 >= 2) {
                            return null;
                        }
                        arrayList.add(iDInstruction);
                    } else if (iDInstruction.isInvoke()) {
                        if (bl && n6 >= 2) {
                            return null;
                        }
                        arrayList.add(iDInstruction);
                    } else {
                        return null;
                    }
                }
            }
            if (n7 == null) {
                n7 = (int)iDInstruction.getOffsetEnd();
            }
            l5 = n7.intValue();
        }
        if (l5 != l4) {
            return null;
        }
        return arrayList;
    }

    public static Collection<BasicBlock<IDInstruction>> determineInterval(BasicBlock<IDInstruction> basicBlock) {
        LinkedHashSet<BasicBlock<IDInstruction>> linkedHashSet = new LinkedHashSet<BasicBlock<IDInstruction>>();
        linkedHashSet.add(basicBlock);
        while (true) {
            BasicBlock basicBlock2 = null;
            block1: for (BasicBlock basicBlock3 : linkedHashSet) {
                for (BasicBlock basicBlock4 : basicBlock3.getAllOutputs()) {
                    if (linkedHashSet.contains(basicBlock4) || !linkedHashSet.containsAll(basicBlock4.getInputs()) || !linkedHashSet.containsAll(basicBlock4.getIrregularInputs())) continue;
                    basicBlock2 = basicBlock4;
                    break block1;
                }
            }
            if (basicBlock2 == null) break;
            linkedHashSet.add(basicBlock2);
        }
        return linkedHashSet;
    }

    public static boolean canThrow(BasicBlock<IDInstruction> basicBlock, int n2) {
        return DUtil.canThrow(basicBlock, n2, basicBlock.size());
    }

    public static boolean canThrow(BasicBlock<IDInstruction> basicBlock, int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            IDInstruction iDInstruction = (IDInstruction)basicBlock.get(i);
            if (!iDInstruction.canThrow()) continue;
            return true;
        }
        return false;
    }

    public static boolean isProtectedByCatchAll(IDMethodContext iDMethodContext, BasicBlock<IDInstruction> basicBlock) {
        if (basicBlock.irroutsize() == 0) {
            return false;
        }
        List<IDExceptionHandler> list = iDMethodContext.getExceptionData().getBlockHandlers((int)basicBlock.getBase());
        for (IDExceptionHandler iDExceptionHandler : list) {
            if (!iDExceptionHandler.isCatchAll(iDMethodContext)) continue;
            return true;
        }
        return false;
    }

    private static class CATDeterminer
    implements IDVisitor {
        IDexContextInfoProvider ciprv;
        ContextAccessType cat = ContextAccessType.NONE;

        CATDeterminer(IDexContextInfoProvider iDexContextInfoProvider) {
            this.ciprv = iDexContextInfoProvider;
        }

        @Override
        public void process(IDExpression iDExpression, IDExpression iDExpression2, IVisitResults<IDExpression> iVisitResults) {
            if (iDExpression instanceof IDCallInfo) {
                ContextAccessType contextAccessType = this.ciprv.getMethodCAT(((IDCallInfo)iDExpression).getMethodSignature());
                this.cat = this.cat.addAccess(contextAccessType);
                if (this.cat.isAllAccess()) {
                    iVisitResults.interrupt(true);
                }
            } else if (iDExpression instanceof IDArrayElt || iDExpression instanceof IDInstanceField || iDExpression instanceof IDStaticField) {
                this.cat = this.cat.addAccess(ContextAccessType.READ_ONLY);
                if (this.cat.isAllAccess()) {
                    iVisitResults.interrupt(true);
                }
            }
        }
    }
}

