/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.ir;

import com.pnfsoftware.jeb.core.units.code.android.ir.IDExpression;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDMethodContext;
import com.pnfsoftware.jeb.core.units.code.java.IJavaType;
import com.pnfsoftware.jeb.core.units.code.java.IJavaTypeFactory;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DTypeInfo {
    IDMethodContext ctx;
    List<TypingConlict> conflicts = new ArrayList<TypingConlict>();
    int unchanged;
    int changed;

    public DTypeInfo(IDMethodContext iDMethodContext) {
        if (iDMethodContext == null) {
            throw new IllegalArgumentException();
        }
        this.ctx = iDMethodContext;
    }

    public IDMethodContext getContext() {
        return this.ctx;
    }

    public IJavaTypeFactory getTypeFactory() {
        return this.ctx.getTypeFactory();
    }

    public void recordConflict(String string, IDExpression iDExpression, IJavaType iJavaType, IJavaType iJavaType2) {
        TypingConlict typingConlict = new TypingConlict(string, iDExpression, iJavaType, iJavaType2);
        this.conflicts.add(typingConlict);
    }

    public void resetCounters() {
        this.changed = 0;
        this.unchanged = 0;
    }

    public void reset() {
        this.resetCounters();
        this.conflicts.clear();
    }

    public int recordChanged() {
        ++this.changed;
        return this.changed;
    }

    public int getChangedCounter() {
        return this.changed;
    }

    public int recordUnchanged() {
        ++this.unchanged;
        return this.unchanged;
    }

    public int getUnchangedCounter() {
        return this.unchanged;
    }

    public List<TypingConlict> getConflicts() {
        return Collections.unmodifiableList(this.conflicts);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Strings.ff(stringBuilder, "TI:mods=%d,moot=%d", this.changed, this.unchanged);
        for (TypingConlict typingConlict : this.conflicts) {
            Strings.ff(stringBuilder, "\n- CONFLICT: %s", typingConlict);
        }
        return stringBuilder.toString();
    }

    public static class TypingConlict {
        String msg;
        IDExpression exp;
        IJavaType currentType;
        IJavaType wantedType;

        public TypingConlict(String string, IDExpression iDExpression, IJavaType iJavaType, IJavaType iJavaType2) {
            this.msg = string;
            this.exp = iDExpression;
            this.currentType = iJavaType;
            this.wantedType = iJavaType2;
        }

        public String getMessage() {
            return this.msg;
        }

        public IDExpression getExpression() {
            return this.exp;
        }

        public IJavaType getCurrentType() {
            return this.currentType;
        }

        public IJavaType getWantedType() {
            return this.wantedType;
        }

        public String toString() {
            return Strings.ff("%s: target=\"%s\", current_type=%s, wanted_type=%s", this.msg, this.exp, this.currentType, this.wantedType);
        }
    }
}

