/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.ir;

import com.pnfsoftware.jeb.core.units.code.android.ir.IDMethodContext;
import com.pnfsoftware.jeb.core.units.code.java.IJavaType;
import com.pnfsoftware.jeb.util.format.Strings;

public class DFormattingContext {
    private StringBuilder sb = new StringBuilder();
    private IDMethodContext ctx = null;
    private boolean usePreferredNames = false;
    private boolean displayTypes = true;
    private boolean displayCanThrow = true;

    public DFormattingContext() {
    }

    public DFormattingContext(IDMethodContext iDMethodContext) {
        this.setMethodContext(iDMethodContext);
    }

    public void setMethodContext(IDMethodContext iDMethodContext) {
        this.ctx = iDMethodContext;
    }

    public IDMethodContext getMethodContext() {
        return this.ctx;
    }

    public void setUsePreferredNames(boolean bl) {
        this.usePreferredNames = bl;
    }

    public boolean isUsePreferredNames() {
        return this.usePreferredNames;
    }

    public void setDisplayTypes(boolean bl) {
        this.displayTypes = bl;
    }

    public boolean isDisplayTypes() {
        return this.displayTypes;
    }

    public void setDisplayCanThrow(boolean bl) {
        this.displayCanThrow = bl;
    }

    public boolean isDisplayCanThrow() {
        return this.displayCanThrow;
    }

    public DFormattingContext append(Object object) {
        this.sb.append(object == null ? "null" : object.toString());
        return this;
    }

    public DFormattingContext append(String string) {
        this.sb.append(string);
        return this;
    }

    public DFormattingContext append(int n2) {
        this.sb.append(n2);
        return this;
    }

    public DFormattingContext append(char c2) {
        this.sb.append(c2);
        return this;
    }

    public DFormattingContext appendFormat(String string, Object ... objectArray) {
        Strings.ff(this.sb, string, objectArray);
        return this;
    }

    public void space() {
        this.sb.append(' ');
    }

    public void paren() {
        this.sb.append('(');
    }

    public void parenClose() {
        this.sb.append(')');
    }

    public void brace() {
        this.sb.append('{');
    }

    public void braceClose() {
        this.sb.append('}');
    }

    public void bracket() {
        this.sb.append('[');
    }

    public void bracketClose() {
        this.sb.append(']');
    }

    public void angle() {
        this.sb.append('<');
    }

    public void angleClose() {
        this.sb.append('>');
    }

    public void appendFormattedTypeIf(IJavaType iJavaType) {
        if (this.displayTypes) {
            this.appendFormattedType(iJavaType);
        }
    }

    public void appendFormattedType(IJavaType iJavaType) {
        this.angle();
        if (iJavaType == null) {
            this.append("unknown_type");
        } else {
            iJavaType.format(this);
        }
        this.angleClose();
    }

    public String toString() {
        return this.sb.toString();
    }
}

