/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.ir;

import com.pnfsoftware.jeb.core.units.code.android.controlflow.CFG;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDImm;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDInstruction;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDMethodContext;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDTryData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class DExecutionParameters {
    SortedMap<Integer, IDInstruction> insnmap;
    Map<Integer, Integer> dalvik2irmap;
    Map<Integer, Integer> ir2dalvikmap;
    CFG<IDInstruction> cfg;
    IDTryData exdata;
    Map<Integer, IDImm> initvals;
    public Integer pc;
    public Integer pcExpectedTermination;
    public Integer pcThresholdMin;
    public Integer pcThresholdMax;
    public Integer iterationCountLeft;

    public DExecutionParameters(SortedMap<Integer, IDInstruction> sortedMap) {
        this(sortedMap, null, null);
    }

    public DExecutionParameters(SortedMap<Integer, IDInstruction> sortedMap, Map<Integer, Integer> map, Map<Integer, Integer> map2) {
        if (sortedMap == null) {
            throw new IllegalArgumentException();
        }
        this.insnmap = sortedMap;
        this.dalvik2irmap = map;
        this.ir2dalvikmap = map2;
    }

    public DExecutionParameters(CFG<IDInstruction> cFG) {
        TreeMap<Integer, IDInstruction> treeMap = new TreeMap<Integer, IDInstruction>();
        cFG.getInstructions().forEach(iDInstruction -> treeMap.put((int)iDInstruction.getOffset(), (IDInstruction)iDInstruction));
        this.insnmap = treeMap;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (IDInstruction iDInstruction2 : cFG.instructions()) {
            hashMap.put(iDInstruction2.getPhysicalOffset(), (int)iDInstruction2.getOffset());
        }
        this.dalvik2irmap = hashMap;
    }

    public DExecutionParameters(IDMethodContext iDMethodContext) {
        this(iDMethodContext.getCfg(), iDMethodContext.getExceptionData());
    }

    public DExecutionParameters(CFG<IDInstruction> cFG, IDTryData iDTryData) {
        TreeMap<Integer, IDInstruction> treeMap = new TreeMap<Integer, IDInstruction>();
        cFG.getInstructions().forEach(iDInstruction -> treeMap.put((int)iDInstruction.getOffset(), (IDInstruction)iDInstruction));
        this.insnmap = treeMap;
        this.dalvik2irmap = null;
        this.cfg = cFG;
        this.exdata = iDTryData;
    }

    public Map<Integer, IDInstruction> getInstructionMap() {
        return this.insnmap;
    }

    public Map<Integer, Integer> getDalvikToIRMap() {
        return this.dalvik2irmap;
    }

    public Map<Integer, Integer> getIRToDalvikMap() {
        return this.ir2dalvikmap;
    }

    public CFG<IDInstruction> getCFG() {
        return this.cfg;
    }

    public IDTryData getExceptionData() {
        return this.exdata;
    }

    public Map<Integer, IDImm> getInitialValues() {
        if (this.initvals == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.initvals);
    }

    public void addInitialValue(int n2, IDImm iDImm) {
        if (this.initvals == null) {
            this.initvals = new HashMap<Integer, IDImm>();
        }
        this.initvals.put(n2, iDImm);
    }

    public void prepareIterations(Integer n2) {
        this.initvals = null;
        this.pc = null;
        this.pcExpectedTermination = null;
        this.pcThresholdMin = null;
        this.pcThresholdMax = null;
        this.iterationCountLeft = n2;
    }
}

