/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.ir;

import com.pnfsoftware.jeb.core.units.code.android.JvmFieldSig;
import com.pnfsoftware.jeb.core.units.code.android.JvmMethodSig;
import java.util.HashSet;
import java.util.Set;

public class DEmuExternalPolicy {
    public static final int RESTRICT_RANDOM = 1;
    public static final int RESTRICT_TIME = 2;
    public static final int RESTRICT_ENV = 4;
    static Set<String> random_classes = new HashSet<String>();
    static Set<String> random_methods = new HashSet<String>();
    static Set<String> random_fields = new HashSet<String>();
    static Set<String> time_classes;
    static Set<String> time_methods;
    static Set<String> time_fields;
    static Set<String> env_classes;
    static Set<String> env_methods;
    static Set<String> env_fields;
    private boolean defaultAllow = true;
    private int flags;
    private Set<String> restrictedClasses = new HashSet<String>();
    private Set<String> restrictedMethods = new HashSet<String>();
    private Set<String> restrictedFields = new HashSet<String>();
    private Set<String> whitelistedClasses = new HashSet<String>();
    private Set<String> whitelistedMethods = new HashSet<String>();
    private Set<String> whitelistedFields = new HashSet<String>();
    private Set<String> blacklistedClasses = new HashSet<String>();
    private Set<String> blacklistedMethods = new HashSet<String>();
    private Set<String> blacklistedFields = new HashSet<String>();

    public DEmuExternalPolicy() {
        this(true, true, true);
    }

    public DEmuExternalPolicy(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            this.flags |= 1;
        }
        if (bl2) {
            this.flags |= 2;
        }
        if (bl3) {
            this.flags |= 4;
        }
    }

    public void setDefaultAllow(boolean bl) {
        this.defaultAllow = bl;
    }

    public boolean isDefaultAllow() {
        return this.defaultAllow;
    }

    public void addRestricted(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (string.contains("->")) {
            if (string.contains(":")) {
                this.restrictedFields.add(string);
            } else {
                this.restrictedMethods.add(string);
            }
        }
        this.restrictedClasses.add(string);
    }

    public void addWhitelisted(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (string.contains("->")) {
            if (string.contains(":")) {
                this.whitelistedFields.add(string);
            } else {
                this.whitelistedMethods.add(string);
            }
        }
        this.whitelistedClasses.add(string);
    }

    public void addBlacklisted(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (string.contains("->")) {
            if (string.contains(":")) {
                this.blacklistedFields.add(string);
            } else {
                this.blacklistedMethods.add(string);
            }
        }
        this.blacklistedClasses.add(string);
    }

    public boolean canExecute(String string) {
        JvmMethodSig jvmMethodSig = JvmMethodSig.parse(string);
        if (this.blacklistedClasses.contains(jvmMethodSig.csig) || this.blacklistedMethods.contains(string)) {
            return false;
        }
        if (this.whitelistedClasses.contains(jvmMethodSig.csig) || this.whitelistedMethods.contains(string)) {
            return true;
        }
        if ((this.flags & 1) != 0) {
            if (random_classes.contains(jvmMethodSig.csig)) {
                return false;
            }
            if (random_methods.contains(string)) {
                return false;
            }
        }
        if ((this.flags & 2) != 0) {
            if (time_classes.contains(jvmMethodSig.csig)) {
                return false;
            }
            if (time_methods.contains(string)) {
                return false;
            }
        }
        if ((this.flags & 4) != 0) {
            if (env_classes.contains(jvmMethodSig.csig)) {
                return false;
            }
            if (env_methods.contains(string)) {
                return false;
            }
        }
        if (this.restrictedClasses.contains(jvmMethodSig.csig) || this.restrictedMethods.contains(string)) {
            return false;
        }
        return this.defaultAllow;
    }

    public boolean canAccess(String string) {
        JvmFieldSig jvmFieldSig = JvmFieldSig.parse(string);
        if (this.blacklistedClasses.contains(jvmFieldSig.csig) || this.blacklistedFields.contains(string)) {
            return false;
        }
        if (this.whitelistedClasses.contains(jvmFieldSig.csig) || this.whitelistedFields.contains(string)) {
            return true;
        }
        if ((this.flags & 1) != 0) {
            if (random_classes.contains(jvmFieldSig.csig)) {
                return false;
            }
            if (random_fields.contains(string)) {
                return false;
            }
        }
        if ((this.flags & 2) != 0) {
            if (time_classes.contains(jvmFieldSig.csig)) {
                return false;
            }
            if (time_fields.contains(string)) {
                return false;
            }
        }
        if ((this.flags & 4) != 0) {
            if (env_classes.contains(jvmFieldSig.csig)) {
                return false;
            }
            if (env_fields.contains(string)) {
                return false;
            }
        }
        if (this.restrictedClasses.contains(jvmFieldSig.csig) || this.restrictedFields.contains(string)) {
            return false;
        }
        return this.defaultAllow;
    }

    static {
        random_classes.add("Ljava/util/concurrent/ThreadLocalRandom;");
        random_methods.add("Ljava/lang/Math;->random()D");
        random_methods.add("Ljava/lang/StrictMath;->random()D");
        random_methods.add("Ljava/util/Random;-><init>()V");
        random_methods.add("Ljava/util/SplittableRandom;-><init>()V");
        random_methods.add("Ljava/security/SecureRandom;-><init>()V");
        random_methods.add("Ljava/security/SecureRandom;-><init>(Ljava/security/SecureRandomSpi;Ljava/security/Provider;)V");
        time_classes = new HashSet<String>();
        time_methods = new HashSet<String>();
        time_fields = new HashSet<String>();
        time_methods.add("Ljava/lang/System;->currentTimeMillis()J");
        time_methods.add("Ljava/lang/System;->nanoTime()J");
        time_methods.add("Ljava/time/Clock;->system(Ljava/time/ZoneId;)Ljava/time/Clock;");
        time_methods.add("Ljava/time/Clock;->systemDefaultZone()Ljava/time/Clock;");
        time_methods.add("Ljava/time/Clock;->systemUTC()Ljava/time/Clock;");
        time_methods.add("Ljava/time/Instant;->now()Ljava/time/Instant;");
        time_methods.add("Ljava/time/LocalDate;->now()Ljava/time/LocalDate;");
        time_methods.add("Ljava/time/LocalDate;->now(Ljava/time/ZoneId;)Ljava/time/LocalDate;");
        time_methods.add("Ljava/time/LocalDateTime;->now()Ljava/time/LocalDateTime;");
        time_methods.add("Ljava/time/LocalDateTime;->now(Ljava/time/ZoneId;)Ljava/time/LocalDateTime;");
        time_methods.add("Ljava/time/LocalTime;->now()Ljava/time/LocalTime;");
        time_methods.add("Ljava/time/LocalTime;->now(Ljava/time/ZoneId;)Ljava/time/LocalTime;");
        time_methods.add("Ljava/time/MonthDay;->now()Ljava/time/MonthDay;");
        time_methods.add("Ljava/time/MonthDay;->now(Ljava/time/ZoneId;)Ljava/time/MonthDay;");
        time_methods.add("Ljava/time/OffsetDateTime;->now()Ljava/time/OffsetDateTime;");
        time_methods.add("Ljava/time/OffsetDateTime;->now(Ljava/time/ZoneId;)Ljava/time/OffsetDateTime;");
        time_methods.add("Ljava/time/OffsetTime;->now()Ljava/time/OffsetTime;");
        time_methods.add("Ljava/time/OffsetTime;->now(Ljava/time/ZoneId;)Ljava/time/OffsetTime;");
        time_methods.add("Ljava/time/Year;->now()Ljava/time/Year;");
        time_methods.add("Ljava/time/Year;->now(Ljava/time/ZoneId;)Ljava/time/Year;");
        time_methods.add("Ljava/time/YearMonth;->now()Ljava/time/YearMonth;");
        time_methods.add("Ljava/time/YearMonth;->now(Ljava/time/ZoneId;)Ljava/time/YearMonth;");
        time_methods.add("Ljava/time/ZonedDateTime;->now()Ljava/time/ZonedDateTime;");
        time_methods.add("Ljava/time/ZoneId;->systemDefault()Ljava/time/ZoneId;");
        time_methods.add("Ljava/util/Calendar;->getInstance()Ljava/util/Calendar;");
        time_methods.add("Ljava/util/Calendar;->getInstance(Ljava/util/Locale;)Ljava/util/Calendar;");
        time_methods.add("Ljava/util/Calendar;->getInstance(Ljava/util/TimeZone;)Ljava/util/Calendar;");
        time_methods.add("Ljava/util/Calendar;->getInstance(Ljava/util/TimeZone;Ljava/util/Locale;)Ljava/util/Calendar;");
        time_methods.add("Landroid/os/SystemClock;->currentGnssTimeClock()Ljava/time/Clock;");
        time_methods.add("Landroid/os/SystemClock;->currentThreadTimeMillis()L");
        time_methods.add("Landroid/os/SystemClock;->elapsedRealtime()L");
        time_methods.add("Landroid/os/SystemClock;->elapsedRealtimeNanos()L");
        time_methods.add("Landroid/os/SystemClock;->uptimeMillis()L");
        env_classes = new HashSet<String>();
        env_methods = new HashSet<String>();
        env_fields = new HashSet<String>();
        env_methods.add("Ljava/lang/System;->getenv()Ljava/util/Map;");
        env_methods.add("Ljava/lang/System;->getenv(Ljava/lang/String;)Ljava/lang/String;");
        env_methods.add("Ljava/lang/System;->getProperties()Ljava/util/Properties;");
        env_methods.add("Ljava/lang/System;->getProperty(Ljava/lang/String;)Ljava/lang/String;");
        env_methods.add("Ljava/lang/System;->getProperty(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
        env_classes.add("Ljava/net/NetworkInterface;");
        env_classes.add("Landroid/os/Environment;");
        env_classes.add("Landroid/os/Build;");
        env_classes.add("Landroid/os/Build$Partition;");
        env_classes.add("Landroid/os/Build$VERSION;");
        env_classes.add("Landroid/os/Build$VERSION_CODES;");
        env_methods.add("Ljava/util/Locale;->getDefault()Ljava/util/Locale;");
        env_methods.add("Ljava/util/Locale;->getDefault(Ljava/util/Locale$Category;)Ljava/util/Locale;");
    }
}

