/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.ir;

import com.pnfsoftware.jeb.core.AbstractPlugin;
import com.pnfsoftware.jeb.core.EditablePluginInformation;
import com.pnfsoftware.jeb.core.units.code.IDFA;
import com.pnfsoftware.jeb.core.units.code.android.IDexDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.CFG;
import com.pnfsoftware.jeb.core.units.code.android.ir.DOptimizerType;
import com.pnfsoftware.jeb.core.units.code.android.ir.DUtil;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDGlobalContext;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDInstruction;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDMethodContext;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDOptimizer;
import com.pnfsoftware.jeb.core.units.code.java.IJavaOperatorFactory;
import com.pnfsoftware.jeb.core.units.code.java.IJavaTypeFactory;
import com.pnfsoftware.jeb.util.concurrent.Watchdog;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractDOptimizer
extends AbstractPlugin
implements IDOptimizer {
    public static final ILogger logger = GlobalLog.getLogger(AbstractDOptimizer.class);
    public IJavaTypeFactory tf;
    public IJavaOperatorFactory of;
    public IDGlobalContext g;
    public IDexUnit dex;
    public IDexDecompilerUnit decomp;
    public List<IDMethodContext> ctxlist;
    public IDMethodContext ctx;
    public CFG<IDInstruction> cfg;
    public IDFA<IDInstruction> dfa;
    private EditablePluginInformation info = new EditablePluginInformation();
    private DOptimizerType type;
    private Set<String> tags;
    private double priority = 0.0;
    private boolean enabled = true;
    private static final AtomicBoolean warnedDNU_removeInstruction = new AtomicBoolean();
    private static final AtomicBoolean warnedDNU_deleteUnreachableTrampoline = new AtomicBoolean();

    public AbstractDOptimizer() {
        this(null);
    }

    public AbstractDOptimizer(DOptimizerType dOptimizerType) {
        this(dOptimizerType, null);
    }

    public AbstractDOptimizer(DOptimizerType dOptimizerType, String string) {
        this.setType(dOptimizerType);
        this.setName(string);
    }

    protected void checkInterrupted() {
        Watchdog.verify(this.ctx == null ? null : this.ctx.getWatchdog());
    }

    @Override
    public EditablePluginInformation getPluginInformation() {
        return this.info;
    }

    protected void setName(String string) {
        int n2;
        if (string == null && (n2 = (string = this.getClass().getSimpleName()).indexOf(36)) >= 0) {
            string = string.substring(0, n2);
        }
        this.info.setName(string);
    }

    @Override
    public String getName() {
        return this.info.getName();
    }

    @Override
    public boolean isCollectionOptimizer() {
        return false;
    }

    protected void setType(DOptimizerType dOptimizerType) {
        if (dOptimizerType == null) {
            dOptimizerType = DOptimizerType.NORMAL;
        }
        this.type = dOptimizerType;
    }

    @Override
    public DOptimizerType getType() {
        return this.type;
    }

    protected void addTag(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (this.tags == null) {
            this.tags = new HashSet<String>();
        }
        this.tags.add(string);
    }

    protected void removeTag(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (this.tags == null) {
            return;
        }
        if (this.tags.remove(string) && this.tags.isEmpty()) {
            this.tags = null;
        }
    }

    @Override
    public Set<String> getTags() {
        if (this.tags == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.tags);
    }

    protected void setPriority(double d) {
        this.priority = d;
    }

    @Override
    public double getPriority() {
        return this.priority;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public final int perform(IDMethodContext iDMethodContext) {
        if (iDMethodContext != null) {
            this.assignLocalFields(iDMethodContext);
        }
        return this.perform();
    }

    public abstract int perform();

    @Override
    public int performOnCollection(List<IDMethodContext> list, Map<IDMethodContext, Integer> map) {
        throw new RuntimeException();
    }

    public void assignLocalFields(IDMethodContext iDMethodContext) {
        this.ctx = iDMethodContext;
        if (this.ctx == null) {
            this.cfg = null;
            this.g = null;
            this.dex = null;
            this.decomp = null;
            this.tf = null;
            this.of = null;
        } else {
            this.cfg = this.ctx.getCfg();
            this.g = this.ctx.getGlobalContext();
            this.dex = this.g.getDex();
            this.decomp = this.g.getDecompiler();
            this.tf = this.g.getTypeFactory();
            this.of = this.g.getOperatorFactory();
        }
    }

    public void resetLocalFields() {
        this.assignLocalFields(null);
    }

    protected IDFA<IDInstruction> analyzeChains(boolean bl) {
        this.dfa = this.cfg.doDataFlowAnalysis(bl);
        return this.dfa;
    }

    protected IDFA<IDInstruction> analyzeChains() {
        return this.analyzeChains(false);
    }

    protected void invalidateChains() {
        this.cfg.invalidateDataFlowAnalysis();
        this.dfa = null;
    }

    @Deprecated
    protected boolean removeInstruction(BasicBlock<IDInstruction> basicBlock, int n2) {
        if (warnedDNU_removeInstruction.compareAndSet(false, true)) {
            logger.warn("AbstractDOptimizer.removeInstruction is deprecated and will be removed in JEB 4.26. Please use DUtil.removeInstruction method instead.", new Object[0]);
        }
        return DUtil.removeInstruction(basicBlock, n2);
    }

    @Deprecated
    protected boolean deleteUnreachableTrampoline(BasicBlock<IDInstruction> basicBlock) {
        if (warnedDNU_deleteUnreachableTrampoline.compareAndSet(false, true)) {
            logger.warn("AbstractDOptimizer.deleteUnreachableTrampoline is deprecated and will be removed in JEB 4.26. Please use DUtil.removeUnreachableTrampoline method instead.", new Object[0]);
        }
        return DUtil.removeUnreachableTrampoline(this.cfg, basicBlock);
    }

    protected int cleanGraph() {
        return this.cleanGraph(true, true);
    }

    protected int cleanGraph(boolean bl, boolean bl2) {
        int n2 = 0;
        if (bl) {
            n2 += DUtil.removeUnreachableBlocks(this.ctx);
        }
        if (bl2) {
            n2 += DUtil.simplifyJCondsAndSwitches(this.ctx);
        }
        return n2;
    }
}

