/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.ir;

import com.pnfsoftware.jeb.core.AbstractPlugin;
import com.pnfsoftware.jeb.core.EditablePluginInformation;
import com.pnfsoftware.jeb.core.units.code.android.IDexDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.ir.DOptimizerType;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDGlobalContext;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDMethodContext;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDOptimizer;
import com.pnfsoftware.jeb.core.units.code.java.IJavaOperatorFactory;
import com.pnfsoftware.jeb.core.units.code.java.IJavaTypeFactory;
import com.pnfsoftware.jeb.util.concurrent.Watchdog;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDCollectionOptimizer
extends AbstractPlugin
implements IDOptimizer {
    public static final ILogger logger = GlobalLog.getLogger(AbstractDCollectionOptimizer.class);
    public IJavaTypeFactory tf;
    public IJavaOperatorFactory of;
    public IDGlobalContext g;
    public IDexUnit dex;
    public IDexDecompilerUnit decomp;
    public List<IDMethodContext> ctxlist;
    private EditablePluginInformation info = new EditablePluginInformation();
    private DOptimizerType type;
    private Set<String> tags;
    private double priority = 0.0;
    private boolean enabled = true;
    Map<IDMethodContext, Integer> pmcntmap = new HashMap<IDMethodContext, Integer>();

    public AbstractDCollectionOptimizer() {
        this(null);
    }

    public AbstractDCollectionOptimizer(DOptimizerType dOptimizerType) {
        this(dOptimizerType, null);
    }

    public AbstractDCollectionOptimizer(DOptimizerType dOptimizerType, String string) {
        this.setType(dOptimizerType);
        this.setName(string);
    }

    protected void checkInterrupted() {
        Watchdog.verify(null);
    }

    @Override
    public EditablePluginInformation getPluginInformation() {
        return this.info;
    }

    protected void setName(String string) {
        int n2;
        if (string == null && (n2 = (string = this.getClass().getSimpleName()).indexOf(36)) >= 0) {
            string = string.substring(0, n2);
        }
        this.info.setName(string);
    }

    @Override
    public String getName() {
        return this.info.getName();
    }

    @Override
    public boolean isCollectionOptimizer() {
        return true;
    }

    protected void setType(DOptimizerType dOptimizerType) {
        if (dOptimizerType == null) {
            dOptimizerType = DOptimizerType.NORMAL;
        }
        this.type = dOptimizerType;
    }

    @Override
    public DOptimizerType getType() {
        return this.type;
    }

    protected void addTag(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (this.tags == null) {
            this.tags = new HashSet<String>();
        }
        this.tags.add(string);
    }

    protected void removeTag(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (this.tags == null) {
            return;
        }
        if (this.tags.remove(string) && this.tags.isEmpty()) {
            this.tags = null;
        }
    }

    @Override
    public Set<String> getTags() {
        if (this.tags == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.tags);
    }

    protected void setPriority(double d) {
        this.priority = d;
    }

    @Override
    public double getPriority() {
        return this.priority;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public final int performOnCollection(List<IDMethodContext> list, Map<IDMethodContext, Integer> map) {
        if (list != null) {
            this.assignLocalFields(list);
        }
        this.pmcntmap = map;
        return this.performOnCollection();
    }

    @Override
    public int perform(IDMethodContext iDMethodContext) {
        throw new RuntimeException();
    }

    protected void recordMethodOptimization(IDMethodContext iDMethodContext2, int n2) {
        if (this.pmcntmap != null && iDMethodContext2 != null && n2 > 0) {
            this.pmcntmap.compute(iDMethodContext2, (iDMethodContext, n3) -> n3 == null ? n2 : n3 + n2);
        }
    }

    public abstract int performOnCollection();

    public void assignLocalFields(List<IDMethodContext> list) {
        IDMethodContext iDMethodContext;
        this.ctxlist = list;
        IDMethodContext iDMethodContext2 = iDMethodContext = this.ctxlist == null || this.ctxlist.isEmpty() ? null : this.ctxlist.get(0);
        if (iDMethodContext == null) {
            this.g = null;
            this.dex = null;
            this.decomp = null;
            this.tf = null;
            this.of = null;
        } else {
            this.g = iDMethodContext.getGlobalContext();
            this.dex = this.g.getDex();
            this.decomp = this.g.getDecompiler();
            this.tf = this.g.getTypeFactory();
            this.of = this.g.getOperatorFactory();
        }
    }

    public void resetLocalFields() {
        this.assignLocalFields(null);
    }
}

