/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.dex;

import com.pnfsoftware.jeb.core.units.code.android.dex.DalvikParserErrorType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class DalvikParserError {
    @SerId(value=1)
    private DalvikParserErrorType errorType;
    @SerId(value=2)
    private int bytecodeOffset;

    public DalvikParserError(DalvikParserErrorType dalvikParserErrorType) {
        this(dalvikParserErrorType, -1);
    }

    public DalvikParserError(DalvikParserErrorType dalvikParserErrorType, int n2) {
        if (dalvikParserErrorType == null) {
            throw new IllegalArgumentException();
        }
        this.errorType = dalvikParserErrorType;
        this.bytecodeOffset = n2;
    }

    public DalvikParserErrorType getErrorType() {
        return this.errorType;
    }

    public int getBytecodeOffset() {
        return this.bytecodeOffset;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.bytecodeOffset;
        n2 = 31 * n2 + (this.errorType == null ? 0 : this.errorType.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DalvikParserError dalvikParserError = (DalvikParserError)object;
        if (this.bytecodeOffset != dalvikParserError.bytecodeOffset) {
            return false;
        }
        return this.errorType == dalvikParserError.errorType;
    }

    public String toString() {
        if (this.bytecodeOffset < 0) {
            return this.errorType.toString();
        }
        return Strings.ff("%s@0x%X", new Object[]{this.errorType, this.bytecodeOffset});
    }
}

