/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.controlflow;

import com.pnfsoftware.jeb.core.units.code.AddressableInstruction;
import com.pnfsoftware.jeb.core.units.code.DFA4;
import com.pnfsoftware.jeb.core.units.code.IBasicBlock;
import com.pnfsoftware.jeb.core.units.code.ICodePointer;
import com.pnfsoftware.jeb.core.units.code.IControlFlowGraph;
import com.pnfsoftware.jeb.core.units.code.IDFA;
import com.pnfsoftware.jeb.core.units.code.IFlowInformation;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.ILocatedInstruction;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.BasicBlockBuilder;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.IVariableInformationProvider;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.IrregularFlowData;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.collect.CollectionUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

@Ser
public class CFG<InsnType extends ILocatedInstruction>
implements IControlFlowGraph<InsnType, BasicBlock<InsnType>>,
Iterable<BasicBlock<InsnType>> {
    public static final AtomicInteger cfgfwccnt = new AtomicInteger();
    private static final long entry = 0L;
    private static final boolean allowUnreachableBlocks = false;
    @SerId(value=1)
    private List<BasicBlock<InsnType>> bblist = null;
    @SerId(value=5)
    private int defaultCollectionFlags = 3;
    @SerId(value=6)
    private boolean defaultIntegrateInputs = true;
    @SerTransient
    IVariableInformationProvider varInfoProvider;
    @SerTransient
    List<IDFA<InsnType>> dfaObjects;

    public CFG(Collection<BasicBlockBuilder<InsnType>> collection) {
        this.bblist = new ArrayList<BasicBlock<InsnType>>(collection.size());
        HashMap<Long, BasicBlock<InsnType>> hashMap = new HashMap<Long, BasicBlock<InsnType>>();
        for (BasicBlockBuilder<InsnType> basicBlockBuilder : collection) {
            BasicBlock basicBlock = new BasicBlock();
            basicBlock.insns = basicBlockBuilder.insns;
            basicBlock.dst_offsets = basicBlockBuilder.dst_offsets;
            basicBlock.irrdst_offsets = basicBlockBuilder.irrdst_offsets;
            this.bblist.add(basicBlock);
            for (ILocatedInstruction iLocatedInstruction : basicBlock.insns) {
                hashMap.put(iLocatedInstruction.getOffset(), basicBlock);
            }
        }
        this.buildGraphSecondPass(hashMap);
    }

    public CFG(List<InsnType> list, List<IrregularFlowData> list2) {
        this.buildGraph(list, list2);
    }

    public CFG(CFG<InsnType> cFG) {
        this.defaultCollectionFlags = cFG.defaultCollectionFlags;
        this.defaultIntegrateInputs = cFG.defaultIntegrateInputs;
        this.varInfoProvider = null;
        this.dfaObjects = null;
        this.buildGraph(cFG.getInstructions(), cFG.generateIrregularFlowDataObjects());
    }

    @Override
    public BasicBlock<InsnType> get(int n2) {
        return this.bblist.get(n2);
    }

    @Override
    public int indexOf(BasicBlock<InsnType> basicBlock) {
        return this.bblist.indexOf(basicBlock);
    }

    public BasicBlock<InsnType> getLast() {
        return this.bblist.get(this.bblist.size() - 1);
    }

    @Override
    public int size() {
        return this.bblist.size();
    }

    @Override
    public long getEntryAddress() {
        return 0L;
    }

    @Override
    public long getFirstAddress() {
        return this.bblist.get(0).getFirstAddress();
    }

    @Override
    public long getLastAddress() {
        return this.bblist.get(this.bblist.size() - 1).getLastAddress();
    }

    @Override
    public long getEndAddress() {
        return this.bblist.get(this.bblist.size() - 1).getEndAddress();
    }

    @Override
    public int getEffectiveSize() {
        int n2 = 0;
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            n2 += (int)(basicBlock.getEndAddress() - basicBlock.getFirstAddress());
        }
        return n2;
    }

    @Override
    public BasicBlock<InsnType> getBlock(int n2) {
        return this.bblist.get(n2);
    }

    @Override
    public List<BasicBlock<InsnType>> getBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.bblist);
    }

    @Override
    public List<BasicBlock<InsnType>> getBlocksView() {
        return Collections.unmodifiableList(this.bblist);
    }

    @Override
    public BasicBlock<InsnType> getBlockAt(long l2) {
        int n2 = this.getBlockIndex(l2);
        return n2 < 0 ? null : this.bblist.get(n2);
    }

    public int getBlockIndex(long l2) {
        int n2 = 0;
        int n3 = this.bblist.size();
        while (n3 > n2) {
            int n4 = n2 + (n3 - n2) / 2;
            BasicBlock<InsnType> basicBlock = this.bblist.get(n4);
            if (l2 < basicBlock.getFirstAddress()) {
                n3 = n4;
                continue;
            }
            if (l2 >= basicBlock.getEndAddress()) {
                n2 = n4 + 1;
                continue;
            }
            return l2 == basicBlock.getFirstAddress() ? n4 : -1;
        }
        return -1;
    }

    @Override
    public BasicBlock<InsnType> getBlockEndingAt(long l2) {
        int n2 = 0;
        int n3 = this.bblist.size();
        while (n3 > n2) {
            int n4 = n2 + (n3 - n2) / 2;
            BasicBlock<InsnType> basicBlock = this.bblist.get(n4);
            if (l2 <= basicBlock.getFirstAddress()) {
                n3 = n4;
                continue;
            }
            if (l2 > basicBlock.getEndAddress()) {
                n2 = n4 + 1;
                continue;
            }
            return l2 == basicBlock.getEndAddress() ? basicBlock : null;
        }
        return null;
    }

    @Override
    public BasicBlock<InsnType> getBlockContaining(long l2) {
        int n2 = 0;
        int n3 = this.bblist.size();
        while (n3 > n2) {
            int n4 = n2 + (n3 - n2) / 2;
            BasicBlock<InsnType> basicBlock = this.bblist.get(n4);
            if (l2 < basicBlock.getFirstAddress()) {
                n3 = n4;
                continue;
            }
            if (l2 >= basicBlock.getEndAddress()) {
                n2 = n4 + 1;
                continue;
            }
            return basicBlock;
        }
        return null;
    }

    @Override
    public BasicBlock<InsnType> getEntryBlock() {
        IBasicBlock iBasicBlock = this.getBlockAt(0L);
        if (iBasicBlock == null) {
            throw new RuntimeException("Cannot find the entry block");
        }
        return iBasicBlock;
    }

    @Override
    public List<BasicBlock<InsnType>> getExitBlocks() {
        ArrayList<BasicBlock<InsnType>> arrayList = new ArrayList<BasicBlock<InsnType>>(1);
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (!basicBlock.getOutputBlocks().isEmpty()) continue;
            arrayList.add(basicBlock);
        }
        return arrayList;
    }

    @Override
    public BasicBlock<InsnType> getBlockByLastAddress(long l2) {
        IBasicBlock iBasicBlock = this.getBlockContaining(l2);
        if (iBasicBlock != null && ((BasicBlock)iBasicBlock).getLastAddress() == l2) {
            return iBasicBlock;
        }
        return null;
    }

    public boolean hasExit() {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (!basicBlock.getOutputBlocks().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNoExit() {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (!basicBlock.getOutputBlocks().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public TreeMap<Long, BasicBlock<InsnType>> getAddressBlockMap() {
        TreeMap<Long, BasicBlock<InsnType>> treeMap = new TreeMap<Long, BasicBlock<InsnType>>();
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            treeMap.put(basicBlock.get(0).getOffset(), basicBlock);
        }
        return treeMap;
    }

    public BasicBlock<InsnType> getBlockFor(InsnType InsnType) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (!basicBlock.insns.contains(InsnType)) continue;
            return basicBlock;
        }
        return null;
    }

    @Override
    public int getInstructionCount() {
        int n2 = 0;
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            n2 += basicBlock.size();
        }
        return n2;
    }

    public InsnType getInstructionAt(long l2) {
        return (InsnType)this.getInstruction(l2);
    }

    @Override
    public InsnType getInstruction(long l2) {
        IBasicBlock iBasicBlock = this.getBlockContaining(l2);
        if (iBasicBlock != null) {
            return (InsnType)((BasicBlock)iBasicBlock).getInstruction(l2);
        }
        return null;
    }

    @Override
    public Couple<BasicBlock<InsnType>, Integer> getInstructionLocation(long l2) {
        return this.getInstructionLocation(l2, true);
    }

    public Couple<BasicBlock<InsnType>, Integer> getInstructionLocation(long l2, boolean bl) {
        IBasicBlock iBasicBlock = this.getBlockContaining(l2);
        if (iBasicBlock == null) {
            return null;
        }
        int n2 = ((BasicBlock)iBasicBlock).getIndexOfInstruction(l2, bl);
        if (n2 < 0) {
            return null;
        }
        return new Couple<IBasicBlock, Integer>(iBasicBlock, n2);
    }

    public boolean containsInstruction(InsnType InsnType) {
        Couple<BasicBlock<InsnType>, Integer> couple = this.getInstructionLocation(InsnType.getOffset());
        if (couple == null) {
            return false;
        }
        return couple.getFirst().get(couple.getSecond()) == InsnType;
    }

    @Override
    public List<InsnType> getInstructions() {
        ArrayList arrayList = new ArrayList(this.getInstructionCount());
        this.bblist.forEach(basicBlock -> arrayList.addAll(basicBlock.insns));
        return arrayList;
    }

    public TreeMap<Long, InsnType> getInstructionSet() {
        TreeMap<Long, ILocatedInstruction> treeMap = new TreeMap<Long, ILocatedInstruction>();
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            for (ILocatedInstruction iLocatedInstruction : basicBlock.insns) {
                treeMap.put(iLocatedInstruction.getOffset(), iLocatedInstruction);
            }
        }
        return treeMap;
    }

    @Override
    public Iterator<BasicBlock<InsnType>> iterator() {
        return this.bblist.iterator();
    }

    @Override
    public Iterable<InsnType> instructions() {
        return new Iterable<InsnType>(){

            @Override
            public Iterator<InsnType> iterator() {
                return new InstructionsIterator();
            }
        };
    }

    public Iterable<InsnType> instructions(final long l2) {
        return new Iterable<InsnType>(){

            @Override
            public Iterator<InsnType> iterator() {
                Couple couple = CFG.this.getInstructionLocation(l2);
                if (couple == null) {
                    return new InstructionsIterator(null, 0);
                }
                return new InstructionsIterator(couple.getFirst(), couple.getSecond());
            }
        };
    }

    @Override
    public Iterable<AddressableInstruction<InsnType>> addressableInstructions() {
        return new Iterable<AddressableInstruction<InsnType>>(){

            @Override
            public Iterator<AddressableInstruction<InsnType>> iterator() {
                return new AddressableInstructionsIterator();
            }
        };
    }

    public Iterable<BasicBlock<InsnType>> handlers() {
        return new Iterable<BasicBlock<InsnType>>(){

            @Override
            public Iterator<BasicBlock<InsnType>> iterator() {
                return new HandlersIterator();
            }
        };
    }

    @Override
    public void getGraphRepresentation(List<int[]> list, List<int[]> list2) {
        list.clear();
        list2.clear();
        LinkedHashMap<BasicBlock<InsnType>, Integer> linkedHashMap = new LinkedHashMap<BasicBlock<InsnType>, Integer>();
        int n2 = 1;
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            linkedHashMap.put(basicBlock, n2);
            ++n2;
        }
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            BasicBlock basicBlock2;
            int n3;
            for (n3 = basicBlock.dst.size() - 1; n3 >= 0; --n3) {
                basicBlock2 = basicBlock.dst.get(n3);
                list.add(new int[]{(Integer)linkedHashMap.get(basicBlock), (Integer)linkedHashMap.get(basicBlock2)});
            }
            for (n3 = basicBlock.irrdst.size() - 1; n3 >= 0; --n3) {
                basicBlock2 = basicBlock.irrdst.get(n3);
                list2.add(new int[]{(Integer)linkedHashMap.get(basicBlock), (Integer)linkedHashMap.get(basicBlock2)});
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void buildGraph(List<InsnType> list, List<IrregularFlowData> list2) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("No instructions");
        }
        if (((ILocatedInstruction)list.get(0)).getOffset() != 0L) {
            throw new IllegalArgumentException("First instruction must have offset 0");
        }
        Collections.sort(list, new Comparator<InsnType>(){

            @Override
            public int compare(InsnType InsnType, InsnType InsnType2) {
                return Long.compare(InsnType.getOffset(), InsnType2.getOffset());
            }
        });
        ILocatedInstruction iLocatedInstruction = (ILocatedInstruction)list.get(list.size() - 1);
        long l2 = iLocatedInstruction.getOffset() + (long)iLocatedInstruction.getSize();
        HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            hashMap.put(((ILocatedInstruction)list.get(i)).getOffset(), i);
        }
        Set set = null;
        this.bblist = new ArrayList<BasicBlock<InsnType>>();
        HashMap<Long, BasicBlock<InsnType>> hashMap2 = new HashMap<Long, BasicBlock<InsnType>>();
        ArrayDeque<Long> arrayDeque = new ArrayDeque<Long>();
        arrayDeque.push(0L);
        int n2 = 0;
        block1: while (true) {
            Object object;
            if (!arrayDeque.isEmpty()) {
                Object object2;
                long l3 = (Long)arrayDeque.pop();
                object = (BasicBlock)hashMap2.get(l3);
                if (object != null) {
                    if (((ILocatedInstruction)((BasicBlock)object).insns.get(0)).getOffset() == l3) continue;
                    int n3 = -1;
                    int n4 = 0;
                    for (ILocatedInstruction iLocatedInstruction2 : ((BasicBlock)object).insns) {
                        if (iLocatedInstruction2.getOffset() == l3) {
                            n3 = n4;
                            break;
                        }
                        ++n4;
                    }
                    if (n3 < 0) {
                        throw new RuntimeException("Cannot split basic block");
                    }
                    object2 = new BasicBlock();
                    this.bblist.add((BasicBlock<InsnType>)object2);
                    for (n4 = n3; n4 < ((BasicBlock)object).insns.size(); ++n4) {
                        ILocatedInstruction iLocatedInstruction2;
                        iLocatedInstruction2 = (ILocatedInstruction)((BasicBlock)object).insns.get(n4);
                        ((BasicBlock)object2).insns.add(iLocatedInstruction2);
                        hashMap2.put(iLocatedInstruction2.getOffset(), (BasicBlock<InsnType>)object2);
                    }
                    ((BasicBlock)object2).dst_offsets = new ArrayList<Long>(((BasicBlock)object).dst_offsets);
                    int n5 = ((BasicBlock)object).insns.size() - n3;
                    for (n4 = 0; n4 < n5; ++n4) {
                        ((BasicBlock)object).insns.remove(n3);
                    }
                    ((BasicBlock)object).dst_offsets.clear();
                    ((BasicBlock)object).dst_offsets.add(l3);
                    continue;
                }
                object = new BasicBlock();
                this.bblist.add((BasicBlock<InsnType>)object);
                while (true) {
                    BasicBlock basicBlock;
                    if ((basicBlock = (BasicBlock)hashMap2.get(l3)) != null) {
                        if (((BasicBlock)object).insns.isEmpty()) {
                            throw new RuntimeException("Unexpected empty basic block");
                        }
                        ((BasicBlock)object).dst_offsets.add(((ILocatedInstruction)basicBlock.insns.get(0)).getOffset());
                        continue block1;
                    }
                    Integer n6 = (Integer)hashMap.get(l3);
                    if (n6 == null) {
                        throw new RuntimeException(Strings.ff("Failed converting index to offset: offset=0x%X", l3));
                    }
                    object2 = (ILocatedInstruction)list.get(n6);
                    if (set != null) {
                        set.remove(l3);
                    }
                    ((BasicBlock)object).insns.add(object2);
                    hashMap2.put(l3, (BasicBlock<InsnType>)object);
                    IFlowInformation iFlowInformation = object2.getBreakingFlow();
                    if (iFlowInformation.isBroken()) {
                        Iterator<ICodePointer> iterator = iFlowInformation.getTargets().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block1;
                            ICodePointer iCodePointer = iterator.next();
                            if (iCodePointer.isUnknownAddress()) {
                                throw new RuntimeException("TBI: unknown address");
                            }
                            ((BasicBlock)object).dst_offsets.add(iCodePointer.getAddress());
                            arrayDeque.push(iCodePointer.getAddress());
                        }
                    }
                    l3 += (long)object2.getSize();
                }
            }
            if (list2 == null || n2 > 0) {
                if (set == null || set.isEmpty()) break;
                long l4 = (Long)set.iterator().next();
                arrayDeque.add(l4);
                continue;
            }
            for (IrregularFlowData irregularFlowData : list2) {
                arrayDeque.push(irregularFlowData.target);
                arrayDeque.push(irregularFlowData.first);
                object = (ILocatedInstruction)list.get((Integer)hashMap.get(irregularFlowData.last));
                long l5 = object.getOffset() + (long)object.getSize();
                if (l5 >= l2) continue;
                arrayDeque.push(l5);
            }
            ++n2;
        }
        if (list2 != null) {
            for (IrregularFlowData irregularFlowData : list2) {
                for (BasicBlock basicBlock : this.bblist) {
                    long l6 = ((ILocatedInstruction)basicBlock.insns.get(0)).getOffset();
                    if (l6 < irregularFlowData.first || l6 > irregularFlowData.last) continue;
                    basicBlock.irrdst_offsets.add(irregularFlowData.target);
                }
            }
        }
        this.buildGraphSecondPass(hashMap2);
    }

    public List<IrregularFlowData> generateIrregularFlowDataObjects() {
        ArrayList<IrregularFlowData> arrayList = new ArrayList<IrregularFlowData>();
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (basicBlock.irrdst == null) continue;
            for (BasicBlock basicBlock2 : basicBlock.irrdst) {
                arrayList.add(new IrregularFlowData(basicBlock.getFirstAddress(), basicBlock.getLastAddress(), basicBlock2.getFirstAddress()));
            }
        }
        return arrayList;
    }

    private void buildGraphSecondPass(Map<Long, BasicBlock<InsnType>> map) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            BasicBlock<InsnType> basicBlock2;
            for (long l2 : basicBlock.dst_offsets) {
                basicBlock2 = map.get(l2);
                basicBlock.dst.add(basicBlock2);
                basicBlock2.src.add(basicBlock);
            }
            for (long l2 : basicBlock.irrdst_offsets) {
                basicBlock2 = map.get(l2);
                basicBlock.irrdst.add(basicBlock2);
                basicBlock2.irrsrc.add(basicBlock);
            }
            basicBlock.dst_offsets = null;
            basicBlock.irrdst_offsets = null;
        }
        Collections.sort(this.bblist, new Comparator<BasicBlock<InsnType>>(){

            @Override
            public int compare(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
                return Long.compare(((ILocatedInstruction)basicBlock.insns.get(0)).getOffset(), ((ILocatedInstruction)basicBlock2.insns.get(0)).getOffset());
            }
        });
    }

    public int simplify() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.bblist.size() - 1) {
            BasicBlock<InsnType> basicBlock;
            BasicBlock<InsnType> basicBlock2 = this.bblist.get(n3);
            if (basicBlock2.outsize() == 1 && basicBlock2.irroutsize() == 0 && !basicBlock2.getLast().getBreakingFlow().isBroken() && (basicBlock = this.bblist.get(n3 + 1)).insize() == 1 && basicBlock.irrinsize() == 0 && basicBlock.irroutsize() == 0 && basicBlock.getInputBlock(0) == basicBlock2) {
                basicBlock2.insns.addAll(basicBlock.insns);
                this.removeBlock(basicBlock);
                ++n2;
                continue;
            }
            ++n3;
        }
        return n2;
    }

    public int simplifyIrregularFlows() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.bblist.size()) {
            BasicBlock<InsnType> basicBlock = this.bblist.get(n3);
            if (basicBlock.outsize() == 1 && basicBlock.size() >= 1 && !basicBlock.getLast().getBreakingFlow().isBroken()) {
                IInstruction iInstruction = basicBlock.getLast();
                long l2 = iInstruction.getOffset() + (long)iInstruction.getSize();
                IBasicBlock iBasicBlock = basicBlock.getOutputBlock(0);
                if (((BasicBlock)iBasicBlock).get(0).getOffset() == l2 && ((BasicBlock)iBasicBlock).insize() == 1 && ((BasicBlock)iBasicBlock).irrinsize() == 0 && ((BasicBlock)iBasicBlock).irroutsize() == 0) {
                    boolean bl = true;
                    for (ILocatedInstruction iLocatedInstruction : ((BasicBlock)iBasicBlock).insns) {
                        if (!iLocatedInstruction.canThrow()) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        for (ILocatedInstruction iLocatedInstruction : ((BasicBlock)iBasicBlock).insns) {
                            basicBlock.insns.add(iLocatedInstruction);
                        }
                        this.removeBlock((BasicBlock<InsnType>)iBasicBlock);
                        ++n2;
                        continue;
                    }
                }
            }
            ++n3;
        }
        return n2;
    }

    public int reorganizeInputs() {
        int n2 = 0;
        block0: for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (basicBlock.src.size() < 2) continue;
            for (int i = 0; i < basicBlock.src.size(); ++i) {
                BasicBlock basicBlock2 = basicBlock.src.get(i);
                if (basicBlock2.getEndAddress() != basicBlock.getAddress()) continue;
                if (i <= 0) continue block0;
                basicBlock.src.remove(i);
                basicBlock.src.add(0, basicBlock2);
                ++n2;
                continue block0;
            }
        }
        return n2;
    }

    public boolean removeBlockSafe(BasicBlock<InsnType> basicBlock) {
        try {
            this.removeBlock(basicBlock);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            String string = illegalStateException.getMessage();
            if (string != null && string.startsWith("Cannot remove block: ")) {
                return false;
            }
            throw illegalStateException;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeBlock(BasicBlock<InsnType> basicBlock) {
        BasicBlock basicBlock2;
        if (basicBlock.irrinsize() != 0) {
            throw new IllegalStateException("Cannot remove block: Has irregular input");
        }
        if (basicBlock.outsize() == 1) {
            void basicBlock4;
            basicBlock2 = basicBlock.dst.get(0);
            if (basicBlock2 == basicBlock) {
                throw new IllegalStateException("Cannot remove block: Would lead to an infinite loop");
            }
            boolean n2 = false;
            while (basicBlock4 < basicBlock2.src.size()) {
                if (basicBlock2.src.get((int)basicBlock4) == basicBlock) {
                    basicBlock2.src.remove((int)basicBlock4);
                    continue;
                }
                ++basicBlock4;
            }
            for (BasicBlock basicBlock3 : basicBlock.src) {
                for (int i = 0; i < basicBlock3.dst.size(); ++i) {
                    if (basicBlock3.dst.get(i) != basicBlock) continue;
                    basicBlock3.dst.set(i, basicBlock2);
                    basicBlock2.src.add(basicBlock3);
                }
            }
        } else if (basicBlock.insize() == 1) {
            void var3_7;
            basicBlock2 = basicBlock.src.get(0);
            if (basicBlock2 == basicBlock) {
                throw new IllegalStateException("Cannot remove block: Would lead to an infinite loop");
            }
            boolean bl = false;
            while (var3_7 < basicBlock2.dst.size()) {
                if (basicBlock2.dst.get((int)var3_7) == basicBlock) {
                    basicBlock2.dst.remove((int)var3_7);
                    continue;
                }
                ++var3_7;
            }
            for (BasicBlock basicBlock3 : basicBlock.dst) {
                for (int i = 0; i < basicBlock3.src.size(); ++i) {
                    if (basicBlock3.src.get(i) != basicBlock) continue;
                    basicBlock3.src.set(i, basicBlock2);
                    basicBlock2.dst.add(basicBlock3);
                }
            }
        }
        for (BasicBlock basicBlock4 : basicBlock.irrdst) {
            int n2 = 0;
            while (n2 < basicBlock4.irrsrc.size()) {
                if (basicBlock4.irrsrc.get(n2) == basicBlock) {
                    basicBlock4.irrsrc.remove(n2);
                    continue;
                }
                ++n2;
            }
        }
        this.bblist.remove(basicBlock);
    }

    public BasicBlock<InsnType> splitBlock(BasicBlock<InsnType> basicBlock, int n2) {
        if (basicBlock == null) {
            throw new IllegalArgumentException("Null block");
        }
        int n3 = this.bblist.indexOf(basicBlock);
        if (n3 < 0) {
            throw new IllegalArgumentException("The input block does not belong to this CFG");
        }
        BasicBlock basicBlock2 = new BasicBlock();
        while (n2 < basicBlock.insns.size()) {
            basicBlock2.insns.add((ILocatedInstruction)basicBlock.insns.remove(n2));
        }
        basicBlock2.dst.addAll(basicBlock.dst);
        basicBlock.dst.clear();
        for (BasicBlock basicBlock4 : basicBlock2.dst) {
            basicBlock4.src.replaceAll(basicBlock3 -> basicBlock3 == basicBlock ? basicBlock2 : basicBlock3);
        }
        basicBlock2.irrdst.addAll(basicBlock.irrdst);
        for (BasicBlock basicBlock4 : basicBlock2.irrdst) {
            basicBlock4.irrsrc.add(basicBlock2);
        }
        basicBlock.dst.add(basicBlock2);
        basicBlock2.src.add(basicBlock);
        this.bblist.add(n3 + 1, basicBlock2);
        return basicBlock2;
    }

    public void addBlock(int n2, BasicBlock<InsnType> basicBlock) {
        if (n2 < 0) {
            n2 += this.bblist.size() + 1;
        }
        this.bblist.add(n2, basicBlock);
    }

    public void addBlock(BasicBlock<InsnType> basicBlock) {
        this.bblist.add(basicBlock);
    }

    public boolean addEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
        if (basicBlock.dst.contains(basicBlock2)) {
            return false;
        }
        basicBlock.dst.add(basicBlock2);
        basicBlock2.src.add(basicBlock);
        return true;
    }

    public int addEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, int n2) {
        if (n2 < 0) {
            n2 += basicBlock.dst.size() + 1;
        }
        int n3 = CollectionUtil.identityCount(basicBlock.dst, basicBlock2);
        basicBlock.dst.add(n2, basicBlock2);
        basicBlock2.src.add(basicBlock);
        return n3 + 1;
    }

    public boolean addIrregularEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
        if (basicBlock.irrdst.contains(basicBlock2)) {
            return false;
        }
        basicBlock.irrdst.add(basicBlock2);
        basicBlock2.irrsrc.add(basicBlock);
        return true;
    }

    public int addIrregularEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, int n2) {
        if (n2 < 0) {
            n2 += basicBlock.irrdst.size() + 1;
        }
        int n3 = CollectionUtil.identityCount(basicBlock.irrdst, basicBlock2);
        basicBlock.irrdst.add(n2, basicBlock2);
        basicBlock2.irrsrc.add(basicBlock);
        return n3 + 1;
    }

    public int reconnectEdges(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, BasicBlock<InsnType> basicBlock3) {
        int n2;
        int n3 = 0;
        while ((n2 = this.reconnectEdge(basicBlock, basicBlock2, basicBlock3, 0)) != 0) {
            ++n3;
        }
        return n3;
    }

    public int reconnectEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, BasicBlock<InsnType> basicBlock3) {
        return this.reconnectEdge(basicBlock, basicBlock2, basicBlock3, null);
    }

    public int reconnectEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, BasicBlock<InsnType> basicBlock3, Integer n2) {
        int n3 = -1;
        int n4 = 0;
        for (int i = 0; i < basicBlock.dst.size(); ++i) {
            BasicBlock basicBlock4 = basicBlock.dst.get(i);
            if (basicBlock4 == basicBlock2) {
                if (n2 == null) {
                    if (n3 != -1) {
                        return -2;
                    }
                    n3 = i;
                } else if (n2 == n4) {
                    n3 = i;
                    break;
                }
                ++n4;
                continue;
            }
            if (basicBlock3 == null || basicBlock4 != basicBlock3 || n2 != null) continue;
            return -1;
        }
        if (n3 < 0) {
            return 0;
        }
        if (basicBlock3 == null) {
            basicBlock.dst.remove(n3);
            basicBlock2.src.remove(basicBlock);
        } else {
            basicBlock.dst.set(n3, basicBlock3);
            basicBlock2.src.remove(basicBlock);
            basicBlock3.src.add(basicBlock);
        }
        return 1;
    }

    public int removeDuplicateEdges(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
        int n2 = -1;
        ArrayList<Integer> arrayList = null;
        for (int i = 0; i < basicBlock.dst.size(); ++i) {
            BasicBlock basicBlock3 = basicBlock.dst.get(i);
            if (basicBlock3 != basicBlock2) continue;
            if (n2 < 0) {
                n2 = i;
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>();
            }
            arrayList.add(0, i);
        }
        if (arrayList == null) {
            return 0;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            basicBlock.dst.remove(n3);
            Assert.a(basicBlock2.src.remove(basicBlock));
        }
        return arrayList.size();
    }

    public int removeDuplicateIrregularEdges(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
        int n2 = -1;
        ArrayList<Integer> arrayList = null;
        for (int i = 0; i < basicBlock.irrdst.size(); ++i) {
            BasicBlock basicBlock3 = basicBlock.irrdst.get(i);
            if (basicBlock3 != basicBlock2) continue;
            if (n2 < 0) {
                n2 = i;
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>();
            }
            arrayList.add(0, i);
        }
        if (arrayList == null) {
            return 0;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            basicBlock.irrdst.remove(n3);
            Assert.a(basicBlock2.irrsrc.remove(basicBlock));
        }
        return arrayList.size();
    }

    public int reconnectIrregularEdges(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, BasicBlock<InsnType> basicBlock3) {
        int n2;
        int n3 = 0;
        while ((n2 = this.reconnectIrregularEdge(basicBlock, basicBlock2, basicBlock3, 0)) != 0) {
            ++n3;
        }
        return n3;
    }

    public int reconnectIrregularEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, BasicBlock<InsnType> basicBlock3) {
        return this.reconnectIrregularEdge(basicBlock, basicBlock2, basicBlock3, null);
    }

    public int reconnectIrregularEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, BasicBlock<InsnType> basicBlock3, Integer n2) {
        int n3 = -1;
        if (n2 == null || n2 >= 0) {
            int n4 = 0;
            for (int i = 0; i < basicBlock.irrdst.size(); ++i) {
                BasicBlock basicBlock4 = basicBlock.irrdst.get(i);
                if (basicBlock4 == basicBlock2) {
                    if (n2 == null) {
                        if (n3 != -1) {
                            return -2;
                        }
                        n3 = i;
                    } else if (n2 == n4) {
                        n3 = i;
                        break;
                    }
                    ++n4;
                    continue;
                }
                if (basicBlock3 == null || basicBlock4 != basicBlock3 || n2 != null) continue;
                return -1;
            }
        } else {
            int n5 = -1;
            for (int i = basicBlock.irrdst.size() - 1; i >= 0; --i) {
                BasicBlock basicBlock5 = basicBlock.irrdst.get(i);
                if (basicBlock5 != basicBlock2) continue;
                if (n2 == n5) {
                    n3 = i;
                    break;
                }
                --n5;
            }
        }
        if (n3 < 0) {
            return 0;
        }
        if (basicBlock3 == null) {
            basicBlock.irrdst.remove(n3);
            basicBlock2.irrsrc.remove(basicBlock);
        } else {
            basicBlock.irrdst.set(n3, basicBlock3);
            basicBlock2.irrsrc.remove(basicBlock);
            basicBlock3.irrsrc.add(basicBlock);
        }
        return 1;
    }

    public int deleteEdges(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
        return this.reconnectEdges(basicBlock, basicBlock2, null);
    }

    public boolean deleteEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
        return this.reconnectEdge(basicBlock, basicBlock2, null, 0) == 1;
    }

    public int deleteEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, int n2) {
        return this.reconnectEdge(basicBlock, basicBlock2, null, n2);
    }

    public int deleteIrregularEdges(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
        return this.reconnectIrregularEdges(basicBlock, basicBlock2, null);
    }

    public boolean deleteIrregularEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
        return this.reconnectIrregularEdge(basicBlock, basicBlock2, null, 0) == 1;
    }

    public int deleteIrregularEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, int n2) {
        return this.reconnectIrregularEdge(basicBlock, basicBlock2, null, n2);
    }

    public void deleteOutEdges(BasicBlock<InsnType> basicBlock) {
        for (BasicBlock basicBlock2 : basicBlock.dst) {
            basicBlock2.src.remove(basicBlock);
        }
        basicBlock.dst.clear();
    }

    public void deleteIrregularOutEdges(BasicBlock<InsnType> basicBlock) {
        for (BasicBlock basicBlock2 : basicBlock.irrdst) {
            basicBlock2.irrsrc.remove(basicBlock);
        }
        basicBlock.irrdst.clear();
    }

    public InsnType replaceInstruction(long l2, InsnType InsnType) {
        if (InsnType == null) {
            throw new IllegalArgumentException("Null instruction");
        }
        IBasicBlock iBasicBlock = this.getBlockContaining(l2);
        if (iBasicBlock == null) {
            return null;
        }
        int n2 = ((BasicBlock)iBasicBlock).getIndexOfInstruction(l2);
        if (n2 < 0) {
            return null;
        }
        InsnType InsnType2 = ((BasicBlock)iBasicBlock).set(n2, InsnType);
        return InsnType2;
    }

    public boolean replaceInstructionsInBlock(long l2, int n2, Collection<InsnType> collection) {
        int n3;
        IBasicBlock iBasicBlock = this.getBlockContaining(l2);
        if (iBasicBlock == null) {
            return false;
        }
        int n4 = ((BasicBlock)iBasicBlock).getIndexOfInstruction(l2);
        if (n4 < 0) {
            return false;
        }
        int n5 = n4 + n2;
        if (n5 > ((BasicBlock)iBasicBlock).size()) {
            return false;
        }
        int n6 = 0;
        for (n3 = n4; n3 < n5; ++n3) {
            ILocatedInstruction iLocatedInstruction = (ILocatedInstruction)((BasicBlock)iBasicBlock).insns.get(n3);
            n6 += iLocatedInstruction.getSize();
        }
        n3 = 0;
        for (ILocatedInstruction iLocatedInstruction : collection) {
            n3 += iLocatedInstruction.getSize();
        }
        if (n3 != n6) {
            return false;
        }
        while (n2-- > 0) {
            ((BasicBlock)iBasicBlock).insns.remove(n4);
        }
        ((BasicBlock)iBasicBlock).insns.addAll(n4, collection);
        return true;
    }

    public synchronized IVariableInformationProvider setVariableInformationProvider(IVariableInformationProvider iVariableInformationProvider) {
        IVariableInformationProvider iVariableInformationProvider2 = this.varInfoProvider;
        this.varInfoProvider = iVariableInformationProvider;
        return iVariableInformationProvider2;
    }

    public synchronized IVariableInformationProvider getVariableInformationProvider() {
        return this.varInfoProvider;
    }

    public int setDFADefaultCollectionFlags(int n2) {
        int n3 = this.defaultCollectionFlags;
        this.defaultCollectionFlags = n2;
        return n3;
    }

    public int getDFADefaultCollectionFlags() {
        return this.defaultCollectionFlags;
    }

    public boolean setDFADefaultIntegrateInputs(boolean bl) {
        boolean bl2 = this.defaultIntegrateInputs;
        this.defaultIntegrateInputs = bl;
        return bl2;
    }

    public boolean isDFADefaultIntegrateInputs() {
        return this.defaultIntegrateInputs;
    }

    public List<IDFA<InsnType>> getCurrentDFAs() {
        if (this.dfaObjects == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.dfaObjects);
    }

    public IDFA<InsnType> doDataFlowAnalysis() {
        return this.doDataFlowAnalysis(false);
    }

    public IDFA<InsnType> doDataFlowAnalysis(boolean bl) {
        return this.doDataFlowAnalysis(bl, this.defaultCollectionFlags, this.defaultIntegrateInputs);
    }

    public IDFA<InsnType> doDataFlowAnalysis(boolean bl, int n2, boolean bl2) {
        this.dfaPrep(bl);
        for (IDFA<InsnType> iDFA : this.dfaObjects) {
            if (!iDFA.isValid() || iDFA.getVariableCollectionFlags() != n2 || iDFA.isIntegrateCalculatedInputRegisters() != bl2 || iDFA.getVariableInformationProvider() != this.getVariableInformationProvider()) continue;
            return iDFA;
        }
        DFA4 dFA4 = new DFA4(this);
        dFA4.setVariableCollectionFlags(n2);
        dFA4.setIntegrateCalculatedInputRegisters(bl2);
        dFA4.setVariableInformationProvider(this.getVariableInformationProvider());
        dFA4.perform();
        this.dfaObjects.add(dFA4);
        return dFA4;
    }

    private void dfaPrep(boolean bl) {
        if (this.dfaObjects == null) {
            this.dfaObjects = new ArrayList<IDFA<InsnType>>();
        } else {
            int n2 = 0;
            while (n2 < this.dfaObjects.size()) {
                if (bl || !this.dfaObjects.get(n2).isValid()) {
                    this.dfaObjects.remove(n2);
                    continue;
                }
                ++n2;
            }
        }
    }

    public IDFA<InsnType> getDataFlowAnalysis() {
        return this.getDataFlowAnalysis(this.defaultCollectionFlags, this.defaultIntegrateInputs);
    }

    public IDFA<InsnType> getDataFlowAnalysis(int n2, boolean bl) {
        this.dfaPrep(false);
        for (IDFA<InsnType> iDFA : this.dfaObjects) {
            if (!iDFA.isValid() || iDFA.getVariableCollectionFlags() != n2 || iDFA.isIntegrateCalculatedInputRegisters() != bl || iDFA.getVariableInformationProvider() != this.getVariableInformationProvider()) continue;
            return iDFA;
        }
        return null;
    }

    public IDFA<InsnType> createDataFlowAnalysisHelperObject() {
        DFA4 dFA4 = new DFA4(this);
        dFA4.setVariableCollectionFlags(this.getDFADefaultCollectionFlags());
        dFA4.setIntegrateCalculatedInputRegisters(this.isDFADefaultIntegrateInputs());
        dFA4.setVariableInformationProvider(this.getVariableInformationProvider());
        dFA4.perform();
        return dFA4;
    }

    public void resetDFA() {
        this.resetDataFlowAnalysis();
    }

    public void resetDataFlowAnalysis() {
        this.invalidateDataFlowAnalysis();
    }

    public void invalidateDataFlowAnalysis() {
        if (this.dfaObjects != null) {
            for (IDFA<InsnType> iDFA : this.dfaObjects) {
                iDFA.invalidate();
            }
            this.dfaObjects.clear();
        }
    }

    public void invalidateDataFlowAnalysis(long l2) {
        if (this.dfaObjects != null) {
            for (IDFA<InsnType> iDFA : this.dfaObjects) {
                iDFA.notifyInstructionUpdate(l2);
            }
        }
    }

    public String format() {
        return this.format(true, true, null);
    }

    public String format(boolean bl, boolean bl2, Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            int n2 = 0;
            for (ILocatedInstruction iLocatedInstruction : basicBlock.insns) {
                if (bl) {
                    char c2 = n2 >= 1 ? (char)':' : (basicBlock.irrinsize() == 0 ? (char)'+' : '*');
                    Strings.ff(stringBuilder, "%04X/%X%c  ", iLocatedInstruction.getOffset(), iLocatedInstruction.getSize(), Character.valueOf(c2));
                }
                Strings.ff(stringBuilder, "%-100s  ", iLocatedInstruction.format(object));
                stringBuilder.append('\n');
                ++n2;
            }
        }
        if (bl2) {
            stringBuilder.append(this.formatEdges());
        }
        return stringBuilder.toString();
    }

    public String formatEdges() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (BasicBlock<InsnType> object : this.bblist) {
            for (int i = 0; i < object.dst.size(); ++i) {
                if (n2 == 0) {
                    stringBuilder.append("  (EDGES: ");
                } else if (n2 >= 1) {
                    stringBuilder.append(", ");
                }
                BasicBlock i2 = object.dst.get(i);
                Strings.ff(stringBuilder, "%04X->%04X", object.getAddress(), i2.getAddress());
                ++n2;
            }
        }
        if (n2 > 0) {
            stringBuilder.append(")");
        }
        int n3 = 0;
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            for (int i = 0; i < basicBlock.irrdst.size(); ++i) {
                if (n3 == 0) {
                    stringBuilder.append("\n  (IRR.E: ");
                } else if (n3 >= 1) {
                    stringBuilder.append(", ");
                }
                BasicBlock basicBlock2 = basicBlock.irrdst.get(i);
                Strings.ff(stringBuilder, "%04X->%04X", basicBlock.getAddress(), basicBlock2.getAddress());
                ++n3;
            }
        }
        if (n3 > 0) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Strings.ff("CFG(%d): ", this.bblist.size()));
        int n2 = 0;
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(basicBlock);
            ++n2;
        }
        return stringBuilder.toString();
    }

    class HandlersIterator
    implements Iterator<BasicBlock<InsnType>> {
        int idx;
        BasicBlock<InsnType> h;

        HandlersIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.h != null) {
                return true;
            }
            while (this.idx < CFG.this.bblist.size()) {
                BasicBlock basicBlock = CFG.this.bblist.get(this.idx);
                if (basicBlock.irrinsize() > 0) {
                    this.h = basicBlock;
                    return true;
                }
                ++this.idx;
            }
            return false;
        }

        @Override
        public BasicBlock<InsnType> next() {
            BasicBlock basicBlock = this.h;
            this.h = null;
            ++this.idx;
            return basicBlock;
        }
    }

    private class AddressableInstructionsIterator
    implements Iterator<AddressableInstruction<InsnType>> {
        private int blkIndex;
        private int insnIndex;
        private BasicBlock<InsnType> blk;

        private AddressableInstructionsIterator() {
            if (CFG.this.bblist.size() > 0) {
                this.blk = CFG.this.bblist.get(0);
            }
        }

        @Override
        public boolean hasNext() {
            return this.blk != null;
        }

        @Override
        public AddressableInstruction<InsnType> next() {
            if (this.blk == null) {
                throw new NoSuchElementException("No more instructions");
            }
            IInstruction iInstruction = this.blk.get(this.insnIndex);
            ++this.insnIndex;
            if (this.insnIndex >= this.blk.size()) {
                this.insnIndex = 0;
                ++this.blkIndex;
                this.blk = this.blkIndex >= CFG.this.bblist.size() ? null : CFG.this.bblist.get(this.blkIndex);
            }
            return new AddressableInstruction<IInstruction>(iInstruction.getOffset(), iInstruction);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Instruction removal not supported in iterator");
        }
    }

    private class InstructionsIterator
    implements Iterator<InsnType> {
        private int blkIndex;
        private int insnIndex;
        private BasicBlock<InsnType> blk;

        private InstructionsIterator() {
            if (CFG.this.bblist.size() > 0) {
                this.blk = CFG.this.bblist.get(0);
            }
        }

        private InstructionsIterator(BasicBlock<InsnType> basicBlock, int n2) {
            if (basicBlock != null) {
                this.blk = basicBlock;
                this.insnIndex = n2;
                this.blkIndex = CFG.this.bblist.indexOf(basicBlock);
            }
        }

        @Override
        public boolean hasNext() {
            return this.blk != null;
        }

        @Override
        public InsnType next() {
            if (this.blk == null) {
                throw new NoSuchElementException("No more instructions");
            }
            IInstruction iInstruction = this.blk.get(this.insnIndex);
            ++this.insnIndex;
            if (this.insnIndex >= this.blk.size()) {
                this.insnIndex = 0;
                ++this.blkIndex;
                this.blk = this.blkIndex >= CFG.this.bblist.size() ? null : CFG.this.bblist.get(this.blkIndex);
            }
            return iInstruction;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Instruction removal not supported in iterator");
        }
    }
}

