/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.controlflow;

import com.pnfsoftware.jeb.core.units.code.IBasicBlock;
import com.pnfsoftware.jeb.core.units.code.ILocatedInstruction;
import com.pnfsoftware.jeb.util.collect.CollectionUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@Ser
public class BasicBlock<InsnType extends ILocatedInstruction>
implements IBasicBlock<InsnType> {
    private static final ILogger logger = GlobalLog.getLogger(BasicBlock.class);
    @SerId(value=1)
    List<InsnType> insns = new ArrayList<InsnType>();
    @SerTransient
    List<Long> dst_offsets = new ArrayList<Long>();
    @SerTransient
    List<Long> irrdst_offsets = new ArrayList<Long>();
    @SerId(value=4)
    List<BasicBlock<InsnType>> src = new ArrayList<BasicBlock<InsnType>>();
    @SerId(value=5)
    List<BasicBlock<InsnType>> dst = new ArrayList<BasicBlock<InsnType>>();
    @SerId(value=6)
    List<BasicBlock<InsnType>> irrsrc = new ArrayList<BasicBlock<InsnType>>();
    @SerId(value=7)
    List<BasicBlock<InsnType>> irrdst = new ArrayList<BasicBlock<InsnType>>();

    public BasicBlock() {
    }

    public BasicBlock(Collection<InsnType> collection) {
        this.insns.addAll(collection);
    }

    @Override
    public int size() {
        return this.insns.size();
    }

    @Override
    public boolean isEmpty() {
        return this.insns.isEmpty();
    }

    @Override
    public InsnType get(int n2) {
        if (n2 < 0) {
            n2 += this.insns.size();
        }
        return (InsnType)((ILocatedInstruction)this.insns.get(n2));
    }

    @Override
    public InsnType getLast() {
        return (InsnType)((ILocatedInstruction)this.insns.get(this.insns.size() - 1));
    }

    @Override
    public List<InsnType> getInstructions() {
        return new ArrayList<InsnType>(this.insns);
    }

    @Override
    public int getSizeOfInstructions() {
        int n2 = 0;
        for (ILocatedInstruction iLocatedInstruction : this.insns) {
            n2 += iLocatedInstruction.getSize();
        }
        return n2;
    }

    @Override
    public long getBase() {
        return this.getFirstAddress();
    }

    public long getAddress() {
        return this.getFirstAddress();
    }

    @Override
    public long getFirstAddress() {
        return ((ILocatedInstruction)this.insns.get(0)).getOffset();
    }

    @Override
    public long getLastAddress() {
        return ((ILocatedInstruction)this.insns.get(this.insns.size() - 1)).getOffset();
    }

    @Override
    public long getEndAddress() {
        ILocatedInstruction iLocatedInstruction = (ILocatedInstruction)this.insns.get(this.insns.size() - 1);
        return iLocatedInstruction.getOffset() + (long)iLocatedInstruction.getSize();
    }

    @Override
    public long getAddressOfInstruction(int n2) {
        if (n2 < 0 || n2 >= this.insns.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return ((ILocatedInstruction)this.insns.get(n2)).getOffset();
    }

    @Override
    public int getIndexOfInstruction(long l2) {
        int n2 = 0;
        for (ILocatedInstruction iLocatedInstruction : this.insns) {
            long l3 = iLocatedInstruction.getOffset();
            if (l3 >= l2) {
                return l2 == l3 ? n2 : -1;
            }
            ++n2;
        }
        return -1;
    }

    public int getIndexOfInstruction(long l2, boolean bl) {
        if (bl) {
            return this.getIndexOfInstruction(l2);
        }
        int n2 = 0;
        for (ILocatedInstruction iLocatedInstruction : this.insns) {
            long l3 = iLocatedInstruction.getOffset();
            if (l3 > l2) {
                return -1;
            }
            if (l3 <= l2 && l2 < iLocatedInstruction.getOffsetEnd()) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    @Override
    public InsnType getInstruction(long l2) {
        for (ILocatedInstruction iLocatedInstruction : this.insns) {
            long l3 = iLocatedInstruction.getOffset();
            if (l3 < l2) continue;
            return (InsnType)(l2 == l3 ? iLocatedInstruction : null);
        }
        return null;
    }

    @Override
    public boolean canThrow() {
        for (ILocatedInstruction iLocatedInstruction : this.insns) {
            if (!iLocatedInstruction.canThrow()) continue;
            return true;
        }
        return false;
    }

    public InsnType remove(int n2) {
        return (InsnType)((ILocatedInstruction)this.insns.remove(n2));
    }

    public void removeAll() {
        this.insns.clear();
    }

    public void add(InsnType InsnType) {
        this.insns.add(InsnType);
    }

    public void addAll(Collection<InsnType> collection) {
        this.insns.addAll(collection);
    }

    public void add(int n2, InsnType InsnType) {
        this.insns.add(n2, InsnType);
    }

    public InsnType set(int n2, InsnType InsnType) {
        return this.set(n2, InsnType, true, false);
    }

    public InsnType set(int n2, InsnType InsnType, boolean bl, boolean bl2) {
        if (bl || bl2) {
            ILocatedInstruction iLocatedInstruction = (ILocatedInstruction)this.insns.get(n2);
            if (bl && iLocatedInstruction.getSize() != InsnType.getSize()) {
                throw new IllegalArgumentException("Replacement of instruction with different sizes");
            }
            if (bl2 && iLocatedInstruction.getOffset() != InsnType.getOffset()) {
                throw new IllegalArgumentException("Replacement of instruction with different sizes");
            }
        }
        return (InsnType)((ILocatedInstruction)this.insns.set(n2, InsnType));
    }

    @Override
    public int insize() {
        return this.src.size();
    }

    @Override
    public int irrinsize() {
        return this.irrsrc.size();
    }

    @Override
    public int allinsize() {
        return this.src.size() + this.irrsrc.size();
    }

    @Override
    public BasicBlock<InsnType> getInputBlock(int n2) {
        return this.src.get(n2);
    }

    @Override
    public List<BasicBlock<InsnType>> getInputBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.src);
    }

    public List<Long> getInputOffsets() {
        ArrayList<Long> arrayList = new ArrayList<Long>(this.src.size());
        this.src.forEach(basicBlock -> arrayList.add(basicBlock.getFirstAddress()));
        return arrayList;
    }

    @Override
    public BasicBlock<InsnType> getIrregularInputBlock(int n2) {
        return this.irrsrc.get(n2);
    }

    @Override
    public List<BasicBlock<InsnType>> getIrregularInputBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.irrsrc);
    }

    public List<Long> getIrregularInputOffsets() {
        ArrayList<Long> arrayList = new ArrayList<Long>(this.irrsrc.size());
        this.irrsrc.forEach(basicBlock -> arrayList.add(basicBlock.getFirstAddress()));
        return arrayList;
    }

    @Override
    public List<BasicBlock<InsnType>> getAllInputBlocks() {
        ArrayList<BasicBlock<InsnType>> arrayList = new ArrayList<BasicBlock<InsnType>>(this.src);
        arrayList.addAll(this.irrsrc);
        return arrayList;
    }

    @Override
    public int outsize() {
        return this.dst.size();
    }

    @Override
    public int irroutsize() {
        return this.irrdst.size();
    }

    @Override
    public int alloutsize() {
        return this.dst.size() + this.irrdst.size();
    }

    @Override
    public BasicBlock<InsnType> getOutputBlock(int n2) {
        return this.dst.get(n2);
    }

    @Override
    public List<BasicBlock<InsnType>> getOutputBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.dst);
    }

    public List<Long> getOutputOffsets() {
        ArrayList<Long> arrayList = new ArrayList<Long>(this.dst.size());
        this.dst.forEach(basicBlock -> arrayList.add(basicBlock.getFirstAddress()));
        return arrayList;
    }

    @Override
    public BasicBlock<InsnType> getIrregularOutputBlock(int n2) {
        return this.irrdst.get(n2);
    }

    @Override
    public List<BasicBlock<InsnType>> getIrregularOutputBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.irrdst);
    }

    public List<Long> getIrregularOutputOffsets() {
        ArrayList<Long> arrayList = new ArrayList<Long>(this.irrdst.size());
        this.irrdst.forEach(basicBlock -> arrayList.add(basicBlock.getFirstAddress()));
        return arrayList;
    }

    @Override
    public List<BasicBlock<InsnType>> getAllOutputBlocks() {
        ArrayList<BasicBlock<InsnType>> arrayList = new ArrayList<BasicBlock<InsnType>>(this.dst);
        arrayList.addAll(this.irrdst);
        return arrayList;
    }

    @Override
    public List<BasicBlock<InsnType>> getInputs() {
        return Collections.unmodifiableList(this.src);
    }

    @Override
    public List<BasicBlock<InsnType>> getIrregularInputs() {
        return Collections.unmodifiableList(this.irrsrc);
    }

    @Override
    public List<BasicBlock<InsnType>> getOutputs() {
        return Collections.unmodifiableList(this.dst);
    }

    @Override
    public List<BasicBlock<InsnType>> getIrregularOutputs() {
        return Collections.unmodifiableList(this.irrdst);
    }

    @Override
    public Iterable<BasicBlock<InsnType>> getAllInputs() {
        return CollectionUtil.doubleCollectionIterable(this.src, this.irrsrc);
    }

    @Override
    public Iterable<BasicBlock<InsnType>> getAllOutputs() {
        return CollectionUtil.doubleCollectionIterable(this.dst, this.irrdst);
    }

    @Override
    public Iterator<InsnType> iterator() {
        return this.insns.iterator();
    }

    public String toString() {
        if (this.insns.size() == 0) {
            return "(empty)";
        }
        long l2 = ((ILocatedInstruction)this.insns.get(0)).getOffset();
        long l3 = ((ILocatedInstruction)this.insns.get(this.insns.size() - 1)).getOffset();
        return Strings.ff("(%X-%X,%d)", l2, l3, this.insns.size());
    }
}

