/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.controlflow;

import com.pnfsoftware.jeb.core.units.code.ILocatedInstruction;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.BasicBlockBuilder;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.CFG;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractGraphReorganizer<InsnType extends ILocatedInstruction> {
    private static final ILogger logger = GlobalLog.getLogger(AbstractGraphReorganizer.class);
    private CFG<InsnType> cfg;
    private CFG<InsnType> reorganizedCfg;
    private Map<Long, Long> conversionMap;

    public AbstractGraphReorganizer(CFG<InsnType> cFG) {
        this.cfg = cFG;
    }

    private static int verifyOrder(int n2, int[] nArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int n3 : nArray) {
            if (n3 >= 0 && n3 < n2 && hashSet.add(n3)) continue;
            return 0;
        }
        if (hashSet.size() != n2) {
            return 0;
        }
        int n4 = 0;
        for (int n5 : nArray) {
            if (n5 != n4) {
                return 1;
            }
            ++n4;
        }
        return -1;
    }

    public CFG<InsnType> reorder(int[] nArray) {
        Object object;
        Object object2;
        boolean bl;
        if (this.conversionMap != null) {
            throw new IllegalStateException();
        }
        int n2 = AbstractGraphReorganizer.verifyOrder(this.cfg.size(), nArray);
        if (n2 <= 0) {
            if (n2 == 0) {
                throw new IllegalArgumentException();
            }
            return null;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<List<Long>> arrayList2 = new ArrayList<List<Long>>();
        ArrayList<List<Long>> arrayList3 = new ArrayList<List<Long>>();
        for (BasicBlock<InsnType> basicBlock : this.cfg) {
            arrayList.add(basicBlock.getFirstAddress());
            arrayList2.add(basicBlock.getOutputOffsets());
            arrayList3.add(basicBlock.getIrregularOutputOffsets());
        }
        long l2 = 0L;
        long l3 = -1L;
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        HashMap<Long, Long> hashMap2 = new HashMap<Long, Long>();
        TreeMap<Long, Object> treeMap = new TreeMap<Long, Object>();
        HashMap hashMap3 = new HashMap();
        HashMap<Object, Integer> hashMap4 = new HashMap<Object, Integer>();
        boolean bl2 = bl = nArray[0] != 0;
        if (bl) {
            BasicBlockBuilder basicBlockBuilder = new BasicBlockBuilder();
            basicBlockBuilder.insns.add(this.createTrampoline(l2, 0L));
            treeMap.put(l2, basicBlockBuilder);
            hashMap4.put(basicBlockBuilder, 0);
            hashMap2.put(l3, l2);
            ++l2;
            --l3;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            boolean bl3 = i + 1 < nArray.length && nArray[i + 1] == n3 + 1;
            object2 = this.cfg.get(n3);
            hashMap.put(l2, ((BasicBlock)object2).getFirstAddress());
            hashMap2.put(((BasicBlock)object2).getFirstAddress(), l2);
            BasicBlockBuilder basicBlockBuilder = new BasicBlockBuilder();
            treeMap.put(l2, basicBlockBuilder);
            hashMap3.put(basicBlockBuilder, n3);
            object = ((BasicBlock)object2).iterator();
            while (object.hasNext()) {
                ILocatedInstruction iLocatedInstruction = (ILocatedInstruction)object.next();
                iLocatedInstruction = this.updateInstructionOffset(iLocatedInstruction, l2);
                l2 += (long)iLocatedInstruction.getSize();
                basicBlockBuilder.insns.add(iLocatedInstruction);
            }
            if (bl3 || !this.needsTrampoline((BasicBlock<InsnType>)object2)) continue;
            if (this.isFallthrough((BasicBlock<InsnType>)object2)) {
                basicBlockBuilder.insns.add(this.createTrampoline(l2, (Long)((List)arrayList2.get(n3)).get(0)));
                ++l2;
                continue;
            }
            object = new BasicBlockBuilder();
            ((BasicBlockBuilder)object).insns.add(this.createTrampoline(l2, (Long)((List)arrayList2.get(n3)).get(0)));
            treeMap.put(l2, object);
            hashMap4.put(object, n3 + 1);
            ((List)arrayList2.get(n3)).set(0, l3);
            hashMap2.put(l3, l2);
            ++l2;
            --l3;
        }
        Object object3 = treeMap.values().iterator();
        while (object3.hasNext()) {
            long l4;
            long l5;
            BasicBlockBuilder basicBlockBuilder = (BasicBlockBuilder)object3.next();
            ILocatedInstruction iLocatedInstruction = (ILocatedInstruction)basicBlockBuilder.insns.get(basicBlockBuilder.insns.size() - 1);
            object2 = (Integer)hashMap4.get(basicBlockBuilder);
            if (object2 != null) {
                long l6 = (Long)arrayList.get((Integer)object2);
                long l7 = (Long)hashMap2.get(l6);
                this.updateTrampolineTarget(iLocatedInstruction, l7);
                basicBlockBuilder.dst_offsets.add(l7);
                continue;
            }
            int n4 = (Integer)hashMap3.get(basicBlockBuilder);
            object = ((List)arrayList2.get(n4)).iterator();
            while (object.hasNext()) {
                l5 = (Long)object.next();
                l4 = (Long)hashMap2.get(l5);
                basicBlockBuilder.dst_offsets.add(l4);
            }
            object = ((List)arrayList3.get(n4)).iterator();
            while (object.hasNext()) {
                l5 = (Long)object.next();
                l4 = (Long)hashMap2.get(l5);
                basicBlockBuilder.irrdst_offsets.add(l4);
            }
            if (!iLocatedInstruction.getBreakingFlow().isBroken()) continue;
            this.updateTargets(iLocatedInstruction, hashMap2);
        }
        this.reorganizedCfg = object3 = new CFG(treeMap.values());
        this.conversionMap = hashMap2;
        return object3;
    }

    public void shift(int n2) {
        if (this.conversionMap != null) {
            throw new IllegalStateException();
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        for (BasicBlock<InsnType> basicBlock : this.cfg) {
            hashMap.put(basicBlock.getAddress(), basicBlock.getAddress() + (long)n2);
        }
        for (BasicBlock<InsnType> basicBlock : this.cfg) {
            for (ILocatedInstruction iLocatedInstruction : basicBlock) {
                this.updateInstructionOffset(iLocatedInstruction, iLocatedInstruction.getOffset() + (long)n2);
                if (!this.hasTargets(iLocatedInstruction)) continue;
                this.updateTargets(iLocatedInstruction, hashMap);
            }
        }
        BasicBlock basicBlock = new BasicBlock();
        basicBlock.add(this.createNop(0L, n2));
        this.cfg.addBlock(0, basicBlock);
        this.cfg.addEdge(basicBlock, (BasicBlock<InsnType>)this.cfg.get(1));
        this.conversionMap = hashMap;
        this.reorganizedCfg = this.cfg;
    }

    public CFG<InsnType> getReorganizedCfg() {
        return this.reorganizedCfg;
    }

    public Map<Long, Long> getConversionMap() {
        return this.conversionMap;
    }

    private boolean isFallthrough(BasicBlock<InsnType> basicBlock) {
        return !basicBlock.getLast().getBreakingFlow().isBroken() && basicBlock.outsize() >= 1;
    }

    private boolean needsTrampoline(BasicBlock<InsnType> basicBlock) {
        return this.isFallthrough(basicBlock) || this.canFallthrough(basicBlock.getLast());
    }

    protected abstract boolean canFallthrough(InsnType var1);

    protected abstract InsnType updateInstructionOffset(InsnType var1, long var2);

    protected abstract InsnType createTrampoline(long var1, long var3);

    protected abstract InsnType createNop(long var1, int var3);

    protected abstract void updateTrampolineTarget(InsnType var1, long var2);

    protected abstract boolean hasTargets(InsnType var1);

    protected abstract void updateTargets(InsnType var1, Map<Long, Long> var2);
}

