/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.adb;

public enum AndroidPlatformABI {
    ARM("armeabi", true),
    ARM7("armeabi-v7a", false),
    ARM64("arm64-v8a", false),
    MIPS("mips", true),
    MIPS64("mips64", true),
    X86("x86", false),
    X64("x86_64", false);

    private final String abiName;
    private final boolean depr;

    private AndroidPlatformABI(String string2, boolean bl) {
        this.abiName = string2;
        this.depr = bl;
    }

    public boolean isIntel() {
        return this == X86 || this == X64;
    }

    public boolean isARM() {
        return this == ARM || this == ARM7 || this == ARM64;
    }

    public boolean isMIPS() {
        return this == MIPS || this == MIPS64;
    }

    public boolean isDeprecated() {
        return this.depr;
    }

    public String toString() {
        return this.abiName;
    }

    public static AndroidPlatformABI fromName(String string) {
        for (AndroidPlatformABI androidPlatformABI : AndroidPlatformABI.values()) {
            if (!androidPlatformABI.toString().equals(string)) continue;
            return androidPlatformABI;
        }
        return null;
    }
}

