/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.adb;

import com.pnfsoftware.jeb.core.AssetManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.android.IApkUnit;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbException;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbProcess;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbResult;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbWrapper;
import com.pnfsoftware.jeb.core.units.code.android.adb.AndroidPlatformABI;
import com.pnfsoftware.jeb.util.collect.Lists;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AndroidDeviceUtil {
    private static final ILogger logger = GlobalLog.getLogger(AndroidDeviceUtil.class);

    public static String uploadFileToDeviceTemp(AdbWrapper adbWrapper, String string, AndroidPlatformABI androidPlatformABI) throws IOException {
        return AndroidDeviceUtil.uploadFileToDeviceTemp(adbWrapper, string, androidPlatformABI, null, null);
    }

    public static String uploadFileToDeviceTemp(AdbWrapper adbWrapper, String string, AndroidPlatformABI androidPlatformABI, String string2, String string3) throws IOException {
        if (adbWrapper == null || string == null) {
            throw new IllegalArgumentException();
        }
        AndroidPlatformABI androidPlatformABI2 = null;
        if (androidPlatformABI != null) {
            switch (androidPlatformABI) {
                case ARM: {
                    androidPlatformABI2 = AndroidPlatformABI.ARM7;
                }
            }
        }
        try {
            return AndroidDeviceUtil.__uploadFileToDeviceTemp(adbWrapper, string, androidPlatformABI, string2, string3);
        }
        catch (IOException iOException) {
            if (androidPlatformABI2 != null) {
                try {
                    return AndroidDeviceUtil.__uploadFileToDeviceTemp(adbWrapper, string, androidPlatformABI2, string2, string3);
                }
                catch (IOException iOException2) {}
            }
            throw iOException;
        }
    }

    private static String __uploadFileToDeviceTemp(AdbWrapper adbWrapper, String string, AndroidPlatformABI androidPlatformABI, String string2, String string3) throws IOException {
        File file = null;
        try {
            byte[] byArray;
            Object object = "android-bin/";
            if (androidPlatformABI != null) {
                object = (String)object + androidPlatformABI.toString() + "/";
            }
            object = (String)object + string;
            if (!Strings.isBlank(string2)) {
                object = (String)object + "-" + string2;
            }
            if (!Strings.isBlank(string3)) {
                object = (String)object + "." + string3;
            }
            if ((byArray = AssetManager.getAssetBytes((String)object)) == null) {
                throw new IOException("Could not retrieve Android asset: " + (String)object);
            }
            file = File.createTempFile("android-tmpfile-", null);
            IO.writeFile(file, byArray);
            String string4 = "/data/local/tmp/" + string;
            if (!adbWrapper.pushFile(file.getAbsolutePath(), string4)) {
                throw new IOException(Strings.ff("Could not upload file to device: src=%s, dst=%s", object, string4));
            }
            String string5 = string4;
            return string5;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public static boolean isRootDevice(AdbWrapper adbWrapper) {
        String[] stringArray;
        String string = adbWrapper.getToolName("su");
        if (adbWrapper.hasFile(null, "/system/xbin/" + string)) {
            return true;
        }
        if (adbWrapper.which(null, string) != null) {
            return true;
        }
        for (String string2 : stringArray = new String[]{"/bin/" + string, "/sbin/" + string, "/system/bin/" + string, "/system/xbin/" + string, "/data/local/" + string, "/data/local/bin/" + string, "/data/local/xbin/" + string, "/system/sd/xbin/" + string, "/system/bin/failsafe/" + string, "/su/bin/" + string}) {
            if (!adbWrapper.hasFile(null, string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean executeCommandAsRoot(AdbWrapper adbWrapper, String string) throws AdbException {
        return AndroidDeviceUtil.executeCommandAsRoot(adbWrapper, true, string);
    }

    public static boolean executeCommandAsRoot(AdbWrapper adbWrapper, boolean bl, String string) throws AdbException {
        return AndroidDeviceUtil.executeCommandsAsRoot(adbWrapper, bl, new String[]{string});
    }

    public static boolean executeCommandsAsRoot(AdbWrapper adbWrapper, String[] stringArray) throws AdbException {
        return AndroidDeviceUtil.executeCommandsAsRoot(adbWrapper, true, stringArray);
    }

    public static boolean executeCommandsAsRoot(AdbWrapper adbWrapper, boolean bl, String[] stringArray) throws AdbException {
        if (bl && !AndroidDeviceUtil.isRootDevice(adbWrapper)) {
            throw new AdbException("The device is not rooted: unable to find 'su'");
        }
        int n2 = 0;
        AdbResult adbResult = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = "\"" + stringArray[i] + "\"";
            String string4 = string2 = stringArray[i].contains(" ") ? stringArray[i].substring(0, stringArray[i].indexOf(32)) : stringArray[i];
            if (n2 == 0 && !(adbResult = adbWrapper.shell(null, null, null, Arrays.asList(string = adbWrapper.getToolName("su"), "-c", string3), !AndroidDeviceUtil.hasCommandResult(string2))).isSuccess(null, true, "invalid uid/gid '-c'")) {
                n2 = 1;
            }
            if (n2 == 1 && !(adbResult = adbWrapper.shell(null, null, null, Arrays.asList(Strings.join(" ", Arrays.asList(string = adbWrapper.getToolName("su"), "0", string3))), !AndroidDeviceUtil.hasCommandResult(string2))).isSuccess(null, true, new String[0])) {
                n2 = 2;
            }
            if (n2 == 2) {
                adbResult = adbWrapper.shell(null, null, null, Arrays.asList(stringArray[i].split(" ")), !AndroidDeviceUtil.hasCommandResult(string2));
            }
            if ((string = adbResult.getOutputString()).contains("Read-only file system")) {
                Object object = "/system can not be made writable on current device.";
                object = (String)object + "\nIf working with an emulator, try to add the option '-writable-system' to your emulator";
                throw new AdbException((String)object);
            }
            if (string.contains("not user mountable") || string.contains("Operation not permitted")) {
                Object object = "The device is not rooted";
                object = (String)object + "\nIf working with an emulator, you may need to execute 'adb root' to force your device being rooted.";
                throw new AdbException((String)object);
            }
            if (adbResult.isSuccess(null, true, new String[0])) continue;
            return false;
        }
        return true;
    }

    private static boolean hasCommandResult(String string) {
        switch (string) {
            case "chmod": 
            case "chown": 
            case "rm": 
            case "cp": 
            case "mount": {
                return false;
            }
        }
        return true;
    }

    public static boolean pullFile(AdbWrapper adbWrapper, String string, String string2) {
        int n2;
        boolean bl = adbWrapper.pullFile(string, string2);
        if (bl) {
            return true;
        }
        String string3 = null;
        if (string.startsWith("/data/data/") && (n2 = (string3 = string.substring("/data/data/".length())).indexOf(47)) >= 0) {
            string3 = string3.substring(0, n2);
        }
        if (string3 != null && string3.length() > 0) {
            String string4 = "/data/local/tmp/tempfile-" + System.nanoTime();
            if (adbWrapper.copyFile(string3, string, string4, false) && (bl = adbWrapper.pullFile(string4, string2))) {
                return true;
            }
            if (adbWrapper.chmod(string3, string, 365, false)) {
                bl = adbWrapper.pullFile(string, string2);
                if (bl) {
                    return true;
                }
                if (adbWrapper.copyFile(null, string, string4, false) && adbWrapper.pullFile(string4, string2)) {
                    return true;
                }
            }
        }
        if (!AndroidDeviceUtil.isRootDevice(adbWrapper)) {
            return false;
        }
        try {
            String string5 = "/data/local/tmp/tempfile-" + System.nanoTime();
            if (AndroidDeviceUtil.executeCommandAsRoot(adbWrapper, false, Strings.ff("cp %s %s", string, string5))) {
                AndroidDeviceUtil.executeCommandAsRoot(adbWrapper, false, "chown shell:shell " + string5);
                AndroidDeviceUtil.executeCommandAsRoot(adbWrapper, false, "chmod 555 " + string5);
                if (adbWrapper.pullFile(string5, string2)) {
                    return true;
                }
            }
        }
        catch (AdbException adbException) {
            return false;
        }
        return false;
    }

    public static List<AndroidPlatformABI> getSupportedABIs(AdbWrapper adbWrapper) {
        String string = adbWrapper.readProperty("ro.product.cpu.abilist").trim();
        if (Strings.isBlank(string)) {
            string = adbWrapper.readProperty("ro.product.cpu.abi").trim();
        }
        ArrayList<AndroidPlatformABI> arrayList = new ArrayList<AndroidPlatformABI>();
        for (String string2 : string.split(",")) {
            AndroidPlatformABI androidPlatformABI = AndroidPlatformABI.fromName(string2);
            if (androidPlatformABI == null) continue;
            arrayList.add(androidPlatformABI);
        }
        return arrayList;
    }

    public static AndroidPlatformABI getPreferredABI(AdbWrapper adbWrapper) {
        return Lists.getFirst(AndroidDeviceUtil.getSupportedABIs(adbWrapper));
    }

    public static AndroidPlatformABI getBestABIForApp(AdbWrapper adbWrapper, IApkUnit iApkUnit) {
        IUnit iUnit = UnitUtil.findFirstChildByName(iApkUnit, "Libraries");
        if (iUnit != null) {
            List<AndroidPlatformABI> list = AndroidDeviceUtil.getSupportedABIs(adbWrapper);
            for (AndroidPlatformABI androidPlatformABI : list) {
                if (UnitUtil.findFirstChildByName(iUnit, androidPlatformABI.toString()) == null) continue;
                return androidPlatformABI;
            }
        }
        return AndroidDeviceUtil.getPreferredABI(adbWrapper);
    }

    public static List<Integer> getProcessesByName(AdbWrapper adbWrapper, String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List<AdbProcess> list = adbWrapper.listProcesses();
        if (list != null) {
            for (AdbProcess adbProcess : adbWrapper.listProcesses()) {
                if (!Strings.equals(adbProcess.getName(), string)) continue;
                arrayList.add(adbProcess.getPid());
            }
        }
        return arrayList;
    }

    public static int getAndroidApiLevel(AdbWrapper adbWrapper) {
        String string = adbWrapper.readProperty("ro.build.version.sdk");
        return Conversion.stringToInt(string);
    }

    public static boolean isDebuggableApp(AdbWrapper adbWrapper, String string) {
        AdbResult adbResult = adbWrapper.shell(Arrays.asList("dumpsys", "package", string));
        if (!adbResult.isSuccess()) {
            return false;
        }
        String string2 = adbResult.getOutputString();
        for (String string3 : Strings.splitLines(string2)) {
            if (!string3.contains("flags")) continue;
            return string3.contains("DEBUGGABLE");
        }
        return false;
    }
}

