/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.adb;

import com.pnfsoftware.jeb.core.units.code.android.adb.AdbDevice;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbDeviceStatus;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbUtil;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbWrapper;
import com.pnfsoftware.jeb.util.concurrent.CommandExec;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class AdbWrapperFactory {
    private static final ILogger logger = GlobalLog.getLogger(AdbWrapperFactory.class);
    public static final long STANDARD_TIMEOUT = 5000L;
    private String adbPath;
    private boolean initialized;
    private long defaultTimeout;

    public static synchronized AdbWrapper createStandardWrapper() throws IOException {
        return new AdbWrapperFactory().createWrapper(null);
    }

    public AdbWrapperFactory() throws IOException {
        this(null);
    }

    public AdbWrapperFactory(String string) throws IOException {
        this(string, 5000L);
    }

    public AdbWrapperFactory(String string, long l2) throws IOException {
        File file = string != null ? new File(string) : AdbUtil.findAdbOnCurrentSystem();
        this.adbPath = file.getPath();
        this.defaultTimeout = l2;
    }

    public synchronized boolean initialize() {
        if (this.initialized) {
            return true;
        }
        this.initialized = this.startServer();
        return this.initialized;
    }

    public String getPath() {
        return this.adbPath;
    }

    public synchronized void setDefaultTimeout(long l2) {
        this.defaultTimeout = l2;
    }

    public synchronized long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public synchronized String getVersion() {
        byte[] byArray = this.execute(null, Arrays.asList("version"));
        if (byArray == null) {
            return null;
        }
        for (String string : Strings.splitLines(Strings.decodeLocal(byArray))) {
            if (!string.startsWith("Android Debug Bridge version ")) continue;
            return string.substring("Android Debug Bridge version ".length());
        }
        return Strings.decodeLocal(byArray).trim();
    }

    public synchronized boolean startServer() {
        long l2 = Math.max(15000L, this.defaultTimeout);
        byte[] byArray = this.execute(l2, Arrays.asList("start-server"));
        return AdbUtil.heurSuccess(byArray);
    }

    public synchronized void stopServer() {
        this.execute(null, Arrays.asList("stop-server"));
    }

    public synchronized List<AdbDevice> listDevices() {
        byte[] byArray = this.execute(null, Arrays.asList("devices", "-l"));
        if (byArray == null) {
            return null;
        }
        ArrayList<AdbDevice> arrayList = new ArrayList<AdbDevice>();
        String[] stringArray = Strings.decodeLocal(byArray).split("\\r?\\n");
        for (int i = 1; i < stringArray.length; ++i) {
            String string = Strings.trim(stringArray[i]);
            if (string.isEmpty() || string.startsWith("* daemon") || string.startsWith("List of devices")) continue;
            String[] stringArray2 = string.split("\\s+");
            String string2 = this.extractToken(stringArray2, 0, null);
            String string3 = this.extractToken(stringArray2, 1, null);
            String string4 = this.extractToken(stringArray2, 2, "product:");
            String string5 = this.extractToken(stringArray2, 3, "model:");
            String string6 = this.extractToken(stringArray2, 4, "device:");
            arrayList.add(new AdbDevice(string2, AdbDeviceStatus.fromString(string3), string4, string5, string6));
        }
        return arrayList;
    }

    private String extractToken(String[] stringArray, int n2, String string) {
        if (stringArray == null || n2 < 0 || n2 >= stringArray.length) {
            return null;
        }
        String string2 = stringArray[n2].trim();
        if (string != null) {
            if (!string2.startsWith(string)) {
                return null;
            }
            string2 = string2.substring(string.length());
        }
        return string2;
    }

    public synchronized AdbWrapper createWrapper(String string) {
        return this.createWrapper(string, this.defaultTimeout);
    }

    public synchronized AdbWrapper createWrapper(String string, long l2) {
        AdbWrapper adbWrapper = new AdbWrapper(this, this.adbPath, l2);
        adbWrapper.setTargetDevice(string);
        return adbWrapper;
    }

    private synchronized byte[] execute(Long l2, Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        arrayList.add(0, this.adbPath);
        CommandExec commandExec = new CommandExec(l2 == null ? this.defaultTimeout : l2);
        commandExec.execute(arrayList);
        byte[] byArray = commandExec.getOutput();
        return byArray;
    }

    public synchronized String toString() {
        return Strings.ff("adbFactory={%s},defaultTimeout={%dms}", this.adbPath, this.defaultTimeout);
    }
}

