/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.adb;

import com.pnfsoftware.jeb.core.units.code.android.adb.AdbDevice;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbForwardType;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbPackage;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbPackageManagerOptions;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbProcess;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbResult;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbUtil;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbWrapperFactory;
import com.pnfsoftware.jeb.core.units.code.android.adb.AndroidDeviceUtil;
import com.pnfsoftware.jeb.util.concurrent.CommandExec;
import com.pnfsoftware.jeb.util.concurrent.ProcessWrapper;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AdbWrapper {
    private static final ILogger logger = GlobalLog.getLogger(AdbWrapper.class);
    public static final long STANDARD_TIMEOUT = 5000L;
    private AdbWrapperFactory adbf;
    private String adbPath;
    private long defaultTimeout;
    private String targetDeviceSerial;
    private String runAsPath = "run-as";
    private Map<String, String> toolNames = new HashMap<String, String>();

    AdbWrapper(AdbWrapperFactory adbWrapperFactory, String string, long l2) {
        this.adbf = adbWrapperFactory;
        this.adbPath = string;
        this.defaultTimeout = l2;
    }

    public synchronized boolean initialize() {
        return this.adbf.initialize() && this.waitForDevice();
    }

    public String getPath() {
        return this.adbPath;
    }

    public synchronized void setTargetDevice(String string) {
        this.targetDeviceSerial = string;
    }

    public synchronized String getTargetDevice() {
        return this.targetDeviceSerial;
    }

    synchronized String determinePreferredTarget(String string) {
        if (string != null) {
            return string;
        }
        return this.getTargetDevice();
    }

    public synchronized void setRunAs(String string) {
        this.runAsPath = string;
    }

    public synchronized String getRunAs() {
        return this.runAsPath;
    }

    public synchronized void setToolName(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        this.toolNames.put(string, string2);
    }

    public synchronized String getToolName(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return this.toolNames.getOrDefault(string, string);
    }

    public synchronized void setDefaultTimeout(long l2) {
        this.defaultTimeout = l2;
    }

    public synchronized long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public synchronized String getVersion() {
        return this.adbf.getVersion();
    }

    public synchronized boolean startServer() {
        return this.adbf.startServer();
    }

    public synchronized void stopServer() {
        this.adbf.stopServer();
    }

    public synchronized List<AdbDevice> listDevices() {
        return this.adbf.listDevices();
    }

    public synchronized InputStream logcat() throws IOException {
        return this.logcat(null, null);
    }

    public synchronized InputStream logcat(Integer n2, String string) throws IOException {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("logcat");
        if (n2 != null) {
            arrayList.add("--pid=" + n2);
        }
        if (string != null) {
            arrayList.add("-t");
            arrayList.add("\"" + string + "\"");
        }
        if ((string2 = this.determinePreferredTarget(null)) != null) {
            arrayList.add(0, "-s");
            arrayList.add(1, string2);
        }
        ProcessWrapper processWrapper = this.executeAsync(-1L, arrayList);
        return processWrapper.getProcessOutput();
    }

    public synchronized boolean logcatClear() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("logcat");
        arrayList.add("-c");
        byte[] byArray = this.executeOn(null, null, arrayList);
        return byArray != null;
    }

    public synchronized boolean waitForDevice() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("wait-for-device");
        byte[] byArray = this.executeOn(30000L, null, arrayList);
        return AdbUtil.heurSuccess(byArray);
    }

    public synchronized boolean waitForBootCompletionHeur1() {
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() - l2 <= 30000L) {
            String string = this.readProperty("dev.bootcomplete");
            if (string != null && Strings.trim(string).equals("1")) {
                return true;
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return false;
    }

    public synchronized boolean waitForBootCompletionHeur2() {
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() - l2 <= 30000L) {
            String string = this.readProperty("init.svc.bootanim");
            if (string != null && Strings.trim(string).equals("stopped")) {
                return true;
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return false;
    }

    public synchronized boolean waitForBootCompletionHeur3() {
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() - l2 <= 180000L) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("pm", "list", "packages", "-f"));
            AdbResult adbResult = this.shell(null, null, null, arrayList);
            if (adbResult.isSuccess(null, false, "Is the system running?")) {
                return true;
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return false;
    }

    public synchronized boolean installApp(String string) {
        return this.installApp(string, false, false, false);
    }

    public synchronized boolean installAppForce(String string) {
        return this.installApp(string, true, false, false);
    }

    public synchronized boolean installApp(String string, boolean bl, boolean bl2, boolean bl3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("install");
        if (bl) {
            arrayList.add("-r");
        }
        if (bl2) {
            arrayList.add("-s");
        }
        if (bl3 && AndroidDeviceUtil.getAndroidApiLevel(this) >= 23) {
            arrayList.add("-g");
        }
        arrayList.add(string);
        byte[] byArray = this.executeOn(0L, null, arrayList);
        return AdbUtil.heurSuccess(byArray);
    }

    public synchronized boolean uninstallApp(String string) {
        return this.uninstallApp(string, false);
    }

    public synchronized boolean uninstallApp(String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("uninstall");
        if (bl) {
            arrayList.add("-k");
        }
        arrayList.add(string);
        byte[] byArray = this.executeOn(0L, null, arrayList);
        return AdbUtil.heurSuccess(byArray);
    }

    public synchronized boolean pushFile(String string, String string2) {
        byte[] byArray = this.executeOn(0L, null, Arrays.asList("push", string, string2));
        if (byArray == null) {
            return false;
        }
        String[] stringArray = new String[]{"failed ", "error:"};
        for (String string3 : Strings.splitLines(Strings.decodeLocal(byArray))) {
            for (String string4 : stringArray) {
                if (!string3.startsWith(string4)) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized boolean pullFile(String string, String string2) {
        byte[] byArray = this.executeOn(0L, null, Arrays.asList("pull", string, string2));
        if (byArray == null) {
            return false;
        }
        for (String string3 : Strings.splitLines(Strings.decodeLocal(byArray))) {
            if (!string3.contains("100%") && !string3.contains("bytes in")) continue;
            return true;
        }
        return false;
    }

    public synchronized List<Integer> listJdwpPids() {
        byte[] byArray = this.executeOn(1000L, null, Arrays.asList("jdwp"));
        if (byArray == null) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String[] stringArray = Strings.decodeLocal(byArray).split("\\r?\\n");
        if (stringArray.length != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n2;
                String string = stringArray[i].trim();
                if (string.isEmpty() || (n2 = Conversion.stringToInt(string, -1)) < 0) continue;
                arrayList.add(n2);
            }
        }
        return arrayList;
    }

    public synchronized boolean forwardJdwpToTcp(int n2, int n3) {
        byte[] byArray = this.executeOn(null, null, Arrays.asList("forward", "tcp:" + n3, "jdwp:" + n2));
        return byArray != null;
    }

    public synchronized boolean forwardLocalToTcp(String string, int n2) {
        byte[] byArray = this.executeOn(null, null, Arrays.asList("forward", "tcp:" + n2, "localfilesystem:" + string));
        return byArray != null;
    }

    public synchronized boolean forwardToTcp(AdbForwardType adbForwardType, String string, int n2) {
        byte[] byArray = this.executeOn(null, null, Arrays.asList("forward", "tcp:" + n2, adbForwardType.toString() + ":" + string));
        return byArray != null;
    }

    public synchronized boolean stopForwardToTcp(int n2) {
        byte[] byArray = this.executeOn(null, null, Arrays.asList("forward", "--remove", "tcp:" + n2));
        return byArray != null;
    }

    public synchronized boolean stopAllForwards(int n2) {
        byte[] byArray = this.executeOn(null, null, Arrays.asList("forward", "--remove-all"));
        return byArray != null;
    }

    public synchronized String readProperty(String string) {
        AdbResult adbResult = this.shell(null, Arrays.asList("getprop", string));
        if (!adbResult.isSuccess(null, false, "error: no devices found")) {
            return null;
        }
        return adbResult.getOutputString();
    }

    public synchronized List<AdbProcess> listProcesses() {
        AdbResult adbResult = this.shell(Arrays.asList("ps"));
        if (!adbResult.isSuccess(null, false, new String[0])) {
            return null;
        }
        List<AdbProcess> list = AdbProcess.parsePsData(adbResult.getOutput());
        if (AdbWrapper.heurLooksLikeUserOnlyProcList(list)) {
            long l2 = Math.max(10000L, this.getDefaultTimeout());
            adbResult = this.shell(l2, null, null, Arrays.asList("ps", "-A"), false);
            if (!adbResult.isSuccess(null, false, new String[0])) {
                return null;
            }
            List<AdbProcess> list2 = AdbProcess.parsePsData(adbResult.getOutput());
            if (list2.size() > list.size()) {
                list = list2;
            }
        }
        return list;
    }

    private static final boolean heurLooksLikeUserOnlyProcList(List<AdbProcess> list) {
        if (list.size() <= 6) {
            for (AdbProcess adbProcess : list) {
                String string = adbProcess.getName();
                if (!string.equals("ps")) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized List<AdbPackage> listPackages() {
        return this.listPackages(null);
    }

    public synchronized List<AdbPackage> listPackages(AdbPackageManagerOptions adbPackageManagerOptions) {
        AdbResult adbResult;
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("pm", "list", "packages", "-f"));
        if (adbPackageManagerOptions != null && adbPackageManagerOptions.thirdPartyOnly) {
            arrayList.add("-3");
        }
        if (!(adbResult = this.shell(null, null, null, arrayList)).isSuccess(null, false, new String[0])) {
            return null;
        }
        ArrayList<AdbPackage> arrayList2 = new ArrayList<AdbPackage>();
        String[] stringArray = adbResult.getOutputString().split("\\r?\\n");
        if (stringArray.length == 0) {
            return arrayList2;
        }
        Pattern pattern = Pattern.compile("package:([^=]+)=(.+)");
        for (int i = 0; i < stringArray.length; ++i) {
            Matcher matcher;
            String string = stringArray[i].trim();
            if (string.isEmpty() || !(matcher = pattern.matcher(string)).matches() || matcher.groupCount() != 2) continue;
            AdbPackage adbPackage = new AdbPackage(matcher.group(2), matcher.group(1));
            arrayList2.add(adbPackage);
        }
        return arrayList2;
    }

    public synchronized boolean startActivity(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("am", "start"));
        if (bl) {
            arrayList.add("-D");
        }
        if (bl2) {
            arrayList.add("-W");
        }
        if (bl3) {
            arrayList.add("-S");
        }
        arrayList.add("-n");
        arrayList.add(Strings.ff("%s/.%s", string, string2));
        AdbResult adbResult = this.shell(arrayList);
        return adbResult.isSuccess(null, false, new String[0]);
    }

    public synchronized boolean startActivity(String string, String string2) {
        return this.startActivity(string, string2, false, false, false);
    }

    public synchronized boolean stopApp(String string) {
        List<String> list = Arrays.asList("am", "force-stop", string);
        AdbResult adbResult = this.shell(list);
        return adbResult.isSuccess(null, false, new String[0]) && AdbUtil.heurSuccess(adbResult.getOutput());
    }

    public synchronized void killProcess(String string, int n2) {
        this.shellLog(string, Arrays.asList("kill", Integer.toString(n2)));
    }

    public synchronized boolean stopProcess(String string, int n2) {
        return this.killProcess(string, n2, "SIGSTOP", "TSTP");
    }

    public synchronized void killProcess(String string, int n2, int n3) {
        this.shellLog(string, Arrays.asList("kill", "-" + n3, Integer.toString(n2)));
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean killProcess(String string, int n2, String ... stringArray) {
        for (String string2 : stringArray) {
            void object;
            AdbResult adbResult;
            if (!string2.startsWith("-")) {
                String string3 = "-" + string2;
            }
            if ((adbResult = this.shell(string, Arrays.asList("kill", object, Integer.toString(n2)))).isSuccess(Boolean.FALSE, false, new String[0])) {
                return true;
            }
            String string4 = adbResult.getOutputString();
            if (string4.toLowerCase().startsWith("invalid signal name")) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean hasFile(String string, String string2) {
        AdbResult adbResult = this.shell(string, Arrays.asList("ls", string2));
        return adbResult.isSuccess(Boolean.TRUE);
    }

    public synchronized boolean touchFile(String string, String string2) {
        AdbResult adbResult = this.shell(string, Arrays.asList("touch", string2));
        return adbResult.isSuccess();
    }

    public synchronized boolean deleteFile(String string, String string2, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("rm");
        arrayList.add("-f");
        if (bl) {
            arrayList.add("-r");
        }
        arrayList.add(string2);
        AdbResult adbResult = this.shell(string, arrayList);
        return adbResult.isSuccess();
    }

    public synchronized boolean copyFile(String string, String string2, String string3, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("cp");
        if (bl) {
            arrayList.add("-R");
        }
        arrayList.add(string2);
        arrayList.add(string3);
        AdbResult adbResult = this.shell(string, arrayList);
        return adbResult.isSuccess();
    }

    public synchronized boolean chmod(String string, String string2, int n2, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("chmod");
        if (bl) {
            arrayList.add("-R");
        }
        arrayList.add(Integer.toOctalString(n2));
        arrayList.add(string2);
        AdbResult adbResult = this.shell(string, arrayList);
        return adbResult.isSuccess();
    }

    public synchronized boolean chown(String string, String string2, String string3, String string4, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("chown");
        if (bl) {
            arrayList.add("-R");
        }
        arrayList.add(string3 + (String)(string4 == null ? "" : ":" + string4));
        arrayList.add(string2);
        AdbResult adbResult = this.shell(string, arrayList);
        return adbResult.isSuccess();
    }

    public synchronized String which(String string, String string2) {
        AdbResult adbResult = this.shell(string, Arrays.asList("which", string2));
        if (!adbResult.isSuccess(Boolean.TRUE)) {
            return null;
        }
        return Strings.replaceNewLines(adbResult.getOutputString(), "");
    }

    public synchronized long dateEpoch() {
        AdbResult adbResult = this.shell(null, Arrays.asList("date", "+%s"));
        if (!adbResult.isSuccess(Boolean.TRUE, false, new String[0])) {
            return -1L;
        }
        return Conversion.stringToLong(adbResult.getOutputString(), -1L);
    }

    public synchronized String dateString(boolean bl) {
        String string = bl ? "\"+%Y-%m-%d_%H:%M:%S_%z\"" : "\"+%Y-%m-%d_%H:%M:%S\"";
        AdbResult adbResult = this.shell(null, Arrays.asList("date", string));
        if (!adbResult.isSuccess(Boolean.TRUE)) {
            return null;
        }
        return Strings.trim(adbResult.getOutputString());
    }

    public synchronized AdbResult shellLog(String string, List<String> list) {
        return this.shell(null, null, string, list, true);
    }

    public synchronized AdbResult shell(String string, List<String> list) {
        return this.shell(null, null, string, list, false);
    }

    public synchronized AdbResult shell(Long l2, String string, String string2, List<String> list) {
        return this.shell(l2, string, string2, list, false);
    }

    public synchronized AdbResult shell(List<String> list) {
        return this.shell(null, null, null, list, false);
    }

    public synchronized AdbResult shell(Long l2, String string, String string2, List<String> list, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(list);
        if (string2 != null && this.getRunAs() != null) {
            arrayList.add(0, this.getRunAs());
            arrayList.add(1, string2);
        }
        arrayList.add(0, "shell");
        arrayList.add("|| echo adb_error_sent_to_jeb");
        byte[] byArray = this.executeOn(l2, string, arrayList);
        if (bl && byArray != null && byArray.length > 0) {
            logger.info("Command \"adb %s\" returned: %s", Strings.join(" ", arrayList), Strings.decodeLocal(byArray));
        }
        return new AdbResult(byArray);
    }

    public synchronized byte[] executeOn(Long l2, String string, Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        if ((string = this.determinePreferredTarget(string)) != null) {
            arrayList.add(0, "-s");
            arrayList.add(1, string);
        }
        return this.execute(l2, arrayList);
    }

    public synchronized byte[] execute(Long l2, Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        arrayList.add(0, this.adbPath);
        CommandExec commandExec = new CommandExec(l2 == null ? this.defaultTimeout : l2);
        commandExec.execute(arrayList);
        byte[] byArray = commandExec.getOutput();
        return byArray;
    }

    public synchronized ProcessWrapper executeAsync(Long l2, Collection<String> collection) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        arrayList.add(0, this.adbPath);
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        ProcessWrapper processWrapper = new ProcessWrapper(l2 == null ? this.defaultTimeout : l2, stringArray);
        try {
            processWrapper.start();
            (new Object[1])[0] = Strings.joinList(arrayList);
            return processWrapper;
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{Strings.joinList(arrayList), iOException};
            throw iOException;
        }
    }

    public synchronized ProcessWrapper shellAsync(Long l2, String string, String string2, List<String> list) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(list);
        if (string2 != null && this.getRunAs() != null) {
            arrayList.add(0, this.getRunAs());
            arrayList.add(1, string2);
        }
        arrayList.add(0, "shell");
        string = this.determinePreferredTarget(string);
        if (string != null) {
            arrayList.add(0, "-s");
            arrayList.add(1, string);
        }
        return this.executeAsync(l2, arrayList);
    }

    public synchronized String toString() {
        return Strings.ff("adb={%s},defaultTimeout={%dms}", this.adbPath, this.defaultTimeout);
    }
}

