/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.adb;

import com.pnfsoftware.jeb.util.base.Env;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AdbUtil {
    private static final ILogger logger = GlobalLog.getLogger(AdbUtil.class);
    public static final String adbName = "adb";
    public static final String legacySdkLocationVar = "ANDROID_SDK_ROOT";
    public static final String currentSdkLocationVar = "ANDROID_HOME";
    private static final List<String> sdkLocationVars = Arrays.asList("ANDROID_SDK_ROOT", "ANDROID_HOME");
    private static final String sdkToolsDir = "platform-tools";

    public static File findAdbOnCurrentSystem() throws IOException {
        Object object;
        OSType oSType = OSType.determine();
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object2 = sdkLocationVars.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            String string = Env.get((String)object);
            if (!Strings.isBlank(string)) {
                logger.debug("[adb] %s: Environment variable added to list of candidate Android SDK locations", object);
                arrayList.add(new File(IO.expandPath(string), sdkToolsDir).getAbsolutePath());
                continue;
            }
            logger.debug("[adb] %s: Environment variable NOT found", object);
        }
        if (arrayList.isEmpty()) {
            object2 = null;
            if (oSType.isWindows()) {
                object2 = Env.getsafe("LOCALAPPDATA") + "\\Android\\sdk";
            } else if (oSType.isMac()) {
                object2 = "~/Library/Android/sdk";
            } else if (oSType.isLinux()) {
                object2 = "~/Android/Sdk";
            }
            if (object2 != null) {
                logger.debug("[adb] %s: OS-specific location found and added to list of candidate Android SDK locations", object2);
                arrayList.add(new File(IO.expandPath((String)object2), sdkToolsDir).getAbsolutePath());
            }
        }
        if (arrayList.isEmpty() && !Strings.isBlank((CharSequence)(object = Env.getsafe((String)(object2 = "ANDROID_SDK_HOME"))))) {
            logger.debug("[adb] %s: WARNING: Unofficial environment variable added to list of candidate Android SDK locations. (You should use one of the following instead: %s.)", object2, sdkLocationVars);
            arrayList.add(new File(IO.expandPath((String)object), sdkToolsDir).getAbsolutePath());
        }
        if (!Strings.isBlank((CharSequence)(object2 = Env.get("PATH")))) {
            logger.debug("[adb] PATH: added to list of searched folders: %s", object2);
            arrayList.addAll(Arrays.asList(((String)object2).split(File.pathSeparator)));
        }
        object = adbName;
        if (oSType.isWindows()) {
            object = (String)object + ".exe";
        }
        logger.debug("[adb] Searching for '%s' in folders, by order: %s", object, arrayList);
        for (String string : arrayList) {
            File file = new File(string, (String)object);
            if (!file.isFile()) continue;
            logger.debug("[adb] Found and using: %s", file);
            return file;
        }
        throw new IOException("The Android Debug Bridge tool (ADB) was not found. Make sure the Android SDK is installed and reference it via the $ANDROID_HOME environment variable.");
    }

    static boolean heurSuccess(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        String string = Strings.decodeLocal(byArray);
        if (string.contains("adb: error")) {
            return false;
        }
        return !string.contains("No such file");
    }
}

