/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android;

import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.core.units.IXmlUnit;
import com.pnfsoftware.jeb.util.collect.Lists;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlResourceHelper {
    protected Document doc;
    protected Element rootElt;

    public XmlResourceHelper(IXmlUnit iXmlUnit) {
        this.prepare(iXmlUnit);
    }

    public XmlResourceHelper(Document document) {
        this.prepare(document);
    }

    private void prepare(IXmlUnit iXmlUnit) {
        if (!iXmlUnit.isProcessed() && !iXmlUnit.process()) {
            throw new JebRuntimeException("Cannot process the xml unit");
        }
        Document document = iXmlUnit.getDocument();
        if (document != null) {
            this.prepare(document);
        }
    }

    protected void prepare(Document document) {
        if (document == null) {
            throw new IllegalArgumentException();
        }
        this.doc = document;
        this.rootElt = document.getDocumentElement();
    }

    public Element getRootElement() {
        return this.rootElt;
    }

    protected String buildAttributeName(String string) {
        return string;
    }

    protected List<Node> convertNodelist(NodeList nodeList) {
        int n2 = nodeList.getLength();
        ArrayList<Node> arrayList = new ArrayList<Node>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(nodeList.item(i));
        }
        return arrayList;
    }

    protected List<Element> convertEltlist(NodeList nodeList) {
        int n2 = nodeList.getLength();
        ArrayList<Element> arrayList = new ArrayList<Element>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add((Element)nodeList.item(i));
        }
        return arrayList;
    }

    public String readAttribute(String string, String string2) {
        List<String> list = this.readAttributes(string, string2, 1);
        return list.isEmpty() ? null : list.get(0);
    }

    public List<String> readAttributes(String string, String string2) {
        return this.readAttributes(string, string2, -1);
    }

    public boolean hasAttributeValue(String string, String string2, String string3) {
        return this.readAttributes(string, string2).contains(string3);
    }

    private List<String> readAttributes(String string, String string2, int n2) {
        Object object;
        List<Element> list;
        if (string2 == null || Strings.isBlank(string2)) {
            throw new IllegalArgumentException("Null attribute");
        }
        if (string == null || string.equals("manifest")) {
            list = Lists.createArrayList(this.rootElt);
        } else {
            object = this.rootElt.getElementsByTagName(string);
            list = this.convertEltlist((NodeList)object);
            if (n2 >= 0 && list.size() > n2) {
                list = list.subList(0, n2);
            }
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        object = this.buildAttributeName(string2);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Element element : list) {
            String string3 = this.getAttr(element, (String)object);
            arrayList.add(string3);
        }
        return arrayList;
    }

    public List<List<String>> readMultiAttributes(String string, String ... stringArray) {
        Object object;
        List<Element> list;
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("No attributes");
        }
        if (string == null || string.equals("manifest")) {
            list = Lists.createArrayList(this.rootElt);
        } else {
            object = this.rootElt.getElementsByTagName(string);
            list = this.convertEltlist((NodeList)object);
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        object = new ArrayList(stringArray.length);
        for (String object2 : stringArray) {
            object.add(this.buildAttributeName(object2));
        }
        ArrayList arrayList = new ArrayList(list.size());
        for (Element element : list) {
            ArrayList<String> arrayList2 = new ArrayList<String>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = this.getAttr(element, string2);
                arrayList2.add(string3);
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    protected String getAttr(Element element, String string) {
        Attr attr = element.getAttributeNode(string);
        if (attr != null) {
            return attr.getNodeValue();
        }
        if (this.isFullyQualifiedName(string)) {
            return "";
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        for (int i = 0; i < n2; ++i) {
            attr = (Attr)namedNodeMap.item(i);
            String string2 = attr.getName();
            if (!(string2 = this.getSimpleName(string2)).equals(string)) continue;
            return attr.getNodeValue();
        }
        return "";
    }

    protected boolean isFullyQualifiedName(String string) {
        return string.indexOf(58) >= 0;
    }

    protected boolean isSimpleName(String string) {
        return string.indexOf(58) < 0;
    }

    protected String getSimpleName(String string) {
        int n2 = string.lastIndexOf(58);
        return n2 < 0 ? string : string.substring(n2 + 1);
    }
}

