/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;

public class JvmUtil {
    private static HashMap<String, String> primToLetter = new HashMap();

    public static String generateTypeSig(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return primToLetter.get(clazz.getName());
        }
        if (clazz.isArray()) {
            return clazz.getName().replace('.', '/');
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    public static String generateConstructorSig(Constructor<?> constructor) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(JvmUtil.generateTypeSig(constructor.getDeclaringClass()));
        stringBuilder.append("->");
        stringBuilder.append("<init>");
        stringBuilder.append("(");
        for (Class<?> clazz : constructor.getParameterTypes()) {
            stringBuilder.append(JvmUtil.generateTypeSig(clazz));
        }
        stringBuilder.append(")");
        stringBuilder.append("V");
        return stringBuilder.toString();
    }

    public static String generateMethodSig(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(JvmUtil.generateTypeSig(method.getDeclaringClass()));
        stringBuilder.append("->");
        stringBuilder.append(method.getName());
        stringBuilder.append("(");
        for (Class<?> clazz : method.getParameterTypes()) {
            stringBuilder.append(JvmUtil.generateTypeSig(clazz));
        }
        stringBuilder.append(")");
        stringBuilder.append(JvmUtil.generateTypeSig(method.getReturnType()));
        return stringBuilder.toString();
    }

    static String generateMethodOrConstructorSig(Executable executable) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(JvmUtil.generateTypeSig(executable.getDeclaringClass()));
        stringBuilder.append("->");
        if (executable instanceof Method) {
            stringBuilder.append(executable.getName());
        } else if (executable instanceof Constructor) {
            stringBuilder.append("<init>");
        } else {
            throw new RuntimeException();
        }
        stringBuilder.append("(");
        for (Class<?> clazz : executable.getParameterTypes()) {
            stringBuilder.append(JvmUtil.generateTypeSig(clazz));
        }
        stringBuilder.append(")");
        if (executable instanceof Method) {
            stringBuilder.append(JvmUtil.generateTypeSig(((Method)executable).getReturnType()));
        } else {
            stringBuilder.append("V");
        }
        return stringBuilder.toString();
    }

    public static String generateFieldSig(Field field) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(JvmUtil.generateTypeSig(field.getDeclaringClass()));
        stringBuilder.append("->");
        stringBuilder.append(field.getName());
        stringBuilder.append(":");
        stringBuilder.append(JvmUtil.generateTypeSig(field.getType()));
        return stringBuilder.toString();
    }

    static {
        primToLetter.put("boolean", "Z");
        primToLetter.put("byte", "B");
        primToLetter.put("char", "C");
        primToLetter.put("short", "S");
        primToLetter.put("int", "I");
        primToLetter.put("long", "J");
        primToLetter.put("float", "F");
        primToLetter.put("double", "D");
        primToLetter.put("void", "V");
    }
}

