/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class JvmMethodSig {
    public String csig;
    public String mname;
    public String rettype;
    public List<String> partypes = new ArrayList<String>();

    private JvmMethodSig() {
    }

    public JvmMethodSig(String string, String string2, String string3, String ... stringArray) {
        this.csig = string;
        this.mname = string2;
        this.rettype = string3;
        this.partypes = new ArrayList<String>(Arrays.asList(stringArray));
    }

    public JvmMethodSig(String string, String string2, String string3, Collection<String> collection) {
        this.csig = string;
        this.mname = string2;
        this.rettype = string3;
        this.partypes = new ArrayList<String>(collection);
    }

    public String getType() {
        return this.csig;
    }

    public String getMethodName() {
        return this.mname;
    }

    public String getReturnType() {
        return this.rettype;
    }

    public List<String> getParameterTypes() {
        return Collections.unmodifiableList(this.partypes);
    }

    public String generate() {
        StringBuilder stringBuilder = new StringBuilder(this.csig);
        stringBuilder.append("->");
        stringBuilder.append(this.mname);
        stringBuilder.append("(");
        this.partypes.forEach(string -> stringBuilder.append((String)string));
        stringBuilder.append(")");
        stringBuilder.append(this.rettype);
        return stringBuilder.toString();
    }

    public static JvmMethodSig parse(String string) {
        JvmMethodSig jvmMethodSig = JvmMethodSig.parseSafe(string);
        if (jvmMethodSig == null) {
            throw new IllegalArgumentException("Illegal method signature: " + string);
        }
        return jvmMethodSig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JvmMethodSig parseSafe(String string) {
        try {
            JvmMethodSig jvmMethodSig = new JvmMethodSig();
            int n2 = string.indexOf("->");
            if (n2 < 0) {
                return null;
            }
            jvmMethodSig.csig = string.substring(0, n2);
            String string2 = string.substring(n2 + 2);
            if ((n2 = string2.indexOf("(")) < 0) {
                return null;
            }
            jvmMethodSig.mname = string2.substring(0, n2);
            if ((n2 = (string2 = string2.substring(n2)).indexOf(")")) < 0) {
                return null;
            }
            jvmMethodSig.rettype = string2.substring(n2 + 1);
            string2 = string2.substring(1, n2);
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 >= string2.length()) {
                    return jvmMethodSig;
                }
                int n5 = n3;
                char c2 = string2.charAt(n3);
                while (c2 == '[') {
                    c2 = string2.charAt(++n3);
                }
                switch (c2) {
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'Z': {
                        n4 = n3 + 1;
                        break;
                    }
                    case 'L': {
                        int n6 = string2.indexOf(59, n3);
                        if (n6 < 0) {
                            return null;
                        }
                        n4 = n6 + 1;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                String string3 = string2.substring(n5, n4);
                jvmMethodSig.partypes.add(string3);
                n3 = n4;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String nameAndParams(String string) {
        int n2 = string.indexOf("->");
        if (n2 < 0) {
            return null;
        }
        int n3 = string.indexOf(")", n2 += 2);
        if (n3 < 0) {
            return null;
        }
        return string.substring(n2, ++n3);
    }
}

