/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android;

import com.pnfsoftware.jeb.core.units.code.android.DexUtil;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.List;

public class JvmGenericsTypeSig {
    public String raw;
    public int arrayDim;
    public char baseType;
    public String typeVar;
    public List<String> pkgElts = new ArrayList<String>();
    public List<Couple<String, List<TypeArg>>> classes = new ArrayList<Couple<String, List<TypeArg>>>();

    public static JvmGenericsTypeSig parse(String string) {
        JvmGenericsTypeSig jvmGenericsTypeSig = JvmGenericsTypeSig.parse(string, 0);
        Assert.a(jvmGenericsTypeSig.raw.length() == string.length());
        return jvmGenericsTypeSig;
    }

    public static JvmGenericsTypeSig parse(String string, int n2) {
        JvmGenericsTypeSig jvmGenericsTypeSig = new JvmGenericsTypeSig();
        int n3 = n2;
        char c2 = string.charAt(n3);
        ++n3;
        int n4 = 0;
        while (c2 == '[') {
            ++n4;
            c2 = string.charAt(n3);
            ++n3;
        }
        block0 : switch (c2) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                jvmGenericsTypeSig.baseType = c2;
                break;
            }
            default: {
                if (c2 == 'L') {
                    while (n3 < string.length()) {
                        int n5 = DexUtil.parseSimpleName(string, n3, 0);
                        Assert.a(n5 > n3 && n5 < string.length());
                        String string2 = string.substring(n3, n5);
                        n3 = n5;
                        c2 = string.charAt(n3);
                        ++n3;
                        if (c2 == '/') {
                            Assert.a(jvmGenericsTypeSig.classes.isEmpty());
                            jvmGenericsTypeSig.pkgElts.add(string2);
                            continue;
                        }
                        ArrayList<TypeArg> arrayList = new ArrayList<TypeArg>();
                        if (c2 == '<') {
                            c2 = string.charAt(n3);
                            ++n3;
                            JvmGenericsTypeSig jvmGenericsTypeSig2 = null;
                            if (c2 == '+' || c2 == '-') {
                                jvmGenericsTypeSig2 = JvmGenericsTypeSig.parse(string, n3);
                                n3 += jvmGenericsTypeSig2.raw.length();
                            } else if (c2 != '*') {
                                Assert.fail();
                            }
                            arrayList.add(new TypeArg(c2, jvmGenericsTypeSig2));
                            c2 = string.charAt(n3);
                            Assert.a(c2 == '>');
                            c2 = string.charAt(++n3);
                            ++n3;
                        }
                        jvmGenericsTypeSig.classes.add(new Couple(string2, arrayList));
                        if (c2 == '.') continue;
                        Assert.a(c2 == ';');
                        break block0;
                    }
                    break;
                }
                if (c2 == 'T') {
                    int n6 = DexUtil.parseSimpleName(string, n3, 0);
                    Assert.a(n6 > n3 && n6 < string.length());
                    jvmGenericsTypeSig.typeVar = string.substring(n3, n6);
                    n3 = n6;
                    c2 = string.charAt(n3);
                    ++n3;
                    Assert.a(c2 == ';');
                    break;
                }
                Assert.fail();
            }
        }
        jvmGenericsTypeSig.arrayDim = n4;
        jvmGenericsTypeSig.raw = string.substring(n2, n3);
        return jvmGenericsTypeSig;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.arrayDim > 0) {
            stringBuilder.append("Array ");
        }
        if (this.baseType != '\u0000') {
            stringBuilder.append(this.baseType);
        } else if (this.typeVar != null) {
            Strings.ff(stringBuilder, "<%s>", this.typeVar);
        } else {
            Strings.ff(stringBuilder, "%s %s", Strings.join(" ", this.pkgElts), Strings.join(" ", this.classes));
        }
        return stringBuilder.toString();
    }

    public static class TypeArg {
        public int kind;
        public JvmGenericsTypeSig type;

        public TypeArg(int n2, JvmGenericsTypeSig jvmGenericsTypeSig) {
            this.kind = n2;
            this.type = jvmGenericsTypeSig;
        }

        public String toString() {
            return Strings.ff("%c%s", Character.valueOf((char)this.kind), this.type);
        }
    }
}

