/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.units.IBinaryUnit;
import com.pnfsoftware.jeb.core.units.code.android.DexParsingException;
import com.pnfsoftware.jeb.core.units.code.android.IApkUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.ParametersInfo;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexAnnotation;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexAnnotationElement;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexAnnotationItem;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexClass;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexDebugInfo;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexField;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexFieldData;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexItem;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethodData;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexType;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexValue;
import com.pnfsoftware.jeb.corei.parsers.dex.ca;
import com.pnfsoftware.jeb.corei.parsers.dex.lc;
import com.pnfsoftware.jeb.corei.parsers.dex.nM;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.collect.BytePipe;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DexUtil {
    private static final ILogger logger = GlobalLog.getLogger(DexUtil.class);
    private static int[] flconv = new int[]{1, 1, 2, 2, 4, 4, 8, 8, 16, 16, 32, 32, 64, 64, 64, 64, 128, 128, 128, 128, 256, 256, 512, 512, 1024, 1024, 2048, 2048, 4096, 4096, 8192, 8192, 16384, 16384, 65536, 65536, 131072, 131072};

    private DexUtil() {
    }

    public static final int getVersion(IBinaryUnit iBinaryUnit) throws ParseException {
        ByteBuffer byteBuffer = iBinaryUnit.getInput().getHeader();
        byte[] byArray = new byte[3];
        byteBuffer.position(4);
        byteBuffer.get(byArray);
        if (!(Character.isDigit(byArray[0]) && Character.isDigit(byArray[1]) && Character.isDigit(byArray[2]))) {
            throw new ParseException("Illegal version number", 0);
        }
        String string = Strings.decodeASCII(byArray);
        string = Strings.ltrim(string, '0');
        return Conversion.stringToInt(string);
    }

    private static void illegalEncoding(String object, byte[] byArray, int n2) {
        int n3;
        if (object == null) {
            object = "Illegal encoding";
        }
        if ((n3 = byArray.length - n2) < 0) {
            object = (String)object + ": nothing to decode";
        }
        throw new DexParsingException((String)object);
    }

    public static int bytearrayULEInt16ToInt(byte[] byArray, int n2) {
        if (n2 + 2 > byArray.length) {
            DexUtil.illegalEncoding("INT16: not enough data", byArray, n2);
        }
        int n3 = byArray[n2] & 0xFF;
        return n3 |= (byArray[n2 + 1] & 0xFF) << 8;
    }

    public static int bytearrayULEInt32ToInt(byte[] byArray, int n2) {
        if (n2 + 4 > byArray.length) {
            DexUtil.illegalEncoding("INT32: not enough data", byArray, n2);
        }
        int n3 = byArray[n2] & 0xFF;
        n3 |= (byArray[n2 + 1] & 0xFF) << 8;
        n3 |= (byArray[n2 + 2] & 0xFF) << 16;
        if ((n3 |= (byArray[n2 + 3] & 0xFF) << 24) < -1) {
            DexUtil.illegalEncoding("INT32: resulting in -1", byArray, n2);
        }
        return n3;
    }

    public static int bytearraySLEB128ToInt(byte[] byArray, int n2, int[] nArray) {
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        while (n4 < 0) {
            if (n2 + n5 >= byArray.length) {
                DexUtil.illegalEncoding("LEB128: not enough data", byArray, n2);
            }
            n4 = byArray[n2 + n5];
            n3 |= (n4 & 0x7F) << n5 * 7;
            ++n5;
        }
        if (n5 > 5) {
            DexUtil.illegalEncoding("LEB128: too long", byArray, n2);
        }
        if ((n4 & 0x40) != 0) {
            if (n5 == 1) {
                n3 |= 0xFFFFFF80;
            } else if (n5 == 2) {
                n3 |= 0xFFFFC000;
            } else if (n5 == 3) {
                n3 |= 0xFFE00000;
            } else if (n5 == 4) {
                n3 |= 0xF0000000;
            }
        }
        nArray[0] = n5;
        return n3;
    }

    public static int bytearrayULEB128ToInt(byte[] byArray, int n2, int[] nArray) {
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        while (n4 < 0) {
            if (n2 + n5 >= byArray.length) {
                DexUtil.illegalEncoding("ULEB128: not enough data", byArray, n2);
            }
            n4 = byArray[n2 + n5];
            n3 |= (n4 & 0x7F) << n5 * 7;
            ++n5;
        }
        if (n5 > 5) {
            DexUtil.illegalEncoding("ULEB128: too long", byArray, n2);
        }
        nArray[0] = n5;
        return n3;
    }

    public static int bytearrayULEB128P1ToInt(byte[] byArray, int n2, int[] nArray) {
        int n3 = DexUtil.bytearrayULEB128ToInt(byArray, n2, nArray);
        return n3 - 1;
    }

    public static String bytearrayMUTF8ToStringFast(byte[] byArray, int n2, int[] nArray, int n3) {
        char[] cArray = new char[n3];
        int n4 = 0;
        int n5 = n2;
        while (true) {
            if (n5 >= byArray.length) {
                DexUtil.illegalEncoding("MUTF8: not enough data at offset " + n5, byArray, n2);
            }
            int n6 = byArray[n5] & 0xFF;
            ++n5;
            if (n6 == 0) break;
            if (n4 >= n3) {
                DexUtil.illegalEncoding("MUTF8: string is longer than expected: " + n3, byArray, n2);
            }
            if ((n6 & 0x80) != 0) {
                int n7;
                if ((n6 & 0xE0) == 192) {
                    if (n5 >= byArray.length) {
                        DexUtil.illegalEncoding("MUTF8: 2be: not enough data at offset " + n5, byArray, n2);
                    }
                    n7 = byArray[n5] & 0xFF;
                    ++n5;
                    if ((n7 & 0xC0) == 128) {
                        n6 = (n6 & 0x1F) << 6 | n7 & 0x3F;
                    } else {
                        DexUtil.illegalEncoding("MUTF8: Invalid 2-byte encoding at offset " + n5, byArray, n2);
                    }
                } else if ((n6 & 0xF0) == 224) {
                    if (n5 + 2 > byArray.length) {
                        DexUtil.illegalEncoding("MUTF8: 3be: not enough data at offset " + n5, byArray, n2);
                    }
                    n7 = byArray[n5] & 0xFF;
                    int n8 = byArray[++n5] & 0xFF;
                    ++n5;
                    if ((n7 & 0xC0) == 128 && (n8 & 0xC0) == 128) {
                        n6 = (n6 & 0xF) << 12 | (n7 & 0x3F) << 6 | n8 & 0x3F;
                    } else {
                        DexUtil.illegalEncoding("MUTF8: Invalid 3-byte encoding at offset " + n5, byArray, n2);
                    }
                } else {
                    DexUtil.illegalEncoding("MUTF8: Invalid encoding at offset " + n5, byArray, n2);
                }
            }
            cArray[n4++] = (char)n6;
        }
        if (nArray != null) {
            nArray[0] = n5 - n2;
        }
        return new String(cArray);
    }

    public static String bytearrayMUTF8ToString(byte[] byArray, int n2, int[] nArray) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = n2;
        int n5 = 0;
        while (true) {
            int n6;
            if (n4 >= byArray.length) {
                DexUtil.illegalEncoding("MUTF8: not enough data at offset " + n4, byArray, n2);
            }
            n3 = byArray[n4] & 0xFF;
            ++n4;
            if (n3 == 0) break;
            if ((n3 & 0x80) != 0) {
                if ((n3 & 0xE0) == 192) {
                    if (n4 >= byArray.length) {
                        DexUtil.illegalEncoding("MUTF8: 2be: not enough data at offset " + n4, byArray, n2);
                    }
                    n6 = byArray[n4] & 0xFF;
                    ++n4;
                    if ((n6 & 0xC0) == 128) {
                        n3 = (n3 & 0x1F) << 6 | n6 & 0x3F;
                    } else {
                        DexUtil.illegalEncoding("MUTF8: Invalid 2-byte encoding at offset " + n4, byArray, n2);
                    }
                } else if ((n3 & 0xF0) == 224) {
                    if (n4 + 2 > byArray.length) {
                        DexUtil.illegalEncoding("MUTF8: 3be: not enough data at offset " + n4, byArray, n2);
                    }
                    n6 = byArray[n4] & 0xFF;
                    int n7 = byArray[++n4] & 0xFF;
                    ++n4;
                    if ((n6 & 0xC0) == 128 && (n7 & 0xC0) == 128) {
                        if ((n3 = (n3 & 0xF) << 12 | (n6 & 0x3F) << 6 | n7 & 0x3F) >= 55296 && n3 <= 56319) {
                            if (n5 != 0) {
                                Object[] cfr_ignored_0 = new Object[0];
                                int n8 = (n5 - 65536 >> 10) + 55296;
                                stringBuilder.appendCodePoint(n8);
                            }
                            n5 = 65536 + (n3 - 55296 << 10);
                            continue;
                        }
                        if (n3 >= 56320 && n3 <= 57343) {
                            if (n5 == 0) {
                                (new Object[1])[0] = n3;
                            } else {
                                n3 = n5 + (n3 - 56320);
                                n5 = 0;
                            }
                        }
                    } else {
                        DexUtil.illegalEncoding("MUTF8: Invalid 3-byte encoding at offset " + n4, byArray, n2);
                    }
                } else {
                    DexUtil.illegalEncoding("MUTF8: Invalid encoding at offset " + n4, byArray, n2);
                }
            }
            if (n5 != 0) {
                Object[] cfr_ignored_1 = new Object[0];
                n6 = (n5 - 65536 >> 10) + 55296;
                n5 = 0;
                stringBuilder.appendCodePoint(n6);
            }
            stringBuilder.appendCodePoint(n3);
        }
        if (n5 != 0) {
            n3 = (n5 - 65536 >> 10) + 55296;
            stringBuilder.appendCodePoint(n3);
        }
        if (nArray != null) {
            nArray[0] = n4 - n2;
        }
        return stringBuilder.toString();
    }

    public static String stringFromMUTF8(byte[] byArray) {
        return DexUtil.bytearrayMUTF8ToString(byArray, 0, null);
    }

    public static byte[] stringToMUTF8(String string) {
        return DexUtil.stringToMUTF8(string, true);
    }

    public static byte[] stringToMUTF8(String string, boolean bl) {
        BytePipe bytePipe = new BytePipe();
        for (char c2 : string.toCharArray()) {
            if (c2 == '\u0000') {
                bytePipe.append(192);
                bytePipe.append(128);
                continue;
            }
            if (c2 <= '\u007f') {
                bytePipe.append(c2);
                continue;
            }
            if (c2 <= '\u07ff') {
                bytePipe.append(0xC0 | c2 >>> 6);
                bytePipe.append(0x80 | c2 & 0x3F);
                continue;
            }
            bytePipe.append(0xE0 | c2 >>> 12);
            bytePipe.append(0x80 | c2 >>> 6 & 0x3F);
            bytePipe.append(0x80 | c2 & 0x3F);
        }
        if (bl) {
            bytePipe.append(0);
        }
        return bytePipe.getAll();
    }

    public static int convertDexFlagsToCodeFlags(int n2) {
        int n3 = 0;
        for (int i = 0; n2 != 0 && i < flconv.length; i += 2) {
            if ((n2 & flconv[i]) == 0) continue;
            n2 &= ~flconv[i];
            n3 |= flconv[i + 1];
        }
        return n3;
    }

    public static void validateFlags(int n2) {
        if ((n2 & 0xFFFC8000) != 0) {
            throw new DexParsingException("Invalid access flags: " + n2);
        }
    }

    public static void validateClassFlags(int n2) {
        if ((n2 & 0xFFFF89E0) != 0) {
            throw new DexParsingException("Invalid class access flags: " + n2);
        }
    }

    public static void validateFieldFlags(int n2) {
        if ((n2 & 0xFFFFAF20) != 0) {
            throw new DexParsingException("Invalid field access flags: " + n2);
        }
    }

    public static void validateMethodFlags(int n2) {
        if ((n2 & 0xFFFCE200) != 0) {
            throw new DexParsingException("Invalid method access flags: " + n2);
        }
    }

    public static String formatAccessFlags(int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        DexUtil.appendAccessFlagString(stringBuilder, n2, 1, "public");
        DexUtil.appendAccessFlagString(stringBuilder, n2, 2, "private");
        DexUtil.appendAccessFlagString(stringBuilder, n2, 4, "protected");
        DexUtil.appendAccessFlagString(stringBuilder, n2, 8, "static");
        DexUtil.appendAccessFlagString(stringBuilder, n2, 16, "final");
        DexUtil.appendAccessFlagString(stringBuilder, n2, 1024, "abstract");
        DexUtil.appendAccessFlagString(stringBuilder, n2, 512, "interface");
        DexUtil.appendAccessFlagString(stringBuilder, n2, 16384, "enum");
        DexUtil.appendAccessFlagString(stringBuilder, n2, 32, "synchronized");
        DexUtil.appendAccessFlagString(stringBuilder, n2, 64, "volatile");
        DexUtil.appendAccessFlagString(stringBuilder, n2, 64, "bridge");
        DexUtil.appendAccessFlagString(stringBuilder, n2, 128, "transient");
        DexUtil.appendAccessFlagString(stringBuilder, n2, 128, "varargs");
        DexUtil.appendAccessFlagString(stringBuilder, n2, 256, "native");
        DexUtil.appendAccessFlagString(stringBuilder, n2, 2048, "strictfp");
        DexUtil.appendAccessFlagString(stringBuilder, n2, 4096, "synthetic");
        DexUtil.appendAccessFlagString(stringBuilder, n2, 8192, "annotation");
        DexUtil.appendAccessFlagString(stringBuilder, n2, 65536, "constructor");
        DexUtil.appendAccessFlagString(stringBuilder, n2, 131072, "declared-synchronized");
        if (n3 == 1 || n3 == -1 && stringBuilder.length() > 0) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    private static void appendAccessFlagString(StringBuilder stringBuilder, int n2, int n3, String string) {
        if (string != null && string.length() > 0 && (n2 & n3) != 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
        }
    }

    public static int determineBestBase(long l2) {
        if (-20L <= l2 && l2 <= 20L) {
            return 10;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        long l3 = l2;
        int n2 = 0;
        int n3 = 0;
        while (l3 != 0L && l3 != -1L) {
            long l4 = l3 % 10L;
            if (l4 == 0L) {
                ++n3;
            }
            l3 /= 10L;
            ++n2;
        }
        l3 = l2;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (l3 != 0L && l3 != -1L) {
            long l5 = l3 & 0xFL;
            if (l5 == 0L) {
                ++n5;
            } else if (l5 == 15L) {
                ++n6;
            }
            l3 >>= 4;
            ++n4;
        }
        int n7 = n3 - (n2 - n3);
        int n8 = n5 + n6 - (n4 - n5 - n6);
        int n9 = n7 >= n8 ? 10 : 16;
        return n9;
    }

    public static final String formatTypenames(IDexUnit iDexUnit, Collection<Integer> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (int n3 : collection) {
            if (n2 >= 1) {
                stringBuilder.append("\n");
            }
            IDexType iDexType = iDexUnit.getType(n3);
            Strings.ff(stringBuilder, "%d: %s", n3, iDexType == null ? "???" : iDexType.getName(false));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static final String formatFieldsigs(IDexUnit iDexUnit, Collection<Integer> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (int n3 : collection) {
            if (n2 >= 1) {
                stringBuilder.append("\n");
            }
            IDexField iDexField = iDexUnit.getField(n3);
            Strings.ff(stringBuilder, "%d: %s", n3, iDexField == null ? "???" : iDexField.getSignature(false));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static final String formatMethodsigs(IDexUnit iDexUnit, Collection<Integer> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (int n3 : collection) {
            if (n2 >= 1) {
                stringBuilder.append("\n");
            }
            IDexMethod iDexMethod = iDexUnit.getMethod(n3);
            Strings.ff(stringBuilder, "%d: %s", n3, iDexMethod == null ? "???" : iDexMethod.getSignature(false));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static IDexValue getStaticFieldInitializer(IDexClass iDexClass, IDexFieldData iDexFieldData) {
        int n2 = iDexClass.getData().getStaticFields().indexOf(iDexFieldData);
        if (n2 < 0 || n2 >= iDexClass.getStaticInitializers().size()) {
            return null;
        }
        return iDexClass.getStaticInitializers().get(n2);
    }

    public static String[] generateDefaultJniNames(String string) {
        String[] stringArray = string.split("->");
        if (stringArray.length != 2) {
            return null;
        }
        String string2 = stringArray[0];
        if (string2.charAt(0) != 'L' || string2.charAt(string2.length() - 1) != ';') {
            return null;
        }
        string2 = string2.substring(1, string2.length() - 1).replace("_", "_1").replace('/', '_');
        int n2 = stringArray[1].indexOf(40);
        if (n2 < 0) {
            String string3 = stringArray[1].replace("_", "_1");
            return new String[]{"Java_" + string2 + "_" + string3};
        }
        String string4 = stringArray[1].substring(0, n2).replace("_", "_1");
        String string5 = stringArray[1].substring(n2);
        string5 = string5.substring(1, string5.indexOf(41)).replace("_", "_1").replace(";", "_2").replace('/', '_');
        String string6 = "Java_" + string2 + "_" + string4;
        return new String[]{string6, string6 + "__" + string5};
    }

    public static List<String> getDebugParameterNames(IDexUnit iDexUnit, IDexMethodData iDexMethodData) {
        if (iDexMethodData.getCodeItem() == null || iDexMethodData.getCodeItem().getDebugInfo() == null) {
            return null;
        }
        IDexDebugInfo iDexDebugInfo = iDexMethodData.getCodeItem().getDebugInfo();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int n2 : iDexDebugInfo.getParameterNameIndexes()) {
            String string = null;
            if (n2 >= 0 && n2 < iDexUnit.getStringCount()) {
                string = iDexUnit.getString(n2).getValue();
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public static List<String> getAnnotatedParameterNames(IDexUnit iDexUnit, IDexMethodData iDexMethodData) {
        IDexType iDexType = iDexUnit.getType("Ldalvik/annotation/MethodParameters;");
        if (iDexType == null) {
            return null;
        }
        int n2 = iDexMethodData.getMethodIndex();
        IDexMethod iDexMethod = iDexUnit.getMethod(n2);
        IDexClass iDexClass = iDexMethod.getClassType().getImplementingClass();
        List<IDexAnnotationItem> list = iDexClass.getAnnotationsDirectory().getMethodAnnotations(n2);
        if (list.isEmpty()) {
            return null;
        }
        Optional<IDexAnnotationItem> optional = list.stream().filter(iDexAnnotationItem -> iDexAnnotationItem.getAnnotation().getTypeIndex() == iDexType.getIndex()).findFirst();
        if (!optional.isPresent()) {
            return Collections.emptyList();
        }
        IDexAnnotation iDexAnnotation = optional.get().getAnnotation();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IDexAnnotationElement iDexAnnotationElement : iDexAnnotation.getElements()) {
            if (!"names".equals(iDexAnnotationElement.getName(iDexUnit))) continue;
            IDexValue iDexValue = iDexAnnotationElement.getValue();
            if (iDexValue.getType() != 28) {
                return null;
            }
            for (IDexValue iDexValue2 : iDexValue.getArray()) {
                if (iDexValue2.getType() != 23) {
                    return null;
                }
                String string = iDexUnit.getString(iDexValue2.getStringIndex()).getValue(false);
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public static ParametersInfo getMethodParametersInfo(IDexUnit iDexUnit, IDexMethodData iDexMethodData) {
        boolean bl = (iDexMethodData.getAccessFlags() & 8) != 0;
        int n2 = iDexMethodData.getMethodIndex();
        int n3 = iDexUnit.getMethod(n2).getPrototypeIndex();
        String string = iDexUnit.getPrototype(n3).getShorty();
        return DexUtil.getMethodParametersInfo(string, bl);
    }

    public static ParametersInfo getMethodParametersInfo(String string, boolean bl) {
        int n2 = bl ? 0 : 1;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        block4: for (int i = 1; i < string.length(); ++i) {
            arrayList.add(n2);
            char c2 = string.charAt(i);
            switch (c2) {
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'L': 
                case 'S': 
                case 'Z': {
                    ++n2;
                    continue block4;
                }
                case 'D': 
                case 'J': {
                    n2 += 2;
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Unknown shorty character type: " + c2);
                }
            }
        }
        return new ParametersInfo(n2, arrayList);
    }

    public static int getMethodSlotCount(String string, boolean bl) {
        int n2 = bl ? 0 : 1;
        block4: for (int i = 1; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'L': 
                case 'S': 
                case 'Z': {
                    ++n2;
                    continue block4;
                }
                case 'D': 
                case 'J': {
                    n2 += 2;
                    continue block4;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        return n2;
    }

    public static int[] getMethodParameterIndices(IDexMethod iDexMethod) {
        IDexMethodData iDexMethodData = iDexMethod.getData();
        int n2 = iDexMethodData.getCodeItem().getRegisterCount();
        String string = iDexMethod.getPrototype().getShorty();
        int n3 = string.length() - 1;
        if (!iDexMethodData.isStatic()) {
            ++n3;
        }
        int[] nArray = new int[n3];
        int n4 = n3 - 1;
        for (int i = string.length() - 1; i >= 1; --i) {
            char c2 = string.charAt(i);
            switch (c2) {
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'L': 
                case 'S': 
                case 'Z': {
                    nArray[n4] = --n2;
                    break;
                }
                case 'D': 
                case 'J': {
                    nArray[n4] = n2 -= 2;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            --n4;
        }
        if (!iDexMethodData.isStatic()) {
            nArray[n4] = --n2;
            --n4;
        }
        Assert.a(n4 == -1);
        return nArray;
    }

    public static boolean isSubtypeOf(IDexUnit iDexUnit, int n2, int n3) {
        return ((nM)iDexUnit).XB().ce(n2, n3);
    }

    public static List<IDexClass> getMemberClasses(IDexUnit iDexUnit, IDexClass iDexClass) {
        return DexUtil.getMemberClasses(iDexUnit, (IDexItem)iDexClass);
    }

    public static List<IDexClass> getMemberClasses(IDexUnit iDexUnit, IDexMethod iDexMethod) {
        return DexUtil.getMemberClasses(iDexUnit, (IDexItem)iDexMethod);
    }

    private static List<IDexClass> getMemberClasses(IDexUnit iDexUnit, IDexItem iDexItem) {
        ArrayList<IDexClass> arrayList = new ArrayList<IDexClass>();
        lc lc2 = ((nM)iDexUnit).oW().ce((ca)iDexItem);
        for (lc lc3 : lc2.getChildren()) {
            if (!(lc3.fz() instanceof IDexClass)) continue;
            arrayList.add((IDexClass)((Object)lc3.fz()));
        }
        return arrayList;
    }

    public static IDexClass getParentClass(IDexUnit iDexUnit, IDexClass iDexClass) {
        return DexUtil.getParentClass(iDexUnit, (IDexItem)iDexClass);
    }

    private static IDexClass getParentClass(IDexUnit iDexUnit, IDexItem iDexItem) {
        lc lc2 = ((nM)iDexUnit).oW().ce((ca)iDexItem);
        lc lc3 = lc2.mm();
        if (lc3 == null) {
            return null;
        }
        ca ca2 = lc3.fz();
        if (ca2 instanceof IDexClass) {
            return (IDexClass)((Object)ca2);
        }
        if (ca2 instanceof IDexMethod) {
            return DexUtil.getParentClass(iDexUnit, ca2);
        }
        return null;
    }

    public static IDexClass getSuperClass(IDexUnit iDexUnit, IDexClass iDexClass) {
        int n2 = iDexClass.getSuperTypeIndex();
        if (n2 < 0) {
            return null;
        }
        return iDexUnit.getType(n2).getImplementingClass();
    }

    public static boolean isSimpleName(String string, int n2) {
        int n3 = DexUtil.parseSimpleName(string, 0, n2);
        return n3 == string.length();
    }

    public static int parseSimpleName(String string, int n2, int n3) {
        int n4;
        if (n2 >= string.length()) {
            return -1;
        }
        boolean bl = false;
        for (n4 = n2; n4 < string.length(); ++n4) {
            char c2 = string.charAt(n4);
            if (bl) {
                if (c2 >= '\ud800' && c2 <= '\udfff') {
                    bl = false;
                    continue;
                }
                return -1;
            }
            if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9' || c2 == '$' || c2 == '-' || c2 == '_' || c2 >= '\u00a1' && c2 <= '\u1fff' || c2 >= '\u2010' && c2 <= '\u2027' || c2 >= '\u2030' && c2 <= '\ud7ff' || c2 >= '\ue000' && c2 <= '\uffef') continue;
            if (c2 >= '\ud800' && c2 <= '\udfff') {
                bl = true;
                continue;
            }
            if (n3 != 0 && n3 < 40 || c2 != ' ' && c2 != '\u00a0' && (c2 < '\u2000' || c2 > '\u200a') && c2 != '\u202f') break;
        }
        return n4;
    }

    public static boolean isInternalClassname(String string, boolean bl, List<String> list, int n2) {
        if (string.length() < 3 || !string.startsWith("L") || !string.endsWith(";")) {
            return false;
        }
        String[] stringArray = string.substring(1, string.length() - 1).split("/", -1);
        if (stringArray.length == 0) {
            return false;
        }
        if (bl) {
            for (String string2 : stringArray) {
                if (DexUtil.isSimpleName(string2, n2)) continue;
                return false;
            }
        }
        if (list != null) {
            list.clear();
            for (String string2 : stringArray) {
                list.add(string2);
            }
        }
        return true;
    }

    public static boolean isClassname(String string, boolean bl, List<String> list, int n2) {
        String[] stringArray = string.split("\\.", -1);
        if (stringArray.length == 0) {
            return false;
        }
        if (bl) {
            for (String string2 : stringArray) {
                if (DexUtil.isSimpleName(string2, n2)) continue;
                return false;
            }
        }
        if (list != null) {
            list.clear();
            for (String string2 : stringArray) {
                list.add(string2);
            }
        }
        return true;
    }

    public static String getStringSafe(IDexUnit iDexUnit, int n2, String string) {
        return ((nM)iDexUnit).ce(n2, string, false);
    }

    public static IDexAnnotation findAnnotation(IDexUnit iDexUnit, Collection<IDexAnnotationItem> collection, String string, Integer n2) {
        IDexType iDexType = iDexUnit.getType(string);
        if (iDexType == null) {
            return null;
        }
        for (IDexAnnotationItem iDexAnnotationItem : collection) {
            if (n2 != null && iDexAnnotationItem.getVisibility() != n2.intValue() || iDexAnnotationItem.getAnnotation().getTypeIndex() != iDexType.getIndex()) continue;
            return iDexAnnotationItem.getAnnotation();
        }
        return null;
    }

    public static IDexValue findAnnotationElement(IDexUnit iDexUnit, IDexAnnotation iDexAnnotation, String string) {
        for (IDexAnnotationElement iDexAnnotationElement : iDexAnnotation.getElements()) {
            if (!string.equals(iDexAnnotationElement.getName(iDexUnit))) continue;
            return iDexAnnotationElement.getValue();
        }
        return null;
    }

    public static IApkUnit findParentApk(IDexUnit iDexUnit) {
        IUnitCreator iUnitCreator = iDexUnit.getParent();
        if (!(iUnitCreator instanceof IApkUnit)) {
            return null;
        }
        return (IApkUnit)iUnitCreator;
    }

    public static String findPackageName(IDexUnit iDexUnit) {
        IUnitCreator iUnitCreator = iDexUnit.getParent();
        if (!(iUnitCreator instanceof IApkUnit)) {
            return null;
        }
        return ((IApkUnit)iUnitCreator).getPackageName();
    }

    public static IDexMethod findInternalVirtualMethodTarget(IDexUnit iDexUnit, IDexClass iDexClass, String string, String ... stringArray) {
        int n2;
        do {
            IDexMethod iDexMethod;
            if ((iDexMethod = iDexClass.getMethod(false, string, stringArray)) == null) continue;
            return iDexMethod;
        } while ((n2 = iDexClass.getSuperTypeIndex()) >= 0 && (iDexClass = iDexUnit.getType(n2).getImplementingClass()) != null);
        return null;
    }

    static {
        Assert.a(flconv.length % 2 == 0);
    }
}

