/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android;

import com.google.common.base.Throwables;
import com.pnfsoftware.jeb.core.units.code.DecompilationOptions;
import com.pnfsoftware.jeb.core.units.code.DecompilerExporter;
import com.pnfsoftware.jeb.core.units.code.android.IDexDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.android.JvmMethodSig;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.HashMap;
import java.util.regex.Pattern;

public class DexDecompilerExporter
extends DecompilerExporter {
    private static final ILogger logger = GlobalLog.getLogger(DexDecompilerExporter.class);
    private static HashMap<Character, String> letterToPrim = new HashMap();

    public DexDecompilerExporter(IDexDecompilerUnit iDexDecompilerUnit) {
        super(iDexDecompilerUnit);
    }

    @Override
    public boolean process() {
        return this.processTopLevelClasses();
    }

    @Override
    protected void customizeOptions(boolean bl, DecompilationOptions.Builder builder) {
        if (bl && this.outputFolder != null) {
            this.usesCustomDecompWriter = true;
            builder.postDecompilationCallback(string -> {
                try {
                    this.writeClassDecompilation((String)string);
                }
                catch (Exception exception) {
                    System.err.println(Throwables.getStackTraceAsString(exception));
                }
            });
        }
    }

    @Override
    public void setSignaturePattern(Pattern pattern) {
        super.setSignaturePattern(pattern);
    }

    @Override
    protected String generateMethodFileName(String string) {
        String string2;
        JvmMethodSig jvmMethodSig = JvmMethodSig.parse(string);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.convertTypeName(jvmMethodSig.csig));
        stringBuilder.append(".");
        switch (jvmMethodSig.mname) {
            case "<clinit>": {
                string2 = "{}";
                break;
            }
            case "<init>": {
                String string3;
                String[] object = jvmMethodSig.csig.substring(1, jvmMethodSig.csig.length() - 1).split("/");
                string2 = string3 = object[object.length - 1];
                break;
            }
            default: {
                string2 = jvmMethodSig.mname;
            }
        }
        stringBuilder.append(string2);
        stringBuilder.append("(");
        int n2 = 0;
        for (String string4 : jvmMethodSig.partypes) {
            if (n2 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.convertTypeName(string4));
            ++n2;
        }
        stringBuilder.append(")");
        stringBuilder.append(this.convertTypeName(jvmMethodSig.rettype));
        stringBuilder.append(".java");
        return stringBuilder.toString();
    }

    private String convertTypeName(String object) {
        int n2 = 0;
        char c2 = ((String)object).charAt(n2);
        while (c2 == '[') {
            c2 = ((String)object).charAt(++n2);
        }
        c2 = ((String)object).charAt(n2);
        object = c2 == 'L' ? ((String)object).substring(n2 + 1, ((String)object).length() - 1).replace('/', '.') : letterToPrim.get(Character.valueOf(c2));
        object = (String)object + Strings.generate("[]", n2);
        return object;
    }

    @Override
    protected String generateClassFileName(String string) {
        return string.substring(1, string.length() - 1) + ".java";
    }

    static {
        letterToPrim.put(Character.valueOf('Z'), "boolean");
        letterToPrim.put(Character.valueOf('B'), "byte");
        letterToPrim.put(Character.valueOf('C'), "char");
        letterToPrim.put(Character.valueOf('S'), "short");
        letterToPrim.put(Character.valueOf('I'), "int");
        letterToPrim.put(Character.valueOf('J'), "long");
        letterToPrim.put(Character.valueOf('F'), "float");
        letterToPrim.put(Character.valueOf('D'), "double");
        letterToPrim.put(Character.valueOf('V'), "");
    }
}

