/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android;

import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import javax.annotation.concurrent.Immutable;

@Ser
@Immutable
public class DexDecompilerEvent<T> {
    @SerId(value=1)
    private long timestamp = System.currentTimeMillis();
    @SerId(value=2)
    private Type type;
    @SerId(value=3)
    private T data;
    @SerId(value=4)
    private String address;

    public DexDecompilerEvent(Type type, T t, String string) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (t == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.data = t;
        this.address = string;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Type getType() {
        return this.type;
    }

    public T getData() {
        return this.data;
    }

    protected String formatData(T t) {
        return t.toString();
    }

    public String getAddress() {
        return this.address;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.address == null ? 0 : this.address.hashCode());
        n2 = 31 * n2 + (this.data == null ? 0 : this.data.hashCode());
        n2 = 31 * n2 + (this.type == null ? 0 : this.type.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DexDecompilerEvent dexDecompilerEvent = (DexDecompilerEvent)object;
        if (this.address == null ? dexDecompilerEvent.address != null : !this.address.equals(dexDecompilerEvent.address)) {
            return false;
        }
        if (this.data == null ? dexDecompilerEvent.data != null : !this.data.equals(dexDecompilerEvent.data)) {
            return false;
        }
        return this.type == dexDecompilerEvent.type;
    }

    public String toString() {
        return this.format(true, true);
    }

    public String format(boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append((Object)this.type);
        }
        if (this.data != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(": ");
            }
            stringBuilder.append(this.formatData(this.data));
        }
        if (bl2 && this.address != null) {
            stringBuilder.append(" @").append(this.address);
        }
        return stringBuilder.toString();
    }

    @Ser
    public static class Message
    extends DexDecompilerEvent<String> {
        public Message(String string, String string2) {
            super(Type.MESSAGE, string, string2);
        }

        @Override
        protected String formatData(String string) {
            return string;
        }
    }

    @Ser
    public static class UnreflectedFieldWrite
    extends DexDecompilerEvent<String> {
        public UnreflectedFieldWrite(String string, String string2) {
            super(Type.UNREFLECTED_FIELD_WRITE, string, string2);
        }

        @Override
        protected String formatData(String string) {
            return string;
        }
    }

    @Ser
    public static class UnreflectedFieldRead
    extends DexDecompilerEvent<String> {
        public UnreflectedFieldRead(String string, String string2) {
            super(Type.UNREFLECTED_FIELD_READ, string, string2);
        }

        @Override
        protected String formatData(String string) {
            return string;
        }
    }

    @Ser
    public static class UnreflectedInvocation
    extends DexDecompilerEvent<String> {
        public UnreflectedInvocation(String string, String string2) {
            super(Type.UNREFLECTED_INVOCATION, string, string2);
        }

        @Override
        protected String formatData(String string) {
            return string;
        }
    }

    @Ser
    public static class DecryptedBytes
    extends DexDecompilerEvent<byte[]> {
        public DecryptedBytes(byte[] byArray, String string) {
            super(Type.DECRYPTED_BYTES, byArray, string);
        }

        @Override
        protected String formatData(byte[] byArray) {
            return "\"" + Formatter.escapeBytes(byArray) + "\"";
        }
    }

    @Ser
    public static class DecryptedString
    extends DexDecompilerEvent<String> {
        public DecryptedString(String string, String string2) {
            super(Type.DECRYPTED_STRING, string, string2);
        }

        @Override
        protected String formatData(String string) {
            return "\"" + Formatter.escapeString(string) + "\"";
        }
    }

    @Ser
    public static class BuiltString
    extends DexDecompilerEvent<String> {
        public BuiltString(String string, String string2) {
            super(Type.BUILT_STRING, string, string2);
        }

        @Override
        protected String formatData(String string) {
            return "\"" + Formatter.escapeString(string) + "\"";
        }
    }

    @Ser
    public static enum Type {
        BUILT_STRING,
        DECRYPTED_STRING,
        DECRYPTED_BYTES,
        UNREFLECTED_INVOCATION,
        UNREFLECTED_FIELD_READ,
        UNREFLECTED_FIELD_WRITE,
        MESSAGE;

    }
}

