/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android;

import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

@Ser
public class DexConstantLibrary {
    @SerId(value=1)
    IDexUnit dex;
    @SerId(value=2)
    Map<Object, Collection<Integer>> objmap = new HashMap<Object, Collection<Integer>>();

    public DexConstantLibrary(IDexUnit iDexUnit) {
        this.dex = iDexUnit;
    }

    public boolean setValue(Object object, int n2) {
        if (object == null || n2 < 0) {
            return false;
        }
        if (!(object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double)) {
            return false;
        }
        Collection<Integer> collection = this.objmap.get(object);
        if (collection == null) {
            collection = new LinkedHashSet<Integer>();
            this.objmap.put(object, collection);
        }
        collection.add(n2);
        return true;
    }

    public Collection<Integer> getFieldIndices(Object object) {
        Collection<Integer> collection = this.objmap.get(object);
        if (collection == null) {
            collection = Collections.emptyList();
        }
        return Collections.unmodifiableCollection(collection);
    }

    void f(byte by, char c2) {
    }

    public Collection<Integer> getFieldIndices(Object object, boolean bl, boolean bl2) {
        Collection<Integer> collection = this.getFieldIndices(object);
        if (bl || bl2) {
            collection = new ArrayList<Integer>(collection);
            if (object instanceof Byte) {
                Byte by = (Byte)object;
                if (bl2) {
                    collection.addAll(this.getFieldIndices(by.shortValue()));
                    collection.addAll(this.getFieldIndices(by.intValue()));
                    collection.addAll(this.getFieldIndices(by.longValue()));
                }
                if (bl2 && bl && by <= 65535 && by >= 0) {
                    char c2 = (char)by.intValue();
                    collection.addAll(this.getFieldIndices(Character.valueOf(c2)));
                }
            } else if (object instanceof Character) {
                Character c3 = (Character)object;
                if (bl2) {
                    collection.addAll(this.getFieldIndices(c3.charValue()));
                    collection.addAll(this.getFieldIndices(c3.charValue()));
                }
                if (bl2 && bl) {
                    if (c3.charValue() <= '\u007f' && c3.charValue() >= '\uffffff80') {
                        collection.addAll(this.getFieldIndices((byte)c3.charValue()));
                    }
                    if (c3.charValue() <= Short.MAX_VALUE && c3.charValue() >= Short.MIN_VALUE) {
                        collection.addAll(this.getFieldIndices((short)c3.charValue()));
                    }
                }
            } else if (object instanceof Short) {
                Short s2 = (Short)object;
                if (bl2) {
                    collection.addAll(this.getFieldIndices(s2.intValue()));
                    collection.addAll(this.getFieldIndices(s2.longValue()));
                }
                if (bl && s2 <= 127 && s2 >= -128) {
                    collection.addAll(this.getFieldIndices(s2.byteValue()));
                }
                if (bl2 && bl && s2 <= 65535 && s2 >= 0) {
                    collection.addAll(this.getFieldIndices(Character.valueOf((char)s2.intValue())));
                }
            } else if (object instanceof Integer) {
                Integer n2 = (Integer)object;
                if (bl2) {
                    collection.addAll(this.getFieldIndices(n2.longValue()));
                }
                if (bl) {
                    if (n2 <= Short.MAX_VALUE && n2 >= Short.MIN_VALUE) {
                        collection.addAll(this.getFieldIndices(n2.shortValue()));
                    }
                    if (n2 <= 65535 && n2 >= 0) {
                        collection.addAll(this.getFieldIndices(Character.valueOf((char)n2.intValue())));
                    }
                    if (n2 <= 127 && n2 >= -128) {
                        collection.addAll(this.getFieldIndices(n2.byteValue()));
                    }
                }
            } else if (object instanceof Long) {
                Long l2 = (Long)object;
                if (bl) {
                    if (l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE) {
                        collection.addAll(this.getFieldIndices(l2.intValue()));
                    }
                    if (l2 <= 32767L && l2 >= -32768L) {
                        collection.addAll(this.getFieldIndices(l2.shortValue()));
                    }
                    if (l2 <= 65535L && l2 >= 0L) {
                        collection.addAll(this.getFieldIndices(Character.valueOf((char)l2.intValue())));
                    }
                    if (l2 <= 127L && l2 >= -128L) {
                        collection.addAll(this.getFieldIndices(l2.byteValue()));
                    }
                }
            } else if (object instanceof Float) {
                Float f = (Float)object;
                if (bl2) {
                    collection.addAll(this.getFieldIndices(f.doubleValue()));
                }
            } else if (object instanceof Double) {
                Double d = (Double)object;
                if (bl && d <= 3.4028234663852886E38 && d >= (double)1.4E-45f) {
                    collection.addAll(this.getFieldIndices(Float.valueOf(d.floatValue())));
                }
            }
        }
        return collection;
    }
}

