/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android;

import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.InstructionCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.MethodCoordinates;
import com.pnfsoftware.jeb.core.units.code.ICodeClass;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.ICodeMethod;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexItem;
import com.pnfsoftware.jeb.util.collect.MultiMap;
import com.pnfsoftware.jeb.util.collect.WeakIdentityHashMap;
import com.pnfsoftware.jeb.util.collect.WeakValueMap;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.graph.Digraph;
import com.pnfsoftware.jeb.util.graph.IAddressableDigraphBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class DalvikCallgraphBuilder
implements IAddressableDigraphBuilder {
    private IDexUnit unit;
    private Digraph model;
    private WeakValueMap<Integer, ICodeMethod> vertexIdToMethodObject;
    private WeakIdentityHashMap<ICodeMethod, Integer> methodObjectToVertexId;
    private String rawfilter;
    private int fltCount;
    private Set<String> wlFltFull = new HashSet<String>();
    private List<String> wlFltStart = new ArrayList<String>();
    private Set<String> blFltFull = new HashSet<String>();
    private List<String> blFltStart = new ArrayList<String>();

    public DalvikCallgraphBuilder(IDexUnit iDexUnit) {
        this.unit = iDexUnit;
    }

    @Override
    public Digraph buildModel() {
        MultiMap<Integer, Integer> multiMap = new MultiMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, TreeSet<Integer>> hashMap2 = new HashMap<Integer, TreeSet<Integer>>();
        TreeMap<Integer, ICodeMethod> treeMap = new TreeMap<Integer, ICodeMethod>();
        for (ICodeMethod iCodeItem : this.unit.getMethods()) {
            if (!iCodeItem.isInternal() || !this.filter(iCodeItem)) continue;
            treeMap.put(iCodeItem.getIndex(), iCodeItem);
        }
        for (ICodeClass iCodeClass : this.unit.getClasses()) {
            if ((iCodeClass.getGenericFlags() & 0x100000) != 0 || !this.filter(iCodeClass)) continue;
            int n2 = iCodeClass.getClassType().getIndex();
            for (ICodeMethod iCodeMethod : iCodeClass.getMethods()) {
                int n3 = iCodeMethod.getIndex();
                multiMap.put(n2, n3);
                hashMap.put(n3, n2);
                List<? extends IInstruction> list = iCodeMethod.getInstructions();
                if (list == null) continue;
                for (IInstruction iInstruction : list) {
                    String string = iInstruction.format(null);
                    int n4 = DalvikCallgraphBuilder.extractMethodIndex(string);
                    if (n4 < 0 || !treeMap.containsKey(n4)) continue;
                    TreeSet<Integer> treeSet = (TreeSet<Integer>)hashMap2.get(n3);
                    if (treeSet == null) {
                        treeSet = new TreeSet<Integer>();
                        hashMap2.put(n3, treeSet);
                    }
                    treeSet.add(n4);
                }
            }
        }
        this.model = new Digraph();
        this.vertexIdToMethodObject = new WeakValueMap();
        this.methodObjectToVertexId = new WeakIdentityHashMap();
        for (ICodeMethod iCodeMethod : treeMap.values()) {
            String string = iCodeMethod.getClassType().getName(true) + "." + iCodeMethod.getName(true);
            int n5 = iCodeMethod.getInstructions() == null ? 0 : iCodeMethod.getInstructions().size();
            this.model.v(iCodeMethod.getIndex(), Double.valueOf(n5), string);
            this.vertexIdToMethodObject.put(iCodeMethod.getIndex(), iCodeMethod);
            this.methodObjectToVertexId.put(iCodeMethod, iCodeMethod.getIndex());
        }
        Iterator<IDexItem> iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            int n6 = (Integer)((Object)iterator.next());
            Iterator iterator2 = ((Set)hashMap2.get(n6)).iterator();
            while (iterator2.hasNext()) {
                int n7 = (Integer)iterator2.next();
                this.model.e(n6, n7);
            }
        }
        return this.model;
    }

    private static int extractMethodIndex(String string) {
        int n2;
        if (string.startsWith("invoke") && (n2 = string.indexOf("method@")) >= 0) {
            int n3 = string.indexOf(",", n2 += 7);
            if (n3 < 0) {
                n3 = string.length();
            }
            return Integer.parseInt(string.substring(n2, n3));
        }
        return -1;
    }

    @Override
    public String getAddressForVertexId(int n2) {
        ICodeMethod iCodeMethod;
        ICodeMethod iCodeMethod2 = iCodeMethod = this.vertexIdToMethodObject == null ? null : this.vertexIdToMethodObject.get(n2);
        if (iCodeMethod == null) {
            return null;
        }
        return iCodeMethod.getAddress();
    }

    @Override
    public Integer getVertexIdForAddress(String string) {
        Integer n2;
        ICodeCoordinates iCodeCoordinates = this.unit.getCodeCoordinatesFromAddress(string);
        if (iCodeCoordinates instanceof InstructionCoordinates) {
            n2 = ((InstructionCoordinates)iCodeCoordinates).getMethodId();
        } else if (iCodeCoordinates instanceof MethodCoordinates) {
            n2 = ((MethodCoordinates)iCodeCoordinates).getMethodId();
        } else {
            return null;
        }
        ICodeMethod iCodeMethod = this.unit.getMethods().get(n2);
        if (iCodeMethod == null) {
            return null;
        }
        return this.methodObjectToVertexId.get(iCodeMethod);
    }

    public String getFilter() {
        return this.rawfilter;
    }

    public void setFilter(String string) {
        this.rawfilter = string;
        this.wlFltStart.clear();
        this.blFltStart.clear();
        if (this.rawfilter == null) {
            return;
        }
        this.fltCount = 0;
        for (String string2 : Strings.splitLines(this.rawfilter)) {
            if ((string2 = Strings.trim(string2)).isEmpty() || string2.startsWith("#")) continue;
            boolean bl = false;
            if (string2.startsWith("-")) {
                if ((string2 = string2.substring(1)).isEmpty()) continue;
                bl = true;
            }
            if (string2.endsWith("*")) {
                string2 = string2.substring(0, string2.length() - 1);
                if (bl) {
                    this.blFltStart.add(string2);
                } else {
                    this.wlFltStart.add(string2);
                }
            } else if (bl) {
                this.blFltFull.add(string2);
            } else {
                this.wlFltFull.add(string2);
            }
            ++this.fltCount;
        }
    }

    private boolean filter(ICodeItem iCodeItem) {
        if (this.fltCount == 0) {
            return true;
        }
        String string = iCodeItem.getSignature(true);
        if (string == null) {
            return false;
        }
        int n2 = string.indexOf(";");
        if (n2 < 2) {
            return false;
        }
        String string2 = string.substring(1, n2).replace('/', '.');
        if (!(this.wlFltFull.isEmpty() && this.wlFltStart.isEmpty() || this.wlFltFull.contains(string2))) {
            boolean bl = false;
            for (String string3 : this.wlFltStart) {
                if (!string2.startsWith(string3)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
        }
        if (this.blFltFull.contains(string2)) {
            return false;
        }
        for (String string4 : this.blFltStart) {
            if (!string2.startsWith(string4)) continue;
            return false;
        }
        return true;
    }
}

