/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android;

import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IXmlUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.android.IApkUnit;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class ApkStringResHelper {
    private static final ILogger logger = GlobalLog.getLogger(ApkStringResHelper.class);
    private IApkUnit apk;
    private List<String> preferredLocales;
    private volatile InternalMap resIdMap;

    public ApkStringResHelper(IApkUnit iApkUnit, List<String> list) {
        if (iApkUnit == null) {
            throw new IllegalArgumentException();
        }
        this.apk = iApkUnit;
        this.preferredLocales = list;
    }

    public ApkStringResHelper(IApkUnit iApkUnit) {
        this(iApkUnit, null);
    }

    private InternalMap generateResIdMap() {
        String string;
        Element element;
        int n2;
        Object object;
        InternalMap internalMap = new InternalMap();
        IUnit iUnit = UnitUtil.retrieveProcessed(true, this.apk, "Resources", "values", "public.xml");
        if (iUnit instanceof IXmlUnit) {
            object = ((IXmlUnit)iUnit).getDocument().getElementsByTagName("public");
            for (n2 = 0; n2 < object.getLength(); ++n2) {
                element = (Element)object.item(n2);
                int n3 = Conversion.stringToInt(element.getAttribute("id"));
                if (n3 == 0) continue;
                string = element.getAttribute("name");
                String string2 = element.getAttribute("type");
                internalMap.pubmap.put(n3, new Couple<String, String>(string2, string));
            }
        }
        iUnit = null;
        if (this.preferredLocales != null) {
            for (String string3 : this.preferredLocales) {
                iUnit = UnitUtil.retrieveProcessed(true, this.apk, "Resources", "values-" + string3, "strings.xml");
                if (iUnit == null) continue;
                break;
            }
        }
        if (iUnit == null) {
            iUnit = UnitUtil.retrieveProcessed(true, this.apk, "Resources", "values", "strings.xml");
        }
        if (iUnit instanceof IXmlUnit) {
            object = ((IXmlUnit)iUnit).getDocument().getElementsByTagName("string");
            for (n2 = 0; n2 < object.getLength(); ++n2) {
                element = (Element)object.item(n2);
                String string4 = element.getAttribute("name");
                string = element.getTextContent();
                internalMap.strmap.put(string4, string);
            }
        }
        return internalMap;
    }

    private void init() {
        if (this.resIdMap == null) {
            ApkStringResHelper apkStringResHelper = this;
            synchronized (apkStringResHelper) {
                if (this.resIdMap == null) {
                    try {
                        InternalMap internalMap;
                        this.resIdMap = internalMap = this.generateResIdMap();
                    }
                    catch (Exception exception) {
                        JebCoreService.silentExcept(exception);
                        this.resIdMap = new InternalMap();
                    }
                }
            }
        }
    }

    public String getDefaultString(int n2) {
        this.init();
        Couple<String, String> couple = this.resIdMap.pubmap.get(n2);
        if (couple == null) {
            return null;
        }
        if (!"string".equals(couple.getFirst())) {
            return null;
        }
        return this.resIdMap.strmap.get(couple.getSecond());
    }

    public String generateAutoCommentForPotentialResourceId(int n2) {
        String string;
        this.init();
        Couple<String, String> couple = this.resIdMap.pubmap.get(n2);
        if (couple == null) {
            return null;
        }
        String string2 = couple.getFirst() + ":" + couple.getSecond();
        if ("string".equals(couple.getFirst()) && (string = this.resIdMap.strmap.get(couple.getSecond())) != null) {
            string2 = string2 + " \"" + Formatter.escapeString(string) + "\"";
        }
        return string2;
    }

    public static class InternalMap {
        public Map<Integer, Couple<String, String>> pubmap = new HashMap<Integer, Couple<String, String>>();
        public Map<String, String> strmap = new HashMap<String, String>();
    }
}

