/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android;

import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.core.units.IXmlUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.android.ApkXmlResourceHelper;
import com.pnfsoftware.jeb.core.units.code.android.IApkUnit;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApkManifestHelper
extends ApkXmlResourceHelper {
    Element appElt;

    public static boolean canParse(IApkUnit iApkUnit) {
        return UnitUtil.findChild(iApkUnit, "Manifest", IXmlUnit.class, false, 0) != null;
    }

    public ApkManifestHelper(IApkUnit iApkUnit) {
        super(UnitUtil.findChild(iApkUnit, "Manifest", IXmlUnit.class, false, 0));
    }

    public ApkManifestHelper(IXmlUnit iXmlUnit) {
        super(iXmlUnit);
    }

    public ApkManifestHelper(Document document) {
        super(document);
    }

    @Override
    protected void prepare(Document document) {
        super.prepare(document);
        if (!"manifest".equals(this.rootElt.getTagName())) {
            throw new IllegalArgumentException("Illegal Android manifest: no 'manifest' tag");
        }
        NodeList nodeList = document.getElementsByTagName("manifest");
        if (nodeList.getLength() == 0) {
            throw new JebRuntimeException("Illegal Android manifest: no 'manifest' tag");
        }
        nodeList = this.rootElt.getElementsByTagName("application");
        if (nodeList.getLength() != 0) {
            this.appElt = (Element)nodeList.item(0);
        }
    }

    public Element getXmlManifestElement() {
        return this.rootElt;
    }

    private String buildClassName(String object) {
        if (((String)object).startsWith(".")) {
            object = this.getPackageName() + (String)object;
        }
        return object;
    }

    public String getPackageName() {
        Node node = this.rootElt.getAttributes().getNamedItem("package");
        if (node == null) {
            return null;
        }
        return node.getTextContent();
    }

    public List<String> getPermissions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = this.rootElt.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!ApkManifestHelper.checkNonNullNode(node, i, this.rootElt) || node.getNodeType() != 1 || !"uses-permission".equals(((Element)node).getTagName())) continue;
            String string = ((Element)node).getAttribute(this.buildAttributeName("name"));
            arrayList.add(string);
        }
        return arrayList;
    }

    public boolean hasApplication() {
        return this.appElt != null;
    }

    public String getApplicationName() {
        if (this.appElt == null) {
            return null;
        }
        Attr attr = this.appElt.getAttributeNode(this.buildAttributeName("name"));
        if (attr == null) {
            return null;
        }
        Object object = attr.getNodeValue();
        if (!((String)(object = this.buildClassName((String)object))).contains(".")) {
            object = this.getPackageName() + "." + (String)object;
        }
        return object;
    }

    public boolean isDebuggable() {
        if (this.appElt == null) {
            return false;
        }
        Attr attr = this.appElt.getAttributeNode(this.buildAttributeName("debuggable"));
        if (attr != null) {
            return BooleanUtils.toBoolean((String)attr.getNodeValue());
        }
        return false;
    }

    public ApplicationDescription getApplicationDescription() {
        if (this.appElt == null) {
            return null;
        }
        ApplicationDescription applicationDescription = new ApplicationDescription();
        applicationDescription.name = this.getApplicationName();
        applicationDescription.debuggable = this.isDebuggable();
        this.fillMetaData(this.appElt, applicationDescription.metadata);
        return applicationDescription;
    }

    private void fillMetaData(Element element, Map<String, String> map) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            String string;
            Node node = nodeList.item(i);
            if (!ApkManifestHelper.checkNonNullNode(node, i, element) || node.getNodeType() != 1 || !"meta-data".equals(((Element)node).getTagName()) || "".equals(string = (element2 = (Element)node).getAttribute(this.buildAttributeName("name")))) continue;
            String string2 = element2.getAttribute(this.buildAttributeName("value"));
            map.put(string, string2);
        }
    }

    public AndroidSystemType getIntendedSystemType() {
        Iterator<String> iterator = this.readAttributes("uses-feature", "name").iterator();
        while (iterator.hasNext()) {
            String string;
            switch (string = iterator.next()) {
                case "android.hardware.type.watch": {
                    return AndroidSystemType.WEAR_OS;
                }
                case "android.hardware.type.automotive": {
                    return AndroidSystemType.AUTOMOTIVE_OS;
                }
            }
        }
        if (this.hasAttributeValue("meta-data", "name", "com.google.android.gms.car.application")) {
            return AndroidSystemType.ANDROID_AUTO;
        }
        if (this.hasAttributeValue("category", "name", "android.intent.category.LEANBACK_LAUNCHER")) {
            return AndroidSystemType.ANDROID_TV;
        }
        return AndroidSystemType.ANDROID;
    }

    public List<String> getActivities() {
        return this.getEndPointNames("activity");
    }

    public List<String> getServices() {
        return this.getEndPointNames("service");
    }

    public List<String> getReceivers() {
        return this.getEndPointNames("receiver");
    }

    public List<String> getProviders() {
        return this.getEndPointNames("provider");
    }

    private List<String> getEndPointNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Element element : this.getEndPointNodes(string)) {
            String string2 = element.getAttribute(this.buildAttributeName("name"));
            arrayList.add(this.buildClassName(string2));
        }
        return arrayList;
    }

    private List<Element> getEndPointNodes(String string) {
        if (this.appElt == null) {
            return Collections.emptyList();
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = this.appElt.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!ApkManifestHelper.checkNonNullNode(node, i, this.appElt) || node.getNodeType() != 1 || !string.equals(((Element)node).getTagName())) continue;
            arrayList.add((Element)node);
        }
        return arrayList;
    }

    public String getMainActivity() {
        String string;
        Element element;
        Element element2;
        for (Element element3 : this.getEndPointNodes("activity")) {
            element2 = this.getFirstChildElement(element3, "intent-filter");
            if (element2 == null || (element = this.getFirstChildElement(element2, "action")) == null || !"android.intent.action.MAIN".equals(string = element.getAttribute(this.buildAttributeName("name")))) continue;
            String string2 = element3.getAttribute(this.buildAttributeName("name"));
            return this.buildClassName(string2);
        }
        for (Element element3 : this.getEndPointNodes("activity-alias")) {
            element2 = this.getFirstChildElement(element3, "intent-filter");
            if (element2 == null || (element = this.getFirstChildElement(element2, "action")) == null || !"android.intent.action.MAIN".equals(string = element.getAttribute(this.buildAttributeName("name")))) continue;
            String string3 = element3.getAttribute(this.buildAttributeName("targetActivity"));
            return this.buildClassName(string3);
        }
        return null;
    }

    private Element getFirstChildElement(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!ApkManifestHelper.checkNonNullNode(node, i, element) || node.getNodeType() != 1 || !string.equals(((Element)node).getTagName())) continue;
            return (Element)node;
        }
        return null;
    }

    public List<EndPointDescription> getEndPointDescriptions() {
        ArrayList<EndPointDescription> arrayList = new ArrayList<EndPointDescription>();
        this.getEndPointDescriptions(EndPointType.ACTIVITY, arrayList);
        this.getEndPointDescriptions(EndPointType.SERVICE, arrayList);
        this.getEndPointDescriptions(EndPointType.RECEIVER, arrayList);
        this.getEndPointDescriptions(EndPointType.PROVIDER, arrayList);
        return arrayList;
    }

    public List<ActivityDescription> getActivityDescriptions() {
        ArrayList<EndPointDescription> arrayList = new ArrayList<EndPointDescription>();
        this.getEndPointDescriptions(EndPointType.ACTIVITY, arrayList);
        return arrayList;
    }

    public List<ServiceDescription> getServiceDescriptions() {
        ArrayList<EndPointDescription> arrayList = new ArrayList<EndPointDescription>();
        this.getEndPointDescriptions(EndPointType.SERVICE, arrayList);
        return arrayList;
    }

    public List<ReceiverDescription> getReceiverDescriptions() {
        ArrayList<EndPointDescription> arrayList = new ArrayList<EndPointDescription>();
        this.getEndPointDescriptions(EndPointType.RECEIVER, arrayList);
        return arrayList;
    }

    public List<ProviderDescription> getProviderDescriptions() {
        ArrayList<EndPointDescription> arrayList = new ArrayList<EndPointDescription>();
        this.getEndPointDescriptions(EndPointType.PROVIDER, arrayList);
        return arrayList;
    }

    private void getEndPointDescriptions(EndPointType endPointType, List<EndPointDescription> list) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(endPointType.toString().toLowerCase()));
        if (endPointType == EndPointType.ACTIVITY) {
            arrayList.add("activity-alias");
        }
        for (String string : arrayList) {
            block7: for (Element element : this.getEndPointNodes(string)) {
                String string2 = element.getAttribute(this.buildAttributeName("enabled"));
                String string3 = element.getAttribute(this.buildAttributeName("exported"));
                String string4 = element.getAttribute(this.buildAttributeName("name"));
                String string5 = this.buildClassName(string4);
                Element element2 = this.getFirstChildElement(element, "intent-filter");
                boolean bl = element2 != null;
                boolean bl2 = !string2.isEmpty() ? string2.equals("true") : true;
                boolean bl3 = !string3.isEmpty() ? string3.equals("true") : bl;
                String string6 = null;
                if (string.equals("activity-alias")) {
                    string6 = element.getAttribute(this.buildAttributeName("targetActivity"));
                    string6 = string6.isEmpty() ? null : this.buildClassName(string6);
                }
                IntentFilterDescriptions intentFilterDescriptions = null;
                if (!string.equals("provider")) {
                    intentFilterDescriptions = this.getIntentFilterDescriptions(element);
                }
                switch (endPointType) {
                    case ACTIVITY: {
                        EndPointDescription endPointDescription = new ActivityDescription(string5, bl2, bl3);
                        endPointDescription.aliasForName = string6;
                        endPointDescription.intentFilters = intentFilterDescriptions;
                        this.fillMetaData(element, endPointDescription.metadata);
                        list.add(endPointDescription);
                        continue block7;
                    }
                    case SERVICE: {
                        EndPointDescription endPointDescription = new ServiceDescription(string5, bl2, bl3);
                        ((ServiceDescription)endPointDescription).intentFilters = intentFilterDescriptions;
                        this.fillMetaData(element, ((ServiceDescription)endPointDescription).metadata);
                        list.add(endPointDescription);
                        continue block7;
                    }
                    case RECEIVER: {
                        EndPointDescription endPointDescription = new ReceiverDescription(string5, bl2, bl3);
                        ((ReceiverDescription)endPointDescription).intentFilters = intentFilterDescriptions;
                        this.fillMetaData(element, ((ReceiverDescription)endPointDescription).metadata);
                        list.add(endPointDescription);
                        continue block7;
                    }
                    case PROVIDER: {
                        EndPointDescription endPointDescription = new ProviderDescription(string5, bl2, bl3);
                        this.fillMetaData(element, ((ProviderDescription)endPointDescription).metadata);
                        list.add(endPointDescription);
                        continue block7;
                    }
                }
                throw new RuntimeException();
            }
        }
    }

    private IntentFilterDescriptions getIntentFilterDescriptions(Element element) {
        IntentFilterDescriptions intentFilterDescriptions = new IntentFilterDescriptions();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!ApkManifestHelper.checkNonNullNode(node, i, element) || node.getNodeType() != 1 || !"intent-filter".equals(((Element)node).getTagName())) continue;
            Element element2 = (Element)node;
            IntentFilterDescription intentFilterDescription = new IntentFilterDescription();
            NodeList nodeList2 = element2.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                String string;
                Node node2 = nodeList2.item(j);
                if (!ApkManifestHelper.checkNonNullNode(node2, j, element2)) continue;
                if (node2.getNodeType() == 1 && "action".equals(((Element)node2).getTagName())) {
                    string = ((Element)node2).getAttribute(this.buildAttributeName("name"));
                    intentFilterDescription.actions.add(string);
                    continue;
                }
                if (node2.getNodeType() != 1 || !"category".equals(((Element)node2).getTagName())) continue;
                string = ((Element)node2).getAttribute(this.buildAttributeName("name"));
                intentFilterDescription.categories.add(string);
            }
            intentFilterDescriptions.list.add(intentFilterDescription);
        }
        return intentFilterDescriptions;
    }

    public int[] getSdkVersion() {
        Element element = this.getFirstChildElement(this.rootElt, "uses-sdk");
        if (element == null) {
            return new int[]{1, 1};
        }
        String string = element.getAttribute(this.buildAttributeName("minSdkVersion"));
        int n2 = Conversion.stringToInt(string, 1);
        string = element.getAttribute(this.buildAttributeName("targetSdkVersion"));
        int n3 = Conversion.stringToInt(string, n2);
        return new int[]{n2, n3};
    }

    private static boolean checkNonNullNode(Node node, int n2, Node node2) {
        if (node != null) {
            return true;
        }
        RuntimeException runtimeException = new RuntimeException(Strings.ff("Null XML child %d for parent %s", n2, node2));
        JebCoreService.notifySilentExceptionToClient(runtimeException);
        return false;
    }

    public static class ServiceDescription
    extends EndPointDescription {
        IntentFilterDescriptions intentFilters;

        public ServiceDescription(String string, boolean bl, boolean bl2) {
            super(string, bl, bl2);
        }

        public IntentFilterDescriptions getIntentFilters() {
            return this.intentFilters;
        }
    }

    public static class ReceiverDescription
    extends EndPointDescription {
        IntentFilterDescriptions intentFilters;

        public ReceiverDescription(String string, boolean bl, boolean bl2) {
            super(string, bl, bl2);
        }

        public IntentFilterDescriptions getIntentFilters() {
            return this.intentFilters;
        }
    }

    public static class ProviderDescription
    extends EndPointDescription {
        public ProviderDescription(String string, boolean bl, boolean bl2) {
            super(string, bl, bl2);
        }
    }

    public static class ActivityDescription
    extends EndPointDescription {
        String aliasForName;
        IntentFilterDescriptions intentFilters;

        public ActivityDescription(String string, boolean bl, boolean bl2) {
            super(string, bl, bl2);
        }

        public boolean isAlias() {
            return this.aliasForName != null;
        }

        public String getAliasForName() {
            return this.aliasForName;
        }

        public IntentFilterDescriptions getIntentFilters() {
            return this.intentFilters;
        }

        @Override
        public String toString() {
            Object object = super.toString();
            if (this.isAlias()) {
                object = (String)object + "->" + this.getAliasForName();
            }
            return object;
        }
    }

    public static class IntentFilterDescriptions {
        List<IntentFilterDescription> list = new ArrayList<IntentFilterDescription>();

        public boolean check(String string, String string2) {
            for (IntentFilterDescription intentFilterDescription : this.list) {
                if (string != null && !intentFilterDescription.actions.contains(string) || string2 != null && !intentFilterDescription.categories.contains(string2)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.list.toString();
        }
    }

    public static class IntentFilterDescription {
        List<String> actions = new ArrayList<String>();
        List<String> categories = new ArrayList<String>();

        public List<String> getActions() {
            return this.actions;
        }

        public List<String> getCategories() {
            return this.categories;
        }

        public boolean check(String string, String string2) {
            return !(string != null && !this.actions.contains(string) || string2 != null && !string2.contains(string2));
        }

        public String toString() {
            return Strings.ff("actions:%s,categories:%s", this.actions, this.categories);
        }
    }

    public static class EndPointDescription {
        String fqname;
        boolean enabled;
        boolean exported;
        Map<String, String> metadata = new HashMap<String, String>();

        public EndPointDescription(String string, boolean bl, boolean bl2) {
            this.fqname = string;
            this.enabled = bl;
            this.exported = bl2;
        }

        public String getFullyQualifiedName() {
            return this.fqname;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isExported() {
            return this.exported;
        }

        public Map<String, String> getMetadata() {
            return Collections.unmodifiableMap(this.metadata);
        }

        public String toString() {
            return Strings.ff("%s,enabled:%s,exported:%s", this.fqname, this.enabled, this.exported);
        }
    }

    public static enum EndPointType {
        ACTIVITY,
        SERVICE,
        RECEIVER,
        PROVIDER;

    }

    public static enum AndroidSystemType {
        ANDROID("Android"),
        WEAR_OS("Wear OS"),
        AUTOMOTIVE_OS("Android Automotive OS"),
        ANDROID_AUTO("Android Auto"),
        ANDROID_TV("Android TV");

        private final String name;

        private AndroidSystemType(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ApplicationDescription {
        String name;
        boolean debuggable;
        Map<String, String> metadata = new HashMap<String, String>();

        public String getName() {
            return this.name;
        }

        public boolean isDebuggable() {
            return this.debuggable;
        }

        public Map<String, String> getMetadata() {
            return Collections.unmodifiableMap(this.metadata);
        }
    }
}

