/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android;

import com.pnfsoftware.jeb.util.base.Env;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class AndroidSdkUtil {
    private static final ILogger logger = GlobalLog.getLogger(AndroidSdkUtil.class);
    public static final String legacySdkLocationVar = "ANDROID_SDK_ROOT";
    public static final String currentSdkLocationVar = "ANDROID_HOME";
    private static final List<String> sdkLocationVars = Arrays.asList("ANDROID_SDK_ROOT", "ANDROID_HOME");
    private static final String singleNdkDir = "ndk-bundle";
    private static final String multiNdksDir = "ndk";
    private static File sdkFolder = null;
    private static SortedMap<String, File> ndkFolders = null;
    private static File bestNdkFolder = null;

    public static File locateSDK(boolean bl) throws IOException {
        Object object;
        if (sdkFolder != null) {
            if (bl) {
                return sdkFolder;
            }
            sdkFolder = null;
        }
        OSType oSType = OSType.determine();
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object2 = sdkLocationVars.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            String string = Env.get((String)object);
            if (!Strings.isBlank(string)) {
                logger.debug("%s: Environment variable added to list of candidate Android SDK locations", object);
                arrayList.add(new File(IO.expandPath(string)).getAbsolutePath());
                continue;
            }
            logger.debug("%s: Environment variable NOT found", object);
        }
        if (arrayList.isEmpty()) {
            object2 = null;
            if (oSType.isWindows()) {
                object2 = Env.getsafe("LOCALAPPDATA") + "\\Android\\sdk";
            } else if (oSType.isMac()) {
                object2 = "~/Library/Android/sdk";
            } else if (oSType.isLinux()) {
                object2 = "~/Android/Sdk";
            }
            if (object2 != null) {
                logger.debug("%s: OS-specific location found and added to list of candidate Android SDK locations", object2);
                arrayList.add(new File(IO.expandPath((String)object2)).getAbsolutePath());
            }
        }
        if (arrayList.isEmpty() && !Strings.isBlank((CharSequence)(object = Env.getsafe((String)(object2 = "ANDROID_SDK_HOME"))))) {
            logger.debug("%s: WARNING: Unofficial environment variable added to list of candidate Android SDK locations. (You should use one of the following instead: %s.)", object2, sdkLocationVars);
            arrayList.add(new File(IO.expandPath((String)object)).getAbsolutePath());
        }
        if (!Strings.isBlank((CharSequence)(object2 = Env.get("PATH")))) {
            logger.debug("PATH: added to list of searched folders: %s", object2);
            arrayList.addAll(Arrays.asList(((String)object2).split(File.pathSeparator)));
        }
        logger.debug("Checking candidate SDK folders, by order: %s", arrayList);
        for (String string : arrayList) {
            File file = new File(string);
            if (!file.isDirectory()) continue;
            logger.debug("Found Android SDK folder: %s", file);
            sdkFolder = file;
            return file;
        }
        throw new IOException("The Android Debug Bridge tool (ADB) was not found. Make sure the Android SDK is installed and reference it via the $ANDROID_HOME environment variable.");
    }

    public static SortedMap<String, File> listNDKFolders(boolean bl) throws IOException {
        File file;
        if (ndkFolders != null && bl) {
            return Collections.unmodifiableSortedMap(ndkFolders);
        }
        File file2 = AndroidSdkUtil.locateSDK(bl);
        TreeMap<String, File> treeMap = new TreeMap<String, File>();
        File file3 = new File(file2, singleNdkDir);
        if (file3.isDirectory()) {
            treeMap.put("", file3);
        }
        if ((file = new File(file2, multiNdksDir)).isDirectory()) {
            for (String string : file.list()) {
                if (string.isEmpty() || !(file3 = new File(file, string)).isDirectory() || !Character.isDigit(string.charAt(0))) continue;
                treeMap.put(string, file3);
            }
        }
        ndkFolders = treeMap;
        return treeMap;
    }

    public static File locateBestNDK(boolean bl) throws IOException {
        SortedMap<String, File> sortedMap;
        if (bestNdkFolder != null) {
            if (bl) {
                return bestNdkFolder;
            }
            bestNdkFolder = null;
        }
        if ((sortedMap = AndroidSdkUtil.listNDKFolders(bl)).isEmpty()) {
            throw new IOException();
        }
        bestNdkFolder = (File)sortedMap.get(sortedMap.lastKey());
        return bestNdkFolder;
    }
}

